/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.data.thread;

import com.yqbsoft.laser.service.data.domain.DaOrderLogDomain;
import com.yqbsoft.laser.service.data.domain.DaStatisticsDomain;
import com.yqbsoft.laser.service.data.domain.SgSendgoodsGoodsDomain;
import com.yqbsoft.laser.service.data.domain.SgSendgoodsReDomain;
import com.yqbsoft.laser.service.data.model.DaOrderLog;
import com.yqbsoft.laser.service.data.service.DaOrderLogService;
import com.yqbsoft.laser.service.data.service.DaStatisticsService;
import com.yqbsoft.laser.service.data.thread.Tool;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;

public class StatisticsThread
implements Runnable {
    private final DaStatisticsService statisticsService;
    private final SgSendgoodsReDomain sendGoodsReDomain;
    private final DaOrderLogService orderLogService;
    private DaOrderLogDomain orderLogDomain;
    private final SupperLogUtil log = new SupperLogUtil(this.getClass());

    public StatisticsThread(DaStatisticsService statisticsService, SgSendgoodsReDomain sendGoodsReDomain, DaOrderLogService orderLogService, DaOrderLogDomain orderLogDomain) {
        this.statisticsService = statisticsService;
        this.sendGoodsReDomain = sendGoodsReDomain;
        this.orderLogService = orderLogService;
        this.orderLogDomain = orderLogDomain;
    }

    @Override
    public void run() {
        this.log.error("================\u603b\u8868\u7edf\u8ba1\u7ebf\u7a0b==============");
        List<SgSendgoodsGoodsDomain> list = this.sendGoodsReDomain.getSgSendgoodsGoodsDomainList();
        ArrayList<DaStatisticsDomain> domainList = new ArrayList<DaStatisticsDomain>();
        Date dat = new Date();
        for (SgSendgoodsGoodsDomain goods : list) {
            DaStatisticsDomain dsd = new DaStatisticsDomain();
            dsd.setMemberMcode(goods.getMemberCode());
            dsd.setMemberMname(goods.getMemberCname());
            dsd.setMemberCode(this.sendGoodsReDomain.getMemberCode());
            dsd.setMemberName(this.sendGoodsReDomain.getMemberName());
            dsd.setMemberBcode(goods.getMemberBcode());
            dsd.setMemberBname(goods.getMemberBname());
            dsd.setContractBillCode(goods.getContractBillcode());
            dsd.setParamCategory(goods.getPntreeCode());
            dsd.setParamCategoryName(goods.getPntreeName());
            dsd.setParamBrand(goods.getBrandCode());
            dsd.setParamBrandName(goods.getBrandName());
            dsd.setDiscountCount(goods.getContractGoodsInmoney().subtract(goods.getContractGoodsMoney()));
            dsd.setParamDsr(this.sendGoodsReDomain.getEmployeeCode());
            dsd.setParamDsrName(this.sendGoodsReDomain.getEmployeeName());
            dsd.setSellingPrice(goods.getContractGoodsInmoney());
            dsd.setPaidIn(goods.getContractGoodsInmoney().subtract(dsd.getDiscountCount()));
            dsd.setGoodsCost(goods.getPricesetNprice());
            dsd.setCreateTime(dat);
            dsd.setTenantCode(goods.getTenantCode());
            StringBuffer sb = new StringBuffer();
            sb.append(goods.getMemberBcode());
            sb.append(new Random().nextInt(1000000000));
            dsd.setStatisticsCode(sb.toString());
            String isPdStr = goods.getGoodsProperty1();
            BigDecimal isPd = new BigDecimal(1);
            if (null != isPdStr && !isPdStr.equals("") && Tool.isInteger(isPdStr)) {
                isPd = new BigDecimal(isPdStr);
            }
            if (isPd.compareTo(BigDecimal.ZERO) == 0) {
                dsd.setPgGoods(0);
            } else {
                dsd.setPgGoods(1);
            }
            domainList.add(dsd);
            this.log.error("================\u603b\u8868\u7edf\u8ba1\u7ebf\u7a0b==========goods.getMemberCcode()====" + goods.getMemberCcode());
        }
        this.log.error("================\u6570\u7ec4\u957f\u5ea6==============" + domainList.size());
        this.statisticsService.saveStatisticsBatch(domainList);
        DaOrderLog log = this.orderLogService.getOrderLogByCode(this.sendGoodsReDomain.getTenantCode(), this.orderLogDomain.getContractBillCode());
        if (null != log) {
            DaOrderLogDomain dld = new DaOrderLogDomain();
            try {
                BeanUtils.copyAllPropertys((Object)dld, (Object)log);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            dld.setLogStat(false);
            this.orderLogService.updateOrderLog(dld);
        }
    }

    public void start() {
        new Thread(this).start();
    }
}

