/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.data.service.impl;

import com.yqbsoft.laser.service.data.dao.DaTaxMapper;
import com.yqbsoft.laser.service.data.domain.DaTaxDomain;
import com.yqbsoft.laser.service.data.domain.DaTaxReDomain;
import com.yqbsoft.laser.service.data.domain.InvInvrateReDomain;
import com.yqbsoft.laser.service.data.domain.OcContractDomain;
import com.yqbsoft.laser.service.data.domain.OcRefundDomain;
import com.yqbsoft.laser.service.data.domain.SgSendgoodsGoodsDomain;
import com.yqbsoft.laser.service.data.model.DaTax;
import com.yqbsoft.laser.service.data.service.DaTaxService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

public class DaTaxServiceImpl
extends BaseServiceImpl
implements DaTaxService {
    private static final String SYS_CODE = SYS_CODE + ".DaTaxServiceImpl";
    private DaTaxMapper daTaxMapper;

    public void setDaTaxMapper(DaTaxMapper daTaxMapper) {
        this.daTaxMapper = daTaxMapper;
    }

    private Date getSysDate() {
        try {
            return this.daTaxMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkTax(DaTaxDomain daTaxDomain) {
        if (null == daTaxDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)daTaxDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setTaxDefault(DaTax daTax) {
        if (null == daTax) {
            return;
        }
        if (null == daTax.getDataState()) {
            daTax.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == daTax.getGmtCreate()) {
            daTax.setGmtCreate(date);
        }
        daTax.setGmtModified(date);
        if (StringUtils.isBlank((String)daTax.getTaxCode())) {
            daTax.setTaxCode(this.getNo(null, "DaTax", "daTax", daTax.getTenantCode()));
        }
    }

    private int getTaxMaxCode() {
        int code = 0;
        try {
            return this.daTaxMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getTaxMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setTaxUpdataDefault(DaTax daTax) {
        if (null == daTax) {
            return;
        }
        daTax.setGmtModified(this.getSysDate());
    }

    private void saveTaxModel(DaTax daTax) throws ApiException {
        if (null == daTax) {
            return;
        }
        try {
            this.daTaxMapper.insert(daTax);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".saveTaxModel.ex", (Throwable)e);
        }
    }

    private void saveTaxBatchModel(List<DaTax> daTaxList) throws ApiException {
        if (null == daTaxList || daTaxList.isEmpty()) {
            return;
        }
        try {
            this.daTaxMapper.insertBatch(daTaxList);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".saveTaxBatchModel.ex", (Throwable)e);
        }
    }

    private DaTax getTaxModelById(Integer taxId) {
        if (null == taxId) {
            return null;
        }
        try {
            return this.daTaxMapper.selectByPrimaryKey(taxId);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getTaxModelById", (Throwable)e);
            return null;
        }
    }

    private DaTax getTaxModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.daTaxMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getTaxModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delTaxModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.daTaxMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".delTaxModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".delTaxModelByCode.num");
        }
    }

    private void deleteTaxModel(Integer taxId) throws ApiException {
        if (null == taxId) {
            return;
        }
        int i = 0;
        try {
            i = this.daTaxMapper.deleteByPrimaryKey(taxId);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".deleteTaxModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".deleteTaxModel.num");
        }
    }

    private void updateTaxModel(DaTax daTax) throws ApiException {
        if (null == daTax) {
            return;
        }
        int i = 0;
        try {
            i = this.daTaxMapper.updateByPrimaryKey(daTax);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateTaxModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".updateTaxModel.num");
        }
    }

    private void updateStateTaxModel(Integer taxId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == taxId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("taxId", taxId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daTaxMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStateTaxModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException(SYS_CODE + ".updateStateTaxModel.null");
        }
    }

    private void updateStateTaxModelByCode(String tenantCode, String taxCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)taxCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("taxCode", taxCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daTaxMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStateTaxModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException(SYS_CODE + ".updateStateTaxModelByCode.null");
        }
    }

    private DaTax makeTax(DaTaxDomain daTaxDomain, DaTax daTax) {
        if (null == daTaxDomain) {
            return null;
        }
        if (null == daTax) {
            daTax = new DaTax();
        }
        try {
            com.yqbsoft.laser.service.tool.util.BeanUtils.copyAllPropertys((Object)daTax, (Object)daTaxDomain);
            return daTax;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeTax", (Throwable)e);
            return null;
        }
    }

    private DaTaxReDomain makeDaTaxReDomain(DaTax daTax) {
        if (null == daTax) {
            return null;
        }
        DaTaxReDomain daTaxReDomain = new DaTaxReDomain();
        try {
            com.yqbsoft.laser.service.tool.util.BeanUtils.copyAllPropertys((Object)daTaxReDomain, (Object)daTax);
            return daTaxReDomain;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeDaTaxReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DaTax> queryTaxModelPage(Map<String, Object> parammap) {
        try {
            return this.daTaxMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".queryTaxModel", (Throwable)e);
            return null;
        }
    }

    private int countTax(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.daTaxMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".countTax", (Throwable)e);
        }
        return i;
    }

    private DaTax createDaTax(DaTaxDomain daTaxDomain) {
        String msg = this.checkTax(daTaxDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(SYS_CODE + ".saveTax.checkTax", msg);
        }
        DaTax daTax = this.makeTax(daTaxDomain, null);
        this.setTaxDefault(daTax);
        return daTax;
    }

    @Override
    public String saveTax(DaTaxDomain daTaxDomain) throws ApiException {
        DaTax daTax = this.createDaTax(daTaxDomain);
        this.saveTaxModel(daTax);
        return daTax.getTaxCode();
    }

    @Override
    public String saveTaxBatch(List<DaTaxDomain> daTaxDomainList) throws ApiException {
        if (null == daTaxDomainList || daTaxDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DaTax> daTaxList = new ArrayList<DaTax>();
        String code = "";
        for (DaTaxDomain daTaxDomain : daTaxDomainList) {
            DaTax daTax = this.createDaTax(daTaxDomain);
            code = daTax.getTaxCode();
            daTaxList.add(daTax);
        }
        this.saveTaxBatchModel(daTaxList);
        return code;
    }

    @Override
    public void updateTaxState(Integer taxId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == taxId) {
            return;
        }
        this.updateStateTaxModel(taxId, dataState, oldDataState, map);
    }

    @Override
    public void updateTaxStateByCode(String tenantCode, String taxCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)taxCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateTaxModelByCode(tenantCode, taxCode, dataState, oldDataState, map);
    }

    @Override
    public void updateTax(DaTaxDomain daTaxDomain) throws ApiException {
        String msg = this.checkTax(daTaxDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(SYS_CODE + ".updateTax.checkTax", msg);
        }
        DaTax oldDaTax = this.getTaxModelById(daTaxDomain.getTaxId());
        if (null == oldDaTax) {
            throw new ApiException(SYS_CODE + ".updateTax.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DaTax daTax = this.makeTax(daTaxDomain, oldDaTax);
        this.setTaxUpdataDefault(daTax);
        this.updateTaxModel(daTax);
    }

    @Override
    public DaTax getTax(Integer taxId) {
        if (null == taxId) {
            return null;
        }
        return this.getTaxModelById(taxId);
    }

    @Override
    public void deleteTax(Integer taxId) throws ApiException {
        if (null == taxId) {
            return;
        }
        this.deleteTaxModel(taxId);
    }

    @Override
    public QueryResult<DaTax> queryTaxPage(Map<String, Object> map) {
        List<DaTax> daTaxList = this.queryTaxModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countTax(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(daTaxList);
        return queryResult;
    }

    @Override
    public DaTax getTaxByCode(String tenantCode, String taxCode) throws ApiException {
        if (StringUtils.isBlank((String)taxCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("taxCode", taxCode);
        return this.getTaxModelByCode(map);
    }

    @Override
    public void deleteTaxByCode(String tenantCode, String taxCode) throws ApiException {
        if (StringUtils.isBlank((String)taxCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("taxCode", taxCode);
        this.delTaxModelByCode(map);
    }

    @Override
    public String saveTaxByOcContractDomain(OcContractDomain ocContractDomain) {
        try {
            this.buildOcContractDomainToDaTaxDomain(ocContractDomain);
        }
        catch (Exception ex) {
            this.logger.error("saveTaxByOcContractDomain ERROR: {}", (Object)ex.getMessage());
        }
        return "success";
    }

    @Override
    public String updateTaxByOcContractDomain(OcContractDomain ocContractDomain) {
        return null;
    }

    private void buildOcContractDomainToDaTaxDomain(OcContractDomain ocContractDomain) {
        InvInvrateReDomain invInvlist;
        OcRefundDomain ocRefund;
        if (null == ocContractDomain) {
            return;
        }
        this.logger.info("buildOcContractDomainToDaTaxDomain --> In ocContractDomain data: {}", (Object)JsonUtil.getAllJsonUtil().toJson((Object)ocContractDomain));
        List<SgSendgoodsGoodsDomain> sendgoodsGoodsDomainList = this.getSendGoodsGoods(ocContractDomain);
        if (CollectionUtils.isEmpty(sendgoodsGoodsDomainList)) {
            return;
        }
        this.logger.info("buildOcContractDomainToDaTaxDomain --> In sendgoodsGoodsDomainList data: {}", (Object)JsonUtil.getAllJsonUtil().toJson(sendgoodsGoodsDomainList));
        DaTaxDomain sourceDaTaxDomain = new DaTaxDomain();
        sourceDaTaxDomain.setOrderNo(ocContractDomain.getContractBillcode());
        sourceDaTaxDomain.setDataState(ocContractDomain.getDataState());
        sourceDaTaxDomain.setTenantCode(ocContractDomain.getTenantCode());
        if (ocContractDomain.getDataState().equals(-1) && null != (ocRefund = this.getOcRefund(ocContractDomain))) {
            sourceDaTaxDomain.setTaxOldOrder(ocContractDomain.getContractBillcode());
            sourceDaTaxDomain.setOrderNo(ocRefund.getRefundCode());
        }
        if (ocContractDomain.getContractInvstate().equals(2) && null != (invInvlist = this.getInvInvlist(ocContractDomain))) {
            sourceDaTaxDomain.setInvoiceNo(invInvlist.getInvrateCode());
            sourceDaTaxDomain.setInvoiceType(Integer.valueOf(invInvlist.getUserinvType()));
            sourceDaTaxDomain.setInvoiceStartTime(invInvlist.getGmtCreate());
            sourceDaTaxDomain.setMemberName(invInvlist.getMemberName());
            sourceDaTaxDomain.setMemberBankCode(invInvlist.getInvlistBankno());
            sourceDaTaxDomain.setMemberTaxCode(invInvlist.getInvlistRatecode());
        }
        for (SgSendgoodsGoodsDomain sgSendgoodsGoodsDomain : sendgoodsGoodsDomainList) {
            this.logger.info("buildOcContractDomainToDaTaxDomain --> sendgoodsGoodsDomainList  --> sgSendgoodsGoodsDomain data: {}", (Object)JsonUtil.getAllJsonUtil().toJson((Object)sgSendgoodsGoodsDomain));
            DaTaxDomain daTaxDomain = new DaTaxDomain();
            BeanUtils.copyProperties((Object)sourceDaTaxDomain, (Object)daTaxDomain);
            daTaxDomain.setTaxValue1(sgSendgoodsGoodsDomain.getContractGoodsMoney().toString());
            daTaxDomain.setTaxValue2(sgSendgoodsGoodsDomain.getContractGoodsMoney().divide(new BigDecimal("1.13"), 2, 4).toString());
            daTaxDomain.setTaxValue3(sgSendgoodsGoodsDomain.getPricesetNprice().toString());
            daTaxDomain.setOrderTime(ocContractDomain.getGmtCreate());
            if (ocContractDomain.getDataState().equals(-1)) {
                sourceDaTaxDomain.setTaxValue5(sgSendgoodsGoodsDomain.getContractGoodsMoney().toString());
            }
            this.logger.info("buildOcContractDomainToDaTaxDomain --> saveTax data: {}", (Object)JsonUtil.getAllJsonUtil().toJson((Object)daTaxDomain));
            this.saveTax(daTaxDomain);
        }
    }

    private InvInvrateReDomain getInvInvlist(OcContractDomain ocContractDomain) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("invlistOpcode", ocContractDomain.getContractBillcode());
            HashMap<String, String> invokeMap = new HashMap<String, String>();
            invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
            QueryResult queryResutl = this.getQueryResutl("inv.invlist.queryInvlistPage", invokeMap, InvInvrateReDomain.class);
            if (null == queryResutl || ListUtil.isEmpty((Collection)queryResutl.getList())) {
                this.logger.error("getOcRefundDataError: {}", (Object)((Object)invokeMap).toString());
                return null;
            }
            this.logger.error("getInvListData: {}", (Object)JsonUtil.buildNonNullBinder().toJson((Object)queryResutl));
            return (InvInvrateReDomain)queryResutl.getList().get(0);
        }
        catch (Exception ex) {
            this.logger.error("GET InvListData Error:{}", (Object)ex.getMessage());
            return null;
        }
    }

    private OcRefundDomain getOcRefund(OcContractDomain ocContractDomain) {
        try {
            Map<String, Object> invokeMap = this.getSelectSendGoodsAndSendGoodsSelectMap(ocContractDomain);
            QueryResult queryResutl = this.getQueryResutl("oc.refund.queryRefundPage", invokeMap, OcRefundDomain.class);
            if (null == queryResutl || ListUtil.isEmpty((Collection)queryResutl.getList())) {
                this.logger.error("getOcRefundDataError: {}", (Object)invokeMap.toString());
                return null;
            }
            this.logger.error("getOcRefundData: {}", (Object)JsonUtil.buildNonNullBinder().toJson((Object)queryResutl));
            return (OcRefundDomain)queryResutl.getList().get(0);
        }
        catch (Exception ex) {
            this.logger.error("GET SendGoods Error:{}", (Object)ex.getMessage());
            return null;
        }
    }

    private Map<String, Object> getSelectSendGoodsAndSendGoodsSelectMap(OcContractDomain ocContractDomain) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", ocContractDomain.getTenantCode());
        map.put("contractBillcode", ocContractDomain.getContractBillcode());
        HashMap<String, Object> invokeMap = new HashMap<String, Object>();
        invokeMap.put("map", JsonUtil.buildNonNullBinder().toJson(map));
        return invokeMap;
    }

    private List<SgSendgoodsGoodsDomain> getSendGoodsGoods(OcContractDomain ocContractDomain) {
        try {
            Map<String, Object> invokeMap = this.getSelectSendGoodsAndSendGoodsSelectMap(ocContractDomain);
            QueryResult queryResutl = this.getQueryResutl("sg.sendgoods.querySendgoodsGoodsPage", invokeMap, SgSendgoodsGoodsDomain.class);
            if (null == queryResutl || ListUtil.isEmpty((Collection)queryResutl.getList())) {
                this.logger.error("getSgGoodsGoods.queryResutl", (Object)invokeMap.toString());
                return null;
            }
            this.logger.info("get SendGoodsGoodsData:{}", (Object)queryResutl.getList());
            return queryResutl.getList();
        }
        catch (Exception ex) {
            this.logger.error("GET SendGoods Error:{}", (Object)ex.getMessage());
            return null;
        }
    }
}

