/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.data.thread;

import com.yqbsoft.laser.service.data.domain.DaOrderLogDomain;
import com.yqbsoft.laser.service.data.domain.DaStatisticsDomain;
import com.yqbsoft.laser.service.data.domain.OcContractDomain;
import com.yqbsoft.laser.service.data.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.data.model.DaOrderLog;
import com.yqbsoft.laser.service.data.model.DaOrderTotal;
import com.yqbsoft.laser.service.data.model.DaStatistics;
import com.yqbsoft.laser.service.data.service.DaOrderLogService;
import com.yqbsoft.laser.service.data.service.DaOrderTotalService;
import com.yqbsoft.laser.service.data.service.DaStatisticsService;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class AddAndStatisticsThread
implements Runnable {
    private final DaStatisticsService statisticsService;
    private final DaOrderTotalService orderTotalService;
    private final OcContractDomain ocContractDomain;
    private final DaOrderLogService orderLogService;
    private DaOrderLogDomain orderLogDomain;
    protected final SupperLogUtil logger = new SupperLogUtil(this.getClass());

    public AddAndStatisticsThread(DaStatisticsService statisticsService, DaOrderTotalService orderTotalService, OcContractDomain ocContractDomain, DaOrderLogService orderLogService, DaOrderLogDomain orderLogDomain) {
        this.statisticsService = statisticsService;
        this.orderTotalService = orderTotalService;
        this.ocContractDomain = ocContractDomain;
        this.orderLogService = orderLogService;
        this.orderLogDomain = orderLogDomain;
    }

    @Override
    public void run() {
        ArrayList<DaOrderTotal> daOrderTotalList = new ArrayList<DaOrderTotal>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("insuranceOpcode1", this.ocContractDomain.getContractBillcode());
        map.put("tenantCode", this.ocContractDomain.getTenantCode());
        QueryResult<DaOrderTotal> daOrderTotalQueryResult = this.orderTotalService.queryOrderTotalPage(map);
        if (ListUtil.isEmpty((Collection)daOrderTotalQueryResult.getList())) {
            List<OcContractGoodsDomain> goodsList = this.ocContractDomain.getGoodsList();
            for (OcContractGoodsDomain cg : goodsList) {
                DaOrderTotal dot = new DaOrderTotal();
                dot.setTenantCode(this.ocContractDomain.getTenantCode());
                dot.setMemberCode(this.ocContractDomain.getMemberCode());
                dot.setInsuranceOpcode1(this.ocContractDomain.getContractBillcode());
                dot.setInsuranceOpcode3(this.ocContractDomain.getGoodsReceiptMem());
                dot.setChannelCode(this.ocContractDomain.getGoodsReceiptPhone());
                dot.setChannelName(this.ocContractDomain.getGoodsReceiptArrdess());
                if (ListUtil.isNotEmpty(this.ocContractDomain.getPackageList())) {
                    dot.setInsuranceOpcode(this.ocContractDomain.getPackageList().get(0).getExpressName());
                    dot.setMemberBcode(this.ocContractDomain.getPackageList().get(0).getExpressCode());
                    dot.setInsuranceOpcode2(this.ocContractDomain.getPackageList().get(0).getPackageBillno());
                }
                dot.setDataOcstate(this.ocContractDomain.getDataState());
                dot.setGmtCreate(this.ocContractDomain.getGmtCreate());
                dot.setMemberName(this.ocContractDomain.getContractRemark());
                if (ListUtil.isNotEmpty(this.ocContractDomain.getOcContractSettlList())) {
                    dot.setMemberBname(this.ocContractDomain.getOcContractSettlList().get(0).getContractSettlOpemo());
                }
                if (ListUtil.isNotEmpty(goodsList)) {
                    dot.setAppmanageIcode(cg.getSkuCode());
                    dot.setOrderTotalOrdertype(cg.getMemberCcode());
                    dot.setGoodsClass(cg.getMemberCname());
                    dot.setMemberMname(cg.getGoodsName());
                    dot.setMemberMcode(cg.getGoodsShowno());
                    dot.setOrderTotalNum(cg.getGoodsNum());
                    dot.setOrderTotalNum1(cg.getPricesetAsprice());
                    dot.setOrderTotalNum2(cg.getPricesetRefrice());
                    dot.setOrderTotalNum3(cg.getPricesetNprice());
                    if (2 == this.ocContractDomain.getDataState()) {
                        this.statistics(this.ocContractDomain);
                    }
                }
                daOrderTotalList.add(dot);
            }
            this.orderTotalService.saveOrderTotalReBatch(daOrderTotalList);
        } else {
            map.put("dataOcstate", this.ocContractDomain.getDataState());
            if (2 == this.ocContractDomain.getDataState()) {
                this.statistics(this.ocContractDomain);
            } else if (3 == this.ocContractDomain.getDataState() && ListUtil.isNotEmpty(this.ocContractDomain.getPackageList())) {
                String insuranceOpcode = this.ocContractDomain.getPackageList().get(0).getExpressName();
                String memberBcode = this.ocContractDomain.getPackageList().get(0).getExpressCode();
                String insuranceOpcode2 = this.ocContractDomain.getPackageList().get(0).getPackageBillno();
                map.put("insuranceOpcode", insuranceOpcode);
                map.put("memberBcode", memberBcode);
                map.put("insuranceOpcode2", insuranceOpcode2);
            }
            this.orderTotalService.updateOrderTotalDataOcstate(map);
        }
    }

    public void statistics(OcContractDomain ocContractDomain) {
        for (OcContractGoodsDomain cg : ocContractDomain.getGoodsList()) {
            BigDecimal goodsNum = cg.getGoodsNum();
            BigDecimal pricesetRefrice = cg.getPricesetRefrice();
            BigDecimal pricesetNprice = cg.getPricesetNprice();
            BigDecimal pricesetRefriceSum = goodsNum.multiply(pricesetRefrice);
            BigDecimal pricesetNpriceSum = goodsNum.multiply(pricesetNprice);
            HashMap<String, Object> param = new HashMap<String, Object>();
            String memberMcode = cg.getSkuCode();
            param.put("memberMcode", memberMcode);
            String tenantCode = cg.getTenantCode();
            param.put("tenantCode", tenantCode);
            String memberCode = cg.getMemberCcode();
            param.put("memberCode", memberCode);
            DaStatistics statisticsByCodes = this.statisticsService.getStatisticsByCodes(tenantCode, memberMcode, memberCode);
            if (null != statisticsByCodes) {
                pricesetRefriceSum = pricesetRefriceSum.add(statisticsByCodes.getSellingPrice());
                param.put("sellingPrice", pricesetRefriceSum);
                pricesetNpriceSum = pricesetNpriceSum.add(statisticsByCodes.getGoodsCost());
                param.put("goodsCost", pricesetNpriceSum);
                this.statisticsService.updateStatisticsAmount(param);
                continue;
            }
            DaStatisticsDomain statisticsDomain = new DaStatisticsDomain();
            statisticsDomain.setMemberMcode(memberMcode);
            statisticsDomain.setMemberCode(memberCode);
            statisticsDomain.setMemberName(cg.getMemberCname());
            statisticsDomain.setTenantCode(tenantCode);
            statisticsDomain.setSellingPrice(pricesetRefriceSum);
            statisticsDomain.setGoodsCost(pricesetNpriceSum);
            this.statisticsService.saveStatistics(statisticsDomain);
        }
        DaOrderLog log = this.orderLogService.getOrderLogByCode(this.orderLogDomain.getTenantCode(), this.orderLogDomain.getLogCode());
        if (null != log) {
            DaOrderLogDomain dld = new DaOrderLogDomain();
            try {
                BeanUtils.copyAllPropertys((Object)dld, (Object)log);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            dld.setLogStat(false);
            this.orderLogService.updateOrderLog(dld);
        }
    }

    public void start() {
        new Thread(this).start();
    }
}

