/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.data.thread;

import com.yqbsoft.laser.service.channelmanage.model.CmChannelClear;
import com.yqbsoft.laser.service.channelmanage.service.CmChannelClearService;
import com.yqbsoft.laser.service.data.domain.DaOrderLogDomain;
import com.yqbsoft.laser.service.data.domain.DaStatisticsDomain;
import com.yqbsoft.laser.service.data.domain.OcContractDomain;
import com.yqbsoft.laser.service.data.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.data.model.DaOrderLog;
import com.yqbsoft.laser.service.data.model.DaOrderTotal;
import com.yqbsoft.laser.service.data.model.DaStatistics;
import com.yqbsoft.laser.service.data.service.DaOrderLogService;
import com.yqbsoft.laser.service.data.service.DaOrderTotalService;
import com.yqbsoft.laser.service.data.service.DaStatisticsService;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.model.RsSku;
import com.yqbsoft.laser.service.resources.service.RsSkuService;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AddAndStatisticsThread
implements Runnable {
    private final DaStatisticsService statisticsService;
    private final DaOrderTotalService orderTotalService;
    private final CmChannelClearService omChannelClearService;
    private final RsSkuService rsSkuService;
    private final OcContractDomain ocContractDomain;
    private final DaOrderLogService orderLogService;
    private DaOrderLogDomain orderLogDomain;
    protected final SupperLogUtil logger = new SupperLogUtil(this.getClass());

    public AddAndStatisticsThread(DaStatisticsService statisticsService, DaOrderTotalService orderTotalService, CmChannelClearService omChannelClearService, RsSkuService rsSkuService, OcContractDomain ocContractDomain, DaOrderLogService orderLogService, DaOrderLogDomain orderLogDomain) {
        this.statisticsService = statisticsService;
        this.orderTotalService = orderTotalService;
        this.rsSkuService = rsSkuService;
        this.omChannelClearService = omChannelClearService;
        this.ocContractDomain = ocContractDomain;
        this.orderLogService = orderLogService;
        this.orderLogDomain = orderLogDomain;
    }

    @Override
    public void run() {
        this.logger.error("----\u5f00\u59cb------");
        ArrayList<DaOrderTotal> daOrderTotalList = new ArrayList<DaOrderTotal>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("insuranceOpcode1", this.ocContractDomain.getContractBillcode());
        map.put("tenantCode", this.ocContractDomain.getTenantCode());
        QueryResult<DaOrderTotal> daOrderTotalQueryResult = this.orderTotalService.queryOrderTotalPage(map);
        if (ListUtil.isEmpty((Collection)daOrderTotalQueryResult.getList())) {
            this.logger.error("----\u65e0\u8bb0\u5f55------");
            List<OcContractGoodsDomain> goodsList = this.ocContractDomain.getGoodsList();
            for (OcContractGoodsDomain cg : goodsList) {
                DaOrderTotal dot = new DaOrderTotal();
                dot.setMemo("2");
                if (StringUtils.isNotBlank((String)this.ocContractDomain.getContractObillcode())) {
                    dot.setContractObillcode(this.ocContractDomain.getContractObillcode());
                }
                dot.setTenantCode(this.ocContractDomain.getTenantCode());
                dot.setMemberCode(this.ocContractDomain.getMemberBname());
                dot.setInsuranceOpcode1(this.ocContractDomain.getContractBillcode());
                dot.setInsuranceOpcode3(this.ocContractDomain.getGoodsReceiptMem());
                dot.setChannelCode(this.ocContractDomain.getGoodsReceiptPhone());
                dot.setChannelName(this.ocContractDomain.getGoodsReceiptArrdess());
                dot.setOrderRefrice(this.ocContractDomain.getPricesetRefrice());
                dot.setOrderNprice(this.ocContractDomain.getContractMoney());
                if (ListUtil.isNotEmpty(this.ocContractDomain.getPackageList())) {
                    dot.setInsuranceOpcode(this.ocContractDomain.getPackageList().get(0).getExpressName());
                    dot.setMemberBcode(this.ocContractDomain.getPackageList().get(0).getExpressCode());
                    dot.setInsuranceOpcode2(this.ocContractDomain.getPackageList().get(0).getPackageBillno());
                }
                dot.setDataOcstate(this.ocContractDomain.getDataState());
                dot.setGmtCreate(this.ocContractDomain.getGmtCreate());
                dot.setMemberName(this.ocContractDomain.getContractRemark());
                if (ListUtil.isNotEmpty(this.ocContractDomain.getOcContractSettlList())) {
                    dot.setMemberBname(this.ocContractDomain.getOcContractSettlList().get(0).getContractSettlOpemo());
                }
                if (ListUtil.isNotEmpty(goodsList)) {
                    dot.setAppmanageIcode(cg.getSkuCode());
                    dot.setSkuShowno(cg.getSkuShowno());
                    dot.setSkuName(cg.getSkuName());
                    dot.setOrderTotalOrdertype(cg.getMemberCcode());
                    dot.setGoodsClass(cg.getMemberCname());
                    dot.setMemberMname(cg.getGoodsName());
                    dot.setMemberMcode(cg.getGoodsShowno());
                    dot.setOrderTotalNum(cg.getGoodsNum());
                    dot.setOrderTotalNum1(cg.getPricesetAsprice());
                    BigDecimal goodsPefprice = cg.getContractGoodsPrice().compareTo(BigDecimal.valueOf(0L)) >= 0 ? cg.getContractGoodsPefprice() : cg.getPricesetNprice();
                    dot.setOrderTotalNum2(goodsPefprice);
                    BigDecimal goodsPrice = cg.getContractGoodsPrice().compareTo(BigDecimal.valueOf(0L)) >= 0 ? cg.getContractGoodsPrice() : cg.getPricesetNprice();
                    dot.setOrderTotalNum3(goodsPrice);
                    dot.setOrderTotalNum4(goodsPefprice.multiply(cg.getGoodsNum()));
                    dot.setOrderTotalNum5(goodsPrice.multiply(cg.getGoodsNum()));
                    dot.setPayState(1);
                    HashMap<String, String> paramSku = new HashMap<String, String>();
                    paramSku.put("skuCode", cg.getSkuCode());
                    paramSku.put("tenantCode", cg.getTenantCode());
                    this.logger.error("--getSkuByCode---", (Object)JsonUtil.buildNormalBinder().toJson(paramSku));
                    RsSku byCode = this.rsSkuService.getSkuByCode(paramSku);
                    if (byCode != null) {
                        dot.setGoodsType(byCode.getGoodsType());
                        if ("2".equals(byCode.getPricesetType())) {
                            dot.setPricesetNrpice(byCode.getPricesetBaseprice());
                        } else {
                            dot.setPricesetNrpice(byCode.getPricesetNprice());
                        }
                        dot.setPricesetMaxeprice(byCode.getPricesetMakeprice());
                    }
                }
                dot.setMschannelCode(this.ocContractDomain.getChannelCode());
                if ("busBBC".equals(this.ocContractDomain.getChannelCode())) {
                    dot.setMschannelName("\u5c0f\u7a0b\u5e8f");
                } else {
                    dot.setMschannelName(this.ocContractDomain.getChannelName());
                }
                this.logger.error("-----dot-----", (Object)JsonUtil.buildNormalBinder().toJson((Object)dot));
                daOrderTotalList.add(dot);
            }
            this.orderTotalService.saveOrderTotalReBatch(daOrderTotalList);
            this.saveOrder();
        } else {
            this.logger.error("----\u6709\u8bb0\u5f55-----\u8ba2\u5355\u72b6\u6001------", (Object)this.ocContractDomain.getDataState());
            map.put("dataOcstate", this.ocContractDomain.getDataState());
            if (2 == this.ocContractDomain.getDataState()) {
                map.put("orderTotalDate", this.ocContractDomain.getGmtModified());
                map.put("contractObillcode", this.ocContractDomain.getContractObillcode());
                this.updateOrderGoods(map);
                this.statistics(this.ocContractDomain);
                map.put("payState", 2);
                this.logger.error("----\u652f\u4ed8\u4fee\u6539\u6570\u636e-----", (Object)JsonUtil.buildNormalBinder().toJson(map));
            } else if (3 == this.ocContractDomain.getDataState()) {
                if (ListUtil.isNotEmpty(this.ocContractDomain.getPackageList())) {
                    String insuranceOpcode = this.ocContractDomain.getPackageList().get(0).getExpressName();
                    String memberBcode = this.ocContractDomain.getPackageList().get(0).getExpressCode();
                    String insuranceOpcode2 = this.ocContractDomain.getPackageList().get(0).getPackageBillno();
                    map.put("insuranceOpcode", insuranceOpcode);
                    map.put("memberBcode", memberBcode);
                    map.put("insuranceOpcode2", insuranceOpcode2);
                }
                map.put("dataOstate", -1);
            } else if (4 == this.ocContractDomain.getDataState() && StringUtils.isNotBlank((String)this.ocContractDomain.getContractNbbillcode())) {
                map.put("contractNbbillcode", this.ocContractDomain.getContractNbbillcode());
                map.put("dataOstate", 1);
            }
            map.put("memo", null);
            this.logger.error("--updateOrderTotalDataOcstate---", (Object)JsonUtil.buildNormalBinder().toJson(map));
            this.orderTotalService.updateOrderTotalDataOcstate(map);
        }
    }

    public void updateOrder(Map<String, Object> map) {
        this.logger.error("---------\u8ba2\u5355\u6dfb\u52a0\u5546\u6237\u8ba2\u5355\u53f7\u548c\u4e09\u65b9\u6d41\u6c34\u53f7---------");
        map.put("memo", "1");
        this.orderTotalService.updateOrderTotalDataOcstate(map);
    }

    public void updateOrderGoods(Map<String, Object> map) {
        if (ListUtil.isNotEmpty(this.ocContractDomain.getGoodsList())) {
            for (OcContractGoodsDomain cg : this.ocContractDomain.getGoodsList()) {
                this.logger.error("------\u7ed9\u542b\u73b0\u91d1\u7684\u5546\u54c1\u6dfb\u52a0\u5546\u6237\u8ba2\u5355\u53f7\u548c\u4e09\u65b9\u6d41\u6c34\u53f7-----");
                if ("3".equals(cg.getPricesetType())) continue;
                map.put("appmanageIcode", cg.getSkuCode());
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("fuzzy", false);
                param.put("businessOrderno", this.ocContractDomain.getContractBillcode());
                param.put("tenantCode", this.ocContractDomain.getTenantCode());
                this.logger.error("--querychannelClearPage---", (Object)JsonUtil.buildNormalBinder().toJson(param));
                QueryResult cmChannelClearQueryResult = this.omChannelClearService.querychannelClearPage(param);
                if (ListUtil.isNotEmpty((Collection)cmChannelClearQueryResult.getList())) {
                    CmChannelClear cmChannelClear = (CmChannelClear)cmChannelClearQueryResult.getList().get(0);
                    this.logger.error("--cmChannelClear---", (Object)JsonUtil.buildNormalBinder().toJson((Object)cmChannelClear));
                    map.put("channelClearSeqno", cmChannelClear.getChannelClearSeqno());
                    map.put("orderBankseq", cmChannelClear.getOrderBankseq());
                }
                this.orderTotalService.updateOrderTotalDataOcstate(map);
            }
            map.put("appmanageIcode", null);
            this.updateOrder(map);
        }
    }

    public void saveOrder() {
        ArrayList<DaOrderTotal> daOrderTotalList = new ArrayList<DaOrderTotal>();
        DaOrderTotal dot = new DaOrderTotal();
        dot.setMemo("1");
        if (StringUtils.isNotBlank((String)this.ocContractDomain.getContractObillcode())) {
            dot.setContractObillcode(this.ocContractDomain.getContractObillcode());
        }
        dot.setTenantCode(this.ocContractDomain.getTenantCode());
        dot.setMemberCode(this.ocContractDomain.getMemberBname());
        dot.setInsuranceOpcode1(this.ocContractDomain.getContractBillcode());
        dot.setInsuranceOpcode3(this.ocContractDomain.getGoodsReceiptMem());
        dot.setChannelCode(this.ocContractDomain.getGoodsReceiptPhone());
        dot.setChannelName(this.ocContractDomain.getGoodsReceiptArrdess());
        dot.setOrderRefrice(this.ocContractDomain.getPricesetRefrice());
        dot.setOrderNprice(this.ocContractDomain.getContractMoney());
        if (ListUtil.isNotEmpty(this.ocContractDomain.getPackageList())) {
            dot.setInsuranceOpcode(this.ocContractDomain.getPackageList().get(0).getExpressName());
            dot.setMemberBcode(this.ocContractDomain.getPackageList().get(0).getExpressCode());
            dot.setInsuranceOpcode2(this.ocContractDomain.getPackageList().get(0).getPackageBillno());
        }
        dot.setDataOcstate(this.ocContractDomain.getDataState());
        dot.setGmtCreate(this.ocContractDomain.getGmtCreate());
        dot.setMemberName(this.ocContractDomain.getContractRemark());
        if (ListUtil.isNotEmpty(this.ocContractDomain.getOcContractSettlList())) {
            dot.setMemberBname(this.ocContractDomain.getOcContractSettlList().get(0).getContractSettlOpemo());
        }
        if (ListUtil.isNotEmpty(this.ocContractDomain.getGoodsList())) {
            dot.setGoodsType(this.ocContractDomain.getGoodsList().get(0).getGoodsType());
        }
        dot.setPayState(1);
        dot.setMschannelCode(this.ocContractDomain.getChannelCode());
        if ("busBBC".equals(this.ocContractDomain.getChannelCode())) {
            dot.setMschannelName("\u5c0f\u7a0b\u5e8f");
        } else {
            dot.setMschannelName(this.ocContractDomain.getChannelName());
        }
        this.logger.error("-----dot-----", (Object)JsonUtil.buildNormalBinder().toJson((Object)dot));
        daOrderTotalList.add(dot);
        this.orderTotalService.saveOrderTotalReBatch(daOrderTotalList);
    }

    public void statistics(OcContractDomain ocContractDomain) {
        this.logger.error("--------\u8ba1\u7b97\u5546\u54c1\u603b\u503c\u5f00\u59cb----------");
        for (OcContractGoodsDomain cg : ocContractDomain.getGoodsList()) {
            BigDecimal goodsNum = cg.getGoodsNum();
            BigDecimal pricesetRefrice = cg.getContractGoodsPrice().compareTo(BigDecimal.valueOf(0L)) >= 0 ? cg.getContractGoodsPefprice() : cg.getPricesetNprice();
            BigDecimal pricesetNprice = cg.getContractGoodsPrice().compareTo(BigDecimal.valueOf(0L)) >= 0 ? cg.getContractGoodsPrice() : cg.getPricesetNprice();
            BigDecimal pricesetRefriceSum = goodsNum.multiply(pricesetRefrice);
            BigDecimal pricesetNpriceSum = goodsNum.multiply(pricesetNprice);
            HashMap<String, Object> param = new HashMap<String, Object>();
            String memberMcode = cg.getSkuCode();
            param.put("memberMcode", memberMcode);
            String tenantCode = cg.getTenantCode();
            param.put("tenantCode", tenantCode);
            String memberCode = cg.getMemberCcode();
            param.put("memberCode", memberCode);
            DaStatistics statisticsByCodes = this.statisticsService.getStatisticsByCodes(tenantCode, memberMcode, memberCode);
            if (null != statisticsByCodes) {
                pricesetRefriceSum = pricesetRefriceSum.add(statisticsByCodes.getSellingPrice());
                param.put("sellingPrice", pricesetRefriceSum);
                pricesetNpriceSum = pricesetNpriceSum.add(statisticsByCodes.getGoodsCost());
                param.put("goodsCost", pricesetNpriceSum);
                this.statisticsService.updateStatisticsAmount(param);
            } else {
                DaStatisticsDomain statisticsDomain = new DaStatisticsDomain();
                statisticsDomain.setMemberMcode(memberMcode);
                statisticsDomain.setMemberCode(memberCode);
                statisticsDomain.setMemberName(cg.getMemberCname());
                statisticsDomain.setTenantCode(tenantCode);
                statisticsDomain.setSellingPrice(pricesetRefriceSum);
                statisticsDomain.setGoodsCost(pricesetNpriceSum);
                statisticsDomain.setDiscountCount(BigDecimal.valueOf(0L));
                statisticsDomain.setPaidIn(BigDecimal.valueOf(0L));
                this.statisticsService.saveStatistics(statisticsDomain);
            }
            this.logger.error("--------\u8ba1\u7b97\u5546\u54c1\u603b\u503c\u7ed3\u675f----------");
        }
        DaOrderLog log = this.orderLogService.getOrderLogByCode(this.orderLogDomain.getTenantCode(), this.orderLogDomain.getLogCode());
        if (null != log) {
            DaOrderLogDomain dld = new DaOrderLogDomain();
            try {
                BeanUtils.copyAllPropertys((Object)dld, (Object)log);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            dld.setLogStat(false);
            this.orderLogService.updateOrderLog(dld);
        }
    }

    public void start() {
        new Thread(this).start();
    }
}

