/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.data.thread;

import com.yqbsoft.laser.service.data.domain.OcContractDomain;
import com.yqbsoft.laser.service.data.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.data.domain.OcContractSettlDomain;
import com.yqbsoft.laser.service.data.model.DaOrderTotal;
import com.yqbsoft.laser.service.data.model.OrgDepartemp;
import com.yqbsoft.laser.service.data.model.OrgEmployee;
import com.yqbsoft.laser.service.data.service.DaOrderTotalService;
import com.yqbsoft.laser.service.esb.core.auth.BaseAuth;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.model.RsSku;
import com.yqbsoft.laser.service.resources.service.RsSkuService;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class CyySendOrderTotalThread
implements Runnable {
    private final DaOrderTotalService orderTotalService;
    private final RsSkuService rsSkuService;
    private final OcContractDomain ocContractDomain;
    protected final SupperLogUtil logger = new SupperLogUtil(this.getClass());

    public CyySendOrderTotalThread(DaOrderTotalService orderTotalService, RsSkuService rsSkuService, OcContractDomain ocContractDomain) {
        this.orderTotalService = orderTotalService;
        this.rsSkuService = rsSkuService;
        this.ocContractDomain = ocContractDomain;
    }

    @Override
    public void run() {
        this.logger.error("----\u5f00\u59cb------");
        ArrayList<DaOrderTotal> daOrderTotalList = new ArrayList<DaOrderTotal>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        String tenantCode = this.ocContractDomain.getTenantCode();
        map.put("channelClearSeqno", this.ocContractDomain.getContractBillcode());
        map.put("tenantCode", tenantCode);
        QueryResult<DaOrderTotal> daOrderTotalQueryResult = this.orderTotalService.queryOrderTotalPage(map);
        if (ListUtil.isEmpty((Collection)daOrderTotalQueryResult.getList())) {
            this.logger.error("----\u65e0\u8bb0\u5f55------");
            List<OcContractGoodsDomain> goodsList = this.ocContractDomain.getGoodsList();
            if (ListUtil.isNotEmpty(goodsList)) {
                for (OcContractGoodsDomain cg : goodsList) {
                    List<OcContractSettlDomain> ocContractSettls;
                    DaOrderTotal dot = new DaOrderTotal();
                    dot.setAppmanageIcode(this.ocContractDomain.getAppmanageIcode());
                    dot.setTenantCode(tenantCode);
                    dot.setMemberBname(this.ocContractDomain.getUserName());
                    if (StringUtils.isNotBlank((String)this.ocContractDomain.getMemberBcode())) {
                        dot.setMemberBcode(this.ocContractDomain.getMemberBcode());
                        HashMap<String, String> mapEmployee = new HashMap<String, String>();
                        mapEmployee.put("tenantCode", this.ocContractDomain.getTenantCode());
                        mapEmployee.put("userinfoCode", this.ocContractDomain.getMemberBcode());
                        String orgEmployeeQueryString = (String)BaseAuth.internalRouter.inInvoke("org.employee.queryEmployeePage", "1.0", "0", map);
                        SupQueryResult orgEmployeeQuery = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(orgEmployeeQueryString, SupQueryResult.class);
                        if (null != orgEmployeeQuery && ListUtil.isNotEmpty((Collection)orgEmployeeQuery.getList())) {
                            dot.setMschannelCode(((OrgEmployee)orgEmployeeQuery.getList().get(0)).getCompanyCode());
                            dot.setMschannelName(((OrgEmployee)orgEmployeeQuery.getList().get(0)).getCompanyShortname());
                            HashMap<String, String> paramMap = new HashMap<String, String>();
                            paramMap.put("tenantCode", tenantCode);
                            paramMap.put("employeeCode", ((OrgEmployee)orgEmployeeQuery.getList().get(0)).getEmployeeCode());
                            String orgDepartempQueryString = (String)BaseAuth.internalRouter.inInvoke("org.depart.queryDepartempPage", "1.0", "0", map);
                            SupQueryResult orgDepartempQuery = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(orgDepartempQueryString, SupQueryResult.class);
                            if (null != orgDepartempQuery && ListUtil.isNotEmpty((Collection)orgDepartempQuery.getList())) {
                                dot.setChannelCode(((OrgDepartemp)orgDepartempQuery.getList().get(0)).getDepartCode());
                                dot.setChannelName(((OrgDepartemp)orgDepartempQuery.getList().get(0)).getDepartName());
                            }
                        }
                    }
                    dot.setMemberCode(this.ocContractDomain.getMemberCcode());
                    dot.setMemberName(this.ocContractDomain.getMemberCname());
                    dot.setInsuranceOpcode(this.ocContractDomain.getGoodsReceiptMem());
                    dot.setInsuranceOpcode1(this.ocContractDomain.getGoodsReceiptPhone());
                    dot.setInsuranceOpcode2(this.ocContractDomain.getGoodsReceiptArrdess());
                    dot.setContractObillcode(this.ocContractDomain.getContractBbillcode());
                    dot.setChannelClearSeqno(this.ocContractDomain.getContractBillcode());
                    dot.setDataOcstate(this.ocContractDomain.getDataState());
                    dot.setOrderTotalType(this.ocContractDomain.getContractType());
                    dot.setInsuranceOpcode3(cg.getGoodsName());
                    dot.setGoodsClass(cg.getGoodsNo());
                    dot.setSkuName(cg.getSkuName());
                    dot.setSkuShowno(cg.getSkuNo());
                    BigDecimal goodsPrice = cg.getPricesetNprice();
                    dot.setPricesetNrpice(goodsPrice);
                    dot.setOrderTotalNum(cg.getGoodsNum());
                    dot.setOrderTotalNum1(goodsPrice.multiply(cg.getGoodsNum()));
                    HashMap<String, String> paramSku = new HashMap<String, String>();
                    paramSku.put("skuNo", cg.getSkuNo());
                    paramSku.put("channelVer", "0");
                    paramSku.put("tenantCode", tenantCode);
                    this.logger.error("--getSkuByCode---", (Object)JsonUtil.buildNormalBinder().toJson(paramSku));
                    RsSku byCode = this.rsSkuService.getSkuBySkuNoAndMemberCode(cg.getSkuNo(), cg.getMemberCcode(), tenantCode);
                    if (byCode != null) {
                        dot.setOrderTotalNum2(byCode.getPricesetAsprice());
                        dot.setOrderTotalNum3(byCode.getPricesetAsprice().multiply(cg.getGoodsNum()));
                    }
                    dot.setOrderTotalNum4(this.ocContractDomain.getGoodsLogmoney());
                    dot.setOrderRefrice(this.ocContractDomain.getGoodsPmoney());
                    dot.setOrderNprice(this.ocContractDomain.getDataBmoney());
                    if (this.ocContractDomain.getDataState() == 2 && ListUtil.isNotEmpty(ocContractSettls = this.ocContractDomain.getOcContractSettlList())) {
                        for (OcContractSettlDomain contractSettl : ocContractSettls) {
                            if ("VD".equals(contractSettl.getContractSettlBlance())) {
                                dot.setOrderTotalNum5(contractSettl.getContractSettlPmoney());
                            } else if ("CAS".equals(contractSettl.getContractSettlBlance())) {
                                dot.setPricesetMaxeprice(contractSettl.getContractSettlPmoney());
                            }
                            dot.setOrderTotalDate(this.ocContractDomain.getGmtModified());
                        }
                    }
                    daOrderTotalList.add(dot);
                }
            }
            this.logger.error("----\u4e94\u8bb0\u5f55-----\u63d2\u5165\u6570\u636e------", (Object)JsonUtil.buildNormalBinder().toJson(daOrderTotalList));
            this.orderTotalService.saveOrderTotalReBatch(daOrderTotalList);
        } else {
            this.logger.error("----\u6709\u8bb0\u5f55-----\u8ba2\u5355\u72b6\u6001------", (Object)this.ocContractDomain.getDataState());
            map.put("dataOcstate", this.ocContractDomain.getDataState());
            if (2 == this.ocContractDomain.getDataState()) {
                List<OcContractSettlDomain> ocContractSettls = this.ocContractDomain.getOcContractSettlList();
                if (ListUtil.isNotEmpty(ocContractSettls)) {
                    for (OcContractSettlDomain contractSettl : ocContractSettls) {
                        if ("VD".equals(contractSettl.getContractSettlBlance())) {
                            map.put("orderTotalNum5", contractSettl.getContractSettlPmoney());
                            continue;
                        }
                        if (!"CAS".equals(contractSettl.getContractSettlBlance())) continue;
                        map.put("pricesetMaxeprice", contractSettl.getContractSettlPmoney());
                    }
                }
                map.put("orderTotalDate", this.ocContractDomain.getGmtModified());
                this.logger.error("----\u652f\u4ed8\u4fee\u6539\u6570\u636e-----", (Object)JsonUtil.buildNormalBinder().toJson(map));
            } else if (3 == this.ocContractDomain.getDataState() && ListUtil.isNotEmpty(this.ocContractDomain.getPackageList())) {
                String memberMname = this.ocContractDomain.getPackageList().get(0).getExpressName();
                String memberMcode = this.ocContractDomain.getPackageList().get(0).getExpressCode();
                String orderBankseq = this.ocContractDomain.getPackageList().get(0).getPackageBillno();
                map.put("memberMname", memberMname);
                map.put("memberMcode", memberMcode);
                map.put("orderBankseq", orderBankseq);
            }
            this.logger.error("--updateOrderTotalDataOcstate---", (Object)JsonUtil.buildNormalBinder().toJson(map));
            this.orderTotalService.updateOrderTotalCyy(map);
        }
    }

    public void start() {
        new Thread(this).start();
    }
}

