/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.data.service.impl;

import com.yqbsoft.laser.service.data.dao.DaOrderTotalGoodsMapper;
import com.yqbsoft.laser.service.data.domain.DaOrderTotalGoodsDomain;
import com.yqbsoft.laser.service.data.model.DaOrderTotalGoods;
import com.yqbsoft.laser.service.data.service.DaOrderTotalGoodsService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class DaOrderTotalGoodsServiceImpl
extends BaseServiceImpl
implements DaOrderTotalGoodsService {
    private static final String SYS_CODE = SYS_CODE + ".DaOrderTotalGoodsServiceImpl";
    @Autowired
    private DaOrderTotalGoodsMapper daOrderTotalGoodsMapper;

    public void setDaOrderTotalGoodsMapper(DaOrderTotalGoodsMapper daOrderTotalGoodsMapper) {
        this.daOrderTotalGoodsMapper = daOrderTotalGoodsMapper;
    }

    @Override
    public String saveOrderTotalGoodsBatch(List<DaOrderTotalGoodsDomain> daOrderTotalGoodsDomainList) throws ApiException {
        if (null == daOrderTotalGoodsDomainList || daOrderTotalGoodsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DaOrderTotalGoods> daOrderTotalGoodsList = new ArrayList<DaOrderTotalGoods>();
        String code = "";
        for (DaOrderTotalGoodsDomain daOrderTotalGoodsDomain : daOrderTotalGoodsDomainList) {
            DaOrderTotalGoods daOrderTotalGoods = this.createDaOrderTotalGoods(daOrderTotalGoodsDomain);
            code = daOrderTotalGoods.getOrderTotalGoodsCode();
            daOrderTotalGoodsList.add(daOrderTotalGoods);
        }
        this.saveOrderTotalGoodsBatchModel(daOrderTotalGoodsList);
        return code;
    }

    private DaOrderTotalGoods createDaOrderTotalGoods(DaOrderTotalGoodsDomain daOrderTotalGoodsDomain) {
        String msg = this.checkOrderTotalGoods(daOrderTotalGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(SYS_CODE + ".saveOrderTotalGoods.checkOrderTotalGoods", msg);
        }
        DaOrderTotalGoods daOrderTotalGoods = this.makeOrderTotalGoods(daOrderTotalGoodsDomain, null);
        this.setOrderTotalGoodsDefault(daOrderTotalGoods);
        return daOrderTotalGoods;
    }

    private void setOrderTotalGoodsDefault(DaOrderTotalGoods daOrderTotalGoods) {
        if (null == daOrderTotalGoods) {
            return;
        }
        if (null == daOrderTotalGoods.getDataState()) {
            daOrderTotalGoods.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == daOrderTotalGoods.getGmtCreate()) {
            daOrderTotalGoods.setGmtCreate(date);
        }
        daOrderTotalGoods.setGmtModified(date);
        if (StringUtils.isBlank((String)daOrderTotalGoods.getOrderTotalGoodsCode())) {
            daOrderTotalGoods.setOrderTotalGoodsCode(this.getNo(null, "DaOrderTotalGoods", "daOrderTotalGoods", daOrderTotalGoods.getTenantCode()));
        }
    }

    private Date getSysDate() {
        try {
            return this.daOrderTotalGoodsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getSysDate", (Throwable)e);
            return null;
        }
    }

    private DaOrderTotalGoods makeOrderTotalGoods(DaOrderTotalGoodsDomain daOrderTotalGoodsDomain, DaOrderTotalGoods daOrderTotalGoods) {
        if (null == daOrderTotalGoodsDomain) {
            return null;
        }
        if (null == daOrderTotalGoods) {
            daOrderTotalGoods = new DaOrderTotalGoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)daOrderTotalGoods, (Object)daOrderTotalGoodsDomain);
            return daOrderTotalGoods;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeOrderTotalGoods", (Throwable)e);
            return null;
        }
    }

    private String checkOrderTotalGoods(DaOrderTotalGoodsDomain daOrderTotalGoodsDomain) {
        if (null == daOrderTotalGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)daOrderTotalGoodsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void saveOrderTotalGoodsBatchModel(List<DaOrderTotalGoods> daOrderTotalGoodsList) throws ApiException {
        if (null == daOrderTotalGoodsList || daOrderTotalGoodsList.isEmpty()) {
            return;
        }
        try {
            this.daOrderTotalGoodsMapper.insertBatch(daOrderTotalGoodsList);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".saveOrderTotalGoodsBatchModel.ex", (Throwable)e);
        }
    }
}

