/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.data.service.impl;

import com.yqbsoft.laser.service.data.dao.DaOrderTotalMapper;
import com.yqbsoft.laser.service.data.domain.DaOrderTotalDomain;
import com.yqbsoft.laser.service.data.domain.DaOrderTotalGoodsDomain;
import com.yqbsoft.laser.service.data.domain.OcContractDomain;
import com.yqbsoft.laser.service.data.domain.SgSendgoodsGoodsDomain;
import com.yqbsoft.laser.service.data.model.DaOrderTotal;
import com.yqbsoft.laser.service.data.model.RsSku;
import com.yqbsoft.laser.service.data.service.DaOrderTotalGoodsService;
import com.yqbsoft.laser.service.data.service.DaOrderTotalService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class DaOrderTotalServiceImpl
extends BaseServiceImpl
implements DaOrderTotalService {
    private static final String SYS_CODE = SYS_CODE + ".DaOrderTotalServiceImpl";
    @Autowired
    private DaOrderTotalMapper daOrderTotalMapper;
    @Autowired
    private DaOrderTotalGoodsService daOrderTotalGoodsService;

    @Override
    public QueryResult<DaOrderTotal> queryOrderTotalPage(Map<String, Object> map) {
        List<DaOrderTotal> daOrderTotalList = this.queryOrderTotalModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOrderTotal(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(daOrderTotalList);
        return queryResult;
    }

    @Override
    public String saveOrderTotalReBatch(List<DaOrderTotal> daOrderTotalList) throws ApiException {
        if (null == daOrderTotalList || daOrderTotalList.isEmpty()) {
            return null;
        }
        ArrayList<DaOrderTotal> daOrderTotalLists = new ArrayList<DaOrderTotal>();
        String code = "";
        for (DaOrderTotal orderTotal : daOrderTotalList) {
            this.setOrderTotalDefault(orderTotal);
            code = orderTotal.getOrderTotalCode();
            daOrderTotalLists.add(orderTotal);
        }
        this.saveOrderTotalBatchModel(daOrderTotalLists);
        return code;
    }

    @Override
    public String updateOrderTotalCyy(Map<String, Object> map) throws ApiException {
        int i = 0;
        try {
            i = this.daOrderTotalMapper.updateOrderTotalCyy(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateOrderTotalDataOcstate.ex", (Throwable)e);
        }
        return "success";
    }

    @Override
    public String saveOrderTotalWithContract(OcContractDomain ocContractDomain) throws ApiException {
        if (ocContractDomain == null) {
            this.logger.error(SYS_CODE + "saveOrderTotalWithContract param is null");
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("insuranceOpcode", ocContractDomain.getContractBillcode());
        map.put("orderTotalType", "1");
        map.put("tenantCode", ocContractDomain.getTenantCode());
        int orderNum = this.countOrderTotal(map);
        if (0 != orderNum) {
            this.logger.info(SYS_CODE, (Object)(ocContractDomain.getContractBillcode() + "-----\u8be5\u8ba2\u5355\u5df2\u5b58\u5728"));
            return "success";
        }
        this.logger.info(SYS_CODE + "ocContractReDomain code is " + ocContractDomain.getContractBillcode());
        DaOrderTotalDomain domain = this.makeDomainWithContract(ocContractDomain);
        this.saveOrderTotalGoodsByBillBCode(domain);
        if (ListUtil.isEmpty(domain.getOrderTotalGoodsDomainList())) {
            this.logger.error(SYS_CODE, (Object)"\u6b63\u5411\u5355\u6ca1\u6709\u53d1\u8d27\u5355,\u65b0\u589e\u5931\u8d25");
            return "success";
        }
        DaOrderTotal daOrderTotal = this.createDaOrderTotal(domain);
        this.saveOrderTotalModel(daOrderTotal);
        for (DaOrderTotalGoodsDomain goodsDomain : domain.getOrderTotalGoodsDomainList()) {
            goodsDomain.setOrderTotalCode(daOrderTotal.getOrderTotalCode());
        }
        this.daOrderTotalGoodsService.saveOrderTotalGoodsBatch(domain.getOrderTotalGoodsDomainList());
        return "success";
    }

    public DaOrderTotalDomain makeDomainWithContract(OcContractDomain reDomain) {
        DaOrderTotalDomain totalDomain = new DaOrderTotalDomain();
        totalDomain.setMemberMcode(reDomain.getMemberMcode());
        totalDomain.setMemberMname(reDomain.getMemberMname());
        totalDomain.setMemberCode(reDomain.getMemberCode());
        totalDomain.setMemberName(reDomain.getMemberName());
        totalDomain.setMemberBcode(reDomain.getMemberBcode());
        totalDomain.setMemberBname(reDomain.getMemberBname());
        totalDomain.setInsuranceOpcode(reDomain.getContractBillcode());
        totalDomain.setInsuranceOpcode1(reDomain.getContractNbbillcode());
        totalDomain.setOrderTotalDate(reDomain.getGmtCreate());
        totalDomain.setChannelCode(reDomain.getChannelCode());
        totalDomain.setChannelName(reDomain.getChannelName());
        totalDomain.setTenantCode(reDomain.getTenantCode());
        totalDomain.setDataOcstate(reDomain.getDataState());
        totalDomain.setOrderTotalType("1");
        totalDomain.setOrderTotalDate1(reDomain.getGmtModified());
        totalDomain.setOrderTotalNum(reDomain.getDataBnum());
        totalDomain.setOrderTotalNum1(reDomain.getDataBmoney());
        totalDomain.setOrderTotalNum2(reDomain.getDataBmoney().divide(new BigDecimal("1.13"), 2, 4));
        totalDomain.setOrderTotalNum3(totalDomain.getOrderTotalNum1().subtract(totalDomain.getOrderTotalNum2()));
        return totalDomain;
    }

    public void saveOrderTotalGoodsByBillBCode(DaOrderTotalDomain orderTotalDomain) throws ApiException {
        String apiCode = "sg.sendgoods.querySendgoodsGoodsPage";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", orderTotalDomain.getTenantCode());
        map.put("contractBillcode", orderTotalDomain.getInsuranceOpcode());
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        List sgSendgoodsDomain = this.getQueryResutl(apiCode, invokeMap, SgSendgoodsGoodsDomain.class).getList();
        if (ListUtil.isEmpty((Collection)sgSendgoodsDomain)) {
            this.logger.error(SYS_CODE, (Object)"saveOrderTotalGoodsByBillBCode sgSendgoodsDomainList is null");
            return;
        }
        BigDecimal srp = new BigDecimal("0.00");
        ArrayList<DaOrderTotalGoodsDomain> totalGoods = new ArrayList<DaOrderTotalGoodsDomain>();
        for (SgSendgoodsGoodsDomain sendgoodsDomain : sgSendgoodsDomain) {
            DaOrderTotalGoodsDomain totalGoodsDomain = this.makeGoodsDomainWithsendtGoods(sendgoodsDomain, orderTotalDomain);
            totalGoodsDomain.setInsuranceOpcode2(orderTotalDomain.getInsuranceOpcode2());
            totalGoodsDomain.setOrderTotalType(orderTotalDomain.getOrderTotalType());
            totalGoodsDomain.setOrderTotalOrdertype(orderTotalDomain.getOrderTotalOrdertype());
            totalGoodsDomain.setInsuranceOpcode(orderTotalDomain.getInsuranceOpcode());
            totalGoodsDomain.setInsuranceOpcode1(orderTotalDomain.getInsuranceOpcode1());
            totalGoods.add(totalGoodsDomain);
            srp = srp.add(totalGoodsDomain.getOrderTotalNum4());
        }
        orderTotalDomain.setOrderTotalNum4(srp);
        orderTotalDomain.setOrderTotalGoodsDomainList(totalGoods);
    }

    public DaOrderTotalGoodsDomain makeGoodsDomainWithsendtGoods(SgSendgoodsGoodsDomain goodsDomain, DaOrderTotalDomain orderTotalDomain) {
        DaOrderTotalGoodsDomain domain = new DaOrderTotalGoodsDomain();
        try {
            BeanUtils.copyAllPropertys((Object)domain, (Object)goodsDomain);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeGoodsDomainWithsendtGoods", (Throwable)e);
        }
        domain.setSkuCode(goodsDomain.getSkuNo());
        domain.setSkuName(goodsDomain.getSkuName());
        domain.setGoodsClass(goodsDomain.getGoodsName());
        if (null == domain.getSkuName()) {
            domain.setSkuName(goodsDomain.getSkuShowno());
        }
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("skuNo", goodsDomain.getSkuNo());
        map1.put("memberCode", orderTotalDomain.getMemberCode());
        map1.put("channelCode", orderTotalDomain.getChannelCode());
        map1.put("tenantCode", goodsDomain.getTenantCode());
        map1.put("memberCcode", goodsDomain.getMemberCcode());
        RsSku rsSku = (RsSku)this.getForObject("rs.sku.getSkuBySkuNo", RsSku.class, map1);
        if (null != rsSku) {
            domain.setGoodsType(rsSku.getGoodsType());
            domain.setGoodsPro(rsSku.getGoodsPro());
        }
        domain.setOrderTotalNum(goodsDomain.getSendgoodsGoodsCamount());
        domain.setOrderTotalNum1(goodsDomain.getContractGoodsMoney());
        domain.setGoodsNum(goodsDomain.getSendgoodsGoodsCamount());
        domain.setOrderTotalNum5(goodsDomain.getContractGoodsPrice());
        domain.setOrderTotalNum2(goodsDomain.getContractGoodsMoney().divide(new BigDecimal("1.13"), 2, 4));
        domain.setOrderTotalNum3(domain.getOrderTotalNum1().subtract(domain.getOrderTotalNum2()));
        domain.setOrderTotalNum4(goodsDomain.getPricesetNprice());
        return domain;
    }

    private List<DaOrderTotal> queryOrderTotalModelPage(Map<String, Object> parammap) {
        try {
            return this.daOrderTotalMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".queryOrderTotalModel", (Throwable)e);
            return null;
        }
    }

    private int countOrderTotal(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.daOrderTotalMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".countOrderTotal", (Throwable)e);
        }
        return i;
    }

    private void setOrderTotalDefault(DaOrderTotal daOrderTotal) {
        if (null == daOrderTotal) {
            return;
        }
        if (null == daOrderTotal.getDataState()) {
            daOrderTotal.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == daOrderTotal.getGmtCreate()) {
            daOrderTotal.setGmtCreate(date);
        }
        daOrderTotal.setGmtModified(date);
        if (StringUtils.isBlank((String)daOrderTotal.getOrderTotalCode())) {
            daOrderTotal.setOrderTotalCode(this.getNo(null, "DaOrderTotal", "daOrderTotal", daOrderTotal.getTenantCode()));
        }
    }

    private void saveOrderTotalBatchModel(List<DaOrderTotal> daOrderTotalList) throws ApiException {
        if (null == daOrderTotalList || daOrderTotalList.isEmpty()) {
            return;
        }
        try {
            this.daOrderTotalMapper.insertBatch(daOrderTotalList);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".saveOrderTotalBatchModel.ex", (Throwable)e);
        }
    }

    private DaOrderTotal createDaOrderTotal(DaOrderTotalDomain daOrderTotalDomain) {
        String msg = this.checkOrderTotal(daOrderTotalDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(SYS_CODE + ".saveOrderTotal.checkOrderTotal", msg);
        }
        DaOrderTotal daOrderTotal = this.makeOrderTotal(daOrderTotalDomain, null);
        this.setOrderTotalDefault(daOrderTotal);
        return daOrderTotal;
    }

    private String checkOrderTotal(DaOrderTotalDomain daOrderTotalDomain) {
        if (null == daOrderTotalDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)daOrderTotalDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void saveOrderTotalModel(DaOrderTotal daOrderTotal) throws ApiException {
        if (null == daOrderTotal) {
            return;
        }
        try {
            this.daOrderTotalMapper.insert(daOrderTotal);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".saveOrderTotalModel.ex", (Throwable)e);
        }
    }

    private DaOrderTotal makeOrderTotal(DaOrderTotalDomain daOrderTotalDomain, DaOrderTotal daOrderTotal) {
        if (null == daOrderTotalDomain) {
            return null;
        }
        if (null == daOrderTotal) {
            daOrderTotal = new DaOrderTotal();
        }
        try {
            BeanUtils.copyAllPropertys((Object)daOrderTotal, (Object)daOrderTotalDomain);
            return daOrderTotal;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeOrderTotal", (Throwable)e);
            return null;
        }
    }

    private Date getSysDate() {
        try {
            return this.daOrderTotalMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getSysDate", (Throwable)e);
            return null;
        }
    }
}

