/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.data.service.impl;

import com.yqbsoft.laser.service.data.dao.DaOrderTotalMapper;
import com.yqbsoft.laser.service.data.domain.CmChannelClearStatementDomain;
import com.yqbsoft.laser.service.data.domain.DaOrderTotalDomain;
import com.yqbsoft.laser.service.data.domain.DaOrderTotalGoodsDomain;
import com.yqbsoft.laser.service.data.domain.OcContractDomain;
import com.yqbsoft.laser.service.data.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.data.domain.OcContractSettlDomain;
import com.yqbsoft.laser.service.data.domain.OcRefundDomain;
import com.yqbsoft.laser.service.data.domain.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.data.domain.SgSendgoodsDomain;
import com.yqbsoft.laser.service.data.domain.SgSendgoodsGoodsDomain;
import com.yqbsoft.laser.service.data.domain.UmUserDomain;
import com.yqbsoft.laser.service.data.domain.VdFaccountInfo;
import com.yqbsoft.laser.service.data.model.CmChannelClearReDomain;
import com.yqbsoft.laser.service.data.model.DaOrderTotal;
import com.yqbsoft.laser.service.data.model.DaOrderTotalGoods;
import com.yqbsoft.laser.service.data.model.OcContractSettl;
import com.yqbsoft.laser.service.data.model.OrgDepartemp;
import com.yqbsoft.laser.service.data.model.OrgEmployee;
import com.yqbsoft.laser.service.data.model.RsSku;
import com.yqbsoft.laser.service.data.service.DaOrderTotalGoodsService;
import com.yqbsoft.laser.service.data.service.DaOrderTotalService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.auth.BaseAuth;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class DaOrderTotalServiceImpl
extends BaseServiceImpl
implements DaOrderTotalService {
    private static final String SYS_CODE = SYS_CODE + ".DaOrderTotalServiceImpl";
    @Autowired
    private DaOrderTotalMapper daOrderTotalMapper;
    @Autowired
    private DaOrderTotalGoodsService daOrderTotalGoodsService;

    @Override
    public QueryResult<DaOrderTotal> queryOrderTotalPage(Map<String, Object> map) {
        List<DaOrderTotal> daOrderTotalList = this.queryOrderTotalModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOrderTotal(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(daOrderTotalList);
        return queryResult;
    }

    @Override
    public String saveOrderTotalReBatch(List<DaOrderTotal> daOrderTotalList) throws ApiException {
        if (null == daOrderTotalList || daOrderTotalList.isEmpty()) {
            return null;
        }
        ArrayList<DaOrderTotal> daOrderTotalLists = new ArrayList<DaOrderTotal>();
        String code = "";
        for (DaOrderTotal orderTotal : daOrderTotalList) {
            this.setOrderTotalDefault(orderTotal);
            code = orderTotal.getOrderTotalCode();
            daOrderTotalLists.add(orderTotal);
        }
        this.saveOrderTotalBatchModel(daOrderTotalLists);
        return code;
    }

    @Override
    public String updateOrderTotalCyy(Map<String, Object> map) throws ApiException {
        int i = 0;
        try {
            i = this.daOrderTotalMapper.updateOrderTotalCyy(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateOrderTotalDataOcstate.ex", (Throwable)e);
        }
        return "success";
    }

    private String updateOrderTotalWl(Map<String, Object> map) throws ApiException {
        int i = 0;
        try {
            i = this.daOrderTotalMapper.updateOrderTotalWl(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateOrderTotalDataOcstate.ex", (Throwable)e);
        }
        return "success";
    }

    @Override
    public String saveOrderTotalWithContract(OcContractDomain ocContractDomain) throws ApiException {
        if (ocContractDomain == null) {
            this.logger.error(SYS_CODE + "saveOrderTotalWithContract param is null");
            return null;
        }
        this.saveDaOrderTotal(ocContractDomain);
        return "success";
    }

    private String saveOrderTotalWithContractData(OcContractDomain ocContractDomain) {
        this.logger.info(SYS_CODE + "\u8ba2\u5355\uff1a " + JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channelClearSeqno", ocContractDomain.getContractBillcode());
        map.put("orderTotalType", "1");
        map.put("tenantCode", ocContractDomain.getTenantCode());
        int orderNum = this.countOrderTotal(map);
        if (0 != orderNum) {
            this.logger.info(SYS_CODE, (Object)(ocContractDomain.getContractBillcode() + "-----\u8be5\u8ba2\u5355\u5df2\u5b58\u5728"));
            return "success";
        }
        this.logger.info(SYS_CODE + "ocContractReDomain code is " + ocContractDomain.getContractBillcode());
        DaOrderTotalDomain domain = this.makeDomainWithContract(ocContractDomain);
        this.saveOrderTotalGoodsByBillBCode(domain);
        if (ListUtil.isEmpty(domain.getOrderTotalGoodsDomainList())) {
            this.logger.error(SYS_CODE, (Object)"\u6b63\u5411\u5355\u6ca1\u6709\u53d1\u8d27\u5355,\u65b0\u589e\u5931\u8d25");
            return "success";
        }
        DaOrderTotal daOrderTotal = this.createDaOrderTotal(domain);
        this.saveOrderTotalModel(daOrderTotal);
        for (DaOrderTotalGoodsDomain goodsDomain : domain.getOrderTotalGoodsDomainList()) {
            goodsDomain.setOrderTotalCode(daOrderTotal.getOrderTotalCode());
        }
        this.daOrderTotalGoodsService.saveOrderTotalGoodsBatch(domain.getOrderTotalGoodsDomainList());
        return "success";
    }

    private void saveDaOrderTotal(OcContractDomain ocContractDomain) {
        ArrayList<DaOrderTotal> daOrderTotalList = new ArrayList<DaOrderTotal>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        String tenantCode = ocContractDomain.getTenantCode();
        map.put("channelClearSeqno", ocContractDomain.getContractBillcode());
        map.put("tenantCode", tenantCode);
        int orderNum = this.countOrderTotal(map);
        if (0 != orderNum) {
            this.logger.info(SYS_CODE, (Object)(ocContractDomain.getContractBillcode() + "-----\u8be5\u8ba2\u5355\u5df2\u5b58\u5728"));
            return;
        }
        this.logger.error("----\u65e0\u8bb0\u5f55------");
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        if (ListUtil.isNotEmpty(goodsList)) {
            for (OcContractGoodsDomain cg : goodsList) {
                DaOrderTotal dot = new DaOrderTotal();
                dot.setAppmanageIcode(ocContractDomain.getAppmanageIcode());
                dot.setTenantCode(tenantCode);
                dot.setMemberBname(ocContractDomain.getUserName());
                if (StringUtils.isNotBlank((String)ocContractDomain.getMemberBcode())) {
                    UmUserDomain userDomain;
                    dot.setMemberBcode(ocContractDomain.getMemberBcode());
                    HashMap<String, String> mapUser = new HashMap<String, String>();
                    mapUser.put("userPcode", ocContractDomain.getMemberBcode());
                    mapUser.put("tenantCode", ocContractDomain.getTenantCode());
                    String userString = (String)BaseAuth.internalRouter.inInvoke("um.user.getUserByPcode", "1.0", "0", mapUser);
                    if (StringUtils.isNotBlank((String)userString) && null != (userDomain = (UmUserDomain)JsonUtil.buildNormalBinder().getJsonToObject(userString, UmUserDomain.class))) {
                        dot.setUserinfoOcode(userDomain.getUserOcode());
                    }
                    HashMap<String, String> pmap = new HashMap<String, String>();
                    HashMap<String, String> mapEmployee = new HashMap<String, String>();
                    mapEmployee.put("tenantCode", ocContractDomain.getTenantCode());
                    mapEmployee.put("userinfoCode", ocContractDomain.getMemberBcode());
                    pmap.put("map", JsonUtil.buildNormalBinder().toJson(mapEmployee));
                    String orgEmployeeQueryString = (String)BaseAuth.internalRouter.inInvoke("org.employee.queryEmployeePage", "1.0", "0", pmap);
                    QueryResult orgEmployeeQuery = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(orgEmployeeQueryString, QueryResult.class);
                    List list = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)orgEmployeeQuery.getList()), OrgEmployee.class);
                    orgEmployeeQuery.setList(list);
                    if (null != orgEmployeeQuery && ListUtil.isNotEmpty((Collection)orgEmployeeQuery.getList())) {
                        dot.setMschannelCode(((OrgEmployee)orgEmployeeQuery.getList().get(0)).getCompanyCode());
                        dot.setMschannelName(((OrgEmployee)orgEmployeeQuery.getList().get(0)).getCompanyShortname());
                        HashMap<String, String> pmap1 = new HashMap<String, String>();
                        HashMap<String, String> paramMap = new HashMap<String, String>();
                        paramMap.put("tenantCode", tenantCode);
                        paramMap.put("employeeCode", ((OrgEmployee)orgEmployeeQuery.getList().get(0)).getEmployeeCode());
                        pmap1.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
                        String orgDepartempQueryString = (String)BaseAuth.internalRouter.inInvoke("org.depart.queryDepartempPage", "1.0", "0", pmap1);
                        QueryResult orgDepartempQuery = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(orgDepartempQueryString, QueryResult.class);
                        List list2 = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)orgDepartempQuery.getList()), OrgDepartemp.class);
                        orgDepartempQuery.setList(list2);
                        if (null != orgDepartempQuery && ListUtil.isNotEmpty((Collection)orgDepartempQuery.getList())) {
                            dot.setChannelCode(((OrgDepartemp)orgDepartempQuery.getList().get(0)).getDepartCode());
                            dot.setChannelName(((OrgDepartemp)orgDepartempQuery.getList().get(0)).getDepartName());
                        }
                    }
                }
                dot.setMemberCode(ocContractDomain.getMemberCcode());
                dot.setMemberName(ocContractDomain.getMemberCname());
                dot.setInsuranceOpcode(ocContractDomain.getGoodsReceiptMem());
                dot.setInsuranceOpcode1(ocContractDomain.getGoodsReceiptPhone());
                dot.setInsuranceOpcode2(ocContractDomain.getGoodsReceiptArrdess());
                dot.setContractObillcode(ocContractDomain.getContractBbillcode());
                dot.setChannelClearSeqno(ocContractDomain.getContractBillcode());
                dot.setDataOcstate(ocContractDomain.getDataState());
                dot.setOrderTotalType(ocContractDomain.getContractType());
                dot.setInsuranceOpcode3(cg.getGoodsName());
                dot.setGoodsClass(cg.getGoodsNo());
                dot.setSkuName(cg.getSkuName());
                dot.setSkuShowno(cg.getSkuNo());
                BigDecimal goodsPrice = cg.getPricesetNprice();
                dot.setPricesetNrpice(goodsPrice);
                dot.setOrderTotalNum(cg.getGoodsNum());
                dot.setOrderTotalNum1(goodsPrice.multiply(cg.getGoodsNum()));
                HashMap<String, String> paramSku = new HashMap<String, String>();
                paramSku.put("skuNo", cg.getSkuNo());
                paramSku.put("channelVer", "0");
                paramSku.put("tenantCode", tenantCode);
                this.logger.error("--getSkuByCode---", (Object)JsonUtil.buildNormalBinder().toJson(paramSku));
                HashMap<String, String> mapSku = new HashMap<String, String>();
                mapSku.put("tenantCode", tenantCode);
                mapSku.put("memberCode", cg.getMemberCcode());
                mapSku.put("skuNo", cg.getSkuNo());
                String rsSkuString = (String)BaseAuth.internalRouter.inInvoke("rs.sku.getSkuBySkuNoAndMemberCode", "1.0", "0", mapSku);
                RsSku byCode = (RsSku)JsonUtil.buildNormalBinder().getJsonToObject(rsSkuString, RsSku.class);
                if (byCode != null) {
                    dot.setOrderTotalNum2(byCode.getPricesetAsprice());
                    dot.setOrderTotalNum3(byCode.getPricesetAsprice().multiply(cg.getGoodsNum()));
                }
                dot.setOrderTotalNum4(ocContractDomain.getGoodsLogmoney());
                dot.setOrderRefrice(ocContractDomain.getGoodsPmoney());
                dot.setOrderNprice(ocContractDomain.getDataBmoney());
                if (ocContractDomain.getDataState() == 2) {
                    List<OcContractSettlDomain> ocContractSettls = ocContractDomain.getOcContractSettlList();
                    if (ListUtil.isNotEmpty(ocContractSettls)) {
                        for (OcContractSettlDomain contractSettl : ocContractSettls) {
                            if ("VD".equals(contractSettl.getContractSettlBlance())) {
                                dot.setOrderTotalNum5(contractSettl.getContractSettlPmoney());
                                continue;
                            }
                            if (!"CAS".equals(contractSettl.getContractSettlBlance())) continue;
                            HashMap<String, String> pmap2 = new HashMap<String, String>();
                            HashMap<String, String> paramSettl = new HashMap<String, String>();
                            paramSettl.put("tenantCode", contractSettl.getTenantCode());
                            paramSettl.put("businessOrderno", ocContractDomain.getContractBbillcode());
                            paramSettl.put("dicClearCode", "PAY");
                            pmap2.put("map", JsonUtil.buildNormalBinder().toJson(paramSettl));
                            String cmChannelClearReDomainSupString = (String)BaseAuth.internalRouter.inInvoke("cm.channelClear.querychannelClearPage", "1.0", "0", pmap2);
                            QueryResult cmChannelClearReDomainSup = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(cmChannelClearReDomainSupString, QueryResult.class);
                            List list = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)cmChannelClearReDomainSup.getList()), CmChannelClearReDomain.class);
                            if (null == list || !ListUtil.isNotEmpty((Collection)list)) continue;
                            boolean flag = false;
                            for (CmChannelClearReDomain channelClear : list) {
                                if (2 != channelClear.getDataState()) continue;
                                flag = true;
                                break;
                            }
                            if (!flag) continue;
                            dot.setPricesetMaxeprice(contractSettl.getContractSettlPmoney());
                        }
                    } else {
                        HashMap<String, String> paramMap = new HashMap<String, String>();
                        paramMap.put("tenantCode", tenantCode);
                        paramMap.put("contractBillcode", ocContractDomain.getContractBbillcode());
                        String ocContractSettlStr = (String)BaseAuth.internalRouter.inInvoke("oc.contract.queryContractSettlByContractCode", "1.0", "0", paramMap);
                        List ocContractSettlList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)ocContractSettlStr), OcContractSettl.class);
                        if (ListUtil.isNotEmpty((Collection)ocContractSettlList)) {
                            for (OcContractSettl contractSettl : ocContractSettlList) {
                                if ("VD".equals(contractSettl.getContractSettlBlance())) {
                                    dot.setOrderTotalNum5(contractSettl.getContractSettlPmoney());
                                    continue;
                                }
                                if (!"CAS".equals(contractSettl.getContractSettlBlance())) continue;
                                HashMap<String, String> pmap2 = new HashMap<String, String>();
                                HashMap<String, String> paramSettl = new HashMap<String, String>();
                                paramSettl.put("tenantCode", contractSettl.getTenantCode());
                                paramSettl.put("businessOrderno", ocContractDomain.getContractBbillcode());
                                paramSettl.put("dicClearCode", "PAY");
                                pmap2.put("map", JsonUtil.buildNormalBinder().toJson(paramSettl));
                                String cmChannelClearReDomainSupString = (String)BaseAuth.internalRouter.inInvoke("cm.channelClear.querychannelClearPage", "1.0", "0", pmap2);
                                QueryResult cmChannelClearReDomainSup = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(cmChannelClearReDomainSupString, QueryResult.class);
                                List list = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)cmChannelClearReDomainSup.getList()), CmChannelClearReDomain.class);
                                if (null == list || !ListUtil.isNotEmpty((Collection)list)) continue;
                                boolean flag = false;
                                for (CmChannelClearReDomain channelClear : list) {
                                    if (2 != channelClear.getDataState()) continue;
                                    flag = true;
                                    break;
                                }
                                if (!flag) continue;
                                dot.setPricesetMaxeprice(contractSettl.getContractSettlPmoney());
                            }
                        }
                    }
                    dot.setOrderTotalDate(ocContractDomain.getGmtModified());
                    if (null == ocContractDomain.getGmtModified()) {
                        dot.setOrderTotalDate(new Date());
                    }
                }
                daOrderTotalList.add(dot);
            }
        }
        this.logger.error("----\u4e94\u8bb0\u5f55-----\u63d2\u5165\u6570\u636e------", (Object)JsonUtil.buildNormalBinder().toJson(daOrderTotalList));
        this.saveOrderTotalReBatch(daOrderTotalList);
    }

    @Override
    public String saveOrderTotalWithRefund(OcRefundDomain ocRefundDomain) {
        if (ocRefundDomain != null && ListUtil.isNotEmpty(ocRefundDomain.getOcRefundGoodsDomainList())) {
            for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundDomain.getOcRefundGoodsDomainList()) {
                HashMap<String, Object> param = new HashMap<String, Object>();
                param.put("channelClearSeqno", ocRefundDomain.getContractBillcode());
                param.put("tenantCode", ocRefundDomain.getTenantCode());
                param.put("refundCode", ocRefundDomain.getRefundCode());
                param.put("skuShowno", ocRefundGoodsDomain.getSkuNo());
                param.put("dataOcstate", -1);
                param.put("refundTime", new Date());
                this.logger.error("----\u9000\u6b3e--\u62a5\u8868\u4fee\u6539\u6570\u636e-----", (Object)JsonUtil.buildNormalBinder().toJson(param));
                this.updateOrderTotalCyy(param);
            }
        }
        return "success";
    }

    @Override
    public String saveOrderTotalLogistics(SgSendgoodsDomain sgSendgoodsDomain) {
        this.logger.info("----\u53d1\u8d27--\u62a5\u8868\u4fee\u6539\u6570\u636e-----", (Object)JsonUtil.buildNormalBinder().toJson((Object)sgSendgoodsDomain));
        if (sgSendgoodsDomain == null) {
            return "success";
        }
        if (ListUtil.isNotEmpty(sgSendgoodsDomain.getSgSendgoodsGoodsDomainList())) {
            for (SgSendgoodsGoodsDomain sgSendgoodsGoodsDomain : sgSendgoodsDomain.getSgSendgoodsGoodsDomainList()) {
                this.updateOrderTotal(sgSendgoodsDomain, sgSendgoodsGoodsDomain.getSkuNo());
            }
        } else {
            this.updateOrderTotal(sgSendgoodsDomain, null);
        }
        return "success";
    }

    public String getEndDayByLastMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, -1);
        calendar.set(5, calendar.getActualMaximum(5));
        Date lastDayOfPreviousMonth = calendar.getTime();
        return DateUtils.getDateString((Date)lastDayOfPreviousMonth, (String)"yyyy-MM-dd 23:59:59");
    }

    @Override
    public String saveOrderTotalByReconciliation(String tenantCode, String startDate, String endDate, String type, Map<String, Object> map) {
        VdFaccountInfo vdFaccountInfo;
        this.logger.info(SYS_CODE + ".saveOrderTotalByReconciliation.param", (Object)(tenantCode + "=" + type + "=" + JsonUtil.buildNormalBinder().toJson(map)));
        if (StringUtils.isBlank((String)startDate)) {
            startDate = DateUtils.getBeforeMonth((int)-1, (String)"yyyy-MM-01 00:00:00");
        }
        if (StringUtils.isBlank((String)endDate)) {
            endDate = this.getEndDayByLastMonth();
        }
        String queryStatementType = "T1,T2,C01,C02,P01";
        String queryVdType = "201";
        if (StringUtils.isNotBlank((String)type)) {
            if (type.contains(";")) {
                String[] split = type.split(";");
                queryStatementType = split[0];
                queryVdType = split[1];
            } else {
                queryStatementType = type;
            }
        }
        Map queryParamMap = this.getQueryParamMap("tenantCode,startDate,endDate,businessType", new Object[]{tenantCode, startDate, endDate, queryStatementType});
        Map sendMap = this.getQueryParamMap("map", new Object[]{JsonUtil.buildNormalBinder().toJson((Object)queryParamMap)});
        QueryResult queryResutl = this.getQueryResutl("cm.channelClear.queryStatement", sendMap, CmChannelClearStatementDomain.class);
        if (null == queryResutl || ListUtil.isEmpty((Collection)queryResutl.getList())) {
            this.logger.error(SYS_CODE + ".saveOrderTotalByReconciliation.data.null", (Object)(tenantCode + "\uff1adataList is null"));
            return "success";
        }
        this.logger.info(SYS_CODE + ".saveOrderTotalByReconciliation.data.size", (Object)(JsonUtil.buildNormalBinder().toJson((Object)queryParamMap) + "=" + queryResutl.getList().size()));
        HashMap<String, String> dataFilter = new HashMap<String, String>();
        for (CmChannelClearStatementDomain cmChannelClearStatementDomain : queryResutl.getList()) {
            String faccountOuterNo = cmChannelClearStatementDomain.getFaccountOuterNo();
            dataFilter.put(faccountOuterNo, faccountOuterNo);
        }
        String vdOuterStr = "";
        for (String dataByUserStr : dataFilter.keySet()) {
            if (StringUtils.isNotBlank((String)vdOuterStr)) {
                vdOuterStr = vdOuterStr + ",";
            }
            vdOuterStr = vdOuterStr + dataByUserStr;
        }
        Map queryParamMap1 = this.getQueryParamMap("faccountOuterNo,tenantCode,faccountType", new Object[]{vdOuterStr, tenantCode, queryVdType});
        Map sendMap1 = this.getQueryParamMap("map", new Object[]{JsonUtil.buildNormalBinder().toJson((Object)queryParamMap1)});
        QueryResult vdFaccountInfoQueryResult = this.getQueryResutl("vd.faccountOuter.queryFaccountOuterPage", sendMap1, VdFaccountInfo.class);
        if (null == vdFaccountInfoQueryResult || ListUtil.isEmpty((Collection)vdFaccountInfoQueryResult.getList())) {
            this.logger.error(SYS_CODE + ".saveOrderTotalByReconciliation.vdFaccountInfoQueryResult.null", (Object)JsonUtil.buildNormalBinder().toJson((Object)queryParamMap1));
            return "error";
        }
        HashMap<String, VdFaccountInfo> VdFaccountInfoMap = new HashMap<String, VdFaccountInfo>();
        HashMap<String, VdFaccountInfo> VdFaccountInfoByUserinfoCodeMap = new HashMap<String, VdFaccountInfo>();
        for (VdFaccountInfo vdFaccountInfo2 : vdFaccountInfoQueryResult.getList()) {
            VdFaccountInfoMap.put(vdFaccountInfo2.getFaccountOuterNo(), vdFaccountInfo2);
            if (VdFaccountInfoByUserinfoCodeMap.containsKey(vdFaccountInfo2.getMerchantCode())) continue;
            VdFaccountInfoByUserinfoCodeMap.put(vdFaccountInfo2.getMerchantCode(), vdFaccountInfo2);
        }
        HashMap<String, ArrayList<CmChannelClearStatementDomain>> dataByUserMap = new HashMap<String, ArrayList<CmChannelClearStatementDomain>>();
        for (CmChannelClearStatementDomain cmChannelClearStatementDomain : queryResutl.getList()) {
            String faccountOuterNo = cmChannelClearStatementDomain.getFaccountOuterNo();
            vdFaccountInfo = (VdFaccountInfo)VdFaccountInfoMap.get(faccountOuterNo);
            if (null == vdFaccountInfo) {
                this.logger.error(SYS_CODE + ".saveOrderTotalByReconciliation.pickVdAccount.null", (Object)faccountOuterNo);
                return "error";
            }
            String merchantCode = vdFaccountInfo.getMerchantCode();
            ArrayList<CmChannelClearStatementDomain> cmChannelClearStatementDomains = (ArrayList<CmChannelClearStatementDomain>)dataByUserMap.get(merchantCode);
            if (null == cmChannelClearStatementDomains) {
                cmChannelClearStatementDomains = new ArrayList<CmChannelClearStatementDomain>();
            }
            cmChannelClearStatementDomains.add(cmChannelClearStatementDomain);
            dataByUserMap.put(merchantCode, cmChannelClearStatementDomains);
        }
        if (MapUtil.isEmpty(dataByUserMap)) {
            this.logger.error(SYS_CODE + ".saveOrderTotalByReconciliation.dataByUserMap.null", (Object)(tenantCode + "=" + startDate + "=" + endDate));
            return "error";
        }
        ArrayList<DaOrderTotalDomain> daOrderTotalDomainSumList = new ArrayList<DaOrderTotalDomain>();
        for (String key : dataByUserMap.keySet()) {
            vdFaccountInfo = (VdFaccountInfo)VdFaccountInfoByUserinfoCodeMap.get(key);
            List cmChannelClearStatementDomains = (List)dataByUserMap.get(key);
            DaOrderTotalDomain assOrderTotalData = this.assOrderTotalData(vdFaccountInfo, cmChannelClearStatementDomains);
            assOrderTotalData.setContractObillcode(startDate + " \u2014\u2014 " + endDate);
            daOrderTotalDomainSumList.add(assOrderTotalData);
        }
        for (DaOrderTotalDomain daOrderTotalDomain : daOrderTotalDomainSumList) {
            DaOrderTotal daOrderTotal = this.createDaOrderTotal(daOrderTotalDomain);
            this.saveOrderTotalModel(daOrderTotal);
            String orderTotalCode = daOrderTotal.getOrderTotalCode();
            List<DaOrderTotalGoodsDomain> orderTotalGoodsDomainList = daOrderTotalDomain.getOrderTotalGoodsDomainList();
            for (DaOrderTotalGoodsDomain daOrderTotalGoodsDomain : orderTotalGoodsDomainList) {
                daOrderTotalGoodsDomain.setOrderTotalCode(orderTotalCode);
            }
            this.daOrderTotalGoodsService.saveOrderTotalGoodsBatch(orderTotalGoodsDomainList);
        }
        return "success";
    }

    @Override
    public QueryResult<DaOrderTotalDomain> queryOrderTotalDomainPage(Map<String, Object> map) {
        List<DaOrderTotal> daOrderTotalList = this.queryOrderTotalModelPage(map);
        ArrayList<DaOrderTotalDomain> daOrderTotalDomainList = new ArrayList<DaOrderTotalDomain>();
        if (ListUtil.isNotEmpty(daOrderTotalList)) {
            HashMap<String, Object> detailMap = new HashMap<String, Object>();
            for (DaOrderTotal daOrderTotal : daOrderTotalList) {
                DaOrderTotalDomain daOrderTotalDomain = this.makeDomain(daOrderTotal);
                if (null != map && map.containsKey("goodsDetail")) {
                    detailMap.put("orderTotalCode", daOrderTotal.getOrderTotalCode());
                    detailMap.put("tenantCode", daOrderTotal.getTenantCode());
                    QueryResult<DaOrderTotalGoods> daOrderTotalGoodsQueryResult = this.daOrderTotalGoodsService.queryOrderTotalGoodsPage(detailMap);
                    if (null != daOrderTotalGoodsQueryResult && ListUtil.isNotEmpty((Collection)daOrderTotalGoodsQueryResult.getList())) {
                        List daOrderTotalGoodsDomainList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)daOrderTotalGoodsQueryResult.getList()), DaOrderTotalGoodsDomain.class);
                        daOrderTotalDomain.setOrderTotalGoodsDomainList(daOrderTotalGoodsDomainList);
                    }
                }
                daOrderTotalDomainList.add(daOrderTotalDomain);
            }
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countOrderTotal(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(daOrderTotalDomainList);
        return queryResult;
    }

    @Override
    public void updateOrderTotalStateByCode(String tenantCode, String orderTotalCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)orderTotalCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateOrderTotalModelByCode(tenantCode, orderTotalCode, dataState, oldDataState, map);
    }

    @Override
    public void updateOrderTotal(DaOrderTotalDomain daOrderTotalDomain) throws ApiException {
        String msg = this.checkOrderTotal(daOrderTotalDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(SYS_CODE + ".updateOrderTotal.checkOrderTotal", msg);
        }
        DaOrderTotal oldDaOrderTotal = this.getOrderTotalModelById(daOrderTotalDomain.getOrderTotalId());
        if (null == oldDaOrderTotal) {
            throw new ApiException(SYS_CODE + ".updateOrderTotal.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DaOrderTotal daOrderTotal = this.makeOrderTotal(daOrderTotalDomain, oldDaOrderTotal);
        this.setOrderTotalUpdataDefault(daOrderTotal);
        this.updateOrderTotalModel(daOrderTotal);
    }

    private void updateOrderTotalModel(DaOrderTotal daOrderTotal) throws ApiException {
        if (null == daOrderTotal) {
            return;
        }
        int i = 0;
        try {
            i = this.daOrderTotalMapper.updateByPrimaryKey(daOrderTotal);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateOrderTotalModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".updateOrderTotalModel.num");
        }
    }

    private void setOrderTotalUpdataDefault(DaOrderTotal daOrderTotal) {
        if (null == daOrderTotal) {
            return;
        }
        daOrderTotal.setGmtModified(this.getSysDate());
    }

    private DaOrderTotal getOrderTotalModelById(Integer orderTotalId) {
        if (null == orderTotalId) {
            return null;
        }
        try {
            return this.daOrderTotalMapper.selectByPrimaryKey(orderTotalId);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getOrderTotalModelById", (Throwable)e);
            return null;
        }
    }

    private DaOrderTotalDomain makeDomain(DaOrderTotal daOrderTotal) {
        if (null == daOrderTotal) {
            return null;
        }
        DaOrderTotalDomain daOrderTotalDomain = new DaOrderTotalDomain();
        try {
            BeanUtils.copyAllPropertys((Object)daOrderTotalDomain, (Object)daOrderTotal);
            return daOrderTotalDomain;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeDomain", (Throwable)e);
            return null;
        }
    }

    private DaOrderTotalDomain assOrderTotalData(VdFaccountInfo vdFaccountInfo, List<CmChannelClearStatementDomain> cmChannelClearStatementDomains) {
        if (null == vdFaccountInfo || ListUtil.isEmpty(cmChannelClearStatementDomains)) {
            this.logger.error(SYS_CODE + ".saveOrderTotalByReconciliation.assOrderTotalData.null", (Object)(null == vdFaccountInfo + "=" + ListUtil.isEmpty(cmChannelClearStatementDomains) ? 1 : 0));
            return null;
        }
        CmChannelClearStatementDomain lastData = cmChannelClearStatementDomains.get(0);
        CmChannelClearStatementDomain firstData = cmChannelClearStatementDomains.get(cmChannelClearStatementDomains.size() - 1);
        DaOrderTotalDomain daOrderTotalDomain = new DaOrderTotalDomain();
        daOrderTotalDomain.setTenantCode(vdFaccountInfo.getTenantCode());
        daOrderTotalDomain.setMemberBcode(vdFaccountInfo.getMerchantCode());
        daOrderTotalDomain.setMemberBname(vdFaccountInfo.getMerchantName());
        daOrderTotalDomain.setOrderTotalType("10");
        daOrderTotalDomain.setOrderTotalNum(vdFaccountInfo.getFaccountPortion());
        daOrderTotalDomain.setOrderTotalNum1(firstData.getFaccountBfamount());
        daOrderTotalDomain.setOrderTotalNum2(lastData.getFaccountAfamount());
        ArrayList<DaOrderTotalGoodsDomain> daOrderTotalGoodsDomains = new ArrayList<DaOrderTotalGoodsDomain>();
        BigDecimal sumMoney = BigDecimal.ZERO;
        for (CmChannelClearStatementDomain cmChannelClearStatementDomain : cmChannelClearStatementDomains) {
            DaOrderTotalGoodsDomain daOrderTotalGoodsDomain = new DaOrderTotalGoodsDomain();
            String businessType = cmChannelClearStatementDomain.getBusinessType();
            String goodsNo = StringUtils.isNotBlank((String)cmChannelClearStatementDomain.getOcGoodsNo()) ? cmChannelClearStatementDomain.getOcGoodsNo() : cmChannelClearStatementDomain.getOcrGoodsNo();
            String goodsName = StringUtils.isNotBlank((String)cmChannelClearStatementDomain.getOcGoodsName()) ? cmChannelClearStatementDomain.getOcGoodsName() : cmChannelClearStatementDomain.getOcrGoodsName();
            String contractBillcode = StringUtils.isNotBlank((String)cmChannelClearStatementDomain.getOcContractBillcode()) ? cmChannelClearStatementDomain.getOcContractBillcode() : cmChannelClearStatementDomain.getOcrContractBillcode();
            String goodsType = StringUtils.isNotBlank((String)cmChannelClearStatementDomain.getOcGoodsType()) ? cmChannelClearStatementDomain.getOcGoodsType() : cmChannelClearStatementDomain.getOcrGoodsType();
            BigDecimal orderAmount = cmChannelClearStatementDomain.getOrderAmount();
            if (!org.apache.commons.lang3.StringUtils.equalsAny((CharSequence)cmChannelClearStatementDomain.getPtradpdeCode(), (CharSequence[])new CharSequence[]{"RECHARGEULINE", "TRANSFER"})) {
                orderAmount = null != cmChannelClearStatementDomain.getOcContractGoodsMoney() ? cmChannelClearStatementDomain.getOcContractGoodsMoney() : cmChannelClearStatementDomain.getOcrRefundGoodsAmt();
            }
            daOrderTotalGoodsDomain.setOrderTotalType(businessType);
            daOrderTotalGoodsDomain.setGoodsNo(goodsNo);
            daOrderTotalGoodsDomain.setSkuName(goodsName);
            daOrderTotalGoodsDomain.setInsuranceOpcode1(contractBillcode);
            daOrderTotalGoodsDomain.setInsuranceOpcode2(cmChannelClearStatementDomain.getOcrRefundCode());
            daOrderTotalGoodsDomain.setInsuranceOpcode3(DateUtil.getDateString((Date)cmChannelClearStatementDomain.getGmtCreate(), (String)"yyyy-MM-dd HH:mm:ss"));
            daOrderTotalGoodsDomain.setSkuCode(null != cmChannelClearStatementDomain.getOcGmtCreate() ? DateUtil.getDateString((Date)cmChannelClearStatementDomain.getOcGmtCreate(), (String)"yyyy-MM-dd HH:mm:ss") : (null != cmChannelClearStatementDomain.getOcrGmtCreate() ? DateUtil.getDateString((Date)cmChannelClearStatementDomain.getOcrGmtCreate(), (String)"yyyy-MM-dd HH:mm:ss") : null));
            daOrderTotalGoodsDomain.setGoodsType(goodsType);
            daOrderTotalGoodsDomain.setOrderTotalNum(cmChannelClearStatementDomain.getOcGoodsCamount());
            daOrderTotalGoodsDomain.setOrderTotalNum1(cmChannelClearStatementDomain.getOcContractGoodsMoney());
            daOrderTotalGoodsDomain.setOrderTotalNum2(cmChannelClearStatementDomain.getOcPricesetNprice());
            daOrderTotalGoodsDomain.setOrderTotalNum3(cmChannelClearStatementDomain.getOcrRefundGoodsNum());
            daOrderTotalGoodsDomain.setOrderTotalNum4(cmChannelClearStatementDomain.getOcrRefundGoodsAmt());
            daOrderTotalGoodsDomain.setTenantCode(vdFaccountInfo.getTenantCode());
            if ("1".equals(cmChannelClearStatementDomain.getOrderDc())) {
                orderAmount = orderAmount.negate();
            }
            daOrderTotalGoodsDomain.setOrderTotalNum5(orderAmount);
            sumMoney = sumMoney.add(orderAmount);
            daOrderTotalGoodsDomains.add(daOrderTotalGoodsDomain);
        }
        daOrderTotalDomain.setOrderTotalNum3(sumMoney);
        daOrderTotalDomain.setOrderTotalGoodsDomainList(daOrderTotalGoodsDomains);
        return daOrderTotalDomain;
    }

    private void updateOrderTotal(SgSendgoodsDomain sgSendgoodsDomain, String skuNo) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelClearSeqno", sgSendgoodsDomain.getContractBillcode());
        param.put("skuShowno", skuNo);
        param.put("tenantCode", sgSendgoodsDomain.getTenantCode());
        param.put("memberMname", sgSendgoodsDomain.getPackageName());
        param.put("memberMcode", sgSendgoodsDomain.getPackageMode());
        param.put("orderBankseq", sgSendgoodsDomain.getPackageBillno());
        this.updateOrderTotalWl(param);
    }

    public DaOrderTotalDomain makeDomainWithContract(OcContractDomain reDomain) {
        DaOrderTotalDomain totalDomain = new DaOrderTotalDomain();
        totalDomain.setMemberMcode(reDomain.getMemberMcode());
        totalDomain.setMemberMname(reDomain.getMemberMname());
        totalDomain.setMemberCode(reDomain.getMemberCode());
        totalDomain.setMemberName(reDomain.getMemberName());
        totalDomain.setMemberBcode(reDomain.getMemberBcode());
        totalDomain.setMemberBname(reDomain.getMemberBname());
        totalDomain.setChannelClearSeqno(reDomain.getContractBillcode());
        totalDomain.setContractNbbillcode(reDomain.getContractNbbillcode());
        totalDomain.setInsuranceOpcode(reDomain.getGoodsReceiptMem());
        totalDomain.setInsuranceOpcode1(reDomain.getGoodsReceiptPhone());
        totalDomain.setInsuranceOpcode2(reDomain.getGoodsReceiptArrdess());
        totalDomain.setOrderTotalDate(reDomain.getGmtCreate());
        totalDomain.setChannelCode(reDomain.getChannelCode());
        totalDomain.setChannelName(reDomain.getChannelName());
        totalDomain.setTenantCode(reDomain.getTenantCode());
        totalDomain.setDataOcstate(reDomain.getDataState());
        totalDomain.setOrderTotalType("1");
        totalDomain.setOrderTotalDate1(reDomain.getGmtModified());
        totalDomain.setOrderTotalNum(reDomain.getDataBnum());
        totalDomain.setOrderTotalNum1(reDomain.getDataBmoney());
        totalDomain.setOrderTotalNum2(reDomain.getDataBmoney().divide(new BigDecimal("1.13"), 2, 4));
        totalDomain.setOrderTotalNum3(totalDomain.getOrderTotalNum1().subtract(totalDomain.getOrderTotalNum2()));
        return totalDomain;
    }

    public void saveOrderTotalGoodsByBillBCode(DaOrderTotalDomain orderTotalDomain) throws ApiException {
        String apiCode = "sg.sendgoods.querySendgoodsGoodsPage";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", orderTotalDomain.getTenantCode());
        map.put("contractBillcode", orderTotalDomain.getChannelClearSeqno());
        HashMap<String, String> invokeMap = new HashMap<String, String>();
        invokeMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(map));
        List sgSendgoodsDomain = this.getQueryResutl(apiCode, invokeMap, SgSendgoodsGoodsDomain.class).getList();
        if (ListUtil.isEmpty((Collection)sgSendgoodsDomain)) {
            this.logger.error(SYS_CODE, (Object)"saveOrderTotalGoodsByBillBCode sgSendgoodsDomainList is null");
            return;
        }
        BigDecimal srp = new BigDecimal("0.00");
        ArrayList<DaOrderTotalGoodsDomain> totalGoods = new ArrayList<DaOrderTotalGoodsDomain>();
        for (SgSendgoodsGoodsDomain sendgoodsDomain : sgSendgoodsDomain) {
            DaOrderTotalGoodsDomain totalGoodsDomain = this.makeGoodsDomainWithsendtGoods(sendgoodsDomain, orderTotalDomain);
            totalGoodsDomain.setInsuranceOpcode2(orderTotalDomain.getInsuranceOpcode2());
            totalGoodsDomain.setOrderTotalType(orderTotalDomain.getOrderTotalType());
            totalGoodsDomain.setOrderTotalOrdertype(orderTotalDomain.getOrderTotalOrdertype());
            totalGoodsDomain.setInsuranceOpcode(orderTotalDomain.getChannelClearSeqno());
            totalGoodsDomain.setInsuranceOpcode1(orderTotalDomain.getInsuranceOpcode1());
            totalGoods.add(totalGoodsDomain);
            srp = srp.add(totalGoodsDomain.getOrderTotalNum4());
        }
        orderTotalDomain.setOrderTotalNum4(srp);
        orderTotalDomain.setOrderTotalGoodsDomainList(totalGoods);
    }

    public DaOrderTotalGoodsDomain makeGoodsDomainWithsendtGoods(SgSendgoodsGoodsDomain goodsDomain, DaOrderTotalDomain orderTotalDomain) {
        DaOrderTotalGoodsDomain domain = new DaOrderTotalGoodsDomain();
        try {
            BeanUtils.copyAllPropertys((Object)domain, (Object)goodsDomain);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeGoodsDomainWithsendtGoods", (Throwable)e);
        }
        domain.setSkuCode(goodsDomain.getSkuNo());
        domain.setSkuName(goodsDomain.getSkuName());
        domain.setGoodsClass(goodsDomain.getGoodsName());
        if (null == domain.getSkuName()) {
            domain.setSkuName(goodsDomain.getSkuShowno());
        }
        HashMap<String, String> map1 = new HashMap<String, String>();
        map1.put("skuNo", goodsDomain.getSkuNo());
        map1.put("memberCode", orderTotalDomain.getMemberCode());
        map1.put("channelCode", orderTotalDomain.getChannelCode());
        map1.put("tenantCode", goodsDomain.getTenantCode());
        map1.put("memberCcode", goodsDomain.getMemberCcode());
        RsSku rsSku = (RsSku)this.getForObject("rs.sku.getSkuBySkuNo", RsSku.class, map1);
        if (null != rsSku) {
            domain.setGoodsType(rsSku.getGoodsType());
            domain.setGoodsPro(rsSku.getGoodsPro());
        }
        domain.setOrderTotalNum(goodsDomain.getSendgoodsGoodsCamount());
        domain.setOrderTotalNum1(goodsDomain.getContractGoodsMoney());
        domain.setGoodsNum(goodsDomain.getSendgoodsGoodsCamount());
        domain.setOrderTotalNum5(goodsDomain.getContractGoodsPrice());
        domain.setOrderTotalNum2(goodsDomain.getContractGoodsMoney().divide(new BigDecimal("1.13"), 2, 4));
        domain.setOrderTotalNum3(domain.getOrderTotalNum1().subtract(domain.getOrderTotalNum2()));
        domain.setOrderTotalNum4(goodsDomain.getPricesetNprice());
        return domain;
    }

    private List<DaOrderTotal> queryOrderTotalModelPage(Map<String, Object> parammap) {
        try {
            return this.daOrderTotalMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".queryOrderTotalModel", (Throwable)e);
            return null;
        }
    }

    private int countOrderTotal(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.daOrderTotalMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".countOrderTotal", (Throwable)e);
        }
        return i;
    }

    private void updateStateOrderTotalModelByCode(String tenantCode, String orderTotalCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)orderTotalCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("orderTotalCode", orderTotalCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.daOrderTotalMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStateOrderTotalModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException(SYS_CODE + ".updateStateOrderTotalModelByCode.null");
        }
    }

    private void setOrderTotalDefault(DaOrderTotal daOrderTotal) {
        if (null == daOrderTotal) {
            return;
        }
        if (null == daOrderTotal.getDataState()) {
            daOrderTotal.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == daOrderTotal.getGmtCreate()) {
            daOrderTotal.setGmtCreate(date);
        }
        daOrderTotal.setGmtModified(date);
        if (StringUtils.isBlank((String)daOrderTotal.getOrderTotalCode())) {
            daOrderTotal.setOrderTotalCode(this.getNo(null, "DaOrderTotal", "daOrderTotal", daOrderTotal.getTenantCode()));
        }
    }

    private void saveOrderTotalBatchModel(List<DaOrderTotal> daOrderTotalList) throws ApiException {
        if (null == daOrderTotalList || daOrderTotalList.isEmpty()) {
            return;
        }
        try {
            this.daOrderTotalMapper.insertBatch(daOrderTotalList);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".saveOrderTotalBatchModel.ex", (Throwable)e);
        }
    }

    private DaOrderTotal createDaOrderTotal(DaOrderTotalDomain daOrderTotalDomain) {
        String msg = this.checkOrderTotal(daOrderTotalDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(SYS_CODE + ".saveOrderTotal.checkOrderTotal", msg);
        }
        DaOrderTotal daOrderTotal = this.makeOrderTotal(daOrderTotalDomain, null);
        this.setOrderTotalDefault(daOrderTotal);
        return daOrderTotal;
    }

    private String checkOrderTotal(DaOrderTotalDomain daOrderTotalDomain) {
        if (null == daOrderTotalDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)daOrderTotalDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void saveOrderTotalModel(DaOrderTotal daOrderTotal) throws ApiException {
        if (null == daOrderTotal) {
            return;
        }
        try {
            this.daOrderTotalMapper.insert(daOrderTotal);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".saveOrderTotalModel.ex", (Throwable)e);
        }
    }

    private DaOrderTotal makeOrderTotal(DaOrderTotalDomain daOrderTotalDomain, DaOrderTotal daOrderTotal) {
        if (null == daOrderTotalDomain) {
            return null;
        }
        if (null == daOrderTotal) {
            daOrderTotal = new DaOrderTotal();
        }
        try {
            BeanUtils.copyAllPropertys((Object)daOrderTotal, (Object)daOrderTotalDomain);
            return daOrderTotal;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeOrderTotal", (Throwable)e);
            return null;
        }
    }

    private Date getSysDate() {
        try {
            return this.daOrderTotalMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getSysDate", (Throwable)e);
            return null;
        }
    }
}

