/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.data.thread;

import com.yqbsoft.laser.service.contract.domain.OcRefundReDomain;
import com.yqbsoft.laser.service.contract.model.OcRefundGoods;
import com.yqbsoft.laser.service.data.domain.DaOpsumListDomain;
import com.yqbsoft.laser.service.data.domain.OcRefundDomain;
import com.yqbsoft.laser.service.data.domain.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.data.model.DaOpsumList;
import com.yqbsoft.laser.service.data.service.DaOpsumListService;
import com.yqbsoft.laser.service.data.service.DaOrderTotalService;
import com.yqbsoft.laser.service.esb.core.auth.BaseAuth;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.resources.model.RsResourceGoods;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class CyySendRefundTotalThread
implements Runnable {
    private final DaOrderTotalService orderTotalService;
    private final OcRefundDomain ocRefundDomain;
    private final DaOpsumListService daOpsumListService;
    private final SupperLogUtil logger = new SupperLogUtil(this.getClass());

    public CyySendRefundTotalThread(DaOrderTotalService orderTotalService, OcRefundDomain ocRefundDomain, DaOpsumListService daOpsumListService) {
        this.orderTotalService = orderTotalService;
        this.ocRefundDomain = ocRefundDomain;
        this.daOpsumListService = daOpsumListService;
    }

    @Override
    public void run() {
        String tenantCode = this.ocRefundDomain.getTenantCode();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("channelClearSeqno", this.ocRefundDomain.getContractBillcode());
        param.put("tenantCode", this.ocRefundDomain.getTenantCode());
        param.put("orderTotalDate1", new Date());
        if ("0".equals(this.ocRefundDomain.getRefundUsertype())) {
            this.saveSum("RefundEx", new BigDecimal("1"), this.ocRefundDomain.getRefundEx(), this.ocRefundDomain.getRefundEx(), this.ocRefundDomain.getTenantCode(), null, null);
        }
        for (OcRefundGoodsDomain refundGoodsDomain : this.ocRefundDomain.getOcRefundGoodsDomainList()) {
            param.put("skuShowno", refundGoodsDomain.getSkuNo());
            HashMap<String, String> pmap = new HashMap<String, String>();
            HashMap<String, String> mapReGoods = new HashMap<String, String>();
            mapReGoods.put("tenantCode", this.ocRefundDomain.getTenantCode());
            mapReGoods.put("contractGoodsCode", refundGoodsDomain.getContractGoodsCode());
            pmap.put("map", JsonUtil.buildNormalBinder().toJson(mapReGoods));
            String refundGoodsQueryString = (String)BaseAuth.internalRouter.inInvoke("oc.refund.queryRefundGoodsPage", "1.0", "0", pmap);
            QueryResult refundGoodsQuery = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(refundGoodsQueryString, QueryResult.class);
            List list = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)refundGoodsQuery.getList()), OcRefundGoods.class);
            if (ListUtil.isNotEmpty((Collection)list)) {
                BigDecimal refundGoodsNum = BigDecimal.ZERO;
                for (OcRefundGoods ocRefundGoods : list) {
                    HashMap<String, String> pmap2 = new HashMap<String, String>();
                    HashMap<String, String> mapRe = new HashMap<String, String>();
                    mapRe.put("tenantCode", this.ocRefundDomain.getTenantCode());
                    mapRe.put("refundCode", ocRefundGoods.getRefundCode());
                    pmap2.put("map", JsonUtil.buildNormalBinder().toJson(mapRe));
                    String refundReDomainStr = (String)BaseAuth.internalRouter.inInvoke("oc.refund.getRefundByCode", "1.0", "0", pmap2);
                    OcRefundReDomain ocRefundReDomain = (OcRefundReDomain)JsonUtil.buildNormalBinder().getJsonToObject(refundReDomainStr, OcRefundReDomain.class);
                    if (ocRefundReDomain == null || ocRefundReDomain.getDataState() != 8 || !"B01".equals(ocRefundReDomain.getRefundType()) && !"B02".equals(ocRefundReDomain.getRefundType())) continue;
                    refundGoodsNum = refundGoodsNum.add(ocRefundGoods.getRefundGoodsNum());
                }
                if (refundGoodsNum.compareTo(refundGoodsDomain.getGoodsCamount()) == 0) {
                    param.put("dataOcstate", -1);
                    this.logger.error("----\u9000\u6b3e--\u62a5\u8868\u4fee\u6539\u6570\u636e-----", (Object)JsonUtil.buildNormalBinder().toJson(param));
                    this.orderTotalService.updateOrderTotalCyy(param);
                }
            }
            String goodsCode = null;
            HashMap<String, String> pmap1 = new HashMap<String, String>();
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("tenantCode", tenantCode);
            paramMap.put("goodsNo", refundGoodsDomain.getGoodsNo());
            paramMap.put("memberCcode", refundGoodsDomain.getMemberCcode());
            pmap1.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
            String rsResourceGoodsQueryStr = (String)BaseAuth.internalRouter.inInvoke("rs.resourceGoods.queryResourceGoodsPage", "1.0", "0", pmap1);
            QueryResult rsResourceGoodsQuery = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(rsResourceGoodsQueryStr, QueryResult.class);
            List rsResourceGoodsList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)rsResourceGoodsQuery.getList()), RsResourceGoods.class);
            rsResourceGoodsQuery.setList(rsResourceGoodsList);
            if (ListUtil.isEmpty((Collection)rsResourceGoodsQuery.getList())) continue;
            goodsCode = ((RsResourceGoods)rsResourceGoodsQuery.getList().get(0)).getGoodsCode();
            this.saveSum("RefundGoodsNum", refundGoodsDomain.getRefundGoodsNum(), goodsCode, refundGoodsDomain.getGoodsName(), refundGoodsDomain.getTenantCode(), null, null);
            String pattern = "yyyy-MM-dd HH:mm:ss";
            SimpleDateFormat sdf = new SimpleDateFormat(pattern);
            String formatDate = sdf.format(new Date());
            BigDecimal refundNum = new BigDecimal("0");
            BigDecimal shopNum = new BigDecimal("1");
            HashMap<String, Object> daMap = new HashMap<String, Object>();
            daMap.put("fuzzy", true);
            daMap.put("group", true);
            daMap.put("order", true);
            daMap.put("tenantCode", tenantCode);
            daMap.put("opsetType", "RefundGoodsNum");
            daMap.put("opsumDimcode", goodsCode);
            daMap.put("startDate", "2019-01-01 00:00:00");
            daMap.put("endDate", formatDate);
            this.logger.error("------------\u67e5\u8be2\u9000\u6b3e\u6570\u91cf-------------", daMap);
            QueryResult<DaOpsumList> opsumlistRefundSumPage = this.daOpsumListService.queryOpsumlistSumPage(daMap);
            if (null != opsumlistRefundSumPage && ListUtil.isNotEmpty((Collection)opsumlistRefundSumPage.getList())) {
                refundNum = ((DaOpsumList)opsumlistRefundSumPage.getList().get(0)).getOpsumListNum();
            }
            daMap.put("opsetType", "GoodsSales");
            this.logger.error("------------\u67e5\u8be2\u8d2d\u4e70\u6570\u91cf-------------", daMap);
            QueryResult<DaOpsumList> opsumlistShopSumPage = this.daOpsumListService.queryOpsumlistSumPage(daMap);
            if (null != opsumlistShopSumPage && ListUtil.isNotEmpty((Collection)opsumlistShopSumPage.getList())) {
                shopNum = ((DaOpsumList)opsumlistShopSumPage.getList().get(0)).getOpsumListNum();
            }
            this.logger.error("------------\u8ba1\u7b97\u9000\u6b3e\u7387-------------", (Object)(refundNum + "-" + shopNum));
            BigDecimal divide = refundNum.divide(shopNum, 8, 4);
            divide = divide.multiply(BigDecimal.valueOf(100L));
            this.logger.error("------------\u9000\u6b3e\u7387-------------", (Object)divide);
            this.saveSum("RefundGoodsRate", divide, goodsCode, refundGoodsDomain.getGoodsName(), refundGoodsDomain.getTenantCode(), null, null);
        }
    }

    void saveSum(String opsetType, BigDecimal num, String opsumDimcode, String opsumDimname, String tenantCode, String opsumDimcode1, String opsumDimname1) {
        if (StringUtils.isBlank((String)opsetType) || StringUtils.isBlank((String)opsumDimcode)) {
            return;
        }
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        date = calendar.getTime();
        String pattern = "yyyy-MM-dd";
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        String formatDate = sdf.format(date);
        DaOpsumListDomain daOpsumListDomain = new DaOpsumListDomain();
        daOpsumListDomain.setOpsumCode("report");
        daOpsumListDomain.setOpsumDate(formatDate);
        daOpsumListDomain.setOpsetType(opsetType);
        daOpsumListDomain.setOpsetName(opsetType);
        daOpsumListDomain.setOpsumDimcode(opsumDimcode);
        daOpsumListDomain.setOpsumDimname(opsumDimname);
        daOpsumListDomain.setOpsumDimcode1(StringUtils.isBlank((String)opsumDimcode1) ? "all" : opsumDimcode1);
        daOpsumListDomain.setOpsumDimname1(StringUtils.isBlank((String)opsumDimname1) ? "all" : opsumDimname1);
        daOpsumListDomain.setOpsumDimcode2("all");
        daOpsumListDomain.setOpsumDimname2("all");
        daOpsumListDomain.setOpsumListNum(num);
        daOpsumListDomain.setTenantCode(tenantCode);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", daOpsumListDomain.getTenantCode());
        map.put("opsumDate", daOpsumListDomain.getOpsumDate());
        map.put("opsetType", daOpsumListDomain.getOpsetType());
        map.put("opsumDimname", daOpsumListDomain.getOpsumDimname());
        map.put("opsumDimcode", daOpsumListDomain.getOpsumDimcode());
        this.daOpsumListService.updateOpsumlistLock(map);
        QueryResult<DaOpsumList> opsumListPage = this.daOpsumListService.queryOpsumListPage(map);
        if (null == opsumListPage || ListUtil.isEmpty((Collection)opsumListPage.getList())) {
            this.daOpsumListService.saveOpsumList(daOpsumListDomain);
        } else {
            DaOpsumList daOpsumList = (DaOpsumList)opsumListPage.getList().get(0);
            try {
                BeanUtils.copyAllPropertys((Object)daOpsumListDomain, (Object)daOpsumList);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!"RefundGoodsRate".equals(opsetType)) {
                num = num.add(daOpsumList.getOpsumListNum());
            }
            daOpsumListDomain.setOpsumListNum(num);
            this.daOpsumListService.updateOpsumList(daOpsumListDomain);
        }
    }

    public void start() {
        new Thread(this).start();
    }
}

