/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.datadictionary.service.impl;

import com.yqbsoft.laser.service.datadictionary.dao.DdFalgSettingMapper;
import com.yqbsoft.laser.service.datadictionary.domain.DdFalgSettingDomain;
import com.yqbsoft.laser.service.datadictionary.domain.FalgSettingBean;
import com.yqbsoft.laser.service.datadictionary.model.DdFalgSetting;
import com.yqbsoft.laser.service.datadictionary.service.DdFalgSettingService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DdFalgSettingServiceImpl
extends BaseServiceImpl
implements DdFalgSettingService {
    public static final String SYS_CODE = "dd.DdFalgSettingServiceImpl";
    private DdFalgSettingMapper ddFalgSettingMapper;

    public void setDdFalgSettingMapper(DdFalgSettingMapper ddFalgSettingMapper) {
        this.ddFalgSettingMapper = ddFalgSettingMapper;
    }

    private Date getSysDate() {
        try {
            return this.ddFalgSettingMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("dd.DdFalgSettingServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkFalgSetting(DdFalgSettingDomain ddFalgSettingDomain) {
        if (null == ddFalgSettingDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setFalgSettingDefault(DdFalgSetting ddFalgSetting) {
        if (null == ddFalgSetting) {
            return;
        }
        if (null == ddFalgSetting.getDataState()) {
            ddFalgSetting.setDataState(0);
        }
        if (null == ddFalgSetting.getGmtCreate()) {
            ddFalgSetting.setGmtCreate(this.getSysDate());
        }
        ddFalgSetting.setGmtModified(this.getSysDate());
    }

    private int getFalgSettingMaxCode() {
        int code = 0;
        try {
            return this.ddFalgSettingMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("dd.DdFalgSettingServiceImpl.getFalgSettingMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setFalgSettingUpdataDefault(DdFalgSetting ddFalgSetting) {
        if (null == ddFalgSetting) {
            return;
        }
        ddFalgSetting.setGmtModified(this.getSysDate());
    }

    private void saveFalgSettingModel(DdFalgSetting ddFalgSetting) throws ApiException {
        if (null == ddFalgSetting) {
            return;
        }
        try {
            this.ddFalgSettingMapper.insert(ddFalgSetting);
        }
        catch (Exception e) {
            throw new ApiException("dd.DdFalgSettingServiceImpl.saveFalgSettingModel.ex", (Throwable)e);
        }
    }

    private DdFalgSetting getFalgSettingModelById(Integer flagSettingId) {
        if (null == flagSettingId) {
            return null;
        }
        try {
            return this.ddFalgSettingMapper.selectByPrimaryKey(flagSettingId);
        }
        catch (Exception e) {
            this.logger.error("dd.DdFalgSettingServiceImpl.getFalgSettingModelById", (Throwable)e);
            return null;
        }
    }

    public DdFalgSetting getFalgSettingModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ddFalgSettingMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("dd.DdFalgSettingServiceImpl.getFalgSettingModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delFalgSettingModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ddFalgSettingMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dd.DdFalgSettingServiceImpl.delFalgSettingModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dd.DdFalgSettingServiceImpl.delFalgSettingModelByCode.num");
        }
    }

    private void deleteFalgSettingModel(Integer flagSettingId) throws ApiException {
        if (null == flagSettingId) {
            return;
        }
        int i = 0;
        try {
            i = this.ddFalgSettingMapper.deleteByPrimaryKey(flagSettingId);
        }
        catch (Exception e) {
            throw new ApiException("dd.DdFalgSettingServiceImpl.deleteFalgSettingModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dd.DdFalgSettingServiceImpl.deleteFalgSettingModel.num");
        }
    }

    private void updateFalgSettingModel(DdFalgSetting ddFalgSetting) throws ApiException {
        if (null == ddFalgSetting) {
            return;
        }
        try {
            this.ddFalgSettingMapper.updateByPrimaryKeySelective(ddFalgSetting);
        }
        catch (Exception e) {
            throw new ApiException("dd.DdFalgSettingServiceImpl.updateFalgSettingModel.ex", (Throwable)e);
        }
    }

    private void updateStateFalgSettingModel(Integer flagSettingId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == flagSettingId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("flagSettingId", flagSettingId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ddFalgSettingMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("dd.DdFalgSettingServiceImpl.updateStateFalgSettingModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dd.DdFalgSettingServiceImpl.updateStateFalgSettingModel.null");
        }
    }

    private DdFalgSetting makeFalgSetting(DdFalgSettingDomain ddFalgSettingDomain, DdFalgSetting ddFalgSetting) {
        if (null == ddFalgSettingDomain) {
            return null;
        }
        if (null == ddFalgSetting) {
            ddFalgSetting = new DdFalgSetting();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ddFalgSetting, (Object)ddFalgSettingDomain);
            return ddFalgSetting;
        }
        catch (Exception e) {
            this.logger.error("dd.DdFalgSettingServiceImpl.makeFalgSetting", (Throwable)e);
            return null;
        }
    }

    private List<DdFalgSetting> queryFalgSettingModelPage(Map<String, Object> parammap) {
        try {
            return this.ddFalgSettingMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("dd.DdFalgSettingServiceImpl.queryFalgSettingModel", (Throwable)e);
            return null;
        }
    }

    private int countFalgSetting(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ddFalgSettingMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("dd.DdFalgSettingServiceImpl.countFalgSetting", (Throwable)e);
        }
        return i;
    }

    @Override
    public DdFalgSetting saveFalgSetting(DdFalgSettingDomain ddFalgSettingDomain) throws ApiException {
        String msg = this.checkFalgSetting(ddFalgSettingDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dd.DdFalgSettingServiceImpl.saveFalgSetting.checkFalgSetting", msg);
        }
        DdFalgSetting ddFalgSetting = this.makeFalgSetting(ddFalgSettingDomain, null);
        this.setFalgSettingDefault(ddFalgSetting);
        this.saveFalgSettingModel(ddFalgSetting);
        return ddFalgSetting;
    }

    @Override
    public void updateFalgSettingState(Integer flagSettingId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateFalgSettingModel(flagSettingId, dataState, oldDataState);
    }

    @Override
    public void updateFalgSetting(DdFalgSettingDomain ddFalgSettingDomain) throws ApiException {
        String msg = this.checkFalgSetting(ddFalgSettingDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dd.DdFalgSettingServiceImpl.updateFalgSetting.checkFalgSetting", msg);
        }
        DdFalgSetting oldDdFalgSetting = this.getFalgSettingModelById(ddFalgSettingDomain.getFlagSettingId());
        if (null == oldDdFalgSetting) {
            throw new ApiException("dd.DdFalgSettingServiceImpl.updateFalgSetting.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DdFalgSetting ddFalgSetting = this.makeFalgSetting(ddFalgSettingDomain, oldDdFalgSetting);
        this.setFalgSettingUpdataDefault(ddFalgSetting);
        this.updateFalgSettingModel(ddFalgSetting);
    }

    @Override
    public DdFalgSetting getFalgSetting(Integer flagSettingId) {
        return this.getFalgSettingModelById(flagSettingId);
    }

    @Override
    public void deleteFalgSetting(Integer flagSettingId) throws ApiException {
        this.deleteFalgSettingModel(flagSettingId);
    }

    @Override
    public QueryResult<DdFalgSetting> queryFalgSettingPage(Map<String, Object> map) {
        List<DdFalgSetting> ddFalgSettingList = this.queryFalgSettingModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFalgSetting(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ddFalgSettingList);
        return queryResult;
    }

    @Override
    public void queryFalgSettingCache() {
        this.logger.info("dd.DdFalgSettingServiceImpl.queryFalgSettingCache.start", (Object)"=======\u8c03\u5ea6start=======");
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", 1);
        List<DdFalgSetting> ddFalgSettingList = this.queryFalgSettingModelPage(parammap);
        String key = "DdFalgSetting-list";
        String keyvalue = "DdFalgSetting-key";
        if (null == ddFalgSettingList || ddFalgSettingList.isEmpty()) {
            DisUtil.delVer((String)key);
            DisUtil.delVer((String)keyvalue);
            this.logger.info("dd.DdFalgSettingServiceImpl.queryFalgSettingCache.delend", (Object)"=======\u8c03\u5ea6del-end=======");
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> cachemapList = new HashMap<String, String>();
        HashMap<String, List<FalgSettingBean>> mapList = new HashMap<String, List<FalgSettingBean>>();
        ArrayList<FalgSettingBean> falgList = null;
        String listkey = null;
        for (DdFalgSetting ddFalgSetting : ddFalgSettingList) {
            if (!StringUtils.isEmpty((String)ddFalgSetting.getFlagSettingScope())) {
                this.addScopeCache(ddFalgSetting, map, mapList);
            }
            listkey = ddFalgSetting.getTenantCode() + "-" + ddFalgSetting.getFlagSettingType();
            map.put(listkey + "-" + ddFalgSetting.getFlagSettingCode(), ddFalgSetting.getFlagSettingInfo());
            falgList = (ArrayList<FalgSettingBean>)mapList.get(listkey);
            if (null == falgList) {
                falgList = new ArrayList<FalgSettingBean>();
                mapList.put(listkey, falgList);
            }
            falgList.add(this.makeCachebean(ddFalgSetting));
        }
        for (String listmapkey : mapList.keySet()) {
            cachemapList.put(listmapkey, JsonUtil.buildNormalBinder().toJson(mapList.get(listmapkey)));
        }
        DisUtil.setMapVer((String)keyvalue, map);
        DisUtil.setMapVer((String)key, cachemapList);
        this.logger.info("dd.DdFalgSettingServiceImpl.queryFalgSettingCache.end", (Object)"=======\u8c03\u5ea6end=======");
    }

    private void addScopeCache(DdFalgSetting ddFalgSetting, Map<String, String> map, Map<String, List<FalgSettingBean>> mapList) {
        String scopeKey = null;
        List<FalgSettingBean> falgScopList = null;
        scopeKey = ddFalgSetting.getTenantCode() + "-" + ddFalgSetting.getFlagSettingType() + "-" + ddFalgSetting.getFlagSettingCode();
        map.put(scopeKey + "-" + ddFalgSetting.getFlagSettingScope(), ddFalgSetting.getFlagSettingInfo());
        falgScopList = mapList.get(scopeKey);
        if (null == falgScopList) {
            falgScopList = new ArrayList<FalgSettingBean>();
            mapList.put(scopeKey, falgScopList);
        }
        falgScopList.add(this.makeCachebean(ddFalgSetting));
    }

    private FalgSettingBean makeCachebean(DdFalgSetting ddFalgSetting) {
        if (null == ddFalgSetting) {
            return null;
        }
        FalgSettingBean falgSettingBean = new FalgSettingBean();
        try {
            BeanUtils.copyAllPropertys((Object)falgSettingBean, (Object)ddFalgSetting);
        }
        catch (Exception e) {
            this.logger.error("dd.DdFalgSettingServiceImpl.makeCachebean", (Object)"e", (Throwable)e);
            return null;
        }
        return falgSettingBean;
    }

    @Override
    public Map<String, Object> getFalgSettingByCode(Map<String, Object> map) {
        return this.getFalgSettingByCodeModel(map);
    }

    public Map<String, Object> getFalgSettingByCodeModel(Map<String, Object> map) {
        try {
            return this.ddFalgSettingMapper.getFalgSettingByCode(map);
        }
        catch (Exception e) {
            this.logger.error("dd.DdFalgSettingServiceImpl.getFalgSettingByCodeModel", (Throwable)e);
            return null;
        }
    }
}

