/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.distribution.service.impl;

import com.yqbsoft.laser.service.distribution.dao.DisChannelMapper;
import com.yqbsoft.laser.service.distribution.domain.DisChannelDomain;
import com.yqbsoft.laser.service.distribution.model.DisChannel;
import com.yqbsoft.laser.service.distribution.service.DisChannelService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DisChannelServiceImpl
extends BaseServiceImpl
implements DisChannelService {
    public static final String SYS_CODE = "dis.DisChannelServiceImpl";
    private DisChannelMapper disChannelMapper;

    public void setDisChannelMapper(DisChannelMapper disChannelMapper) {
        this.disChannelMapper = disChannelMapper;
    }

    private Date getSysDate() {
        try {
            return this.disChannelMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("dis.DisChannelServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkChannel(DisChannelDomain disChannelDomain) {
        if (null == disChannelDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setChannelDefault(DisChannel disChannel) {
        if (null == disChannel) {
            return;
        }
        if (null == disChannel.getDataState()) {
            disChannel.setDataState(0);
        }
        if (null == disChannel.getGmtCreate()) {
            disChannel.setGmtCreate(this.getSysDate());
        }
        disChannel.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)disChannel.getChannelCode())) {
            disChannel.setChannelCode(this.createUUIDString());
        }
    }

    private int getChannelMaxCode() {
        int code = 0;
        try {
            return this.disChannelMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("dis.DisChannelServiceImpl.getChannelMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setChannelUpdataDefault(DisChannel disChannel) {
        if (null == disChannel) {
            return;
        }
        disChannel.setGmtModified(this.getSysDate());
    }

    private void saveChannelModel(DisChannel disChannel) throws ApiException {
        if (null == disChannel) {
            return;
        }
        try {
            this.disChannelMapper.insert(disChannel);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisChannelServiceImpl.saveChannelModel.ex", (Throwable)e);
        }
    }

    private DisChannel getChannelModelById(Integer channelId) {
        if (null == channelId) {
            return null;
        }
        try {
            return this.disChannelMapper.selectByPrimaryKey(channelId);
        }
        catch (Exception e) {
            this.logger.error("dis.DisChannelServiceImpl.getChannelModelById", (Throwable)e);
            return null;
        }
    }

    private List<DisChannel> getChannelModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.disChannelMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisChannelServiceImpl.getChannelModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delChannelModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.disChannelMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisChannelServiceImpl.delChannelModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisChannelServiceImpl.delChannelModelByCode.num");
        }
    }

    private void deleteChannelModel(Integer channelId) throws ApiException {
        if (null == channelId) {
            return;
        }
        int i = 0;
        try {
            i = this.disChannelMapper.deleteByPrimaryKey(channelId);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisChannelServiceImpl.deleteChannelModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisChannelServiceImpl.deleteChannelModel.num");
        }
    }

    private void updateChannelModel(DisChannel disChannel) throws ApiException {
        if (null == disChannel) {
            return;
        }
        try {
            this.disChannelMapper.updateByPrimaryKeySelective(disChannel);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisChannelServiceImpl.updateChannelModel.ex", (Throwable)e);
        }
    }

    private void updateStateChannelModel(Integer channelId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == channelId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channelId", channelId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.disChannelMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisChannelServiceImpl.updateStateChannelModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisChannelServiceImpl.updateStateChannelModel.null");
        }
    }

    private DisChannel makeChannel(DisChannelDomain disChannelDomain, DisChannel disChannel) {
        if (null == disChannelDomain) {
            return null;
        }
        if (null == disChannel) {
            disChannel = new DisChannel();
        }
        try {
            BeanUtils.copyAllPropertys((Object)disChannel, (Object)disChannelDomain);
            return disChannel;
        }
        catch (Exception e) {
            this.logger.error("dis.DisChannelServiceImpl.makeChannel", (Throwable)e);
            return null;
        }
    }

    private List<DisChannel> queryChannelModelPage(Map<String, Object> parammap) {
        try {
            return this.disChannelMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("dis.DisChannelServiceImpl.queryChannelModel", (Throwable)e);
            return null;
        }
    }

    private int countChannel(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.disChannelMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisChannelServiceImpl.countChannel", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveChannel(DisChannelDomain disChannelDomain) throws ApiException {
        String msg = this.checkChannel(disChannelDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisChannelServiceImpl.saveChannel.checkChannel", msg);
        }
        DisChannel disChannel = this.makeChannel(disChannelDomain, null);
        this.setChannelDefault(disChannel);
        this.saveChannelModel(disChannel);
        return disChannel.getChannelCode();
    }

    @Override
    public void updateChannelState(Integer channelId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateChannelModel(channelId, dataState, oldDataState);
    }

    @Override
    public void updateChannel(DisChannelDomain disChannelDomain) throws ApiException {
        String msg = this.checkChannel(disChannelDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisChannelServiceImpl.updateChannel.checkChannel", msg);
        }
        DisChannel oldDisChannel = this.getChannelModelById(disChannelDomain.getChannelId());
        if (null == oldDisChannel) {
            throw new ApiException("dis.DisChannelServiceImpl.updateChannel.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DisChannel disChannel = this.makeChannel(disChannelDomain, oldDisChannel);
        this.setChannelUpdataDefault(disChannel);
        this.updateChannelModel(disChannel);
    }

    @Override
    public DisChannel getChannel(Integer channelId) {
        return this.getChannelModelById(channelId);
    }

    @Override
    public void deleteChannel(Integer channelId) throws ApiException {
        this.deleteChannelModel(channelId);
    }

    @Override
    public QueryResult<DisChannel> queryChannelPage(Map<String, Object> map) {
        List<DisChannel> disChannelList = this.queryChannelModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countChannel(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(disChannelList);
        return queryResult;
    }

    @Override
    public List<DisChannel> getChannelByCode(Map<String, Object> map) {
        return this.getChannelModelByCode(map);
    }

    @Override
    public List<DisChannel> getChannelsByTenantCode(String tenantCode) {
        assert (StringUtils.isNotBlank((String)tenantCode)) : "tenantCode is required";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tenantCode", tenantCode);
        return this.queryChannelModelPage(params);
    }

    @Override
    public void delChannelByCode(Map<String, Object> map) throws ApiException {
        this.delChannelModelByCode(map);
    }

    @Override
    public List<DisChannel> queryChannelMerberMerchant(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        return this.queryMemberOrMerchant(map);
    }

    private List<DisChannel> queryMemberOrMerchant(Map<String, Object> parammap) {
        try {
            return this.disChannelMapper.queryMemberOrMerchant(parammap);
        }
        catch (Exception e) {
            this.logger.error("dis.DisChannelServiceImpl.queryChannelModel", (Throwable)e);
            return null;
        }
    }
}

