/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.distribution.service.impl;

import com.yqbsoft.laser.service.distribution.dao.DisStatusMapper;
import com.yqbsoft.laser.service.distribution.domain.DisStatusDomain;
import com.yqbsoft.laser.service.distribution.model.DisStatus;
import com.yqbsoft.laser.service.distribution.service.DisStatusService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DisStatusServiceImpl
extends BaseServiceImpl
implements DisStatusService {
    public static final String SYS_CODE = "dis.DisStatusServiceImpl";
    private DisStatusMapper disStatusMapper;

    public void setDisStatusMapper(DisStatusMapper disStatusMapper) {
        this.disStatusMapper = disStatusMapper;
    }

    private Date getSysDate() {
        try {
            return this.disStatusMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("dis.DisStatusServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkStatus(DisStatusDomain disStatusDomain) {
        if (null == disStatusDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setStatusDefault(DisStatus disStatus) {
        if (null == disStatus) {
            return;
        }
        if (null == disStatus.getDataState()) {
            disStatus.setDataState(0);
        }
        if (null == disStatus.getGmtCreate()) {
            disStatus.setGmtCreate(this.getSysDate());
        }
        disStatus.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)disStatus.getStatusCode())) {
            disStatus.setStatusCode(this.createUUIDString());
        }
    }

    private int getStatusMaxCode() {
        int code = 0;
        try {
            return this.disStatusMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("dis.DisStatusServiceImpl.getStatusMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setStatusUpdataDefault(DisStatus disStatus) {
        if (null == disStatus) {
            return;
        }
        disStatus.setGmtModified(this.getSysDate());
    }

    private void saveStatusModel(DisStatus disStatus) throws ApiException {
        if (null == disStatus) {
            return;
        }
        try {
            this.disStatusMapper.insert(disStatus);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisStatusServiceImpl.saveStatusModel.ex", (Throwable)e);
        }
    }

    private DisStatus getStatusModelById(Integer statusId) {
        if (null == statusId) {
            return null;
        }
        try {
            return this.disStatusMapper.selectByPrimaryKey(statusId);
        }
        catch (Exception e) {
            this.logger.error("dis.DisStatusServiceImpl.getStatusModelById", (Throwable)e);
            return null;
        }
    }

    private DisStatus getModelByStrictStatusCodeAndCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.disStatusMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisStatusServiceImpl.getModelByStrictStatusCodeAndCode", (Throwable)e);
            return null;
        }
    }

    public void delStatusModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.disStatusMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisStatusServiceImpl.delStatusModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisStatusServiceImpl.delStatusModelByCode.num");
        }
    }

    private void deleteStatusModel(Integer statusId) throws ApiException {
        if (null == statusId) {
            return;
        }
        int i = 0;
        try {
            i = this.disStatusMapper.deleteByPrimaryKey(statusId);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisStatusServiceImpl.deleteStatusModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisStatusServiceImpl.deleteStatusModel.num");
        }
    }

    private void updateStatusModel(DisStatus disStatus) throws ApiException {
        if (null == disStatus) {
            return;
        }
        try {
            this.disStatusMapper.updateByPrimaryKeySelective(disStatus);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisStatusServiceImpl.updateStatusModel.ex", (Throwable)e);
        }
    }

    private void updateStateStatusModel(Integer statusId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == statusId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("statusId", statusId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.disStatusMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisStatusServiceImpl.updateStateStatusModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisStatusServiceImpl.updateStateStatusModel.null");
        }
    }

    private DisStatus makeStatus(DisStatusDomain disStatusDomain, DisStatus disStatus) {
        if (null == disStatusDomain) {
            return null;
        }
        if (null == disStatus) {
            disStatus = new DisStatus();
        }
        try {
            BeanUtils.copyAllPropertys((Object)disStatus, (Object)disStatusDomain);
            return disStatus;
        }
        catch (Exception e) {
            this.logger.error("dis.DisStatusServiceImpl.makeStatus", (Throwable)e);
            return null;
        }
    }

    private List<DisStatus> queryStatusModelPage(Map<String, Object> parammap) {
        try {
            return this.disStatusMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("dis.DisStatusServiceImpl.queryStatusModel", (Throwable)e);
            return null;
        }
    }

    private int countStatus(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.disStatusMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisStatusServiceImpl.countStatus", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveStatus(DisStatusDomain disStatusDomain) throws ApiException {
        String msg = this.checkStatus(disStatusDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisStatusServiceImpl.saveStatus.checkStatus", msg);
        }
        DisStatus disStatus = this.makeStatus(disStatusDomain, null);
        this.setStatusDefault(disStatus);
        this.saveStatusModel(disStatus);
        return disStatus.getStatusCode();
    }

    @Override
    public void updateStatusState(Integer statusId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateStatusModel(statusId, dataState, oldDataState);
    }

    @Override
    public void updateStatus(DisStatusDomain disStatusDomain) throws ApiException {
        String msg = this.checkStatus(disStatusDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisStatusServiceImpl.updateStatus.checkStatus", msg);
        }
        DisStatus oldDisStatus = this.getStatusModelById(disStatusDomain.getStatusId());
        if (null == oldDisStatus) {
            throw new ApiException("dis.DisStatusServiceImpl.updateStatus.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DisStatus disStatus = this.makeStatus(disStatusDomain, oldDisStatus);
        this.setStatusUpdataDefault(disStatus);
        this.updateStatusModel(disStatus);
    }

    @Override
    public DisStatus getStatus(Integer statusId) {
        return this.getStatusModelById(statusId);
    }

    @Override
    public void deleteStatus(Integer statusId) throws ApiException {
        this.deleteStatusModel(statusId);
    }

    @Override
    public QueryResult<DisStatus> queryStatusPage(Map<String, Object> map) {
        List<DisStatus> disStatusList = this.queryStatusModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countStatus(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(disStatusList);
        return queryResult;
    }

    @Override
    public DisStatus getDisStatusByStrictStatusCodeAndCode(Map<String, Object> map) {
        return this.getModelByStrictStatusCodeAndCode(map);
    }

    @Override
    public void delStatusByCode(Map<String, Object> map) throws ApiException {
        this.delStatusModelByCode(map);
    }

    @Override
    public List<DisStatus> getDisStatusListByTenantCodeAndOpBillno(String tenantCode, String opBillnO) {
        assert (StringUtils.isNotBlank((String)tenantCode) || StringUtils.isNotBlank((String)opBillnO)) : "params can`t be null";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("tenantCode", tenantCode);
        params.put("opBillno", opBillnO);
        return this.queryStatusModelPage(params);
    }

    @Override
    public List<DisStatus> getDisStatusInOpbillNos(Map<String, Object> map) {
        if (map == null) {
            return Collections.EMPTY_LIST;
        }
        return this.disStatusMapper.getDisStatusInOpbillNos(map);
    }
}

