/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.distribution.service.impl;

import com.yqbsoft.laser.service.distribution.dao.DisDgnumListMapper;
import com.yqbsoft.laser.service.distribution.dao.DisDgnumMapper;
import com.yqbsoft.laser.service.distribution.domain.DisDgnumDomain;
import com.yqbsoft.laser.service.distribution.domain.DisDgnumListDomain;
import com.yqbsoft.laser.service.distribution.domain.DisDgnumListReDomain;
import com.yqbsoft.laser.service.distribution.domain.DisDgnumReDomain;
import com.yqbsoft.laser.service.distribution.model.DisDgnum;
import com.yqbsoft.laser.service.distribution.model.DisDgnumList;
import com.yqbsoft.laser.service.distribution.service.DisDgnumService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DisDgnumServiceImpl
extends BaseServiceImpl
implements DisDgnumService {
    private static final String SYS_CODE = "dis.DisDgnumServiceImpl";
    private DisDgnumMapper disDgnumMapper;
    private DisDgnumListMapper disDgnumListMapper;
    private String cachekey = "DisDgnumList-channelCode";

    public void setDisDgnumMapper(DisDgnumMapper disDgnumMapper) {
        this.disDgnumMapper = disDgnumMapper;
    }

    public void setDisDgnumListMapper(DisDgnumListMapper disDgnumListMapper) {
        this.disDgnumListMapper = disDgnumListMapper;
    }

    private Date getSysDate() {
        try {
            return this.disDgnumMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgnumServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkDgnum(DisDgnumDomain disDgnumDomain) {
        if (null == disDgnumDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)disDgnumDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDgnumDefault(DisDgnum disDgnum) {
        if (null == disDgnum) {
            return;
        }
        if (null == disDgnum.getDataState()) {
            disDgnum.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == disDgnum.getGmtCreate()) {
            disDgnum.setGmtCreate(date);
        }
        disDgnum.setGmtModified(date);
        if (StringUtils.isBlank((String)disDgnum.getDgnumCode())) {
            disDgnum.setDgnumCode(this.getNo(null, "DisDgnum", "disDgnum", disDgnum.getTenantCode()));
        }
    }

    private int getDgnumMaxCode() {
        int code = 0;
        try {
            return this.disDgnumMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgnumServiceImpl.getDgnumMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setDgnumUpdataDefault(DisDgnum disDgnum) {
        if (null == disDgnum) {
            return;
        }
        disDgnum.setGmtModified(this.getSysDate());
    }

    private void saveDgnumModel(DisDgnum disDgnum) throws ApiException {
        if (null == disDgnum) {
            return;
        }
        try {
            this.disDgnumMapper.insert(disDgnum);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgnumServiceImpl.saveDgnumModel.ex", (Throwable)e);
        }
    }

    public void saveDgnumBatchModel(List<DisDgnum> disDgnumList) throws ApiException {
        if (null == disDgnumList || disDgnumList.isEmpty()) {
            return;
        }
        try {
            this.disDgnumMapper.insertBatch(disDgnumList);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgnumServiceImpl.saveDgnumBatchModel.ex", (Throwable)e);
        }
    }

    private DisDgnum getDgnumModelById(Integer dgnumId) {
        if (null == dgnumId) {
            return null;
        }
        try {
            return this.disDgnumMapper.selectByPrimaryKey(dgnumId);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgnumServiceImpl.getDgnumModelById", (Throwable)e);
            return null;
        }
    }

    private DisDgnum getDgnumModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.disDgnumMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgnumServiceImpl.getDgnumModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delDgnumModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.disDgnumMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgnumServiceImpl.delDgnumModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDgnumServiceImpl.delDgnumModelByCode.num");
        }
    }

    private void deleteDgnumModel(Integer dgnumId) throws ApiException {
        if (null == dgnumId) {
            return;
        }
        int i = 0;
        try {
            i = this.disDgnumMapper.deleteByPrimaryKey(dgnumId);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgnumServiceImpl.deleteDgnumModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDgnumServiceImpl.deleteDgnumModel.num");
        }
    }

    private void updateDgnumModel(DisDgnum disDgnum) throws ApiException {
        if (null == disDgnum) {
            return;
        }
        int i = 0;
        try {
            i = this.disDgnumMapper.updateByPrimaryKey(disDgnum);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgnumServiceImpl.updateDgnumModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDgnumServiceImpl.updateDgnumModel.num");
        }
    }

    private void updateStateDgnumModel(Integer dgnumId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == dgnumId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dgnumId", dgnumId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disDgnumMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgnumServiceImpl.updateStateDgnumModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisDgnumServiceImpl.updateStateDgnumModel.null");
        }
    }

    private void updateStateDgnumModelByCode(String tenantCode, String dgnumCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)dgnumCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dgnumCode", dgnumCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disDgnumMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgnumServiceImpl.updateStateDgnumModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisDgnumServiceImpl.updateStateDgnumModelByCode.null");
        }
    }

    private DisDgnum makeDgnum(DisDgnumDomain disDgnumDomain, DisDgnum disDgnum) {
        if (null == disDgnumDomain) {
            return null;
        }
        if (null == disDgnum) {
            disDgnum = new DisDgnum();
        }
        try {
            BeanUtils.copyAllPropertys((Object)disDgnum, (Object)disDgnumDomain);
            return disDgnum;
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgnumServiceImpl.makeDgnum", (Throwable)e);
            return null;
        }
    }

    private DisDgnumReDomain makeDisDgnumReDomain(DisDgnum disDgnum) {
        if (null == disDgnum) {
            return null;
        }
        DisDgnumReDomain disDgnumReDomain = new DisDgnumReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disDgnumReDomain, (Object)disDgnum);
            disDgnumReDomain.setDisDgnumListDomainList(this.makeDisDgnumListDomainList(this.queryDgnumListModelPage(this.getQueryMapParam("dgnumCode,tenantCode", new Object[]{disDgnum.getDgnumCode(), disDgnum.getTenantCode()}))));
            return disDgnumReDomain;
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgnumServiceImpl.makeDisDgnumReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DisDgnum> queryDgnumModelPage(Map<String, Object> parammap) {
        try {
            return this.disDgnumMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgnumServiceImpl.queryDgnumModel", (Throwable)e);
            return null;
        }
    }

    private int countDgnum(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.disDgnumMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgnumServiceImpl.countDgnum", (Throwable)e);
        }
        return i;
    }

    private DisDgnum createDisDgnum(DisDgnumDomain disDgnumDomain) {
        String msg = this.checkDgnum(disDgnumDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDgnumServiceImpl.saveDgnum.checkDgnum", msg);
        }
        DisDgnum disDgnum = this.makeDgnum(disDgnumDomain, null);
        this.setDgnumDefault(disDgnum);
        return disDgnum;
    }

    private String checkDgnumList(DisDgnumListDomain disDgnumListDomain) {
        if (null == disDgnumListDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)disDgnumListDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDgnumListDefault(DisDgnumList disDgnumList) {
        if (null == disDgnumList) {
            return;
        }
        if (null == disDgnumList.getDataState()) {
            disDgnumList.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == disDgnumList.getGmtCreate()) {
            disDgnumList.setGmtCreate(date);
        }
        disDgnumList.setGmtModified(date);
        if (StringUtils.isBlank((String)disDgnumList.getDgnumListCode())) {
            disDgnumList.setDgnumListCode(this.getNo(null, "DisDgnumList", "disDgnumList", disDgnumList.getTenantCode()));
        }
    }

    private int getDgnumListMaxCode() {
        int code = 0;
        try {
            return this.disDgnumListMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgnumServiceImpl.getDgnumListMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setDgnumListUpdataDefault(DisDgnumList disDgnumList) {
        if (null == disDgnumList) {
            return;
        }
        disDgnumList.setGmtModified(this.getSysDate());
    }

    private void saveDgnumListModel(DisDgnumList disDgnumList) throws ApiException {
        if (null == disDgnumList) {
            return;
        }
        try {
            this.disDgnumListMapper.insert(disDgnumList);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgnumServiceImpl.saveDgnumListModel.ex", (Throwable)e);
        }
    }

    private void saveDgnumListBatchModel(List<DisDgnumList> disDgnumListList) throws ApiException {
        if (null == disDgnumListList || disDgnumListList.isEmpty()) {
            return;
        }
        try {
            this.disDgnumListMapper.insertBatch(disDgnumListList);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgnumServiceImpl.saveDgnumListBatchModel.ex", (Throwable)e);
        }
    }

    private DisDgnumList getDgnumListModelById(Integer dgnumListId) {
        if (null == dgnumListId) {
            return null;
        }
        try {
            return this.disDgnumListMapper.selectByPrimaryKey(dgnumListId);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgnumServiceImpl.getDgnumListModelById", (Throwable)e);
            return null;
        }
    }

    private DisDgnumList getDgnumListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.disDgnumListMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgnumServiceImpl.getDgnumListModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delDgnumListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.disDgnumListMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgnumServiceImpl.delDgnumListModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDgnumServiceImpl.delDgnumListModelByCode.num");
        }
    }

    private void delModelByGnumCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        try {
            this.disDgnumListMapper.delByGnumCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgnumServiceImpl.delModelByGnumCode.ex", (Throwable)e);
        }
    }

    private void deleteDgnumListModel(Integer dgnumListId) throws ApiException {
        if (null == dgnumListId) {
            return;
        }
        int i = 0;
        try {
            i = this.disDgnumListMapper.deleteByPrimaryKey(dgnumListId);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgnumServiceImpl.deleteDgnumListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDgnumServiceImpl.deleteDgnumListModel.num");
        }
    }

    private void updateDgnumListModel(DisDgnumList disDgnumList) throws ApiException {
        if (null == disDgnumList) {
            return;
        }
        int i = 0;
        try {
            i = this.disDgnumListMapper.updateByPrimaryKey(disDgnumList);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgnumServiceImpl.updateDgnumListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDgnumServiceImpl.updateDgnumListModel.num");
        }
    }

    private void updateStateDgnumListModel(Integer dgnumListId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == dgnumListId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dgnumListId", dgnumListId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disDgnumListMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgnumServiceImpl.updateStateDgnumListModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisDgnumServiceImpl.updateStateDgnumListModel.null");
        }
    }

    private void updateStateDgnumListModelByCode(String tenantCode, String dgnumListCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)dgnumListCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dgnumListCode", dgnumListCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disDgnumListMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgnumServiceImpl.updateStateDgnumListModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisDgnumServiceImpl.updateStateDgnumListModelByCode.null");
        }
    }

    private DisDgnumList makeDgnumList(DisDgnumListDomain disDgnumListDomain, DisDgnumList disDgnumList) {
        if (null == disDgnumListDomain) {
            return null;
        }
        if (null == disDgnumList) {
            disDgnumList = new DisDgnumList();
        }
        try {
            BeanUtils.copyAllPropertys((Object)disDgnumList, (Object)disDgnumListDomain);
            return disDgnumList;
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgnumServiceImpl.makeDgnumList", (Throwable)e);
            return null;
        }
    }

    private DisDgnumListReDomain makeDisDgnumListReDomain(DisDgnumList disDgnumList) {
        if (null == disDgnumList) {
            return null;
        }
        DisDgnumListReDomain disDgnumListReDomain = new DisDgnumListReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disDgnumListReDomain, (Object)disDgnumList);
            return disDgnumListReDomain;
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgnumServiceImpl.makeDisDgnumListReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DisDgnumListDomain> makeDisDgnumListDomainList(List<DisDgnumList> disDgnumListList) {
        if (ListUtil.isEmpty(disDgnumListList)) {
            return null;
        }
        ArrayList<DisDgnumListDomain> relist = new ArrayList<DisDgnumListDomain>();
        for (DisDgnumList disDgnumList : disDgnumListList) {
            relist.add(this.makeDisDgnumListDomain(disDgnumList));
        }
        return relist;
    }

    private DisDgnumListDomain makeDisDgnumListDomain(DisDgnumList disDgnumList) {
        if (null == disDgnumList) {
            return null;
        }
        DisDgnumListDomain disDgnumListDomain = new DisDgnumListDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disDgnumListDomain, (Object)disDgnumList);
            return disDgnumListDomain;
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgnumServiceImpl.makeDisDgnumListDomain", (Throwable)e);
            return null;
        }
    }

    private List<DisDgnumList> queryDgnumListModelPage(Map<String, Object> parammap) {
        try {
            return this.disDgnumListMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgnumServiceImpl.queryDgnumListModel", (Throwable)e);
            return null;
        }
    }

    private int countDgnumList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.disDgnumListMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgnumServiceImpl.countDgnumList", (Throwable)e);
        }
        return i;
    }

    private DisDgnumList createDisDgnumList(DisDgnumListDomain disDgnumListDomain) {
        String msg = this.checkDgnumList(disDgnumListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDgnumServiceImpl.saveDgnumList.checkDgnumList", msg);
        }
        DisDgnumList disDgnumList = this.makeDgnumList(disDgnumListDomain, null);
        this.setDgnumListDefault(disDgnumList);
        return disDgnumList;
    }

    @Override
    public String saveDgnum(DisDgnumDomain disDgnumDomain) throws ApiException {
        if (null != disDgnumDomain.getDgnumId()) {
            if (StringUtils.isBlank((String)disDgnumDomain.getDgnumCode())) {
                DisDgnum oldDisDgnum = this.getDgnumModelById(disDgnumDomain.getDgnumId());
                if (null == oldDisDgnum) {
                    throw new ApiException("dis.DisDgnumServiceImpl.saveDgnum.null", "\u6570\u636e\u4e3a\u7a7a");
                }
                disDgnumDomain.setDgnumCode(oldDisDgnum.getDgnumCode());
            }
            this.deleteDgnum(disDgnumDomain.getDgnumId());
        }
        DisDgnum disDgnum = this.createDisDgnum(disDgnumDomain);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dgnumCode", disDgnum.getDgnumCode());
        map.put("tenantCode", disDgnum.getTenantCode());
        this.saveDgnumModel(disDgnum);
        this.delModelByGnumCode(map);
        if (ListUtil.isNotEmpty(disDgnumDomain.getDisDgnumListDomainList())) {
            this.saveDgnumListDomain(disDgnumDomain.getDisDgnumListDomainList(), disDgnum);
        }
        this.updateDgnumCache(disDgnum);
        return disDgnum.getDgnumCode();
    }

    private void saveDgnumListDomain(List<DisDgnumListDomain> disDgnumListDomainList, DisDgnum disDgnum) {
        if (ListUtil.isEmpty(disDgnumListDomainList) || null == disDgnum) {
            return;
        }
        for (DisDgnumListDomain disDgnumListDomain : disDgnumListDomainList) {
            try {
                BeanUtils.copyAllPropertys((Object)disDgnumListDomain, (Object)disDgnum);
            }
            catch (Exception e) {}
        }
        this.saveDgnumListBatch(disDgnumListDomainList);
    }

    private void updateDgnumListDomain(List<DisDgnumListDomain> disDgnumListDomainList, DisDgnum disDgnum) {
        if (ListUtil.isEmpty(disDgnumListDomainList) || null == disDgnum) {
            return;
        }
        this.delModelByGnumCode(this.getQueryMapParam("dgnumCode,tenantCode", new Object[]{disDgnum.getDgnumCode(), disDgnum.getTenantCode()}));
        this.saveDgnumListDomain(disDgnumListDomainList, disDgnum);
    }

    @Override
    public String saveDgnumBatch(List<DisDgnumDomain> disDgnumDomainList) throws ApiException {
        if (null == disDgnumDomainList || disDgnumDomainList.isEmpty()) {
            return null;
        }
        for (DisDgnumDomain disDgnumDomain : disDgnumDomainList) {
            this.saveDgnum(disDgnumDomain);
        }
        return "";
    }

    @Override
    public void updateDgnumState(Integer dgnumId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == dgnumId) {
            return;
        }
        this.updateStateDgnumModel(dgnumId, dataState, oldDataState, map);
        if (dataState == 0 && oldDataState != 0) {
            DisDgnum disDgnum = this.getDgnumModelById(dgnumId);
            this.updateDgnumCache(disDgnum);
        } else if (oldDataState == 0 && dataState != 0) {
            DisDgnum disDgnum = this.getDgnumModelById(dgnumId);
            this.deleteDgnumCache(disDgnum);
        }
    }

    @Override
    public void updateDgnumStateByCode(String tenantCode, String dgnumCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)dgnumCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateDgnumModelByCode(tenantCode, dgnumCode, dataState, oldDataState, map);
        if (dataState == 0 && oldDataState != 0) {
            DisDgnum disDgnum = this.getDgnumModelByCode(this.getQueryMapParam("dgnumCode,tenantCode", new Object[]{dgnumCode, tenantCode}));
            this.updateDgnumCache(disDgnum);
        } else if (oldDataState == 0 && dataState != 0) {
            DisDgnum disDgnum = this.getDgnumModelByCode(this.getQueryMapParam("dgnumCode,tenantCode", new Object[]{dgnumCode, tenantCode}));
            this.deleteDgnumCache(disDgnum);
        }
    }

    @Override
    public void updateDgnum(DisDgnumDomain disDgnumDomain) throws ApiException {
        String msg = this.checkDgnum(disDgnumDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDgnumServiceImpl.updateDgnum.checkDgnum", msg);
        }
        DisDgnum oldDisDgnum = this.getDgnumModelById(disDgnumDomain.getDgnumId());
        if (null == oldDisDgnum) {
            throw new ApiException("dis.DisDgnumServiceImpl.updateDgnum.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DisDgnum disDgnum = this.makeDgnum(disDgnumDomain, oldDisDgnum);
        this.setDgnumUpdataDefault(disDgnum);
        this.updateDgnumModel(disDgnum);
        oldDisDgnum = this.getDgnumModelById(disDgnumDomain.getDgnumId());
        if (null == oldDisDgnum) {
            throw new ApiException("dis.DisDgnumServiceImpl.updateDgnum.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        this.updateDgnumListDomain(disDgnumDomain.getDisDgnumListDomainList(), oldDisDgnum);
        this.updateDgnumCache(oldDisDgnum);
    }

    @Override
    public DisDgnumReDomain getDgnum(Integer dgnumId) {
        if (null == dgnumId) {
            return null;
        }
        DisDgnum disDgnum = this.getDgnumModelById(dgnumId);
        if (null == disDgnum) {
            return null;
        }
        return this.makeDisDgnumReDomain(disDgnum);
    }

    @Override
    public void deleteDgnum(Integer dgnumId) throws ApiException {
        if (null == dgnumId) {
            return;
        }
        DisDgnum disDgnum = this.getDgnumModelById(dgnumId);
        this.deleteDgnumModel(dgnumId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dgnumCode", disDgnum.getDgnumCode());
        map.put("tenantCode", disDgnum.getTenantCode());
        this.delModelByGnumCode(map);
        this.deleteDgnumCache(disDgnum);
        List<DisDgnumList> disDgnumLists = this.queryDgnumListModelPage(map);
        if (ListUtil.isNotEmpty(disDgnumLists)) {
            for (DisDgnumList disDgnumList : disDgnumLists) {
                this.deleteDgnumListCache(disDgnumList);
            }
        }
    }

    @Override
    public QueryResult<DisDgnumReDomain> queryDgnumPage(Map<String, Object> map) {
        List<DisDgnum> disDgnumList = this.queryDgnumModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDgnum(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        if (ListUtil.isEmpty(disDgnumList)) {
            queryResult.setList(null);
            return queryResult;
        }
        ArrayList<DisDgnumReDomain> relist = new ArrayList<DisDgnumReDomain>();
        for (DisDgnum disDgnum : disDgnumList) {
            relist.add(this.makeDisDgnumReDomain(disDgnum));
        }
        queryResult.setList(relist);
        return queryResult;
    }

    @Override
    public DisDgnumReDomain getDgnumByCode(String tenantCode, String dgnumCode) throws ApiException {
        if (StringUtils.isBlank((String)dgnumCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dgnumCode", dgnumCode);
        return this.makeDisDgnumReDomain(this.getDgnumModelByCode(map));
    }

    @Override
    public void deleteDgnumByCode(String tenantCode, String dgnumCode) throws ApiException {
        if (StringUtils.isBlank((String)dgnumCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dgnumCode", dgnumCode);
        DisDgnum disDgnum = this.getDgnumModelByCode(map);
        this.delDgnumModelByCode(map);
        this.deleteDgnumCache(disDgnum);
    }

    @Override
    public String saveDgnumList(DisDgnumListDomain disDgnumListDomain) throws ApiException {
        DisDgnumList disDgnumList = this.createDisDgnumList(disDgnumListDomain);
        this.saveDgnumListModel(disDgnumList);
        this.updateDgnumListCache(disDgnumList);
        return disDgnumList.getDgnumListCode();
    }

    @Override
    public String saveDgnumListBatch(List<DisDgnumListDomain> disDgnumListDomainList) throws ApiException {
        if (null == disDgnumListDomainList || disDgnumListDomainList.isEmpty()) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dgnumCode", disDgnumListDomainList.get(0).getDgnumCode());
        map.put("tenantCode", disDgnumListDomainList.get(0).getTenantCode());
        this.delModelByGnumCode(map);
        ArrayList<DisDgnumList> disDgnumListList = new ArrayList<DisDgnumList>();
        String code = "";
        if (!"removeAll".equals(disDgnumListDomainList.get(0).getDgnumListValuen())) {
            for (DisDgnumListDomain disDgnumListDomain : disDgnumListDomainList) {
                DisDgnumList disDgnumList = this.createDisDgnumList(disDgnumListDomain);
                code = disDgnumList.getDgnumListCode();
                disDgnumListList.add(disDgnumList);
            }
            this.saveDgnumListBatchModel(disDgnumListList);
            for (DisDgnumList disDgnumList2 : disDgnumListList) {
                this.updateDgnumListCache(disDgnumList2);
            }
        }
        return code;
    }

    @Override
    public void updateDgnumListState(Integer dgnumListId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == dgnumListId) {
            return;
        }
        this.updateStateDgnumListModel(dgnumListId, dataState, oldDataState, map);
    }

    @Override
    public void updateDgnumListStateByCode(String tenantCode, String dgnumListCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)dgnumListCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateDgnumListModelByCode(tenantCode, dgnumListCode, dataState, oldDataState, map);
    }

    @Override
    public void updateDgnumList(DisDgnumListDomain disDgnumListDomain) throws ApiException {
        String msg = this.checkDgnumList(disDgnumListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDgnumServiceImpl.updateDgnumList.checkDgnumList", msg);
        }
        DisDgnumList oldDisDgnumList = this.getDgnumListModelById(disDgnumListDomain.getDgnumListId());
        if (null == oldDisDgnumList) {
            throw new ApiException("dis.DisDgnumServiceImpl.updateDgnumList.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DisDgnumList disDgnumList = this.makeDgnumList(disDgnumListDomain, oldDisDgnumList);
        this.setDgnumListUpdataDefault(disDgnumList);
        this.updateDgnumListModel(disDgnumList);
        this.updateDgnumListCache(disDgnumList);
    }

    @Override
    public DisDgnumList getDgnumList(Integer dgnumListId) {
        if (null == dgnumListId) {
            return null;
        }
        return this.getDgnumListModelById(dgnumListId);
    }

    @Override
    public void deleteDgnumList(Integer dgnumListId) throws ApiException {
        if (null == dgnumListId) {
            return;
        }
        DisDgnumList disDgnumList = this.getDgnumListModelById(dgnumListId);
        this.deleteDgnumListModel(dgnumListId);
        this.deleteDgnumListCache(disDgnumList);
    }

    @Override
    public QueryResult<DisDgnumList> queryDgnumListPage(Map<String, Object> map) {
        List<DisDgnumList> disDgnumListList = this.queryDgnumListModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDgnumList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(disDgnumListList);
        return queryResult;
    }

    @Override
    public DisDgnumList getDgnumListByCode(String tenantCode, String dgnumListCode) throws ApiException {
        if (StringUtils.isBlank((String)dgnumListCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dgnumListCode", dgnumListCode);
        return this.getDgnumListModelByCode(map);
    }

    @Override
    public void deleteDgnumListByCode(String tenantCode, String dgnumListCode) throws ApiException {
        if (StringUtils.isBlank((String)dgnumListCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dgnumListCode", dgnumListCode);
        DisDgnumList disDgnumList = this.getDgnumListModelByCode(map);
        this.delDgnumListModelByCode(map);
        this.deleteDgnumListCache(disDgnumList);
    }

    private void deleteDgnumCache(DisDgnum disDgnum) {
        String json;
        if (null == disDgnum) {
            return;
        }
        if (StringUtils.isBlank((String)disDgnum.getChannelCode())) {
            disDgnum.setChannelCode("all");
        }
        if (StringUtils.isBlank((String)(json = DisUtil.getMap((String)this.cachekey, (String)(disDgnum.getChannelCode() + "-" + disDgnum.getTenantCode()))))) {
            return;
        }
        List dlist = (List)JsonUtil.buildNormalBinder().getJsonToList(json, DisDgnumDomain.class);
        ArrayList<DisDgnumDomain> dlist2 = new ArrayList<DisDgnumDomain>();
        for (DisDgnumDomain disDgnumDomain2 : dlist) {
            if (disDgnumDomain2.getDgnumCode().equals(disDgnum.getDgnumCode())) continue;
            dlist2.add(disDgnumDomain2);
        }
        DisUtil.setMapVer((String)this.cachekey, (String)(disDgnum.getChannelCode() + "-" + disDgnum.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(this.disDomainsort(dlist2)));
    }

    private void deleteDgnumListCache(DisDgnumList disDgnumList) {
        String json;
        if (null == disDgnumList) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", disDgnumList.getTenantCode());
        map.put("dgnumCode", disDgnumList.getDgnumCode());
        DisDgnum disDgnum = this.getDgnumModelByCode(map);
        if (StringUtils.isBlank((String)disDgnum.getChannelCode())) {
            disDgnum.setChannelCode("all");
        }
        if (StringUtils.isBlank((String)(json = DisUtil.getMap((String)this.cachekey, (String)(disDgnum.getChannelCode() + "-" + disDgnum.getTenantCode()))))) {
            return;
        }
        List dlist = (List)JsonUtil.buildNormalBinder().getJsonToList(json, DisDgnumDomain.class);
        ArrayList<DisDgnumDomain> dlist1 = new ArrayList<DisDgnumDomain>();
        for (DisDgnumDomain disDgnumDomain2 : dlist) {
            if (disDgnumDomain2.getDgnumCode().equals(disDgnum.getDgnumCode())) {
                ArrayList<DisDgnumList> configcacheList = new ArrayList<DisDgnumList>();
                disDgnumDomain2.setDisDgnumListList(configcacheList);
                for (DisDgnumList disDgnumList2 : disDgnumDomain2.getDisDgnumListList()) {
                    if (disDgnumList2.getDgnumListCode().equals(disDgnumList.getDgnumListCode())) continue;
                    configcacheList.add(disDgnumList2);
                }
            }
            dlist1.add(disDgnumDomain2);
        }
        DisUtil.setMapVer((String)this.cachekey, (String)(disDgnum.getChannelCode() + "-" + disDgnumList.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(this.disDomainsort(dlist1)));
    }

    private void updateDgnumCache(DisDgnum disDgnum) {
        if (null == disDgnum) {
            return;
        }
        if (StringUtils.isBlank((String)disDgnum.getChannelCode())) {
            disDgnum.setChannelCode("all");
        }
        DisDgnumDomain disDgnumDomain = this.makeDisDgnumDomain(disDgnum);
        HashMap<String, Object> confparammap = new HashMap<String, Object>();
        confparammap.put("dgnumCode", disDgnum.getDgnumCode());
        confparammap.put("tenantCode", disDgnum.getTenantCode());
        List<DisDgnumList> upcachelist = this.queryDgnumListModelPage(confparammap);
        disDgnumDomain.setDisDgnumListList(upcachelist);
        String json = DisUtil.getMap((String)this.cachekey, (String)(disDgnum.getChannelCode() + "-" + disDgnum.getTenantCode()));
        if (StringUtils.isBlank((String)json)) {
            ArrayList<DisDgnumDomain> dlist = new ArrayList<DisDgnumDomain>();
            dlist.add(disDgnumDomain);
            DisUtil.setMapVer((String)this.cachekey, (String)(disDgnum.getChannelCode() + "-" + disDgnum.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(this.disDomainsort(dlist)));
        } else {
            List dlist = (List)JsonUtil.buildNormalBinder().getJsonToList(json, DisDgnumDomain.class);
            ArrayList<DisDgnumDomain> cachedlist = new ArrayList<DisDgnumDomain>();
            for (DisDgnumDomain disDgnumDomain2 : dlist) {
                if (disDgnumDomain2.getDgnumCode().equals(disDgnum.getDgnumCode())) {
                    cachedlist.add(disDgnumDomain);
                    continue;
                }
                cachedlist.add(disDgnumDomain2);
            }
            DisUtil.setMapVer((String)this.cachekey, (String)(disDgnum.getChannelCode() + "-" + disDgnum.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(this.disDomainsort(cachedlist)));
        }
    }

    private void updateDgnumListCache(DisDgnumList disDgnumList) {
        if (null == disDgnumList) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", disDgnumList.getTenantCode());
        map.put("dgnumCode", disDgnumList.getDgnumCode());
        DisDgnum disDgnum = this.getDgnumModelByCode(map);
        if (StringUtils.isBlank((String)disDgnum.getChannelCode())) {
            disDgnum.setChannelCode("all");
        }
        DisDgnumDomain disDgnumDomain = this.makeDisDgnumDomain(disDgnum);
        HashMap<String, Object> confparammap = new HashMap<String, Object>();
        confparammap.put("dgnumCode", disDgnum.getDgnumCode());
        confparammap.put("tenantCode", disDgnum.getTenantCode());
        List<DisDgnumList> upcachelist = this.queryDgnumListModelPage(confparammap);
        disDgnumDomain.setDisDgnumListList(upcachelist);
        String json = DisUtil.getMap((String)this.cachekey, (String)(disDgnum.getChannelCode() + "-" + disDgnum.getTenantCode()));
        if (StringUtils.isBlank((String)json)) {
            ArrayList<DisDgnumDomain> dlist = new ArrayList<DisDgnumDomain>();
            dlist.add(disDgnumDomain);
            DisUtil.setMapVer((String)this.cachekey, (String)(disDgnum.getChannelCode() + "-" + disDgnumList.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(this.disDomainsort(dlist)));
        } else {
            List dlist = (List)JsonUtil.buildNormalBinder().getJsonToList(json, DisDgnumDomain.class);
            for (DisDgnumDomain disDgnumDomain2 : dlist) {
                if (!disDgnumDomain2.getDgnumCode().equals(disDgnum.getDgnumCode())) continue;
                ArrayList<DisDgnumList> cachedlist = new ArrayList<DisDgnumList>();
                for (DisDgnumList disDgnumList2 : disDgnumDomain2.getDisDgnumListList()) {
                    if (disDgnumList2.getDgnumListCode().equals(disDgnumList.getDgnumListCode())) {
                        cachedlist.add(disDgnumList);
                        continue;
                    }
                    cachedlist.add(disDgnumList2);
                }
                disDgnumDomain2.setDisDgnumListList(cachedlist);
            }
            DisUtil.setMapVer((String)this.cachekey, (String)(disDgnum.getChannelCode() + "-" + disDgnumList.getTenantCode()), (String)JsonUtil.buildNormalBinder().toJson(this.disDomainsort(dlist)));
        }
    }

    @Override
    public void queryDgnumLoadCache() {
        this.logger.info("DisDgnumService.queryDgnumLoadCache", (Object)"===========start==========");
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", 0);
        List<DisDgnum> disDgnumList = this.queryDgnumModelPage(parammap);
        if (null == disDgnumList || disDgnumList.isEmpty()) {
            DisUtil.delVer((String)this.cachekey);
            this.logger.info("DisDgnumService.queryDgnumLoadCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> ddMap = new ConcurrentHashMap<String, String>();
        HashMap<String, Object> confparammap = new HashMap<String, Object>();
        ConcurrentHashMap<String, ArrayList<DisDgnumDomain>> ddListMap = new ConcurrentHashMap<String, ArrayList<DisDgnumDomain>>();
        for (DisDgnum disDgnum : disDgnumList) {
            if (StringUtils.isBlank((String)disDgnum.getChannelCode())) {
                disDgnum.setChannelCode("all");
            }
            DisDgnumDomain disDgnumDomain = this.makeDisDgnumDomain(disDgnum);
            confparammap.put("dgnumCode", disDgnum.getDgnumCode());
            confparammap.put("tenantCode", disDgnum.getTenantCode());
            List<DisDgnumList> disDgnumListList = this.queryDgnumListModelPage(confparammap);
            disDgnumDomain.setDisDgnumListList(disDgnumListList);
            ArrayList<DisDgnumDomain> dlist = (ArrayList<DisDgnumDomain>)ddListMap.get(disDgnum.getChannelCode() + "-" + disDgnum.getTenantCode());
            if (null == dlist) {
                dlist = new ArrayList<DisDgnumDomain>();
                ddListMap.put(disDgnum.getChannelCode() + "-" + disDgnum.getTenantCode(), dlist);
            }
            dlist.add(disDgnumDomain);
        }
        for (String key : ddListMap.keySet()) {
            ddMap.put(key, JsonUtil.buildNormalBinder().toJson(this.disDomainsort((List)ddListMap.get(key))));
        }
        DisUtil.setMapVer((String)this.cachekey, ddMap);
        this.logger.info("DisDgnumService.queryDgnumLoadCache", (Object)"===========add-end==========");
    }

    private List<DisDgnumDomain> disDomainsort(List<DisDgnumDomain> dlist) {
        if (ListUtil.isEmpty(dlist)) {
            return null;
        }
        Collections.sort(dlist, new Comparator<DisDgnumDomain>(){

            @Override
            public int compare(DisDgnumDomain arg0, DisDgnumDomain arg1) {
                if (arg0.getDgnumWeight() > arg1.getDgnumWeight()) {
                    return 1;
                }
                if (arg0.getDgnumWeight() < arg1.getDgnumWeight()) {
                    return -1;
                }
                return arg0.getDgnumWeight().compareTo(arg0.getDgnumWeight());
            }
        });
        return dlist;
    }

    private DisDgnumDomain makeDisDgnumDomain(DisDgnum disDgnum) {
        if (null == disDgnum) {
            return null;
        }
        DisDgnumDomain disDgnumDomain = new DisDgnumDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disDgnumDomain, (Object)disDgnum);
            return disDgnumDomain;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

