/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.distribution.service.impl;

import com.yqbsoft.laser.service.distribution.dao.DisDgoodsuplistMapper;
import com.yqbsoft.laser.service.distribution.domain.DisDgoodsuplistDomain;
import com.yqbsoft.laser.service.distribution.domain.DisDgoodsuplistReDomain;
import com.yqbsoft.laser.service.distribution.model.DisDgoodsuplist;
import com.yqbsoft.laser.service.distribution.service.DisDgoodsuplistService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DisDgoodsuplistServiceImpl
extends BaseServiceImpl
implements DisDgoodsuplistService {
    private static final String SYS_CODE = "dis.DisDgoodsuplistServiceImpl";
    private DisDgoodsuplistMapper disDgoodsuplistMapper;
    private String cachekey = "DisDgoodsuplist-No-channelCode";

    public void setDisDgoodsuplistMapper(DisDgoodsuplistMapper disDgoodsuplistMapper) {
        this.disDgoodsuplistMapper = disDgoodsuplistMapper;
    }

    private Date getSysDate() {
        try {
            return this.disDgoodsuplistMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsuplistServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkDgoodsuplist(DisDgoodsuplistDomain disDgoodsuplistDomain) {
        if (null == disDgoodsuplistDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)disDgoodsuplistDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDgoodsuplistDefault(DisDgoodsuplist disDgoodsuplist) {
        if (null == disDgoodsuplist) {
            return;
        }
        if (null == disDgoodsuplist.getDataState()) {
            disDgoodsuplist.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == disDgoodsuplist.getGmtCreate()) {
            disDgoodsuplist.setGmtCreate(date);
        }
        disDgoodsuplist.setGmtModified(date);
        if (StringUtils.isBlank((String)disDgoodsuplist.getDgoodsuplistCode())) {
            disDgoodsuplist.setDgoodsuplistCode(this.getNo(null, "DisDgoodsuplist", "disDgoodsuplist", disDgoodsuplist.getTenantCode()));
        }
    }

    private int getDgoodsuplistMaxCode() {
        int code = 0;
        try {
            return this.disDgoodsuplistMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsuplistServiceImpl.getDgoodsuplistMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setDgoodsuplistUpdataDefault(DisDgoodsuplist disDgoodsuplist) {
        if (null == disDgoodsuplist) {
            return;
        }
        disDgoodsuplist.setGmtModified(this.getSysDate());
    }

    private void saveDgoodsuplistModel(DisDgoodsuplist disDgoodsuplist) throws ApiException {
        if (null == disDgoodsuplist) {
            return;
        }
        try {
            this.disDgoodsuplistMapper.insert(disDgoodsuplist);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.saveDgoodsuplistModel.ex", (Throwable)e);
        }
    }

    private void saveDgoodsuplistBatchModel(List<DisDgoodsuplist> disDgoodsuplistList) throws ApiException {
        if (null == disDgoodsuplistList || disDgoodsuplistList.isEmpty()) {
            return;
        }
        try {
            this.disDgoodsuplistMapper.insertBatch(disDgoodsuplistList);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.saveDgoodsuplistBatchModel.ex", (Throwable)e);
        }
    }

    private DisDgoodsuplist getDgoodsuplistModelById(Integer dgoodsuplistId) {
        if (null == dgoodsuplistId) {
            return null;
        }
        try {
            return this.disDgoodsuplistMapper.selectByPrimaryKey(dgoodsuplistId);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsuplistServiceImpl.getDgoodsuplistModelById", (Throwable)e);
            return null;
        }
    }

    private DisDgoodsuplist getDgoodsuplistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.disDgoodsuplistMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsuplistServiceImpl.getDgoodsuplistModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delDgoodsuplistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.disDgoodsuplistMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.delDgoodsuplistModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.delDgoodsuplistModelByCode.num");
        }
    }

    private void deleteDgoodsuplistModel(Integer dgoodsuplistId) throws ApiException {
        if (null == dgoodsuplistId) {
            return;
        }
        int i = 0;
        try {
            i = this.disDgoodsuplistMapper.deleteByPrimaryKey(dgoodsuplistId);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.deleteDgoodsuplistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.deleteDgoodsuplistModel.num");
        }
    }

    private void updateDgoodsuplistModel(DisDgoodsuplist disDgoodsuplist) throws ApiException {
        if (null == disDgoodsuplist) {
            return;
        }
        int i = 0;
        try {
            i = this.disDgoodsuplistMapper.updateByPrimaryKey(disDgoodsuplist);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.updateDgoodsuplistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.updateDgoodsuplistModel.num");
        }
    }

    private void updateStateDgoodsuplistModel(Integer dgoodsuplistId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == dgoodsuplistId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dgoodsuplistId", dgoodsuplistId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disDgoodsuplistMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.updateStateDgoodsuplistModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.updateStateDgoodsuplistModel.null");
        }
    }

    private void updateStateDgoodsuplistModelByCode(String tenantCode, String dgoodsuplistCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)dgoodsuplistCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dgoodsuplistCode", dgoodsuplistCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disDgoodsuplistMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.updateStateDgoodsuplistModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.updateStateDgoodsuplistModelByCode.null");
        }
    }

    private DisDgoodsuplist makeDgoodsuplist(DisDgoodsuplistDomain disDgoodsuplistDomain, DisDgoodsuplist disDgoodsuplist) {
        if (null == disDgoodsuplistDomain) {
            return null;
        }
        if (null == disDgoodsuplist) {
            disDgoodsuplist = new DisDgoodsuplist();
        }
        try {
            BeanUtils.copyAllPropertys((Object)disDgoodsuplist, (Object)disDgoodsuplistDomain);
            return disDgoodsuplist;
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsuplistServiceImpl.makeDgoodsuplist", (Throwable)e);
            return null;
        }
    }

    private DisDgoodsuplistReDomain makeDisDgoodsuplistReDomain(DisDgoodsuplist disDgoodsuplist) {
        if (null == disDgoodsuplist) {
            return null;
        }
        DisDgoodsuplistReDomain disDgoodsuplistReDomain = new DisDgoodsuplistReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disDgoodsuplistReDomain, (Object)disDgoodsuplist);
            return disDgoodsuplistReDomain;
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsuplistServiceImpl.makeDisDgoodsuplistReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DisDgoodsuplist> queryDgoodsuplistModelPage(Map<String, Object> parammap) {
        try {
            return this.disDgoodsuplistMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsuplistServiceImpl.queryDgoodsuplistModel", (Throwable)e);
            return null;
        }
    }

    private int countDgoodsuplist(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.disDgoodsuplistMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDgoodsuplistServiceImpl.countDgoodsuplist", (Throwable)e);
        }
        return i;
    }

    private DisDgoodsuplist createDisDgoodsuplist(DisDgoodsuplistDomain disDgoodsuplistDomain) {
        String msg = this.checkDgoodsuplist(disDgoodsuplistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.saveDgoodsuplist.checkDgoodsuplist", msg);
        }
        DisDgoodsuplist disDgoodsuplist = this.makeDgoodsuplist(disDgoodsuplistDomain, null);
        this.setDgoodsuplistDefault(disDgoodsuplist);
        return disDgoodsuplist;
    }

    @Override
    public String saveDgoodsuplist(DisDgoodsuplistDomain disDgoodsuplistDomain) throws ApiException {
        DisDgoodsuplist disDgoodsuplist = this.createDisDgoodsuplist(disDgoodsuplistDomain);
        this.saveDgoodsuplistModel(disDgoodsuplist);
        this.updateCache(disDgoodsuplist);
        return disDgoodsuplist.getDgoodsuplistCode();
    }

    @Override
    public String saveDgoodsuplistBatch(List<DisDgoodsuplistDomain> disDgoodsuplistDomainList) throws ApiException {
        if (null == disDgoodsuplistDomainList || disDgoodsuplistDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DisDgoodsuplist> disDgoodsuplistList = new ArrayList<DisDgoodsuplist>();
        String code = "";
        for (DisDgoodsuplistDomain disDgoodsuplistDomain : disDgoodsuplistDomainList) {
            DisDgoodsuplist disDgoodsuplist = this.createDisDgoodsuplist(disDgoodsuplistDomain);
            code = disDgoodsuplist.getDgoodsuplistCode();
            disDgoodsuplistList.add(disDgoodsuplist);
        }
        this.saveDgoodsuplistBatchModel(disDgoodsuplistList);
        for (DisDgoodsuplist disDgoodsuplist2 : disDgoodsuplistList) {
            this.updateCache(disDgoodsuplist2);
        }
        return code;
    }

    @Override
    public void updateDgoodsuplistState(Integer dgoodsuplistId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == dgoodsuplistId) {
            return;
        }
        this.updateStateDgoodsuplistModel(dgoodsuplistId, dataState, oldDataState, map);
        if (-1 == dataState) {
            DisDgoodsuplist disDgoodsuplist = this.getDgoodsuplistModelById(dgoodsuplistId);
            this.deleteCache(disDgoodsuplist);
        } else if (0 == dataState) {
            DisDgoodsuplist disDgoodsuplist = this.getDgoodsuplistModelById(dgoodsuplistId);
            this.updateCache(disDgoodsuplist);
        }
    }

    @Override
    public void updateDgoodsuplistStateByCode(String tenantCode, String dgoodsuplistCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)dgoodsuplistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateDgoodsuplistModelByCode(tenantCode, dgoodsuplistCode, dataState, oldDataState, map);
        if (-1 == dataState) {
            DisDgoodsuplist disDgoodsuplist = this.getDgoodsuplistModelByCode(this.getQueryMapParam(tenantCode, new Object[]{dgoodsuplistCode, tenantCode, dgoodsuplistCode}));
            this.deleteCache(disDgoodsuplist);
        } else if (0 == dataState) {
            DisDgoodsuplist disDgoodsuplist = this.getDgoodsuplistModelByCode(this.getQueryMapParam(tenantCode, new Object[]{dgoodsuplistCode, tenantCode, dgoodsuplistCode}));
            this.updateCache(disDgoodsuplist);
        }
    }

    @Override
    public void updateDgoodsuplist(DisDgoodsuplistDomain disDgoodsuplistDomain) throws ApiException {
        String msg = this.checkDgoodsuplist(disDgoodsuplistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.updateDgoodsuplist.checkDgoodsuplist", msg);
        }
        DisDgoodsuplist oldDisDgoodsuplist = this.getDgoodsuplistModelById(disDgoodsuplistDomain.getDgoodsuplistId());
        if (null == oldDisDgoodsuplist) {
            throw new ApiException("dis.DisDgoodsuplistServiceImpl.updateDgoodsuplist.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DisDgoodsuplist disDgoodsuplist = this.makeDgoodsuplist(disDgoodsuplistDomain, oldDisDgoodsuplist);
        this.setDgoodsuplistUpdataDefault(disDgoodsuplist);
        this.updateDgoodsuplistModel(disDgoodsuplist);
        this.updateCache(disDgoodsuplist);
    }

    @Override
    public DisDgoodsuplist getDgoodsuplist(Integer dgoodsuplistId) {
        if (null == dgoodsuplistId) {
            return null;
        }
        return this.getDgoodsuplistModelById(dgoodsuplistId);
    }

    @Override
    public void deleteDgoodsuplist(Integer dgoodsuplistId) throws ApiException {
        if (null == dgoodsuplistId) {
            return;
        }
        DisDgoodsuplist disDgoodsuplist = this.getDgoodsuplistModelById(dgoodsuplistId);
        this.deleteDgoodsuplistModel(dgoodsuplistId);
        this.deleteCache(disDgoodsuplist);
    }

    @Override
    public QueryResult<DisDgoodsuplist> queryDgoodsuplistPage(Map<String, Object> map) {
        List<DisDgoodsuplist> disDgoodsuplistList = this.queryDgoodsuplistModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDgoodsuplist(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(disDgoodsuplistList);
        return queryResult;
    }

    @Override
    public DisDgoodsuplist getDgoodsuplistByCode(String tenantCode, String dgoodsuplistCode) throws ApiException {
        if (StringUtils.isBlank((String)dgoodsuplistCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dgoodsuplistCode", dgoodsuplistCode);
        return this.getDgoodsuplistModelByCode(map);
    }

    @Override
    public void deleteDgoodsuplistByCode(String tenantCode, String dgoodsuplistCode) throws ApiException {
        if (StringUtils.isBlank((String)dgoodsuplistCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dgoodsuplistCode", dgoodsuplistCode);
        DisDgoodsuplist disDgoodsuplist = this.getDgoodsuplistModelByCode(map);
        this.delDgoodsuplistModelByCode(map);
        this.deleteCache(disDgoodsuplist);
    }

    private void updateCache(DisDgoodsuplist disDgoodsuplist) {
        if (null == disDgoodsuplist) {
            return;
        }
        if (null == disDgoodsuplist.getSkuShowno()) {
            disDgoodsuplist.setSkuShowno("");
        }
        if (null == disDgoodsuplist.getGoodsShowno()) {
            disDgoodsuplist.setGoodsShowno("");
        }
        if (null == disDgoodsuplist.getGoodsShowname()) {
            disDgoodsuplist.setGoodsShowname("");
        }
        if (StringUtils.isNotBlank((String)disDgoodsuplist.getSkuNo())) {
            DisUtil.setMapVer((String)this.cachekey, (String)(disDgoodsuplist.getChannelCode() + "-1-" + disDgoodsuplist.getSkuNo() + "-" + disDgoodsuplist.getTenantCode()), (String)(disDgoodsuplist.getSkuShowno() + "||" + disDgoodsuplist.getGoodsShowno() + "||" + disDgoodsuplist.getGoodsShowname()));
        }
        if (StringUtils.isNotBlank((String)disDgoodsuplist.getGoodsNo())) {
            DisUtil.setMapVer((String)this.cachekey, (String)(disDgoodsuplist.getChannelCode() + "-0-" + disDgoodsuplist.getGoodsNo() + "-" + disDgoodsuplist.getTenantCode()), (String)(disDgoodsuplist.getSkuShowno() + "||" + disDgoodsuplist.getGoodsShowno() + "||" + disDgoodsuplist.getGoodsShowname()));
        }
    }

    private void deleteCache(DisDgoodsuplist disDgoodsuplist) {
        if (null == disDgoodsuplist) {
            return;
        }
        if (null == disDgoodsuplist.getSkuShowno()) {
            disDgoodsuplist.setSkuShowno("");
        }
        if (null == disDgoodsuplist.getGoodsShowno()) {
            disDgoodsuplist.setGoodsShowno("");
        }
        if (null == disDgoodsuplist.getGoodsShowname()) {
            disDgoodsuplist.setGoodsShowname("");
        }
        if (StringUtils.isNotBlank((String)disDgoodsuplist.getSkuNo())) {
            DisUtil.delMapVer((String)this.cachekey, (String[])new String[]{disDgoodsuplist.getChannelCode() + "-1-" + disDgoodsuplist.getSkuNo() + "-" + disDgoodsuplist.getTenantCode()});
        }
        if (StringUtils.isNotBlank((String)disDgoodsuplist.getGoodsNo())) {
            DisUtil.delMapVer((String)this.cachekey, (String[])new String[]{disDgoodsuplist.getChannelCode() + "-0-" + disDgoodsuplist.getGoodsNo() + "-" + disDgoodsuplist.getTenantCode()});
        }
    }

    @Override
    public void queryDgoodsuplistLoadCache() {
        this.logger.info("dis.DisDgoodsuplistServiceImpl.queryDgoodsuplistLoadCache", (Object)"===========start==========");
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", 0);
        List<DisDgoodsuplist> disDgoodsuplistlist = this.queryDgoodsuplistModelPage(parammap);
        if (null == disDgoodsuplistlist || disDgoodsuplistlist.isEmpty()) {
            DisUtil.delVer((String)this.cachekey);
            this.logger.info("dis.DisDgoodsuplistServiceImpl.queryDgoodsuplistLoadCache", (Object)"===========del-end==========");
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (DisDgoodsuplist disDgoodsuplist : disDgoodsuplistlist) {
            if (null == disDgoodsuplist.getSkuShowno()) {
                disDgoodsuplist.setSkuShowno("");
            }
            if (null == disDgoodsuplist.getGoodsShowno()) {
                disDgoodsuplist.setGoodsShowno("");
            }
            if (null == disDgoodsuplist.getGoodsShowname()) {
                disDgoodsuplist.setGoodsShowname("");
            }
            if (StringUtils.isNotBlank((String)disDgoodsuplist.getSkuNo())) {
                map.put(disDgoodsuplist.getChannelCode() + "-1-" + disDgoodsuplist.getSkuNo() + "-" + disDgoodsuplist.getTenantCode(), disDgoodsuplist.getSkuShowno() + "||" + disDgoodsuplist.getGoodsShowno() + "||" + disDgoodsuplist.getGoodsShowname());
            }
            if (!StringUtils.isNotBlank((String)disDgoodsuplist.getGoodsNo())) continue;
            map.put(disDgoodsuplist.getChannelCode() + "-0-" + disDgoodsuplist.getGoodsNo() + "-" + disDgoodsuplist.getTenantCode(), disDgoodsuplist.getSkuShowno() + "||" + disDgoodsuplist.getGoodsShowno() + "||" + disDgoodsuplist.getGoodsShowname());
        }
        DisUtil.setMapVer((String)this.cachekey, map);
        this.logger.info("dis.DisDgoodsuplistServiceImpl.queryDgoodsuplistLoadCache", (Object)"===========add-end==========");
    }
}

