/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.distribution.service.impl;

import com.yqbsoft.laser.service.distribution.dao.DisContractGoodsMapper;
import com.yqbsoft.laser.service.distribution.dao.DisContractMapper;
import com.yqbsoft.laser.service.distribution.dao.DisContractproMapper;
import com.yqbsoft.laser.service.distribution.dao.DisPackageMapper;
import com.yqbsoft.laser.service.distribution.domain.DisChannelsendDomain;
import com.yqbsoft.laser.service.distribution.domain.DisContractDomain;
import com.yqbsoft.laser.service.distribution.domain.DisContractGoodsDomain;
import com.yqbsoft.laser.service.distribution.domain.DisContractGoodsReDomain;
import com.yqbsoft.laser.service.distribution.domain.DisContractReDomain;
import com.yqbsoft.laser.service.distribution.domain.DisContractSettlDomain;
import com.yqbsoft.laser.service.distribution.domain.DisContractproDomain;
import com.yqbsoft.laser.service.distribution.domain.DisContractproReDomain;
import com.yqbsoft.laser.service.distribution.domain.DisPackageDomain;
import com.yqbsoft.laser.service.distribution.domain.DisPackageReDomain;
import com.yqbsoft.laser.service.distribution.domain.GoodsBean;
import com.yqbsoft.laser.service.distribution.model.DisChannel;
import com.yqbsoft.laser.service.distribution.model.DisChannelsend;
import com.yqbsoft.laser.service.distribution.model.DisContract;
import com.yqbsoft.laser.service.distribution.model.DisContractGoods;
import com.yqbsoft.laser.service.distribution.model.DisContractpro;
import com.yqbsoft.laser.service.distribution.model.DisPackage;
import com.yqbsoft.laser.service.distribution.service.DisChannelsendBaseService;
import com.yqbsoft.laser.service.distribution.service.DisChannelsendService;
import com.yqbsoft.laser.service.distribution.service.DisContractService;
import com.yqbsoft.laser.service.distribution.service.DisContractSettlService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DisContractServiceImpl
extends BaseServiceImpl
implements DisContractService {
    private static final String SYS_CODE = "dis.DisContractServiceImpl";
    private DisContractMapper disContractMapper;
    private DisContractGoodsMapper disContractGoodsMapper;
    private DisContractproMapper disContractproMapper;
    private DisPackageMapper disPackageMapper;
    DisChannelsendService disChannelsendService;
    DisContractSettlService disContractSettlService;
    private DisChannelsendBaseService disChannelsendBaseService;

    public DisChannelsendBaseService getDisChannelsendBaseService() {
        if (null == this.disChannelsendBaseService) {
            this.disChannelsendBaseService = (DisChannelsendBaseService)SpringApplicationContextUtil.getBean((String)"disChannelsendBaseService");
        }
        return this.disChannelsendBaseService;
    }

    public void setDisContractSettlService(DisContractSettlService disContractSettlService) {
        this.disContractSettlService = disContractSettlService;
    }

    public void setDisChannelsendService(DisChannelsendService disChannelsendService) {
        this.disChannelsendService = disChannelsendService;
    }

    public void setDisContractMapper(DisContractMapper disContractMapper) {
        this.disContractMapper = disContractMapper;
    }

    public void setDisContractGoodsMapper(DisContractGoodsMapper disContractGoodsMapper) {
        this.disContractGoodsMapper = disContractGoodsMapper;
    }

    public void setDisContractproMapper(DisContractproMapper disContractproMapper) {
        this.disContractproMapper = disContractproMapper;
    }

    public void setDisPackageMapper(DisPackageMapper disPackageMapper) {
        this.disPackageMapper = disPackageMapper;
    }

    private Date getSysDate() {
        try {
            return this.disContractMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkContract(DisContractDomain disContractDomain) {
        if (null == disContractDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)disContractDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setContractDefault(DisContract disContract) {
        if (null == disContract) {
            return;
        }
        if (null == disContract.getDataState()) {
            disContract.setDataState(0);
        }
        if (null == disContract.getContractSendstate()) {
            disContract.setContractSendstate(0);
        }
        Date date = this.getSysDate();
        if (null == disContract.getGmtCreate()) {
            disContract.setGmtCreate(date);
        }
        disContract.setGmtModified(date);
        if (StringUtils.isBlank((String)disContract.getContractBillcode())) {
            disContract.setContractBillcode(this.getNo(null, "DisContract", "disContract", disContract.getTenantCode()));
        }
    }

    private int getContractMaxCode() {
        int code = 0;
        try {
            return this.disContractMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractServiceImpl.getContractMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setContractUpdataDefault(DisContract disContract) {
        if (null == disContract) {
            return;
        }
        disContract.setGmtModified(this.getSysDate());
    }

    private void saveContractModel(DisContract disContract) throws ApiException {
        if (null == disContract) {
            return;
        }
        try {
            this.disContractMapper.insert(disContract);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractServiceImpl.saveContractModel.ex", (Throwable)e);
        }
    }

    public void saveContractBatchModel(List<DisContract> disContractList) throws ApiException {
        if (null == disContractList || disContractList.isEmpty()) {
            return;
        }
        try {
            this.disContractMapper.insertBatch(disContractList);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractServiceImpl.saveContractBatchModel.ex", (Throwable)e);
        }
    }

    private DisContract getContractModelById(Integer contractId) {
        if (null == contractId) {
            return null;
        }
        try {
            return this.disContractMapper.selectByPrimaryKey(contractId);
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractServiceImpl.getContractModelById", (Throwable)e);
            return null;
        }
    }

    private DisContract getContractModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.disContractMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractServiceImpl.getContractModelByCode", (Throwable)e);
            return null;
        }
    }

    private DisContract getContractModelByNbCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.disContractMapper.getByNbCode(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractServiceImpl.getContractModelByNbCode", (Throwable)e);
            return null;
        }
    }

    private void delContractModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.disContractMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractServiceImpl.delContractModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisContractServiceImpl.delContractModelByCode.num");
        }
    }

    private void deleteContractModel(Integer contractId) throws ApiException {
        if (null == contractId) {
            return;
        }
        int i = 0;
        try {
            i = this.disContractMapper.deleteByPrimaryKey(contractId);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractServiceImpl.deleteContractModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisContractServiceImpl.deleteContractModel.num");
        }
    }

    private void updateContractModel(DisContract disContract) throws ApiException {
        if (null == disContract) {
            return;
        }
        int i = 0;
        try {
            i = this.disContractMapper.updateByPrimaryKey(disContract);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractServiceImpl.updateContractModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisContractServiceImpl.updateContractModel.num");
        }
    }

    private void updateStateContractModel(Integer contractId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == contractId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractId", contractId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disContractMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractServiceImpl.updateStateContractModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisContractServiceImpl.updateStateContractModel.null");
        }
    }

    private void updateStateContractModelByCode(String tenantCode, String contractBillcode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)contractBillcode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractBillcode", contractBillcode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disContractMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractServiceImpl.updateStateContractModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisContractServiceImpl.updateStateContractModelByCode.null");
        }
    }

    private void updateSendStateContractModelByCode(String tenantCode, String contractBillcode, Integer contractSendstate, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)contractBillcode) || null == contractSendstate) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractBillcode", contractBillcode);
        map.put("contractSendstate", contractSendstate);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disContractMapper.updateSendStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractServiceImpl.updateSendStateContractModelByCode.ex", ((Object)map).toString(), (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisContractServiceImpl.updateSendStateContractModelByCode.null");
        }
    }

    private void updateStateContractModelByNbCode(String tenantCode, String contractNbillcode, String channelCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)contractNbillcode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractNbillcode", contractNbillcode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        map.put("channelCode", channelCode);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disContractMapper.updateStateByNbCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractServiceImpl.updateStateContractModelByNbCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisContractServiceImpl.updateStateContractModelByNbCode.null map=" + map + "; expmap:" + expmap);
        }
    }

    private DisContract makeContract(DisContractDomain disContractDomain, DisContract disContract) {
        if (null == disContractDomain) {
            return null;
        }
        if (null == disContract) {
            disContract = new DisContract();
        }
        try {
            BeanUtils.copyAllPropertys((Object)disContract, (Object)disContractDomain);
            return disContract;
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractServiceImpl.makeContract", (Throwable)e);
            return null;
        }
    }

    private DisContractReDomain makeDisContractReDomain(DisContract disContract) {
        if (null == disContract) {
            return null;
        }
        DisContractReDomain disContractReDomain = new DisContractReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disContractReDomain, (Object)disContract);
            return disContractReDomain;
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractServiceImpl.makeDisContractReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DisContract> queryContractModelPage(Map<String, Object> parammap) {
        try {
            return this.disContractMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractServiceImpl.queryContractModel", (Throwable)e);
            return null;
        }
    }

    private int countContract(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.disContractMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractServiceImpl.countContract", (Throwable)e);
        }
        return i;
    }

    private DisContract createDisContract(DisContractDomain disContractDomain) {
        String msg = this.checkContract(disContractDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisContractServiceImpl.saveContract.checkContract", msg);
        }
        DisContract disContract = this.makeContract(disContractDomain, null);
        this.setContractDefault(disContract);
        return disContract;
    }

    private String checkContractGoods(DisContractGoodsDomain disContractGoodsDomain) {
        if (null == disContractGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)disContractGoodsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setContractGoodsDefault(DisContractGoods disContractGoods) {
        if (null == disContractGoods) {
            return;
        }
        if (null == disContractGoods.getDataState()) {
            disContractGoods.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == disContractGoods.getGmtCreate()) {
            disContractGoods.setGmtCreate(date);
        }
        disContractGoods.setGmtModified(date);
        if (StringUtils.isBlank((String)disContractGoods.getContractGoodsCode())) {
            disContractGoods.setContractGoodsCode(this.getNo(null, "DisContractGoods", "disContractGoods", disContractGoods.getTenantCode()));
        }
    }

    private int getContractGoodsMaxCode() {
        int code = 0;
        try {
            return this.disContractGoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractServiceImpl.getContractGoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setContractGoodsUpdataDefault(DisContractGoods disContractGoods) {
        if (null == disContractGoods) {
            return;
        }
        disContractGoods.setGmtModified(this.getSysDate());
    }

    private void saveContractGoodsModel(DisContractGoods disContractGoods) throws ApiException {
        if (null == disContractGoods) {
            return;
        }
        try {
            this.disContractGoodsMapper.insert(disContractGoods);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractServiceImpl.saveContractGoodsModel.ex", (Throwable)e);
        }
    }

    private void saveContractGoodsBatchModel(List<DisContractGoods> disContractGoodsList) throws ApiException {
        if (null == disContractGoodsList || disContractGoodsList.isEmpty()) {
            return;
        }
        try {
            this.disContractGoodsMapper.insertBatch(disContractGoodsList);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractServiceImpl.saveContractGoodsBatchModel.ex", (Throwable)e);
        }
    }

    private DisContractGoods getContractGoodsModelById(Integer contractGoodsId) {
        if (null == contractGoodsId) {
            return null;
        }
        try {
            return this.disContractGoodsMapper.selectByPrimaryKey(contractGoodsId);
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractServiceImpl.getContractGoodsModelById", (Throwable)e);
            return null;
        }
    }

    private DisContractGoods getContractGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.disContractGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractServiceImpl.getContractGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void updateRefunFlagByCodeModel(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            return;
        }
        int i = 0;
        try {
            i = this.disContractGoodsMapper.updateRefunFlagByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractServiceImpl.updateRefunFlagByCodeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisContractServiceImpl.updateRefunFlagByCodeModel.num");
        }
    }

    private void delContractGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.disContractGoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractServiceImpl.delContractGoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisContractServiceImpl.delContractGoodsModelByCode.num");
        }
    }

    private void deleteContractGoodsModel(Integer contractGoodsId) throws ApiException {
        if (null == contractGoodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.disContractGoodsMapper.deleteByPrimaryKey(contractGoodsId);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractServiceImpl.deleteContractGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisContractServiceImpl.deleteContractGoodsModel.num");
        }
    }

    private void updateContractGoodsModel(DisContractGoods disContractGoods) throws ApiException {
        if (null == disContractGoods) {
            return;
        }
        int i = 0;
        try {
            i = this.disContractGoodsMapper.updateByPrimaryKey(disContractGoods);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractServiceImpl.updateContractGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisContractServiceImpl.updateContractGoodsModel.num");
        }
    }

    private void updateStateContractGoodsModel(Integer contractGoodsId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == contractGoodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractGoodsId", contractGoodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disContractGoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractServiceImpl.updateStateContractGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisContractServiceImpl.updateStateContractGoodsModel.null");
        }
    }

    private void updateStateContractGoodsModelByCode(String tenantCode, String contractGoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)contractGoodsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractGoodsCode", contractGoodsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disContractGoodsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractServiceImpl.updateStateContractGoodsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisContractServiceImpl.updateStateContractGoodsModelByCode.null");
        }
    }

    private DisContractGoods makeContractGoods(DisContractGoodsDomain disContractGoodsDomain, DisContractGoods disContractGoods) {
        if (null == disContractGoodsDomain) {
            return null;
        }
        if (null == disContractGoods) {
            disContractGoods = new DisContractGoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)disContractGoods, (Object)disContractGoodsDomain);
            return disContractGoods;
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractServiceImpl.makeContractGoods", (Throwable)e);
            return null;
        }
    }

    private DisContractGoodsReDomain makeDisContractGoodsReDomain(DisContractGoods disContractGoods) {
        if (null == disContractGoods) {
            return null;
        }
        DisContractGoodsReDomain disContractGoodsReDomain = new DisContractGoodsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disContractGoodsReDomain, (Object)disContractGoods);
            return disContractGoodsReDomain;
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractServiceImpl.makeDisContractGoodsReDomain", (Throwable)e);
            return null;
        }
    }

    private DisContractGoodsDomain makeDisContractGoodsDomain(DisContractGoods disContractGoods) {
        if (null == disContractGoods) {
            return null;
        }
        DisContractGoodsDomain disContractGoodsDomain = new DisContractGoodsDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disContractGoodsDomain, (Object)disContractGoods);
            return disContractGoodsDomain;
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractServiceImpl.makeDisContractGoodsDomain", (Throwable)e);
            return null;
        }
    }

    private List<DisContractGoods> queryContractGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.disContractGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractServiceImpl.queryContractGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countContractGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.disContractGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractServiceImpl.countContractGoods", (Throwable)e);
        }
        return i;
    }

    private DisContractGoods createDisContractGoods(DisContractGoodsDomain disContractGoodsDomain) {
        String msg = this.checkContractGoods(disContractGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisContractServiceImpl.saveContractGoods.checkContractGoods", msg);
        }
        DisContractGoods disContractGoods = this.makeContractGoods(disContractGoodsDomain, null);
        this.setContractGoodsDefault(disContractGoods);
        return disContractGoods;
    }

    private String checkContractpro(DisContractproDomain disContractproDomain) {
        if (null == disContractproDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)disContractproDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setContractproDefault(DisContractpro disContractpro) {
        if (null == disContractpro) {
            return;
        }
        if (null == disContractpro.getDataState()) {
            disContractpro.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == disContractpro.getGmtCreate()) {
            disContractpro.setGmtCreate(date);
        }
        disContractpro.setGmtModified(date);
        if (StringUtils.isBlank((String)disContractpro.getContractproBillcode())) {
            disContractpro.setContractproBillcode(this.getNo(null, "DisContractpro", "disContractpro", disContractpro.getTenantCode()));
        }
    }

    private int getContractproMaxCode() {
        int code = 0;
        try {
            return this.disContractproMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractServiceImpl.getContractproMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setContractproUpdataDefault(DisContractpro disContractpro) {
        if (null == disContractpro) {
            return;
        }
        disContractpro.setGmtModified(this.getSysDate());
    }

    private void saveContractproModel(DisContractpro disContractpro) throws ApiException {
        if (null == disContractpro) {
            return;
        }
        try {
            this.disContractproMapper.insert(disContractpro);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractServiceImpl.saveContractproModel.ex", (Throwable)e);
        }
    }

    private void saveContractproBatchModel(List<DisContractpro> disContractproList) throws ApiException {
        if (null == disContractproList || disContractproList.isEmpty()) {
            return;
        }
        try {
            this.disContractproMapper.insertBatch(disContractproList);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractServiceImpl.saveContractproBatchModel.ex", (Throwable)e);
        }
    }

    private DisContractpro getContractproModelById(Integer contractproId) {
        if (null == contractproId) {
            return null;
        }
        try {
            return this.disContractproMapper.selectByPrimaryKey(contractproId);
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractServiceImpl.getContractproModelById", (Throwable)e);
            return null;
        }
    }

    private DisContractpro getContractproModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.disContractproMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractServiceImpl.getContractproModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delContractproModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.disContractproMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractServiceImpl.delContractproModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisContractServiceImpl.delContractproModelByCode.num");
        }
    }

    private void deleteContractproModel(Integer contractproId) throws ApiException {
        if (null == contractproId) {
            return;
        }
        int i = 0;
        try {
            i = this.disContractproMapper.deleteByPrimaryKey(contractproId);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractServiceImpl.deleteContractproModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisContractServiceImpl.deleteContractproModel.num");
        }
    }

    private void updateContractproModel(DisContractpro disContractpro) throws ApiException {
        if (null == disContractpro) {
            return;
        }
        int i = 0;
        try {
            i = this.disContractproMapper.updateByPrimaryKey(disContractpro);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractServiceImpl.updateContractproModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisContractServiceImpl.updateContractproModel.num");
        }
    }

    private void updateStateContractproModel(Integer contractproId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == contractproId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractproId", contractproId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disContractproMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractServiceImpl.updateStateContractproModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisContractServiceImpl.updateStateContractproModel.null");
        }
    }

    private void updateStateContractproModelByCode(String tenantCode, String contractproCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)contractproCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractproCode", contractproCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disContractproMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractServiceImpl.updateStateContractproModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisContractServiceImpl.updateStateContractproModelByCode.null");
        }
    }

    private DisContractpro makeContractpro(DisContractproDomain disContractproDomain, DisContractpro disContractpro) {
        if (null == disContractproDomain) {
            return null;
        }
        if (null == disContractpro) {
            disContractpro = new DisContractpro();
        }
        try {
            BeanUtils.copyAllPropertys((Object)disContractpro, (Object)disContractproDomain);
            return disContractpro;
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractServiceImpl.makeContractpro", (Throwable)e);
            return null;
        }
    }

    private DisContractproDomain makeDisContractproDomain(DisContractpro disContractpro) {
        if (null == disContractpro) {
            return null;
        }
        DisContractproDomain disContractproDomain = new DisContractproDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disContractproDomain, (Object)disContractpro);
            return disContractproDomain;
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractServiceImpl.makeDisContractproDomain", (Throwable)e);
            return null;
        }
    }

    private DisContractproReDomain makeDisContractproReDomain(DisContractpro disContractpro) {
        if (null == disContractpro) {
            return null;
        }
        DisContractproReDomain disContractproReDomain = new DisContractproReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disContractproReDomain, (Object)disContractpro);
            return disContractproReDomain;
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractServiceImpl.makeDisContractproReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DisContractpro> queryContractproModelPage(Map<String, Object> parammap) {
        try {
            return this.disContractproMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractServiceImpl.queryContractproModel", (Throwable)e);
            return null;
        }
    }

    private int countContractpro(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.disContractproMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractServiceImpl.countContractpro", (Throwable)e);
        }
        return i;
    }

    private DisContractpro createDisContractpro(DisContractproDomain disContractproDomain) {
        String msg = this.checkContractpro(disContractproDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisContractServiceImpl.saveContractpro.checkContractpro", msg);
        }
        DisContractpro disContractpro = this.makeContractpro(disContractproDomain, null);
        this.setContractproDefault(disContractpro);
        return disContractpro;
    }

    private String checkPackage(DisPackageDomain disPackageDomain) {
        if (null == disPackageDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)disPackageDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setPackageDefault(DisPackage disPackage) {
        if (null == disPackage) {
            return;
        }
        if (null == disPackage.getDataState()) {
            disPackage.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == disPackage.getGmtCreate()) {
            disPackage.setGmtCreate(date);
        }
        disPackage.setGmtModified(date);
        if (StringUtils.isBlank((String)disPackage.getPackageCode())) {
            disPackage.setPackageCode(this.getNo(null, "DisPackage", "disPackage", disPackage.getTenantCode()));
        }
    }

    private int getPackageMaxCode() {
        int code = 0;
        try {
            return this.disPackageMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractServiceImpl.getPackageMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPackageUpdataDefault(DisPackage disPackage) {
        if (null == disPackage) {
            return;
        }
        disPackage.setGmtModified(this.getSysDate());
    }

    private void savePackageModel(DisPackage disPackage) throws ApiException {
        if (null == disPackage) {
            return;
        }
        try {
            this.disPackageMapper.insert(disPackage);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractServiceImpl.savePackageModel.ex", (Throwable)e);
        }
    }

    public void savePackageBatchModel(List<DisPackage> disPackageList) throws ApiException {
        if (null == disPackageList || disPackageList.isEmpty()) {
            return;
        }
        try {
            this.disPackageMapper.insertBatch(disPackageList);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractServiceImpl.savePackageBatchModel.ex", (Throwable)e);
        }
    }

    private DisPackage getPackageModelById(Integer packageId) {
        if (null == packageId) {
            return null;
        }
        try {
            return this.disPackageMapper.selectByPrimaryKey(packageId);
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractServiceImpl.getPackageModelById", (Throwable)e);
            return null;
        }
    }

    private DisPackage getPackageModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.disPackageMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractServiceImpl.getPackageModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delPackageModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.disPackageMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractServiceImpl.delPackageModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisContractServiceImpl.delPackageModelByCode.num");
        }
    }

    private void deletePackageModel(Integer packageId) throws ApiException {
        if (null == packageId) {
            return;
        }
        int i = 0;
        try {
            i = this.disPackageMapper.deleteByPrimaryKey(packageId);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractServiceImpl.deletePackageModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisContractServiceImpl.deletePackageModel.num");
        }
    }

    private void updatePackageModel(DisPackage disPackage) throws ApiException {
        if (null == disPackage) {
            return;
        }
        int i = 0;
        try {
            i = this.disPackageMapper.updateByPrimaryKey(disPackage);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractServiceImpl.updatePackageModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisContractServiceImpl.updatePackageModel.num");
        }
    }

    private void updateStatePackageModel(Integer packageId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == packageId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("packageId", packageId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disPackageMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractServiceImpl.updateStatePackageModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisContractServiceImpl.updateStatePackageModel.null");
        }
    }

    private void updateStatePackageModelByCode(String tenantCode, String packageCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)packageCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("packageCode", packageCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disPackageMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractServiceImpl.updateStatePackageModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisContractServiceImpl.updateStatePackageModelByCode.null");
        }
    }

    private DisPackage makePackage(DisPackageDomain disPackageDomain, DisPackage disPackage) {
        if (null == disPackageDomain) {
            return null;
        }
        if (null == disPackage) {
            disPackage = new DisPackage();
        }
        try {
            BeanUtils.copyAllPropertys((Object)disPackage, (Object)disPackageDomain);
            return disPackage;
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractServiceImpl.makePackage", (Throwable)e);
            return null;
        }
    }

    private DisPackageReDomain makeDisPackageReDomain(DisPackage disPackage) {
        if (null == disPackage) {
            return null;
        }
        DisPackageReDomain disPackageReDomain = new DisPackageReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disPackageReDomain, (Object)disPackage);
            return disPackageReDomain;
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractServiceImpl.makeDisPackageReDomain", (Throwable)e);
            return null;
        }
    }

    private DisPackageDomain makeDisPackageDomain(DisPackage disPackage) {
        if (null == disPackage) {
            return null;
        }
        DisPackageDomain disPackageDomain = new DisPackageDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disPackageDomain, (Object)disPackage);
            return disPackageDomain;
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractServiceImpl.makeDisPackageDomain", (Throwable)e);
            return null;
        }
    }

    private List<DisPackage> queryPackageModelPage(Map<String, Object> parammap) {
        try {
            return this.disPackageMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractServiceImpl.queryPackageModel", (Throwable)e);
            return null;
        }
    }

    private int countPackage(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.disPackageMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractServiceImpl.countPackage", (Throwable)e);
        }
        return i;
    }

    private DisPackage createDisPackage(DisPackageDomain disPackageDomain) {
        String msg = this.checkPackage(disPackageDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisContractServiceImpl.savePackage.checkPackage", msg);
        }
        DisPackage disPackage = this.makePackage(disPackageDomain, null);
        this.setPackageDefault(disPackage);
        return disPackage;
    }

    @Override
    public String saveContract(DisContractDomain disContractDomain) throws ApiException {
        DisContract disContract = this.saveContractRe(disContractDomain);
        return disContract.getContractBillcode();
    }

    private DisContract saveContractRe(DisContractDomain disContractDomain) throws ApiException {
        if (null == disContractDomain || StringUtils.isBlank((String)disContractDomain.getContractNbillcode())) {
            return null;
        }
        DisContract oldDisContract = this.getContractModelByNbCode(this.getQueryMapParam("contractNbillcode,channelCode,tenantCode", new Object[]{disContractDomain.getContractNbillcode(), disContractDomain.getChannelCode(), disContractDomain.getTenantCode()}));
        if (null != oldDisContract) {
            this.updateContractStateByNbCode(disContractDomain.getTenantCode(), disContractDomain.getContractNbillcode(), disContractDomain.getChannelCode(), disContractDomain.getDataState(), null, null);
            oldDisContract.setDataState(disContractDomain.getDataState());
            return oldDisContract;
        }
        DisContract disContract = this.createDisContract(disContractDomain);
        this.saveContractModel(disContract);
        if (ListUtil.isNotEmpty(disContractDomain.getPackageList())) {
            this.savePackageLis(disContractDomain.getPackageList(), disContract);
        }
        this.saveContractpro(disContractDomain.getOcContractproDomainList(), disContract);
        this.saveContractSettl(disContractDomain.getOcContractSettlList(), disContract);
        return disContract;
    }

    private void saveContractSettl(List<DisContractSettlDomain> contractSettlDomainList, DisContract disContract) {
        if (ListUtil.isEmpty(contractSettlDomainList) || null == disContract) {
            return;
        }
        for (DisContractSettlDomain disContractSettlDomain : contractSettlDomainList) {
            try {
                BeanUtils.copyAllPropertys((Object)disContractSettlDomain, (Object)disContract);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.disContractSettlService.saveContractSettl(disContractSettlDomain);
        }
    }

    private void saveContractpro(List<DisContractproDomain> contractproList, DisContract disContract) {
        if (ListUtil.isEmpty(contractproList) || null == disContract) {
            return;
        }
        for (DisContractproDomain disContractproDomain : contractproList) {
            try {
                BeanUtils.copyAllPropertys((Object)disContractproDomain, (Object)disContract);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.saveContractpro(disContractproDomain);
        }
    }

    private void savePackageLis(List<DisPackageDomain> packageList, DisContract disContract) {
        if (ListUtil.isEmpty(packageList) || null == disContract) {
            return;
        }
        for (DisPackageDomain disPackageDomain : packageList) {
            BigDecimal goodsMoney = disPackageDomain.getGoodsMoney();
            BigDecimal goodsPmoney = disPackageDomain.getGoodsPmoney();
            String goodsPmbillno = disPackageDomain.getGoodsPmbillno();
            BigDecimal goodsWeight = disPackageDomain.getGoodsWeight();
            BigDecimal goodsNum = disPackageDomain.getGoodsNum();
            String areaCode = disPackageDomain.getAreaCode();
            String areaName = disPackageDomain.getAreaName();
            String warehouseName = disPackageDomain.getWarehouseName();
            String warehouseCode = disPackageDomain.getWarehouseCode();
            String contractPumode = disPackageDomain.getContractPumode();
            try {
                BeanUtils.copyAllPropertys((Object)disPackageDomain, (Object)disContract);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (StringUtils.isNotBlank((String)contractPumode)) {
                disPackageDomain.setContractPumode(contractPumode);
            }
            disPackageDomain.setGoodsMoney(goodsMoney);
            disPackageDomain.setGoodsPmoney(goodsPmoney);
            disPackageDomain.setGoodsPmbillno(goodsPmbillno);
            disPackageDomain.setGoodsWeight(goodsWeight);
            disPackageDomain.setGoodsNum(goodsNum);
            disPackageDomain.setAreaCode(areaCode);
            disPackageDomain.setAreaName(areaName);
            disPackageDomain.setWarehouseCode(warehouseCode);
            disPackageDomain.setWarehouseName(warehouseName);
            this.savePackage(disPackageDomain);
        }
    }

    @Override
    public List<DisChannelsend> saveContractBatch(List<DisContractDomain> disContractDomainList) throws ApiException {
        if (null == disContractDomainList || disContractDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DisChannelsendDomain> disChannelsendDomainList = new ArrayList<DisChannelsendDomain>();
        for (DisContractDomain disContractDomain : disContractDomainList) {
            if (StringUtils.isBlank((String)disContractDomain.getContractNbillcode()) || StringUtils.isBlank((String)disContractDomain.getChannelCode())) {
                throw new ApiException("dis.DisContractServiceImpl.saveContractBatch.contractNbillcode");
            }
            List<DisContract> oldDisContractList = this.queryContractModelPage(this.getQueryMapParam("contractNbillcode,channelCode,tenantCode", new Object[]{disContractDomain.getContractNbillcode(), disContractDomain.getChannelCode(), disContractDomain.getTenantCode()}));
            if (ListUtil.isNotEmpty(oldDisContractList)) continue;
            DisContract disContract = this.saveContractRe(disContractDomain);
            if (!this.checkSkuCode(disContractDomain)) continue;
            DisChannelsendDomain disChannelsendDomain = new DisChannelsendDomain();
            disChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)disContract));
            disChannelsendDomain.setChannelCode(disContractDomain.getChannelCode());
            disChannelsendDomain.setChannelsendDir("add");
            disChannelsendDomain.setChannelsendType("DisContract");
            disChannelsendDomain.setTenantCode(disContractDomain.getTenantCode());
            disChannelsendDomainList.add(disChannelsendDomain);
        }
        if (ListUtil.isEmpty(disChannelsendDomainList)) {
            return null;
        }
        return this.disChannelsendService.saveChannelsendBatch(disChannelsendDomainList);
    }

    private boolean checkSkuCode(DisContractDomain disContractDomain) {
        if (null == disContractDomain || ListUtil.isEmpty(disContractDomain.getPackageList())) {
            return false;
        }
        for (DisPackageDomain disPackageDomain : disContractDomain.getPackageList()) {
            if (ListUtil.isEmpty(disPackageDomain.getContractGoodsList())) {
                return false;
            }
            for (DisContractGoodsDomain disContractGoodsDomain : disPackageDomain.getContractGoodsList()) {
                if (!StringUtils.isBlank((String)disContractGoodsDomain.getSkuCode())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void updateContractState(Integer contractId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateContractModel(contractId, dataState, oldDataState, map);
    }

    @Override
    public void updateContractStateByCode(String tenantCode, String contractBillcode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateContractModelByCode(tenantCode, contractBillcode, dataState, oldDataState, map);
    }

    @Override
    public void updateContractSendStateByCode(String tenantCode, String contractBillcode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateSendStateContractModelByCode(tenantCode, contractBillcode, dataState, oldDataState, map);
    }

    @Override
    public QueryResult<DisContractReDomain> queryContractReDomainByPage(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            throw new ApiException("dis.DisContractServiceImpl.queryContractByPage.map.null");
        }
        int count = this.countContract(map);
        List<DisContractReDomain> disContractReDomains = this.queryDisContractRedomainByPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(count);
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(disContractReDomains);
        this.queryContractGoodsPage(map);
        return queryResult;
    }

    @Override
    public String foreignQueryContractPageReDomain(Map<String, Object> vop_mapTobean) {
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        Object pageNo = vop_mapTobean.get("pageNo");
        Object pageSize = vop_mapTobean.get("pageSize");
        Object startDate = vop_mapTobean.get("startDate");
        Object endDate = vop_mapTobean.get("endDate");
        if (startDate != null) {
            parameter.put("startDate", startDate);
        }
        if (endDate != null) {
            parameter.put("endDate", endDate);
        }
        if (pageNo == null || pageSize == null) {
            vop_mapTobean.put("msg", "\u5206\u9875\u53c2\u6570\u672a\u586b\u5199");
            return JsonUtil.buildNormalBinder().toJson(vop_mapTobean);
        }
        parameter.put("childFlag", true);
        parameter.put("startRow", (Integer.parseInt(pageNo.toString()) - 1) * Integer.parseInt(pageSize.toString()));
        parameter.put("rows", Integer.parseInt(pageSize.toString()));
        parameter.put("tenantCode", vop_mapTobean.get("tenantCode"));
        return JsonUtil.buildNormalBinder().toJson(this.queryContractReDomainByPage(parameter));
    }

    @Override
    public Map<String, Object> queryDisContractCount(Map<String, Object> map) throws ApiException {
        Map<String, Object> resMap = null;
        try {
            resMap = this.disContractMapper.countData(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisContractServiceImpl.querySgContractCount.ex", (Throwable)e);
        }
        return resMap;
    }

    @Override
    public void loadSendExcOrder() {
        this.loadExcOrder();
    }

    private void loadExcOrder() {
        Integer pn = 0;
        Integer ps = 50;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractSendstate", "0");
        map.put("goodsFlag", true);
        map.put("order", true);
        map.put("orderStr", "GMT_CREATE desc");
        HashMap<String, String> pmap = new HashMap<String, String>();
        ArrayList<DisChannelsendDomain> disChannelsendDomainList = null;
        map.put("rows", ps);
        map.put("startRow", pn);
        QueryResult<DisContractReDomain> disContractReDomainQueryResult = this.queryContractReDomainPage(map);
        List disContractReDomainList = disContractReDomainQueryResult.getList();
        if (ListUtil.isEmpty((Collection)disContractReDomainList)) {
            return;
        }
        long time = 0L;
        for (DisContractReDomain disContractReDomain : disContractReDomainList) {
            List<DisContractGoodsDomain> goodsDomainList;
            time = disContractReDomain.getGmtModified().getTime() - disContractReDomain.getGmtCreate().getTime();
            if (time >= 36000000L || ListUtil.isEmpty(goodsDomainList = disContractReDomain.getGoodsDomainList())) continue;
            for (DisContractGoodsDomain disContractGoodsDomain : goodsDomainList) {
                pmap.put("skuNo", disContractGoodsDomain.getSkuNo());
                pmap.put("memberCode", disContractGoodsDomain.getMemberCode());
                pmap.put("memberCcode", disContractGoodsDomain.getMemberCcode());
                pmap.put("channelCode", disContractReDomain.getChannelCode());
                pmap.put("tenantCode", disContractGoodsDomain.getTenantCode());
                String goodsBeanJson = (String)this.getInternalRouter().inInvoke("rs.resourceGoods.getResourceBySkuNo", pmap);
                GoodsBean goodsBean = (GoodsBean)JsonUtil.buildNormalBinder().getJsonToObject(goodsBeanJson, GoodsBean.class);
                if (null == goodsBean) continue;
                this.updateDisContractGoods(goodsBean, disContractGoodsDomain);
                disChannelsendDomainList = new ArrayList<DisChannelsendDomain>();
                DisChannelsendDomain disChannelsendDomain = new DisChannelsendDomain();
                disChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)disContractReDomain));
                disChannelsendDomain.setChannelCode(disContractReDomain.getChannelCode());
                disChannelsendDomain.setChannelsendDir("add");
                disChannelsendDomain.setChannelsendType("DisContract");
                disChannelsendDomain.setTenantCode(disContractReDomain.getTenantCode());
                disChannelsendDomainList.add(disChannelsendDomain);
                this.getDisChannelsendBaseService().sendChannelsendBatch(disChannelsendDomainList);
            }
        }
    }

    public void updateDisContractGoods(GoodsBean goodsBean, DisContractGoodsDomain disContractGoodsDomain) {
        try {
            String skuEocode = disContractGoodsDomain.getSkuEocode();
            String goodsEocode = disContractGoodsDomain.getGoodsEocode();
            BigDecimal pricesetNprice = disContractGoodsDomain.getPricesetNprice();
            BeanUtils.copyAllPropertys((Object)disContractGoodsDomain, (Object)goodsBean.getRsResourceGoods());
            BeanUtils.copyAllPropertys((Object)disContractGoodsDomain, (Object)goodsBean.getRsSku());
            disContractGoodsDomain.setGoodsNum(disContractGoodsDomain.getGoodsCamount());
            disContractGoodsDomain.setGoodsWeight(disContractGoodsDomain.getGoodsCweight());
            disContractGoodsDomain.setSkuEocode(skuEocode);
            disContractGoodsDomain.setGoodsEocode(goodsEocode);
            disContractGoodsDomain.setPricesetNprice(pricesetNprice);
            disContractGoodsDomain.setGoodsNum(disContractGoodsDomain.getGoodsCamount());
            disContractGoodsDomain.setGoodsWeight(disContractGoodsDomain.getGoodsCweight());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateContractGoods(disContractGoodsDomain);
    }

    public List<DisContractReDomain> queryDisContractRedomainByPage(Map<String, Object> map) {
        ArrayList<DisContractReDomain> contractReDomainList = new ArrayList<DisContractReDomain>();
        List<DisContract> disContractList = this.disContractMapper.query(map);
        if (ListUtil.isEmpty(disContractList)) {
            return null;
        }
        for (DisContract disContract : disContractList) {
            DisContractReDomain disContractReDomain = this.makeDisContractReDomain(disContract);
            disContractReDomain.setOcContractSettlList(this.disContractSettlService.queryContractSettlByOrerCode(disContractReDomain.getTenantCode(), disContractReDomain.getContractBillcode()));
            disContractReDomain.setOcContractproDomainList(this.makeProDomainList(disContractReDomain.getTenantCode(), disContractReDomain.getContractBillcode()));
            disContractReDomain.setPackageList(this.makePackageDomainList(disContractReDomain.getTenantCode(), disContractReDomain.getContractBillcode(), false));
            disContractReDomain.setGoodsDomainList(this.queryContractGoodsDomainList(disContract.getContractBillcode(), disContract.getTenantCode()));
            contractReDomainList.add(disContractReDomain);
        }
        return contractReDomainList;
    }

    private List<DisContractGoodsDomain> queryContractGoodsDomainList(String contractBillcode, String tenantCode) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("contractBillcode", contractBillcode);
        paramMap.put("tenantCode", tenantCode);
        List<DisContractGoods> disContractGoods = this.queryContractGoodsModelPage(paramMap);
        if (ListUtil.isEmpty(disContractGoods)) {
            return null;
        }
        ArrayList<DisContractGoodsDomain> goodsDomainList = new ArrayList<DisContractGoodsDomain>();
        for (DisContractGoods disContractGood : disContractGoods) {
            DisContractGoodsDomain disContractGoodsDomain = this.makeDisContractGoodsDomain(disContractGood);
            goodsDomainList.add(disContractGoodsDomain);
        }
        return goodsDomainList;
    }

    @Override
    public List<DisChannelsend> updateContractStateByNbCode(String tenantCode, String contractNbillcode, String channelCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == dataState || StringUtils.isBlank((String)contractNbillcode) || StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("dis.DisContractServiceImpl.updateContractStateByNbCode.param", (Object)(tenantCode + "=:=" + contractNbillcode + "=:=" + channelCode + "=:=" + dataState + "=:=" + oldDataState + "=:=" + map));
            return null;
        }
        Map querymap = this.getQueryMapParam("tenantCode,contractNbillcode,channelCode", new Object[]{tenantCode, contractNbillcode, channelCode});
        DisContract disContract = this.getContractModelByNbCode(querymap);
        if (null == disContract) {
            this.logger.error("dis.DisContractServiceImpl.updateContractStateByNbCode.disContract", (Object)querymap.toString());
            return null;
        }
        if (null != disContract.getDataState() && dataState.intValue() == disContract.getDataState().intValue()) {
            return null;
        }
        this.updateStateContractModelByNbCode(tenantCode, contractNbillcode, channelCode, dataState, oldDataState, map);
        disContract.setDataState(dataState);
        if (MapUtil.isNotEmpty(map)) {
            disContract.setDataStatestr((String)map.get("dataStatestr"));
        }
        if (!this.checkSkuCode(this.queryContractGoodsModelPage(this.getQueryMapParam("tenantCode,contractBillcode", new Object[]{tenantCode, disContract.getContractBillcode()})))) {
            return null;
        }
        ArrayList<DisChannelsendDomain> disChannelsendDomainList = new ArrayList<DisChannelsendDomain>();
        DisChannelsendDomain disChannelsendDomain = new DisChannelsendDomain();
        disChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)disContract));
        disChannelsendDomain.setChannelCode(disContract.getChannelCode());
        disChannelsendDomain.setChannelsendDir("update");
        disChannelsendDomain.setChannelsendType("DisContract");
        disChannelsendDomain.setTenantCode(disContract.getTenantCode());
        disChannelsendDomainList.add(disChannelsendDomain);
        return this.disChannelsendService.saveChannelsendBatch(disChannelsendDomainList);
    }

    private boolean checkSkuCode(List<DisContractGoods> disContractGoodsList) {
        if (ListUtil.isEmpty(disContractGoodsList)) {
            return false;
        }
        for (DisContractGoods disContractGoods : disContractGoodsList) {
            if (!StringUtils.isBlank((String)disContractGoods.getSkuCode())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void updateContract(DisContractDomain disContractDomain) throws ApiException {
        String msg = this.checkContract(disContractDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisContractServiceImpl.updateContract.checkContract", msg);
        }
        DisContract oldDisContract = this.getContractModelById(disContractDomain.getContractId());
        if (null == oldDisContract) {
            throw new ApiException("dis.DisContractServiceImpl.updateContract.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DisContract disContract = this.makeContract(disContractDomain, oldDisContract);
        this.setContractUpdataDefault(disContract);
        this.updateContractModel(disContract);
    }

    @Override
    public DisContract getContract(Integer contractId) {
        return this.getContractModelById(contractId);
    }

    @Override
    public void deleteContract(Integer contractId) throws ApiException {
        this.deleteContractModel(contractId);
    }

    @Override
    public QueryResult<DisContract> queryContractPage(Map<String, Object> map) {
        List<DisContract> disContractList = this.queryContractModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countContract(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(disContractList);
        return queryResult;
    }

    @Override
    public QueryResult<DisContractReDomain> queryContractReDomainPage(Map<String, Object> map) {
        int count = this.countContract(map);
        List<DisContractReDomain> disContractList = null;
        if (count > 0) {
            disContractList = this.queryContractRedomainlPage(map);
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(count);
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(disContractList);
        return queryResult;
    }

    private List<DisContractReDomain> queryContractRedomainlPage(Map<String, Object> map) {
        ArrayList<DisContractReDomain> disContractReDomainList = new ArrayList<DisContractReDomain>();
        List<DisContract> disContractList = this.queryContractModelPage(map);
        if (ListUtil.isEmpty(disContractList)) {
            return null;
        }
        DisContractReDomain disContractReDomain = null;
        for (DisContract disContract : disContractList) {
            boolean goodsProFlag;
            boolean goodsFlag;
            disContractReDomain = this.makeDisContractReDomain(disContract);
            boolean bl = goodsFlag = null == map.get("goodsFlag") ? false : Boolean.valueOf(map.get("goodsFlag").toString());
            if (goodsFlag) {
                disContractReDomain.setGoodsDomainList(this.queryDisContractGoodsDomainPage(disContract));
            }
            boolean bl2 = goodsProFlag = null == map.get("goodsProFlag") ? false : Boolean.valueOf(map.get("goodsProFlag").toString());
            if (goodsProFlag) {
                disContractReDomain.setOcContractproDomainList(this.queryDisContractProDomain(disContract));
            }
            disContractReDomainList.add(disContractReDomain);
        }
        return disContractReDomainList;
    }

    private List<DisContractproDomain> queryDisContractProDomain(DisContract disContract) {
        List<DisContractpro> disContractproList = this.queryContractproModelPage(this.getQueryParamMap("contractBillcode,tenantCode", new Object[]{disContract.getContractBillcode(), disContract.getTenantCode()}));
        if (ListUtil.isEmpty(disContractproList)) {
            return null;
        }
        ArrayList<DisContractproDomain> disContractproDomainList = new ArrayList<DisContractproDomain>();
        for (DisContractpro disContractpro : disContractproList) {
            DisContractproDomain disContractproDomain = new DisContractproDomain();
            try {
                BeanUtils.copyAllPropertys((Object)disContractproDomain, (Object)disContractpro);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            disContractproDomainList.add(disContractproDomain);
        }
        return disContractproDomainList;
    }

    private List<DisContractGoodsDomain> queryDisContractGoodsDomainPage(DisContract disContract) {
        List<DisContractGoods> disContractGoodsList = this.queryContractGoodsModelPage(this.getQueryParamMap("contractBillcode,tenantCode", new Object[]{disContract.getContractBillcode(), disContract.getTenantCode()}));
        if (ListUtil.isEmpty(disContractGoodsList)) {
            return null;
        }
        ArrayList<DisContractGoodsDomain> disContractGoodsDomainList = new ArrayList<DisContractGoodsDomain>();
        for (DisContractGoods disContractGoods : disContractGoodsList) {
            DisContractGoodsDomain disContractGoodsDomain = new DisContractGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)disContractGoodsDomain, (Object)disContractGoods);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            disContractGoodsDomainList.add(disContractGoodsDomain);
        }
        return disContractGoodsDomainList;
    }

    @Override
    public DisContract getContractByCode(String tenantCode, String contractBillcode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractBillcode", contractBillcode);
        DisContract contractModelByCode = this.getContractModelByCode(map);
        if (null == contractModelByCode) {
            return contractModelByCode;
        }
        contractModelByCode.setPackageList(this.queryPackageModelPage(map));
        contractModelByCode.setGoodsDomainList(this.queryContractGoodsModelPage(map));
        return contractModelByCode;
    }

    @Override
    public void deleteContractByCode(String tenantCode, String contractBillcode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractBillcode", contractBillcode);
        this.delContractModelByCode(map);
    }

    @Override
    public String saveContractGoods(DisContractGoodsDomain disContractGoodsDomain) throws ApiException {
        DisContractGoods disContractGoods = this.createDisContractGoods(disContractGoodsDomain);
        this.saveContractGoodsModel(disContractGoods);
        return disContractGoods.getContractGoodsCode();
    }

    @Override
    public String saveContractGoodsBatch(List<DisContractGoodsDomain> disContractGoodsDomainList) throws ApiException {
        if (null == disContractGoodsDomainList || disContractGoodsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DisContractGoods> disContractGoodsList = new ArrayList<DisContractGoods>();
        String code = "";
        for (DisContractGoodsDomain disContractGoodsDomain : disContractGoodsDomainList) {
            DisContractGoods disContractGoods = this.createDisContractGoods(disContractGoodsDomain);
            code = disContractGoods.getContractGoodsCode();
            disContractGoodsList.add(disContractGoods);
        }
        this.saveContractGoodsBatchModel(disContractGoodsList);
        return code;
    }

    @Override
    public void updateContractGoodsState(Integer contractGoodsId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateContractGoodsModel(contractGoodsId, dataState, oldDataState, map);
    }

    @Override
    public void updateContractGoodsStateByCode(String tenantCode, String contractGoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateContractGoodsModelByCode(tenantCode, contractGoodsCode, dataState, oldDataState, map);
    }

    @Override
    public void updateContractGoods(DisContractGoodsDomain disContractGoodsDomain) throws ApiException {
        String msg = this.checkContractGoods(disContractGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisContractServiceImpl.updateContractGoods.checkContractGoods", msg);
        }
        DisContractGoods oldDisContractGoods = this.getContractGoodsModelById(disContractGoodsDomain.getContractGoodsId());
        if (null == oldDisContractGoods) {
            throw new ApiException("dis.DisContractServiceImpl.updateContractGoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DisContractGoods disContractGoods = this.makeContractGoods(disContractGoodsDomain, oldDisContractGoods);
        this.setContractGoodsUpdataDefault(disContractGoods);
        this.updateContractGoodsModel(disContractGoods);
    }

    @Override
    public DisContractGoods getContractGoods(Integer contractGoodsId) {
        return this.getContractGoodsModelById(contractGoodsId);
    }

    @Override
    public void deleteContractGoods(Integer contractGoodsId) throws ApiException {
        this.deleteContractGoodsModel(contractGoodsId);
    }

    @Override
    public QueryResult<DisContractGoods> queryContractGoodsPage(Map<String, Object> map) {
        List<DisContractGoods> disContractGoodsList = this.queryContractGoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countContractGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(disContractGoodsList);
        return queryResult;
    }

    @Override
    public DisContractGoods getContractGoodsByCode(String tenantCode, String contractGoodsCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractGoodsCode", contractGoodsCode);
        return this.getContractGoodsModelByCode(map);
    }

    @Override
    public void updateRefunFlagByCode(Integer refundFlag, BigDecimal contractGoodsRefnum, String tenantCode, String channelCode, String contractGoodsCode) throws ApiException {
        if (null == refundFlag || null == contractGoodsRefnum || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)contractGoodsCode) || StringUtils.isBlank((String)channelCode)) {
            this.logger.error("dis.DisContractServiceImpl .updateRefunFlagByCode .", (Object)(refundFlag + " =:= " + tenantCode + " =:= " + channelCode + " =:= " + contractGoodsCode + " =:= " + contractGoodsRefnum));
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("refundFlag", refundFlag);
        map.put("contractGoodsRefnum", contractGoodsRefnum);
        map.put("tenantCode", tenantCode);
        map.put("contractGoodsCode", contractGoodsCode);
        map.put("channelCode", channelCode);
        this.updateRefunFlagByCodeModel(map);
    }

    @Override
    public void deleteContractGoodsByCode(String tenantCode, String contractGoodsCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractGoodsCode", contractGoodsCode);
        this.delContractGoodsModelByCode(map);
    }

    @Override
    public String saveContractpro(DisContractproDomain disContractproDomain) throws ApiException {
        DisContractpro disContractpro = this.createDisContractpro(disContractproDomain);
        this.saveContractproModel(disContractpro);
        return disContractpro.getContractproBillcode();
    }

    @Override
    public String saveContractproBatch(List<DisContractproDomain> disContractproDomainList) throws ApiException {
        if (null == disContractproDomainList || disContractproDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DisContractpro> disContractproList = new ArrayList<DisContractpro>();
        String code = "";
        for (DisContractproDomain disContractproDomain : disContractproDomainList) {
            DisContractpro disContractpro = this.createDisContractpro(disContractproDomain);
            code = disContractpro.getContractproBillcode();
            disContractproList.add(disContractpro);
        }
        this.saveContractproBatchModel(disContractproList);
        return code;
    }

    @Override
    public void updateContractproState(Integer contractproId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateContractproModel(contractproId, dataState, oldDataState, map);
    }

    @Override
    public void updateContractproStateByCode(String tenantCode, String contractproCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateContractproModelByCode(tenantCode, contractproCode, dataState, oldDataState, map);
    }

    @Override
    public void updateContractpro(DisContractproDomain disContractproDomain) throws ApiException {
        String msg = this.checkContractpro(disContractproDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisContractServiceImpl.updateContractpro.checkContractpro", msg);
        }
        DisContractpro oldDisContractpro = this.getContractproModelById(disContractproDomain.getContractproId());
        if (null == oldDisContractpro) {
            throw new ApiException("dis.DisContractServiceImpl.updateContractpro.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DisContractpro disContractpro = this.makeContractpro(disContractproDomain, oldDisContractpro);
        this.setContractproUpdataDefault(disContractpro);
        this.updateContractproModel(disContractpro);
    }

    @Override
    public DisContractpro getContractpro(Integer contractproId) {
        return this.getContractproModelById(contractproId);
    }

    @Override
    public void deleteContractpro(Integer contractproId) throws ApiException {
        this.deleteContractproModel(contractproId);
    }

    @Override
    public QueryResult<DisContractpro> queryContractproPage(Map<String, Object> map) {
        List<DisContractpro> disContractproList = this.queryContractproModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countContractpro(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(disContractproList);
        return queryResult;
    }

    @Override
    public DisContractpro getContractproByCode(String tenantCode, String contractproCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractproCode", contractproCode);
        return this.getContractproModelByCode(map);
    }

    @Override
    public void deleteContractproByCode(String tenantCode, String contractproCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractproCode", contractproCode);
        this.delContractproModelByCode(map);
    }

    @Override
    public String savePackage(DisPackageDomain disPackageDomain) throws ApiException {
        DisPackage disPackage = this.createDisPackage(disPackageDomain);
        this.savePackageModel(disPackage);
        this.saveGoodsList(disPackageDomain.getContractGoodsList(), disPackage);
        return disPackage.getPackageCode();
    }

    private void saveGoodsList(List<DisContractGoodsDomain> contractGoodsList, DisPackage disPackage) {
        if (ListUtil.isEmpty(contractGoodsList) || null == disPackage) {
            return;
        }
        for (DisContractGoodsDomain disContractGoodsDomain : contractGoodsList) {
            disContractGoodsDomain.setPackageCode(disPackage.getPackageCode());
            disContractGoodsDomain.setContractBillcode(disPackage.getContractBillcode());
            disContractGoodsDomain.setTenantCode(disPackage.getTenantCode());
            disContractGoodsDomain.setMemberBcode(disPackage.getMemberBcode());
            disContractGoodsDomain.setMemberBname(disPackage.getMemberBname());
            if (null != disPackage) {
                if (StringUtils.isBlank((String)disContractGoodsDomain.getMemberCcode()) && StringUtils.isNotBlank((String)disPackage.getMemberCcode())) {
                    disContractGoodsDomain.setMemberCcode(disPackage.getMemberCcode());
                    disContractGoodsDomain.setMemberCname(disPackage.getMemberCname());
                }
                disContractGoodsDomain.setMemberCode(disPackage.getMemberCode());
                disContractGoodsDomain.setMemberName(disPackage.getMemberName());
            }
            this.saveContractGoods(disContractGoodsDomain);
        }
    }

    @Override
    public String savePackageBatch(List<DisPackageDomain> disPackageDomainList) throws ApiException {
        if (null == disPackageDomainList || disPackageDomainList.isEmpty()) {
            return null;
        }
        String code = "";
        for (DisPackageDomain disPackageDomain : disPackageDomainList) {
            this.savePackage(disPackageDomain);
        }
        return code;
    }

    @Override
    public void updatePackageState(Integer packageId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStatePackageModel(packageId, dataState, oldDataState, map);
    }

    @Override
    public void updatePackageStateByCode(String tenantCode, String packageCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStatePackageModelByCode(tenantCode, packageCode, dataState, oldDataState, map);
    }

    @Override
    public void updatePackage(DisPackageDomain disPackageDomain) throws ApiException {
        String msg = this.checkPackage(disPackageDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisContractServiceImpl.updatePackage.checkPackage", msg);
        }
        DisPackage oldDisPackage = this.getPackageModelById(disPackageDomain.getPackageId());
        if (null == oldDisPackage) {
            throw new ApiException("dis.DisContractServiceImpl.updatePackage.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DisPackage disPackage = this.makePackage(disPackageDomain, oldDisPackage);
        this.setPackageUpdataDefault(disPackage);
        this.updatePackageModel(disPackage);
    }

    @Override
    public DisPackage getPackage(Integer packageId) {
        return this.getPackageModelById(packageId);
    }

    @Override
    public void deletePackage(Integer packageId) throws ApiException {
        this.deletePackageModel(packageId);
    }

    @Override
    public QueryResult<DisPackage> queryPackagePage(Map<String, Object> map) {
        List<DisPackage> disPackageList = this.queryPackageModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPackage(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(disPackageList);
        return queryResult;
    }

    @Override
    public DisPackage getPackageByCode(String tenantCode, String packageCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("packageCode", packageCode);
        return this.getPackageModelByCode(map);
    }

    @Override
    public void deletePackageByCode(String tenantCode, String packageCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("packageCode", packageCode);
        this.delPackageModelByCode(map);
    }

    @Override
    public DisContractReDomain getContractDomainByCode(String tenantCode, String contractBillcode) throws ApiException {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        DisContract disContract = this.getContractByCode(tenantCode, contractBillcode);
        if (null == disContract) {
            return null;
        }
        DisContractReDomain disContractDomain = this.makeDisContractReDomain(disContract);
        if (null == disContractDomain) {
            return null;
        }
        disContractDomain.setOcContractSettlList(this.disContractSettlService.queryContractSettlByOrerCode(tenantCode, contractBillcode));
        disContractDomain.setOcContractproDomainList(this.makeProDomainList(tenantCode, contractBillcode));
        disContractDomain.setPackageList(this.makePackageDomainList(tenantCode, contractBillcode, true));
        if (ListUtil.isEmpty(disContractDomain.getPackageList())) {
            return null;
        }
        return disContractDomain;
    }

    private List<DisPackageDomain> makePackageDomainList(String tenantCode, String contractBillcode, boolean sku) {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        List<DisPackage> disPackageList = this.queryPackageModelPage(this.getQueryMapParam("contractBillcode,tenantCode", new Object[]{contractBillcode, tenantCode}));
        if (ListUtil.isEmpty(disPackageList)) {
            return null;
        }
        ArrayList<DisPackageDomain> disPackageDomainList = new ArrayList<DisPackageDomain>();
        for (DisPackage disPackage : disPackageList) {
            DisPackageDomain disPackageDomain = this.makeDisPackageDomain(disPackage);
            List<DisContractGoodsDomain> goodsList = this.makeGoodsDomainList(tenantCode, disPackageDomain.getPackageCode(), sku);
            if (ListUtil.isEmpty(goodsList)) {
                return null;
            }
            disPackageDomain.setContractGoodsList(goodsList);
            disPackageDomainList.add(disPackageDomain);
        }
        return disPackageDomainList;
    }

    private List<DisContractGoodsDomain> makeGoodsDomainList(String tenantCode, String packageCode, boolean sku) {
        if (StringUtils.isBlank((String)packageCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        List<DisContractGoods> proList = this.queryContractGoodsModelPage(this.getQueryMapParam("packageCode,tenantCode", new Object[]{packageCode, tenantCode}));
        if (ListUtil.isEmpty(proList)) {
            return null;
        }
        ArrayList<DisContractGoodsDomain> disContractGoodsDomainList = new ArrayList<DisContractGoodsDomain>();
        for (DisContractGoods disContractGoods : proList) {
            DisContractGoodsDomain disContractGoodsDomain = this.makeDisContractGoodsDomain(disContractGoods);
            if (sku) {
                String channelCode = disContractGoods.getChannelCode();
                if (StringUtils.isBlank((String)channelCode)) {
                    return null;
                }
                String json = DisUtil.getMap((String)"DisChannel-channelCode", (String)(channelCode + "-" + disContractGoods.getTenantCode()));
                if (StringUtils.isBlank((String)json)) {
                    return null;
                }
                DisChannel disChannel = (DisChannel)JsonUtil.buildNormalBinder().getJsonToObject(json, DisChannel.class);
                if (null == disChannel) {
                    return null;
                }
                this.buildGoods(disContractGoodsDomain, disChannel);
            }
            disContractGoodsDomainList.add(disContractGoodsDomain);
        }
        return disContractGoodsDomainList;
    }

    private void buildGoods(DisContractGoodsDomain disContractGoodsDomain, DisChannel disChannel) {
        if (null == disContractGoodsDomain || null == disChannel) {
            return;
        }
        if ("2".equals(disContractGoodsDomain.getContractGoodsGtype()) && StringUtils.isBlank((String)disContractGoodsDomain.getSkuCode())) {
            return;
        }
        if (StringUtils.isBlank((String)disContractGoodsDomain.getMemberCode()) || StringUtils.isBlank((String)disContractGoodsDomain.getMemberCcode()) || StringUtils.isBlank((String)disContractGoodsDomain.getSkuNo()) || StringUtils.isBlank((String)disContractGoodsDomain.getTenantCode()) || StringUtils.isBlank((String)disContractGoodsDomain.getChannelCode())) {
            return;
        }
        String apiCode = "rs.resourceGoods.getResourceBySkuNo";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("tenantCode", disContractGoodsDomain.getTenantCode());
        map.put("skuNo", disContractGoodsDomain.getSkuNo());
        map.put("channelCode", disChannel.getChannelCode());
        map.put("memberCode", disContractGoodsDomain.getMemberCode());
        map.put("memberCcode", disContractGoodsDomain.getMemberCcode());
        GoodsBean rsGoodsBean = (GoodsBean)this.getForObject(apiCode, GoodsBean.class, map);
        String goodsShowName = disContractGoodsDomain.getGoodsName();
        if (null == rsGoodsBean) {
            this.createGoods(disContractGoodsDomain, goodsShowName);
        }
        try {
            String skuEocode = disContractGoodsDomain.getSkuEocode();
            String goodsEocode = disContractGoodsDomain.getGoodsEocode();
            BigDecimal pricesetNprice = disContractGoodsDomain.getPricesetNprice();
            BeanUtils.copyAllPropertys((Object)disContractGoodsDomain, (Object)rsGoodsBean.getRsResourceGoods());
            BeanUtils.copyAllPropertys((Object)disContractGoodsDomain, (Object)rsGoodsBean.getRsSku());
            disContractGoodsDomain.setGoodsNum(disContractGoodsDomain.getGoodsCamount());
            disContractGoodsDomain.setGoodsWeight(disContractGoodsDomain.getGoodsCweight());
            disContractGoodsDomain.setSkuEocode(skuEocode);
            disContractGoodsDomain.setGoodsShowname(goodsShowName);
            disContractGoodsDomain.setGoodsEocode(goodsEocode);
            disContractGoodsDomain.setPricesetNprice(pricesetNprice);
            disContractGoodsDomain.setGoodsNum(disContractGoodsDomain.getGoodsCamount());
            disContractGoodsDomain.setGoodsWeight(disContractGoodsDomain.getGoodsCweight());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void createGoods(DisContractGoodsDomain disContractGoodsDomain, String goodsShowName) {
        String goodsCode = disContractGoodsDomain.getSkuNo();
        if (StringUtils.isBlank((String)goodsCode) && StringUtils.isBlank((String)(goodsCode = disContractGoodsDomain.getSkuEocode()))) {
            return;
        }
        HashMap<String, String> saveMap = new HashMap<String, String>();
        HashMap<String, Object> saveMapStr = new HashMap<String, Object>();
        saveMapStr.put("dataOpbillstate", 2);
        saveMapStr.put("goodsCode", goodsCode);
        saveMapStr.put("goodsName", goodsShowName);
        saveMapStr.put("tenantCode", disContractGoodsDomain.getTenantCode());
        saveMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(saveMapStr));
        String result = "";
        try {
            result = (String)this.getInternalRouter().inInvoke("fuji.infGoods.saveExcelGoods", saveMap);
            if (StringUtils.isBlank((String)result)) {
                this.logger.error("dis.DisContractServiceImpl.buildGoods.saveExcelGoods===", (Object)result);
                return;
            }
        }
        catch (Exception e) {
            this.logger.error("dis.DisContractServiceImpl.buildGoods.saveExcelGoods.e", (Throwable)e);
            return;
        }
        Map jsonResult = (Map)JsonUtil.buildNonEmptyBinder().getJsonToMap(result, String.class, Object.class);
        if (!"success".equals(String.valueOf(jsonResult.get("result")))) {
            String msg = String.valueOf(jsonResult.get("msg"));
            this.logger.error("dis.DisContractServiceImpl.buildGoods.saveExcelGoods.error.msg", (Object)msg);
            return;
        }
    }

    private List<DisContractproDomain> makeProDomainList(String tenantCode, String contractBillcode) {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        List<DisContractpro> proList = this.queryContractproModelPage(this.getQueryMapParam("contractBillcode,tenantCode", new Object[]{contractBillcode, tenantCode}));
        if (ListUtil.isEmpty(proList)) {
            return null;
        }
        ArrayList<DisContractproDomain> ocContractproDomainList = new ArrayList<DisContractproDomain>();
        for (DisContractpro disContractpro : proList) {
            ocContractproDomainList.add(this.makeDisContractproDomain(disContractpro));
        }
        return ocContractproDomainList;
    }

    @Override
    public DisContract getContractByNbCode(String tenantCode, String contractNbillcode, String channelCode) throws ApiException {
        return this.getContractModelByNbCode(this.getQueryMapParam("tenantCode,contractNbillcode,channelCode", new Object[]{tenantCode, contractNbillcode, channelCode}));
    }
}

