/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.distribution.service.impl;

import com.yqbsoft.laser.service.distribution.dao.DisDeliverMapper;
import com.yqbsoft.laser.service.distribution.domain.DisDeliverDomain;
import com.yqbsoft.laser.service.distribution.domain.DisDeliverReDomain;
import com.yqbsoft.laser.service.distribution.model.DisDeliver;
import com.yqbsoft.laser.service.distribution.service.DisDeliverService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DisDeliverServiceImpl
extends BaseServiceImpl
implements DisDeliverService {
    private static final String SYS_CODE = "dis.DisDeliverServiceImpl";
    private DisDeliverMapper disDeliverMapper;

    public void setDisDeliverMapper(DisDeliverMapper disDeliverMapper) {
        this.disDeliverMapper = disDeliverMapper;
    }

    private Date getSysDate() {
        try {
            return this.disDeliverMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("dis.DisDeliverServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkDeliver(DisDeliverDomain disDeliverDomain) {
        if (null == disDeliverDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)disDeliverDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDeliverDefault(DisDeliver disDeliver) {
        if (null == disDeliver) {
            return;
        }
        if (null == disDeliver.getDataState()) {
            disDeliver.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == disDeliver.getGmtCreate()) {
            disDeliver.setGmtCreate(date);
        }
        disDeliver.setGmtModified(date);
        if (StringUtils.isBlank((String)disDeliver.getDeliverCode())) {
            disDeliver.setDeliverCode(this.getNo(null, "DisDeliver", "disDeliver", disDeliver.getTenantCode()));
        }
    }

    private int getDeliverMaxCode() {
        int code = 0;
        try {
            return this.disDeliverMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("dis.DisDeliverServiceImpl.getDeliverMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setDeliverUpdataDefault(DisDeliver disDeliver) {
        if (null == disDeliver) {
            return;
        }
        disDeliver.setGmtModified(this.getSysDate());
    }

    private void saveDeliverModel(DisDeliver disDeliver) throws ApiException {
        if (null == disDeliver) {
            return;
        }
        try {
            this.disDeliverMapper.insert(disDeliver);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDeliverServiceImpl.saveDeliverModel.ex", (Throwable)e);
        }
    }

    private void saveDeliverBatchModel(List<DisDeliver> disDeliverList) throws ApiException {
        if (null == disDeliverList || disDeliverList.isEmpty()) {
            return;
        }
        try {
            this.disDeliverMapper.insertBatch(disDeliverList);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDeliverServiceImpl.saveDeliverBatchModel.ex", (Throwable)e);
        }
    }

    private DisDeliver getDeliverModelById(Integer deliverId) {
        if (null == deliverId) {
            return null;
        }
        try {
            return this.disDeliverMapper.selectByPrimaryKey(deliverId);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDeliverServiceImpl.getDeliverModelById", (Throwable)e);
            return null;
        }
    }

    private DisDeliver getDeliverModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.disDeliverMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDeliverServiceImpl.getDeliverModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delDeliverModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.disDeliverMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDeliverServiceImpl.delDeliverModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDeliverServiceImpl.delDeliverModelByCode.num");
        }
    }

    private void deleteDeliverModel(Integer deliverId) throws ApiException {
        if (null == deliverId) {
            return;
        }
        int i = 0;
        try {
            i = this.disDeliverMapper.deleteByPrimaryKey(deliverId);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDeliverServiceImpl.deleteDeliverModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDeliverServiceImpl.deleteDeliverModel.num");
        }
    }

    private void updateDeliverModel(DisDeliver disDeliver) throws ApiException {
        if (null == disDeliver) {
            return;
        }
        int i = 0;
        try {
            i = this.disDeliverMapper.updateByPrimaryKey(disDeliver);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDeliverServiceImpl.updateDeliverModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("dis.DisDeliverServiceImpl.updateDeliverModel.num");
        }
    }

    private void updateStateDeliverModel(Integer deliverId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == deliverId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("deliverId", deliverId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disDeliverMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDeliverServiceImpl.updateStateDeliverModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisDeliverServiceImpl.updateStateDeliverModel.null");
        }
    }

    private void updateStateDeliverModelByCode(String tenantCode, String deliverCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)deliverCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("deliverCode", deliverCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.disDeliverMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("dis.DisDeliverServiceImpl.updateStateDeliverModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("dis.DisDeliverServiceImpl.updateStateDeliverModelByCode.null");
        }
    }

    private DisDeliver makeDeliver(DisDeliverDomain disDeliverDomain, DisDeliver disDeliver) {
        if (null == disDeliverDomain) {
            return null;
        }
        if (null == disDeliver) {
            disDeliver = new DisDeliver();
        }
        try {
            BeanUtils.copyAllPropertys((Object)disDeliver, (Object)disDeliverDomain);
            return disDeliver;
        }
        catch (Exception e) {
            this.logger.error("dis.DisDeliverServiceImpl.makeDeliver", (Throwable)e);
            return null;
        }
    }

    private DisDeliverReDomain makeDisDeliverReDomain(DisDeliver disDeliver) {
        if (null == disDeliver) {
            return null;
        }
        DisDeliverReDomain disDeliverReDomain = new DisDeliverReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disDeliverReDomain, (Object)disDeliver);
            return disDeliverReDomain;
        }
        catch (Exception e) {
            this.logger.error("dis.DisDeliverServiceImpl.makeDisDeliverReDomain", (Throwable)e);
            return null;
        }
    }

    private List<DisDeliver> queryDeliverModelPage(Map<String, Object> parammap) {
        try {
            return this.disDeliverMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDeliverServiceImpl.queryDeliverModel", (Throwable)e);
            return null;
        }
    }

    private int countDeliver(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.disDeliverMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("dis.DisDeliverServiceImpl.countDeliver", (Throwable)e);
        }
        return i;
    }

    private DisDeliver createDisDeliver(DisDeliverDomain disDeliverDomain) {
        String msg = this.checkDeliver(disDeliverDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDeliverServiceImpl.saveDeliver.checkDeliver", msg);
        }
        DisDeliver disDeliver = this.makeDeliver(disDeliverDomain, null);
        this.setDeliverDefault(disDeliver);
        return disDeliver;
    }

    @Override
    public String saveDeliver(DisDeliverDomain disDeliverDomain) throws ApiException {
        DisDeliver disDeliver = this.createDisDeliver(disDeliverDomain);
        this.saveDeliverModel(disDeliver);
        return disDeliver.getDeliverCode();
    }

    @Override
    public String saveDeliverBatch(List<DisDeliverDomain> disDeliverDomainList) throws ApiException {
        if (null == disDeliverDomainList || disDeliverDomainList.isEmpty()) {
            return null;
        }
        ArrayList<DisDeliver> disDeliverList = new ArrayList<DisDeliver>();
        String code = "";
        for (DisDeliverDomain disDeliverDomain : disDeliverDomainList) {
            DisDeliver disDeliver = this.createDisDeliver(disDeliverDomain);
            code = disDeliver.getDeliverCode();
            disDeliverList.add(disDeliver);
        }
        this.saveDeliverBatchModel(disDeliverList);
        return code;
    }

    @Override
    public void updateDeliverState(Integer deliverId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateDeliverModel(deliverId, dataState, oldDataState, map);
    }

    @Override
    public void updateDeliverStateByCode(String tenantCode, String deliverCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateDeliverModelByCode(tenantCode, deliverCode, dataState, oldDataState, map);
    }

    @Override
    public void updateDeliver(DisDeliverDomain disDeliverDomain) throws ApiException {
        String msg = this.checkDeliver(disDeliverDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("dis.DisDeliverServiceImpl.updateDeliver.checkDeliver", msg);
        }
        DisDeliver oldDisDeliver = this.getDeliverModelById(disDeliverDomain.getDeliverId());
        if (null == oldDisDeliver) {
            throw new ApiException("dis.DisDeliverServiceImpl.updateDeliver.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        DisDeliver disDeliver = this.makeDeliver(disDeliverDomain, oldDisDeliver);
        this.setDeliverUpdataDefault(disDeliver);
        this.updateDeliverModel(disDeliver);
    }

    @Override
    public DisDeliver getDeliver(Integer deliverId) {
        return this.getDeliverModelById(deliverId);
    }

    @Override
    public void deleteDeliver(Integer deliverId) throws ApiException {
        this.deleteDeliverModel(deliverId);
    }

    @Override
    public QueryResult<DisDeliver> queryDeliverPage(Map<String, Object> map) {
        List<DisDeliver> disDeliverList = this.queryDeliverModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDeliver(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(disDeliverList);
        return queryResult;
    }

    @Override
    public DisDeliver getDeliverByCode(String tenantCode, String deliverCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("deliverCode", deliverCode);
        return this.getDeliverModelByCode(map);
    }

    @Override
    public void deleteDeliverByCode(String tenantCode, String deliverCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("deliverCode", deliverCode);
        this.delDeliverModelByCode(map);
    }
}

