/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.eq.service.impl;

import com.yqbsoft.laser.service.eq.dao.EqAuctionMapper;
import com.yqbsoft.laser.service.eq.domain.EqAuctionDomain;
import com.yqbsoft.laser.service.eq.domain.EqAuctionEnrollReDomain;
import com.yqbsoft.laser.service.eq.domain.EqAuctionFileDomain;
import com.yqbsoft.laser.service.eq.domain.EqAuctionGinfoDomain;
import com.yqbsoft.laser.service.eq.domain.EqAuctionGoodsDomain;
import com.yqbsoft.laser.service.eq.domain.EqAuctionReDomain;
import com.yqbsoft.laser.service.eq.model.EqAuction;
import com.yqbsoft.laser.service.eq.model.EqAuctionEnroll;
import com.yqbsoft.laser.service.eq.model.EqAuctionGinfo;
import com.yqbsoft.laser.service.eq.model.EqAuctionGoods;
import com.yqbsoft.laser.service.eq.service.EqAuctionEnrollService;
import com.yqbsoft.laser.service.eq.service.EqAuctionFileService;
import com.yqbsoft.laser.service.eq.service.EqAuctionGinfoService;
import com.yqbsoft.laser.service.eq.service.EqAuctionGoodsService;
import com.yqbsoft.laser.service.eq.service.EqAuctionService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EqAuctionServiceImpl
extends BaseServiceImpl
implements EqAuctionService {
    private static final String SYS_CODE = "eq.EqAuctionServiceImpl";
    private EqAuctionFileService eqAuctionFileService;
    private EqAuctionEnrollService eqAuctionEnrollService;
    private EqAuctionGinfoService eqAuctionGinfoService;
    private EqAuctionGoodsService eqAuctionGoodsService;
    private EqAuctionMapper eqAuctionMapper;

    public void setEqAuctionFileService(EqAuctionFileService eqAuctionFileService) {
        this.eqAuctionFileService = eqAuctionFileService;
    }

    public void setEqAuctionEnrollService(EqAuctionEnrollService eqAuctionEnrollService) {
        this.eqAuctionEnrollService = eqAuctionEnrollService;
    }

    public void setEqAuctionGoodsService(EqAuctionGoodsService eqAuctionGoodsService) {
        this.eqAuctionGoodsService = eqAuctionGoodsService;
    }

    public void setEqAuctionGinfoService(EqAuctionGinfoService eqAuctionGinfoService) {
        this.eqAuctionGinfoService = eqAuctionGinfoService;
    }

    public void setEqAuctionMapper(EqAuctionMapper eqAuctionMapper) {
        this.eqAuctionMapper = eqAuctionMapper;
    }

    private Date getSysDate() {
        try {
            return this.eqAuctionMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("eq.EqAuctionServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkAuction(EqAuctionDomain eqAuctionDomain) {
        if (null == eqAuctionDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)eqAuctionDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setAuctionDefault(EqAuction eqAuction) {
        if (null == eqAuction) {
            return;
        }
        if (null == eqAuction.getDataState()) {
            eqAuction.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == eqAuction.getGmtCreate()) {
            eqAuction.setGmtCreate(date);
        }
        eqAuction.setGmtModified(date);
        if (StringUtils.isBlank((String)eqAuction.getAuctionCode())) {
            eqAuction.setAuctionCode(this.getNo(null, "EqAuction", "eqAuction", eqAuction.getTenantCode()));
        }
    }

    private int getAuctionMaxCode() {
        int code = 0;
        try {
            return this.eqAuctionMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("eq.EqAuctionServiceImpl.getAuctionMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setAuctionUpdataDefault(EqAuction eqAuction) {
        if (null == eqAuction) {
            return;
        }
        eqAuction.setGmtModified(this.getSysDate());
    }

    private void saveAuctionModel(EqAuction eqAuction) throws ApiException {
        if (null == eqAuction) {
            return;
        }
        try {
            this.eqAuctionMapper.insert(eqAuction);
        }
        catch (Exception e) {
            throw new ApiException("eq.EqAuctionServiceImpl.saveAuctionModel.ex", (Throwable)e);
        }
    }

    private void saveAuctionBatchModel(List<EqAuction> eqAuctionList) throws ApiException {
        if (null == eqAuctionList || eqAuctionList.isEmpty()) {
            return;
        }
        try {
            this.eqAuctionMapper.insertBatch(eqAuctionList);
        }
        catch (Exception e) {
            throw new ApiException("eq.EqAuctionServiceImpl.saveAuctionBatchModel.ex", (Throwable)e);
        }
    }

    private EqAuction getAuctionModelById(Integer auctionId) {
        if (null == auctionId) {
            return null;
        }
        try {
            return this.eqAuctionMapper.selectByPrimaryKey(auctionId);
        }
        catch (Exception e) {
            this.logger.error("eq.EqAuctionServiceImpl.getAuctionModelById", (Throwable)e);
            return null;
        }
    }

    private EqAuction getAuctionModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.eqAuctionMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("eq.EqAuctionServiceImpl.getAuctionModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delAuctionModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.eqAuctionMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("eq.EqAuctionServiceImpl.delAuctionModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("eq.EqAuctionServiceImpl.delAuctionModelByCode.num");
        }
    }

    private void deleteAuctionModel(Integer auctionId) throws ApiException {
        if (null == auctionId) {
            return;
        }
        int i = 0;
        try {
            i = this.eqAuctionMapper.deleteByPrimaryKey(auctionId);
        }
        catch (Exception e) {
            throw new ApiException("eq.EqAuctionServiceImpl.deleteAuctionModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("eq.EqAuctionServiceImpl.deleteAuctionModel.num");
        }
    }

    private void updateAuctionModel(EqAuction eqAuction) throws ApiException {
        if (null == eqAuction) {
            return;
        }
        int i = 0;
        try {
            i = this.eqAuctionMapper.updateByPrimaryKey(eqAuction);
        }
        catch (Exception e) {
            throw new ApiException("eq.EqAuctionServiceImpl.updateAuctionModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("eq.EqAuctionServiceImpl.updateAuctionModel.num");
        }
    }

    private void updateStateAuctionModel(Integer auctionId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == auctionId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("auctionId", auctionId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.eqAuctionMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("eq.EqAuctionServiceImpl.updateStateAuctionModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("eq.EqAuctionServiceImpl.updateStateAuctionModel.null");
        }
    }

    private void updateDataOpbillstateAuctionModel(Integer auctionId, Integer dataOpbillstate, Integer oldDataOpbillstate, Map<String, Object> expmap) throws ApiException {
        if (null == auctionId || null == dataOpbillstate) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("auctionId", auctionId);
        map.put("dataOpbillstate", dataOpbillstate);
        map.put("oldDataOpbillstate", oldDataOpbillstate);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.eqAuctionMapper.updateDataOpbillstateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("eq.EqAuctionServiceImpl.updateDataOpbillstateAuctionModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("eq.EqAuctionServiceImpl.updateDataOpbillstateAuctionModel.null");
        }
    }

    private void updateStateAuctionModelByCode(String tenantCode, String auctionCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)auctionCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("auctionCode", auctionCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.eqAuctionMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("eq.EqAuctionServiceImpl.updateStateAuctionModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("eq.EqAuctionServiceImpl.updateStateAuctionModelByCode.null");
        }
    }

    private EqAuction makeAuction(EqAuctionDomain eqAuctionDomain, EqAuction eqAuction) {
        if (null == eqAuctionDomain) {
            return null;
        }
        if (null == eqAuction) {
            eqAuction = new EqAuction();
        }
        try {
            BeanUtils.copyAllPropertys((Object)eqAuction, (Object)eqAuctionDomain);
            return eqAuction;
        }
        catch (Exception e) {
            this.logger.error("eq.EqAuctionServiceImpl.makeAuction", (Throwable)e);
            return null;
        }
    }

    private EqAuctionReDomain makeEqAuctionReDomain(EqAuction eqAuction) {
        if (null == eqAuction) {
            return null;
        }
        EqAuctionReDomain eqAuctionReDomain = new EqAuctionReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)eqAuctionReDomain, (Object)eqAuction);
            return eqAuctionReDomain;
        }
        catch (Exception e) {
            this.logger.error("eq.EqAuctionServiceImpl.makeEqAuctionReDomain", (Throwable)e);
            return null;
        }
    }

    private List<EqAuction> queryAuctionModelPage(Map<String, Object> parammap) {
        try {
            return this.eqAuctionMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("eq.EqAuctionServiceImpl.queryAuctionModel", (Throwable)e);
            return null;
        }
    }

    private int countAuction(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.eqAuctionMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("eq.EqAuctionServiceImpl.countAuction", (Throwable)e);
        }
        return i;
    }

    private EqAuction createEqAuction(EqAuctionDomain eqAuctionDomain) {
        String msg = this.checkAuction(eqAuctionDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("eq.EqAuctionServiceImpl.saveAuction.checkAuction", msg);
        }
        EqAuction eqAuction = this.makeAuction(eqAuctionDomain, null);
        this.setAuctionDefault(eqAuction);
        return eqAuction;
    }

    @Override
    public String saveAuction(EqAuctionReDomain eqAuctionReDomain) throws ApiException {
        int i;
        this.logger.error(".----saveAuction\u5f00\u59cb-----", (Object)JsonUtil.buildNonDefaultBinder().toJson((Object)eqAuctionReDomain));
        EqAuction eqAuction = this.createEqAuction(eqAuctionReDomain);
        this.saveAuctionModel(eqAuction);
        this.logger.error(".----saveAuctionModel-----", (Object)"saveAuctionModel---------");
        if (ListUtil.isNotEmpty(eqAuctionReDomain.getEqAuctionFileDomainList())) {
            List<EqAuctionFileDomain> fileList = eqAuctionReDomain.getEqAuctionFileDomainList();
            for (i = 0; i < fileList.size(); ++i) {
                fileList.get(i).setTenantCode(eqAuction.getTenantCode());
                fileList.get(i).setAuctionCode(eqAuction.getAuctionCode());
                fileList.get(i).setAuctionName(eqAuction.getAuctionName());
                fileList.get(i).setMemberCode(eqAuction.getMemberCode());
                fileList.get(i).setMemberName(eqAuction.getMemberName());
            }
            if (ListUtil.isNotEmpty(fileList)) {
                this.eqAuctionFileService.saveAuctionFileBatch(fileList);
            }
        }
        this.logger.error(".----saveAuctionFileBatch-----", (Object)"saveAuctionFileBatch---------");
        if (ListUtil.isNotEmpty(eqAuctionReDomain.getEqAuctionEnrollReDomainList())) {
            List<EqAuctionEnrollReDomain> enrollList = eqAuctionReDomain.getEqAuctionEnrollReDomainList();
            for (i = 0; i < enrollList.size(); ++i) {
                enrollList.get(i).setTenantCode(eqAuction.getTenantCode());
                enrollList.get(i).setAuctionCode(eqAuction.getAuctionCode());
                enrollList.get(i).setAuctionName(eqAuction.getAuctionName());
                enrollList.get(i).setMemberCode(eqAuction.getMemberCode());
                enrollList.get(i).setMemberName(eqAuction.getMemberName());
                enrollList.get(i).setMemberCcode(eqAuction.getMemberCcode());
                enrollList.get(i).setMemberCname(eqAuction.getMemberCname());
            }
            if (ListUtil.isNotEmpty(enrollList)) {
                for (EqAuctionEnrollReDomain enroll : enrollList) {
                    this.eqAuctionEnrollService.saveAuctionEnroll(enroll);
                }
            }
        }
        this.logger.error(".----saveAuctionEnroll-----", (Object)"saveAuctionEnroll---------");
        if (ListUtil.isNotEmpty(eqAuctionReDomain.getEqAuctionGinfoDomainList())) {
            List<EqAuctionGinfoDomain> ginfoList = eqAuctionReDomain.getEqAuctionGinfoDomainList();
            for (int i2 = 0; i2 < ginfoList.size(); ++i2) {
                ginfoList.get(i2).setTenantCode(eqAuction.getTenantCode());
                ginfoList.get(i2).setAuctionCode(eqAuction.getAuctionCode());
                ginfoList.get(i2).setMemberCode(eqAuction.getMemberCode());
                ginfoList.get(i2).setMemberName(eqAuction.getMemberName());
            }
            if (ListUtil.isNotEmpty(ginfoList)) {
                this.eqAuctionGinfoService.saveAuctionGinfoBatch(ginfoList);
            }
        }
        this.logger.error(".----saveAuctionGinfoBatch-----", (Object)"saveAuctionGinfoBatch---------");
        return eqAuction.getAuctionCode();
    }

    @Override
    public String saveAuctionBatch(List<EqAuctionDomain> eqAuctionDomainList) throws ApiException {
        if (null == eqAuctionDomainList || eqAuctionDomainList.isEmpty()) {
            return null;
        }
        ArrayList<EqAuction> eqAuctionList = new ArrayList<EqAuction>();
        String code = "";
        for (EqAuctionDomain eqAuctionDomain : eqAuctionDomainList) {
            EqAuction eqAuction = this.createEqAuction(eqAuctionDomain);
            code = eqAuction.getAuctionCode();
            eqAuctionList.add(eqAuction);
        }
        this.saveAuctionBatchModel(eqAuctionList);
        return code;
    }

    @Override
    public void updateAuctionState(Integer auctionId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == auctionId) {
            return;
        }
        this.updateStateAuctionModel(auctionId, dataState, oldDataState, map);
    }

    @Override
    public void updateAuctionStateByCode(String tenantCode, String auctionCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)auctionCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateAuctionModelByCode(tenantCode, auctionCode, dataState, oldDataState, map);
    }

    @Override
    public void updateAuction(EqAuctionDomain eqAuctionDomain) throws ApiException {
        String msg = this.checkAuction(eqAuctionDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("eq.EqAuctionServiceImpl.updateAuction.checkAuction", msg);
        }
        EqAuction oldEqAuction = this.getAuctionModelById(eqAuctionDomain.getAuctionId());
        if (null == oldEqAuction) {
            throw new ApiException("eq.EqAuctionServiceImpl.updateAuction.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        EqAuction eqAuction = this.makeAuction(eqAuctionDomain, oldEqAuction);
        this.setAuctionUpdataDefault(eqAuction);
        this.updateAuctionModel(eqAuction);
    }

    @Override
    public EqAuction getAuction(Integer auctionId) {
        if (null == auctionId) {
            return null;
        }
        return this.getAuctionModelById(auctionId);
    }

    @Override
    public void deleteAuction(Integer auctionId) throws ApiException {
        if (null == auctionId) {
            return;
        }
        this.deleteAuctionModel(auctionId);
    }

    @Override
    public QueryResult<EqAuction> queryAuctionPage(Map<String, Object> map) {
        List<EqAuction> eqAuctionList = this.queryAuctionModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countAuction(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(eqAuctionList);
        return queryResult;
    }

    @Override
    public EqAuction getAuctionByCode(String tenantCode, String auctionCode) throws ApiException {
        if (StringUtils.isBlank((String)auctionCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("auctionCode", auctionCode);
        return this.getAuctionModelByCode(map);
    }

    @Override
    public void deleteAuctionByCode(String tenantCode, String auctionCode) throws ApiException {
        if (StringUtils.isBlank((String)auctionCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("auctionCode", auctionCode);
        this.delAuctionModelByCode(map);
    }

    @Override
    public Map<String, Object> queryCountByState(String tenantCode, int dataState, String memberBcode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("memberBcode", memberBcode);
        return this.eqAuctionMapper.queryCountByState(map);
    }

    @Override
    public EqAuctionReDomain priceRanks(Integer auctionId) throws ApiException {
        EqAuctionReDomain eqAuctionReDomain = new EqAuctionReDomain();
        ArrayList<EqAuctionEnrollReDomain> enrollReDomainList = new ArrayList<EqAuctionEnrollReDomain>();
        ArrayList<EqAuctionGinfoDomain> eqAuctionGinfoDomainList = new ArrayList<EqAuctionGinfoDomain>();
        if (null == auctionId) {
            return null;
        }
        EqAuction eqAuction = this.eqAuctionMapper.selectByPrimaryKey(auctionId);
        if (eqAuction != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("auctionCode", eqAuction.getAuctionCode());
            map.put("tenantCode", eqAuction.getTenantCode());
            QueryResult<EqAuctionEnroll> eqAuctionEnrolls = this.eqAuctionEnrollService.queryAuctionEnrollPage(map);
            QueryResult<EqAuctionGinfo> eqAuctionGinfoQueryResult = this.eqAuctionGinfoService.queryAuctionGinfoPage(map);
            if (ListUtil.isNotEmpty((Collection)eqAuctionEnrolls.getList())) {
                for (EqAuctionEnroll enroll : eqAuctionEnrolls.getList()) {
                    EqAuctionEnrollReDomain domain = new EqAuctionEnrollReDomain();
                    ArrayList<EqAuctionGoodsDomain> eqAuctionGoodsDomainList = new ArrayList<EqAuctionGoodsDomain>();
                    domain.setMemberCode(enroll.getMemberCode());
                    domain.setMemberName(enroll.getMemberName());
                    domain.setRank("0");
                    domain.setRate(eqAuction.getInvoiceTaxRate());
                    HashMap<String, Object> goodsMap = new HashMap<String, Object>();
                    goodsMap.put("auctionGinfoCode", enroll.getAuctionEnrollCode());
                    QueryResult<EqAuctionGoods> eqAuctionGoodsQueryResult = this.eqAuctionGoodsService.queryAuctionGoodsPage(goodsMap);
                    domain.setDefectCount(eqAuctionGinfoQueryResult.getList().size() - eqAuctionGoodsQueryResult.getList().size());
                    BigDecimal price = null;
                    HashMap<String, EqAuctionGoods> eqAuctionGoodsMap = new HashMap<String, EqAuctionGoods>();
                    if (ListUtil.isNotEmpty((Collection)eqAuctionGoodsQueryResult.getList())) {
                        for (EqAuctionGoods good : eqAuctionGoodsQueryResult.getList()) {
                            price = price == null ? good.getGoodsSupplynum().multiply(good.getPricesetNprice()).setScale(2, 4) : price.add(good.getGoodsSupplynum().multiply(good.getPricesetNprice()).setScale(2, 4));
                            eqAuctionGoodsMap.put(good.getAuctionGinfoCode(), good);
                        }
                        if (ListUtil.isNotEmpty((Collection)eqAuctionGinfoQueryResult.getList())) {
                            for (EqAuctionGinfo ginfo : eqAuctionGinfoQueryResult.getList()) {
                                EqAuctionGinfoDomain eqAuctionGinfoDomain = new EqAuctionGinfoDomain();
                                try {
                                    BeanUtils.copyAllPropertys((Object)eqAuctionGinfoDomain, (Object)ginfo);
                                }
                                catch (Exception e) {
                                    this.logger.error("eq.EqAuctionServiceImpl.priceRanks", (Throwable)e);
                                }
                                eqAuctionGinfoDomainList.add(eqAuctionGinfoDomain);
                                EqAuctionGoodsDomain eqAuctionGoodsDomain = new EqAuctionGoodsDomain();
                                if (eqAuctionGoodsMap != null && eqAuctionGoodsMap.get(ginfo.getAuctionGinfoCode()) != null) {
                                    try {
                                        BeanUtils.copyAllPropertys((Object)eqAuctionGoodsDomain, eqAuctionGoodsMap.get(ginfo.getAuctionGinfoCode()));
                                    }
                                    catch (Exception e) {
                                        this.logger.error("eq.EqAuctionServiceImpl.priceRanks", (Throwable)e);
                                    }
                                    eqAuctionGoodsDomainList.add(eqAuctionGoodsDomain);
                                    continue;
                                }
                                eqAuctionGoodsDomainList.add(null);
                            }
                        }
                    }
                    domain.setEqAuctionGoodsDomainList(eqAuctionGoodsDomainList);
                    domain.setAuctionPriceAmount(price);
                    enrollReDomainList.add(domain);
                }
            }
        }
        eqAuctionReDomain.setEqAuctionGinfoDomainList(eqAuctionGinfoDomainList);
        eqAuctionReDomain.setEqAuctionEnrollReDomainList(this.enrollSort(enrollReDomainList));
        return eqAuctionReDomain;
    }

    @Override
    public void saveAuctionAward(List<EqAuctionGoodsDomain> eqAuctionGoodsDomainList) throws ApiException {
        if (ListUtil.isNotEmpty(eqAuctionGoodsDomainList)) {
            for (EqAuctionGoodsDomain domain : eqAuctionGoodsDomainList) {
                this.eqAuctionGoodsService.updateAuctionGoods(domain);
            }
        }
    }

    private List<EqAuctionEnrollReDomain> enrollSort(List<EqAuctionEnrollReDomain> enrollReDomainList) {
        ArrayList<EqAuctionEnrollReDomain> allGoods = new ArrayList<EqAuctionEnrollReDomain>();
        ArrayList<EqAuctionEnrollReDomain> missGoods = new ArrayList<EqAuctionEnrollReDomain>();
        if (ListUtil.isNotEmpty(enrollReDomainList)) {
            for (EqAuctionEnrollReDomain eqAuctionEnrollReDomain : enrollReDomainList) {
                if (eqAuctionEnrollReDomain.getDefectCount() == 0) {
                    allGoods.add(eqAuctionEnrollReDomain);
                    continue;
                }
                eqAuctionEnrollReDomain.setRank("-");
                missGoods.add(eqAuctionEnrollReDomain);
            }
        }
        if (ListUtil.isNotEmpty(enrollReDomainList)) {
            Collections.sort(allGoods, new Comparator<EqAuctionEnrollReDomain>(){

                @Override
                public int compare(EqAuctionEnrollReDomain o1, EqAuctionEnrollReDomain o2) {
                    return o1.getAuctionPriceAmount().subtract(o2.getAuctionPriceAmount()).intValue();
                }
            });
        }
        if (ListUtil.isNotEmpty(enrollReDomainList)) {
            Collections.sort(missGoods, new Comparator<EqAuctionEnrollReDomain>(){

                @Override
                public int compare(EqAuctionEnrollReDomain o1, EqAuctionEnrollReDomain o2) {
                    return o1.getDefectCount() - o2.getDefectCount();
                }
            });
        }
        allGoods.addAll(missGoods);
        return allGoods;
    }

    @Override
    public void updateAuctionCompareState(Integer auctionId, Integer dataOpbillstate, Integer oldDataOpbillstate, Map<String, Object> map) throws ApiException {
        if (null == auctionId) {
            return;
        }
        this.updateDataOpbillstateAuctionModel(auctionId, dataOpbillstate, oldDataOpbillstate, map);
    }
}

