/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.appmanage.service.impl;

import com.yqbsoft.laser.service.esb.appmanage.domain.AmAppwarDomain;
import com.yqbsoft.laser.service.esb.appmanage.domain.AppwarUpdateDomain;
import com.yqbsoft.laser.service.esb.appmanage.model.AmAppwar;
import com.yqbsoft.laser.service.esb.appmanage.service.AmAppRegisterService;
import com.yqbsoft.laser.service.esb.appmanage.service.AmAppwarService;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.suppercore.point.RegeditBean;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import java.util.Map;

public class AmAppRegisterServiceImpl
extends BaseServiceImpl
implements AmAppRegisterService {
    private static final String SYS_CODE = "am.ESB.APPMANAGE.AmAppRegisterServiceImpl";
    public static final String VFOAPPMANAGE_LINEINFO = "EcoreAppmanage-lineInfo";
    private AmAppwarService amAppwarService;
    public static final Long REGEDIT_OVER_TIME = 60000L;

    public AmAppwarService getAmAppwarService() {
        return this.amAppwarService;
    }

    public void setAmAppwarService(AmAppwarService amAppwarService) {
        this.amAppwarService = amAppwarService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queryCacheToAppwar() {
        Map appMap = DisUtil.getMapAll((String)VFOAPPMANAGE_LINEINFO);
        Map warkeyMap = DisUtil.getMapAll((String)"EcoreAppwar-pro");
        try {
            AmAppRegisterServiceImpl amAppRegisterServiceImpl = this;
            synchronized (amAppRegisterServiceImpl) {
                this.check(appMap, warkeyMap);
            }
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmAppRegisterServiceImpl.queryCacheToAppwar.e", (Object)"", (Throwable)e);
        }
    }

    private void check(Map<String, String> appMap, Map<String, String> warkeyMap) {
        RegeditBean regeditBean;
        if (null != warkeyMap) {
            String regejson = null;
            for (String key : warkeyMap.keySet()) {
                AmAppwar amAppwar = (AmAppwar)JsonUtil.buildNonDefaultBinder().getJsonToObject(warkeyMap.get(key), AmAppwar.class);
                if (null != appMap) {
                    regejson = appMap.get(key);
                }
                if (StringUtils.isNotBlank(regejson)) {
                    regeditBean = (RegeditBean)JsonUtil.buildNonDefaultBinder().getJsonToObject(regejson, RegeditBean.class);
                    this.updateAppwar(amAppwar, regeditBean);
                    continue;
                }
                this.updateAppwar(amAppwar);
            }
        }
        if (null == appMap) {
            return;
        }
        for (String key : appMap.keySet()) {
            if (null != warkeyMap && null != warkeyMap.get(key) || this.delAppCache(regeditBean = (RegeditBean)JsonUtil.buildNonDefaultBinder().getJsonToObject(appMap.get(key), RegeditBean.class))) continue;
            this.insertAppwar(regeditBean);
        }
    }

    private void insertAppwar(RegeditBean regeditBean) {
        if (null == regeditBean) {
            return;
        }
        AmAppwarDomain amAppwarDomain = new AmAppwarDomain();
        amAppwarDomain.setAppwarAppkey(regeditBean.getAppkey());
        amAppwarDomain.setAppwarApptype(regeditBean.getApptype());
        amAppwarDomain.setAppwarFwtype("0");
        amAppwarDomain.setAppwarIcode(regeditBean.getAppIcode());
        amAppwarDomain.setAppwarName(regeditBean.getAppIcode());
        amAppwarDomain.setAppwarType(regeditBean.getApptype());
        amAppwarDomain.setAppwarUuid(regeditBean.getAppUuid());
        amAppwarDomain.setAppwarIp(regeditBean.getAppIp());
        amAppwarDomain.setAppwarDomain("http://" + regeditBean.getAppIp() + ":" + regeditBean.getAppPort() + "/" + regeditBean.getContextPath());
        amAppwarDomain.setTenantCode("00000000");
        this.amAppwarService.saveAppwar(amAppwarDomain);
    }

    private boolean delAppCache(RegeditBean regeditBean) {
        if (null == regeditBean) {
            return false;
        }
        if (System.currentTimeMillis() > regeditBean.getLastDate().getTime() + REGEDIT_OVER_TIME) {
            DisUtil.delMap((String)VFOAPPMANAGE_LINEINFO, (String[])new String[]{regeditBean.getAppkey()});
            return true;
        }
        return false;
    }

    private void updateAppwar(AmAppwar amAppwar) {
        if (null == amAppwar) {
            return;
        }
        AppwarUpdateDomain appwarUpdateDomain = new AppwarUpdateDomain();
        appwarUpdateDomain.setAppwarAppkey(amAppwar.getAppwarAppkey());
        appwarUpdateDomain.setTenantCode(amAppwar.getTenantCode());
        appwarUpdateDomain.setAppwarIcode(amAppwar.getAppwarIcode());
        appwarUpdateDomain.setDataState(0);
        this.updateAppwaruuid(amAppwar, appwarUpdateDomain);
    }

    private void updateAppwaruuid(AmAppwar amAppwar, AppwarUpdateDomain appwarUpdateDomain) {
        if (null == appwarUpdateDomain || null == amAppwar) {
            return;
        }
        amAppwar.setAppwarIp(appwarUpdateDomain.getAppwarIp());
        amAppwar.setAppwarDomain(appwarUpdateDomain.getAppwarDomain());
        amAppwar.setAppwarUuid(appwarUpdateDomain.getAppwarUuid());
        amAppwar.setDataState(appwarUpdateDomain.getDataState());
        this.amAppwarService.updateAppwaruuid(appwarUpdateDomain);
        DisUtil.setMap((String)"EcoreAppwar-pro", (String)amAppwar.getAppwarAppkey(), (String)JsonUtil.buildNonDefaultBinder().toJson((Object)amAppwar));
    }

    private void updateAppwar(AmAppwar amAppwar, RegeditBean regeditBean) {
        if (null == amAppwar || null == regeditBean) {
            return;
        }
        AppwarUpdateDomain appwarUpdateDomain = new AppwarUpdateDomain();
        appwarUpdateDomain.setAppwarAppkey(amAppwar.getAppwarAppkey());
        appwarUpdateDomain.setTenantCode(amAppwar.getTenantCode());
        appwarUpdateDomain.setAppwarIcode(amAppwar.getAppwarIcode());
        appwarUpdateDomain.setAppwarIp(regeditBean.getAppIp());
        appwarUpdateDomain.setAppwarUuid(regeditBean.getAppUuid());
        String domain = "http://" + regeditBean.getAppIp() + ":" + regeditBean.getAppPort() + "/" + regeditBean.getContextPath();
        appwarUpdateDomain.setAppwarDomain(domain);
        appwarUpdateDomain.setDataState(0);
        if (!this.delAppCache(regeditBean) && this.checkHealthy(domain)) {
            appwarUpdateDomain.setDataState(1);
        }
        this.updateAppwaruuid(amAppwar, appwarUpdateDomain);
    }

    private boolean checkHealthy(String domain) {
        if (StringUtils.isBlank((String)domain)) {
            return false;
        }
        try {
            String res = WebUtils.doGet((String)(domain + "/healthy"), null);
            if ("ok".equals(res)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

