/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.appmanage.service.impl;

import com.yqbsoft.laser.service.esb.appmanage.dao.AmDepartMapper;
import com.yqbsoft.laser.service.esb.appmanage.domain.AmDepartDomain;
import com.yqbsoft.laser.service.esb.appmanage.domain.AmDepartReDomain;
import com.yqbsoft.laser.service.esb.appmanage.model.AmDepart;
import com.yqbsoft.laser.service.esb.appmanage.service.AmDepartService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AmDepartServiceImpl
extends BaseServiceImpl
implements AmDepartService {
    private static final String SYS_CODE = "am.ESB.APPMANAGE.AmDepartServiceImpl";
    private AmDepartMapper amDepartMapper;

    public void setAmDepartMapper(AmDepartMapper amDepartMapper) {
        this.amDepartMapper = amDepartMapper;
    }

    private Date getSysDate() {
        try {
            return this.amDepartMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmDepartServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkDepart(AmDepartDomain amDepartDomain) {
        if (null == amDepartDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)amDepartDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDepartDefault(AmDepart amDepart) {
        if (null == amDepart) {
            return;
        }
        if (null == amDepart.getDataState()) {
            amDepart.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == amDepart.getGmtCreate()) {
            amDepart.setGmtCreate(date);
        }
        amDepart.setGmtModified(date);
        if (StringUtils.isBlank((String)amDepart.getDepartCode())) {
            amDepart.setDepartCode(this.getNo(null, "AmDepart", "amDepart", amDepart.getTenantCode()));
        }
    }

    private int getDepartMaxCode() {
        int code = 0;
        try {
            return this.amDepartMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmDepartServiceImpl.getDepartMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setDepartUpdataDefault(AmDepart amDepart) {
        if (null == amDepart) {
            return;
        }
        amDepart.setGmtModified(this.getSysDate());
    }

    private void saveDepartModel(AmDepart amDepart) throws ApiException {
        if (null == amDepart) {
            return;
        }
        try {
            this.amDepartMapper.insert(amDepart);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmDepartServiceImpl.saveDepartModel.ex", (Throwable)e);
        }
    }

    private void saveDepartBatchModel(List<AmDepart> amDepartList) throws ApiException {
        if (null == amDepartList || amDepartList.isEmpty()) {
            return;
        }
        try {
            this.amDepartMapper.insertBatch(amDepartList);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmDepartServiceImpl.saveDepartBatchModel.ex", (Throwable)e);
        }
    }

    private AmDepart getDepartModelById(Integer departId) {
        if (null == departId) {
            return null;
        }
        try {
            return this.amDepartMapper.selectByPrimaryKey(departId);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmDepartServiceImpl.getDepartModelById", (Throwable)e);
            return null;
        }
    }

    private AmDepart getDepartModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.amDepartMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmDepartServiceImpl.getDepartModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delDepartModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.amDepartMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmDepartServiceImpl.delDepartModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("am.ESB.APPMANAGE.AmDepartServiceImpl.delDepartModelByCode.num");
        }
    }

    private void deleteDepartModel(Integer departId) throws ApiException {
        if (null == departId) {
            return;
        }
        int i = 0;
        try {
            i = this.amDepartMapper.deleteByPrimaryKey(departId);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmDepartServiceImpl.deleteDepartModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("am.ESB.APPMANAGE.AmDepartServiceImpl.deleteDepartModel.num");
        }
    }

    private void updateDepartModel(AmDepart amDepart) throws ApiException {
        if (null == amDepart) {
            return;
        }
        int i = 0;
        try {
            i = this.amDepartMapper.updateByPrimaryKey(amDepart);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmDepartServiceImpl.updateDepartModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("am.ESB.APPMANAGE.AmDepartServiceImpl.updateDepartModel.num");
        }
    }

    private void updateStateDepartModel(Integer departId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == departId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("departId", departId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.amDepartMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmDepartServiceImpl.updateStateDepartModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("am.ESB.APPMANAGE.AmDepartServiceImpl.updateStateDepartModel.null");
        }
    }

    private void updateStateDepartModelByCode(String tenantCode, String departCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)departCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("departCode", departCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.amDepartMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AmDepartServiceImpl.updateStateDepartModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("am.ESB.APPMANAGE.AmDepartServiceImpl.updateStateDepartModelByCode.null");
        }
    }

    private AmDepart makeDepart(AmDepartDomain amDepartDomain, AmDepart amDepart) {
        if (null == amDepartDomain) {
            return null;
        }
        if (null == amDepart) {
            amDepart = new AmDepart();
        }
        try {
            BeanUtils.copyAllPropertys((Object)amDepart, (Object)amDepartDomain);
            return amDepart;
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmDepartServiceImpl.makeDepart", (Throwable)e);
            return null;
        }
    }

    private AmDepartReDomain makeAmDepartReDomain(AmDepart amDepart) {
        if (null == amDepart) {
            return null;
        }
        AmDepartReDomain amDepartReDomain = new AmDepartReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)amDepartReDomain, (Object)amDepart);
            return amDepartReDomain;
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmDepartServiceImpl.makeAmDepartReDomain", (Throwable)e);
            return null;
        }
    }

    private List<AmDepart> queryDepartModelPage(Map<String, Object> parammap) {
        try {
            return this.amDepartMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmDepartServiceImpl.queryDepartModel", (Throwable)e);
            return null;
        }
    }

    private int countDepart(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.amDepartMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AmDepartServiceImpl.countDepart", (Throwable)e);
        }
        return i;
    }

    private AmDepart createAmDepart(AmDepartDomain amDepartDomain) {
        String msg = this.checkDepart(amDepartDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.AmDepartServiceImpl.saveDepart.checkDepart", msg);
        }
        AmDepart amDepart = this.makeDepart(amDepartDomain, null);
        this.setDepartDefault(amDepart);
        return amDepart;
    }

    @Override
    public String saveDepart(AmDepartDomain amDepartDomain) throws ApiException {
        AmDepart amDepart = this.createAmDepart(amDepartDomain);
        this.saveDepartModel(amDepart);
        return amDepart.getDepartCode();
    }

    @Override
    public String saveDepartBatch(List<AmDepartDomain> amDepartDomainList) throws ApiException {
        if (null == amDepartDomainList || amDepartDomainList.isEmpty()) {
            return null;
        }
        ArrayList<AmDepart> amDepartList = new ArrayList<AmDepart>();
        String code = "";
        for (AmDepartDomain amDepartDomain : amDepartDomainList) {
            AmDepart amDepart = this.createAmDepart(amDepartDomain);
            code = amDepart.getDepartCode();
            amDepartList.add(amDepart);
        }
        this.saveDepartBatchModel(amDepartList);
        return code;
    }

    @Override
    public void updateDepartState(Integer departId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == departId) {
            return;
        }
        this.updateStateDepartModel(departId, dataState, oldDataState, map);
    }

    @Override
    public void updateDepartStateByCode(String tenantCode, String departCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)departCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateDepartModelByCode(tenantCode, departCode, dataState, oldDataState, map);
    }

    @Override
    public void updateDepart(AmDepartDomain amDepartDomain) throws ApiException {
        String msg = this.checkDepart(amDepartDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.AmDepartServiceImpl.updateDepart.checkDepart", msg);
        }
        AmDepart oldAmDepart = this.getDepartModelById(amDepartDomain.getDepartId());
        if (null == oldAmDepart) {
            throw new ApiException("am.ESB.APPMANAGE.AmDepartServiceImpl.updateDepart.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        AmDepart amDepart = this.makeDepart(amDepartDomain, oldAmDepart);
        this.setDepartUpdataDefault(amDepart);
        this.updateDepartModel(amDepart);
    }

    @Override
    public AmDepart getDepart(Integer departId) {
        if (null == departId) {
            return null;
        }
        return this.getDepartModelById(departId);
    }

    @Override
    public void deleteDepart(Integer departId) throws ApiException {
        if (null == departId) {
            return;
        }
        this.deleteDepartModel(departId);
    }

    @Override
    public QueryResult<AmDepart> queryDepartPage(Map<String, Object> map) {
        List<AmDepart> amDepartList = this.queryDepartModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countDepart(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(amDepartList);
        return queryResult;
    }

    @Override
    public AmDepart getDepartByCode(String tenantCode, String departCode) throws ApiException {
        if (StringUtils.isBlank((String)departCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("departCode", departCode);
        return this.getDepartModelByCode(map);
    }

    @Override
    public void deleteDepartByCode(String tenantCode, String departCode) throws ApiException {
        if (StringUtils.isBlank((String)departCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("departCode", departCode);
        this.delDepartModelByCode(map);
    }
}

