/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.appmanage.service.impl;

import com.yqbsoft.laser.service.esb.appmanage.dao.AmConnServerMapper;
import com.yqbsoft.laser.service.esb.appmanage.domain.AmConnServerDomain;
import com.yqbsoft.laser.service.esb.appmanage.model.AmConnServer;
import com.yqbsoft.laser.service.esb.appmanage.service.ConnServerService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.netty.ConnServerProperty;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConnServerServiceImpl
extends BaseServiceImpl
implements ConnServerService {
    public static final String SYS_CODE = "am.ESB.APPMANAGE.ConnServerServiceImpl";
    private static final String CACHE_KEY = "AmConnServer-pro";
    private AmConnServerMapper amConnServerMapper;

    public void setAmConnServerMapper(AmConnServerMapper amConnServerMapper) {
        this.amConnServerMapper = amConnServerMapper;
    }

    private Date getSysDate() {
        try {
            return this.amConnServerMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.ConnServerServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkConnServer(AmConnServerDomain amConnServerDomain) {
        if (null == amConnServerDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setConnServerDefault(AmConnServer amConnServer) {
        if (null == amConnServer) {
            return;
        }
        if (null == amConnServer.getDataState()) {
            amConnServer.setDataState(0);
        }
        if (null == amConnServer.getGmtCreate()) {
            amConnServer.setGmtCreate(this.getSysDate());
        }
        amConnServer.setGmtModified(this.getSysDate());
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.amConnServerMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.ConnServerServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setConnServerUpdataDefault(AmConnServer amConnServer) {
        if (null == amConnServer) {
            return;
        }
        amConnServer.setGmtModified(this.getSysDate());
    }

    private void saveConnServerModel(AmConnServer amConnServer) throws ApiException {
        if (null == amConnServer) {
            return;
        }
        try {
            this.amConnServerMapper.insert(amConnServer);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.ConnServerServiceImpl.saveFtpserverModel.ex");
        }
    }

    private AmConnServer getConnServerModelById(Integer connServerId) {
        if (null == connServerId) {
            return null;
        }
        try {
            return this.amConnServerMapper.selectByPrimaryKey(connServerId);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.ConnServerServiceImpl.getConnServerModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteConnServerModel(Integer connServerId) throws ApiException {
        if (null == connServerId) {
            return;
        }
        int i = 0;
        try {
            i = this.amConnServerMapper.deleteByPrimaryKey(connServerId);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.ConnServerServiceImpl.deleteConnServerModel.ex");
        }
        if (1 != i) {
            throw new ApiException("am.ESB.APPMANAGE.ConnServerServiceImpl.deleteConnServerModel.num");
        }
    }

    private void updateConnServerModel(AmConnServer amConnServer) throws ApiException {
        if (null == amConnServer) {
            return;
        }
        try {
            this.amConnServerMapper.updateByPrimaryKeySelective(amConnServer);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.ConnServerServiceImpl.updateConnServerModel.ex");
        }
    }

    private void updateStateConnServerModel(Integer connServerId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == connServerId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("connServerId", connServerId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.amConnServerMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.ConnServerServiceImpl.updateStateConnServerModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("am.ESB.APPMANAGE.ConnServerServiceImpl.updateStateConnServerModel.null");
        }
    }

    private AmConnServer makeConnServer(AmConnServerDomain amConnServerDomain, AmConnServer amConnServer) {
        if (null == amConnServerDomain) {
            return null;
        }
        if (null == amConnServer) {
            amConnServer = new AmConnServer();
        }
        try {
            BeanUtils.copyAllPropertys((Object)amConnServer, (Object)amConnServerDomain);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.ConnServerServiceImpl.makeConnServer", (Throwable)e);
        }
        return amConnServer;
    }

    private List<AmConnServer> queryConnServerModelPage(Map<String, Object> parammap) {
        try {
            return this.amConnServerMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.ConnServerServiceImpl.queryConnServerModel", (Throwable)e);
            return null;
        }
    }

    private int countConnServer(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.amConnServerMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.ConnServerServiceImpl.countConnServer", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveConnServer(AmConnServerDomain amConnServerDomain) throws ApiException {
        String msg = this.checkConnServer(amConnServerDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.ConnServerServiceImpl.saveConnServer.checkConnServer", msg);
        }
        AmConnServer amConnServer = this.makeConnServer(amConnServerDomain, null);
        this.setConnServerDefault(amConnServer);
        this.saveConnServerModel(amConnServer);
    }

    @Override
    public void updateConnServerState(Integer connServerId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateConnServerModel(connServerId, dataState, oldDataState);
    }

    @Override
    public void updateConnServer(AmConnServerDomain amConnServerDomain) throws ApiException {
        String msg = this.checkConnServer(amConnServerDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.ConnServerServiceImpl.updateConnServer.checkConnServer", msg);
        }
        AmConnServer oldAmConnServer = this.getConnServerModelById(amConnServerDomain.getConnServerId());
        if (null == oldAmConnServer) {
            throw new ApiException("am.ESB.APPMANAGE.ConnServerServiceImpl.updateConnServer.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        AmConnServer amConnServer = this.makeConnServer(amConnServerDomain, oldAmConnServer);
        this.setConnServerUpdataDefault(amConnServer);
        this.updateConnServerModel(amConnServer);
    }

    @Override
    public AmConnServer getConnServer(Integer connServerId) {
        return this.getConnServerModelById(connServerId);
    }

    @Override
    public void deleteConnServer(Integer connServerId) throws ApiException {
        this.deleteConnServerModel(connServerId);
    }

    @Override
    public QueryResult<AmConnServer> queryConnServerPage(Map<String, Object> map) {
        List<AmConnServer> amConnServerList = this.queryConnServerModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countConnServer(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(amConnServerList);
        return queryResult;
    }

    @Override
    public void queryConnServerCache() {
        this.info("am.ESB.APPMANAGE.ConnServerServiceImpl.queryConnServerCache", "=======queryConnServerCache\u8c03\u5ea6start=======");
        List<AmConnServer> amConnServerList = this.queryConnServerModelPage(this.getQueryParamMap("dataState", new Object[]{1}));
        if (amConnServerList == null || amConnServerList.isEmpty()) {
            DisUtil.delVer((String)CACHE_KEY);
            this.info("am.ESB.APPMANAGE.ConnServerServiceImpl.queryConnServerCache", "=======queryConnServerCache\u8c03\u5ea6end-del=======");
            return;
        }
        HashMap<String, List<ConnServerProperty>> map = new HashMap<String, List<ConnServerProperty>>();
        for (AmConnServer amConnServer : amConnServerList) {
            this.saveCache(amConnServer, map);
        }
        DisUtil.setVer((String)CACHE_KEY, (String)JsonUtil.buildNormalBinder().toJson(map));
        this.info("am.ESB.APPMANAGE.ConnServerServiceImpl.queryConnServerCache", "=======queryConnServerCache\u8c03\u5ea6end=======");
    }

    private void saveCache(AmConnServer amConnServer, Map<String, List<ConnServerProperty>> map) {
        if (amConnServer.getAppmanageIp() == null) {
            return;
        }
        List list = MapUtil.getList(map, (Object)amConnServer.getConnProtocol());
        Integer index = null;
        for (int i = 0; i < list.size(); ++i) {
            if (!((ConnServerProperty)list.get(i)).getConnServerId().equals(amConnServer.getConnServerId())) continue;
            index = i;
            break;
        }
        ConnServerProperty connServer = this.makeServer(amConnServer);
        if (index != null) {
            list.set(index, connServer);
        } else {
            list.add(connServer);
        }
    }

    private ConnServerProperty makeServer(AmConnServer amConnServer) {
        if (null == amConnServer) {
            return null;
        }
        ConnServerProperty server = new ConnServerProperty();
        try {
            BeanUtils.copyAllPropertys((Object)server, (Object)amConnServer);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.ConnServerServiceImpl.makeServer", (Throwable)e);
        }
        return server;
    }
}

