/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.appmanage.service.impl;

import com.yqbsoft.laser.service.esb.appmanage.dao.AmAppUpdateMapper;
import com.yqbsoft.laser.service.esb.appmanage.dao.AmAppmanageMapper;
import com.yqbsoft.laser.service.esb.appmanage.domain.AmAppmanageDomain;
import com.yqbsoft.laser.service.esb.appmanage.model.AmAppmanage;
import com.yqbsoft.laser.service.esb.appmanage.model.AmAppwar;
import com.yqbsoft.laser.service.esb.appmanage.model.AmAppwarJar;
import com.yqbsoft.laser.service.esb.appmanage.service.AmAppwarService;
import com.yqbsoft.laser.service.esb.appmanage.service.AppmanageService;
import com.yqbsoft.laser.service.esb.appmanage.service.impl.RandomId;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.router.InternalRouter;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.router.AppProperty;
import com.yqbsoft.laser.service.suppercore.router.AppState;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;

public class AppmanageServiceImpl
extends BaseServiceImpl
implements AppmanageService {
    public static final String SYS_CODE = "am.ESB.APPMANAGE.AppmanageServiceImpl";
    private AmAppwarService amAppwarService;
    private InternalRouter internalRouter;
    private AmAppmanageMapper amAppmanageMapper;
    private AmAppUpdateMapper amAppUpdateMapper;

    public AmAppwarService getAmAppwarService() {
        return this.amAppwarService;
    }

    public void setAmAppwarService(AmAppwarService amAppwarService) {
        this.amAppwarService = amAppwarService;
    }

    public InternalRouter getInternalRouter() {
        return this.internalRouter;
    }

    public void setInternalRouter(InternalRouter internalRouter) {
        this.internalRouter = internalRouter;
    }

    public void setAmAppmanageMapper(AmAppmanageMapper amAppmanageMapper) {
        this.amAppmanageMapper = amAppmanageMapper;
    }

    public void setAmAppUpdateMapper(AmAppUpdateMapper amAppUpdateMapper) {
        this.amAppUpdateMapper = amAppUpdateMapper;
    }

    private String check(AmAppmanage amAppmanage) {
        if (null == amAppmanage) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)amAppmanage.getAppmanageAppkey())) {
            msg = msg + "AppmanageAppkey\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)amAppmanage.getAppmanageIcode())) {
            msg = msg + "AppmanageIcode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDefault(AmAppmanage amAppmanage) {
        if (null == amAppmanage) {
            return;
        }
        if (null == amAppmanage.getDataState()) {
            amAppmanage.setDataState(0);
        }
        if (null == amAppmanage.getDataStateOld()) {
            amAppmanage.setDataStateOld(0);
        }
        if (null == amAppmanage.getGmtCreate()) {
            amAppmanage.setGmtCreate(this.getSysDate());
        }
    }

    private void setUpdateDefault(AmAppmanage amAppmanage) {
        if (null == amAppmanage) {
            return;
        }
        if (null == amAppmanage.getDataState()) {
            amAppmanage.setDataState(0);
        }
        if (null == amAppmanage.getGmtModified()) {
            amAppmanage.setGmtModified(this.getSysDate());
        }
    }

    private void saveAppmanageMode(AmAppmanage amAppmanage) throws ApiException {
        if (null == amAppmanage) {
            return;
        }
        try {
            this.amAppmanageMapper.insert(amAppmanage);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AppmanageServiceImpl.saveAppmanageMode.ex", (Throwable)e);
        }
    }

    private void updateAppmanageMode(AmAppmanage amAppmanage) throws ApiException {
        if (null == amAppmanage) {
            return;
        }
        try {
            this.amAppmanageMapper.updateByPrimaryKey(amAppmanage);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AppmanageServiceImpl.updateAppmanageMode.ex");
        }
    }

    private Date getSysDate() {
        try {
            return this.amAppmanageMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AppmanageServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private AppProperty makePro(AmAppmanage amAppmanage) {
        if (null == amAppmanage) {
            return null;
        }
        AppProperty appProperty = new AppProperty();
        try {
            BeanUtils.copyAllPropertys((Object)appProperty, (Object)amAppmanage);
            String appProType = "";
            appProType = null == amAppmanage.getAppmanageType() || "0".equals(amAppmanage.getAppmanageType()) ? "2" : "0";
            appProperty.setAppmanageType(appProType);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AppmanageServiceImpl.makePro", (Throwable)e);
        }
        return appProperty;
    }

    private AppProperty makeWarPro(AmAppwar amAppware) {
        if (null == amAppware) {
            return null;
        }
        AppProperty appProperty = new AppProperty();
        try {
            String appProType = "";
            appProType = null == amAppware.getAppwarApptype() || "0".equals(amAppware.getAppwarApptype()) ? "2" : "0";
            BeanUtils.copyAllPropertys((Object)appProperty, (Object)amAppware);
            appProperty.setAppmanageIcode(amAppware.getAppwarIcode());
            appProperty.setAppmanageAppkey(amAppware.getAppwarAppkey());
            appProperty.setAppmanageType(appProType);
            appProperty.setAppmanageApptype(amAppware.getAppwarApptype());
            appProperty.setAppmanageFwtype(amAppware.getAppwarFwtype());
            appProperty.setAppmanageSecretkey(amAppware.getAppwarSecretkey());
            appProperty.setAppmanageName(amAppware.getAppwarName());
            appProperty.setRouterDire(amAppware.getRouterDire());
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AppmanageServiceImpl.makePro", (Throwable)e);
        }
        return appProperty;
    }

    private List<AmAppmanage> query(Map<String, Object> parammap) {
        try {
            return this.amAppmanageMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AppmanageServiceImpl.query", (Throwable)e);
            return null;
        }
    }

    private void updateStateMode(Integer appmanageId, Integer dataState, Integer oldDataState, String appmanageExtappcode, String uid) throws ApiException {
        if (null == appmanageId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appmanageId", appmanageId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        map.put("appmanageExtappcode", appmanageExtappcode);
        map.put("uid", uid);
        int i = 0;
        try {
            i = this.amAppmanageMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AppmanageServiceImpl.updateStateMode.ex");
        }
        if (i <= 0) {
            throw new ApiException("am.ESB.APPMANAGE.AppmanageServiceImpl.updateStateMode.null");
        }
    }

    private void updateRoyaltyMode(String appmanageAppkey, Integer royaltyType, String royaltyValue, String memo) throws ApiException {
        if (null == appmanageAppkey || null == royaltyType || null == royaltyValue) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appmanageAppkey", appmanageAppkey);
        map.put("royaltyType", royaltyType);
        map.put("royaltyValue", royaltyValue);
        map.put("memo", memo);
        int i = 0;
        try {
            i = this.amAppmanageMapper.updateRoyaltyByAppmanageAppkey(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AppmanageServiceImpl.updateRoyaltyMode.ex");
        }
        if (i <= 0) {
            throw new ApiException("am.ESB.APPMANAGE.AppmanageServiceImpl.updateRoyaltyMode.null");
        }
    }

    private void updateStateModeRecover(Integer appmanageId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == appmanageId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appmanageId", appmanageId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.amAppmanageMapper.updateStateByPrimaryKeyRecover(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AppmanageServiceImpl.updateStateModeRecover.ex");
        }
        if (i <= 0) {
            throw new ApiException("am.ESB.APPMANAGE.AppmanageServiceImpl.updateStateMode.null");
        }
    }

    private void updateAppmanageMesModel(Integer appmanageId, String appmanageApiouturl, String appmanageUrlsuffix, String appmanageTesturl) throws ApiException {
        if (null == appmanageId) {
            return;
        }
        if (null == appmanageApiouturl && null == appmanageTesturl) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appmanageId", appmanageId);
        map.put("appmanageApiouturl", appmanageApiouturl);
        map.put("appmanageUrlsuffix", appmanageUrlsuffix);
        map.put("appmanageTesturl", appmanageTesturl);
        int i = 0;
        try {
            i = this.amAppmanageMapper.updateAppmanageMesByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AppmanageServiceImpl.updateAppmanageMesModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("am.ESB.APPMANAGE.AppmanageServiceImpl.updateAppmanageMesModel.null");
        }
    }

    private void updateAppmanagePicurlModel(Integer appmanageId, String appmanagePicurl) throws ApiException {
        if (null == appmanageId) {
            return;
        }
        if (null == appmanagePicurl) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appmanageId", appmanageId);
        map.put("appmanagePicurl", appmanagePicurl);
        int i = 0;
        try {
            i = this.amAppmanageMapper.updateAppmanagePicurlByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AppmanageServiceImpl.updateAppmanageMesModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("am.ESB.APPMANAGE.AppmanageServiceImpl.updateAppmanageMesModel.null");
        }
    }

    private void updateAppUState(Integer appupdateId, Integer dataState, Integer oldDataState, String memo) throws ApiException {
        if (null == appupdateId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appupdateId", appupdateId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        map.put("memo", memo);
        int i = 0;
        try {
            i = this.amAppUpdateMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("am.ESB.APPMANAGE.AppmanageServiceImpl.updateStateModeCheck.ex");
        }
        if (i <= 0) {
            throw new ApiException("am.ESB.APPMANAGE.AppmanageServiceImpl.updateStateModeCheck.null");
        }
    }

    @Override
    public void saveAppmanage(AmAppmanageDomain amAppmanageDomain) throws ApiException {
        AmAppmanage amAppmanage = new AmAppmanage();
        String msg = this.check(amAppmanage = this.makeModel(amAppmanage, amAppmanageDomain));
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.AppmanageServiceImpl.amAppmanage.null", msg);
        }
        this.setDefault(amAppmanage);
        this.saveAppmanageMode(amAppmanage);
        this.refreshCache(amAppmanage, false);
    }

    @Override
    public void updateAppmanage(AmAppmanageDomain amAppmanageDomain) throws ApiException {
        AmAppmanage amAppmanage = this.getAppmanage(amAppmanageDomain.getAppmanageId());
        String msg = this.check(amAppmanage = this.makeModel(amAppmanage, amAppmanageDomain));
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("am.ESB.APPMANAGE.AppmanageServiceImpl.amAppmanage.null", msg);
        }
        this.setUpdateDefault(amAppmanage);
        this.updateAppmanageMode(amAppmanage);
        this.refreshCache(amAppmanage, false);
    }

    private AmAppmanage makeModel(AmAppmanage amAppmanage, AmAppmanageDomain amAppmanageDomain) {
        if (amAppmanageDomain == null) {
            return null;
        }
        if (amAppmanage == null) {
            amAppmanage = new AmAppmanage();
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)amAppmanage, (Object)amAppmanageDomain);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return amAppmanage;
    }

    @Override
    public void queryAppmanageLoadCache() {
        this.info("am.ESB.APPMANAGE.AppmanageServiceImpl.queryAppmanageLoadCache", "=======app\u8c03\u5ea6start=======");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("dataStates", AppState.getAllStateCode());
        List<AmAppmanage> appList = this.query(params);
        if (CollectionUtils.isEmpty(appList)) {
            DisUtil.delVer((String)"EcoreAppmanage-pro");
            return;
        }
        Map<String, List<AmAppwar>> warMap = this.amAppwarService.queryAppwarToMap();
        Map<String, AmAppwarJar> jarMap = this.amAppwarService.queryAppwarJarToMap();
        HashMap<String, List<AppProperty>> mmap = new HashMap<String, List<AppProperty>>();
        for (AmAppmanage amAppmanage : appList) {
            this.makeWarToAppmanage(amAppmanage, jarMap);
            this.convert2Property(amAppmanage, mmap);
        }
        List<AmAppwar> appwarList = null;
        if (null == warMap || warMap.isEmpty()) {
            DisUtil.delVer((String)"EcoreAppwar-pro");
        } else {
            ConcurrentHashMap<String, String> warkeyMap = new ConcurrentHashMap<String, String>();
            for (String Key : warMap.keySet()) {
                appwarList = warMap.get(Key);
                if (null == appwarList || appwarList.isEmpty()) continue;
                for (AmAppwar amAppwar : appwarList) {
                    this.convertWar2Property(amAppwar, mmap);
                    warkeyMap.put(amAppwar.getAppwarAppkey(), JsonUtil.buildNormalBinder().toJson((Object)amAppwar));
                }
            }
            DisUtil.setMapVer((String)"EcoreAppwar-pro", warkeyMap);
        }
        DisUtil.setJsonVer((String)"EcoreAppmanage-pro", mmap);
        this.info("am.ESB.APPMANAGE.AppmanageServiceImpl.queryAppmanageLoadCache", "=======app\u8c03\u5ea6end=======");
    }

    @Override
    public void updateAppmanageState(Integer appmanageId, Integer newState, Integer oldState) throws ApiException {
        this.updateStateMode(appmanageId, newState, oldState, "", "");
        AmAppmanage app = this.getAppmanage(appmanageId);
        app.setDataState(newState);
        this.refreshCache(app, false);
    }

    @Override
    public void updateAppmanageRoyaltype(String appmanageAppkey, Integer royaltyType, String royaltyValue, String memo) throws ApiException {
        this.updateRoyaltyMode(appmanageAppkey, royaltyType, royaltyValue, memo);
        AmAppmanage app = this.getAppmanageByAppmanageAppkey(appmanageAppkey);
        this.refreshCache(app, false);
    }

    @Override
    public void updateAppmanageStateRecover(Integer appmanageId, Integer newState, Integer oldState) throws ApiException {
        this.updateStateModeRecover(appmanageId, newState, oldState);
        AmAppmanage app = this.getAppmanage(appmanageId);
        app.setDataState(newState);
        this.refreshCache(app, false);
    }

    @Override
    public void updateAppmanageStateByAppkey(String appmanageAppkey, Integer appDataState, Integer appOldState, Integer appupdateId, Integer dataState, Integer oldDataState, String memo) throws ApiException {
        this.updateAppmanageStateBykey(appmanageAppkey, appDataState, appOldState);
        this.updateAppUState(appupdateId, dataState, oldDataState, memo);
    }

    @Override
    public void updateAppmanageStateBykey(String appmanageAppkey, Integer appDataState, Integer appOldState) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appmanageAppkey", appmanageAppkey);
        List<AmAppmanage> appList = this.queryAppmanageListNopage(map);
        AmAppmanage amAppmanage = appList.get(0);
        this.updateAppmanageState(amAppmanage.getAppmanageId(), appDataState, appOldState);
    }

    @Override
    public void updateAppmanageMes(Integer appmanageId, String appmanageApiouturl, String appmanageUrlsuffix, String appmanageTesturl) throws ApiException {
        this.updateAppmanageMesModel(appmanageId, appmanageApiouturl, appmanageUrlsuffix, appmanageTesturl);
        this.refreshCache(this.getAppmanage(appmanageId), false);
    }

    @Override
    public void updateAppmanagePicurl(Integer appmanageId, String appmanagePicurl) throws ApiException {
        this.updateAppmanagePicurlModel(appmanageId, appmanagePicurl);
        this.refreshCache(this.getAppmanage(appmanageId), false);
    }

    private void refreshCache(AmAppmanage amAppmanage, boolean delete) {
        HashMap<String, List<AppProperty>> map = DisUtil.getMapByListJson((String)"EcoreAppmanage-pro", String.class, AppProperty.class);
        if (map == null) {
            map = new HashMap<String, List<AppProperty>>();
        }
        if (delete) {
            this.deleteCache(amAppmanage, map);
        } else {
            this.convert2Property(amAppmanage, map);
        }
        DisUtil.setJsonVer((String)"EcoreAppmanage-pro", map);
    }

    private void deleteCache(AmAppmanage amAppmanage, Map<String, List<AppProperty>> mmap) {
        List<AppProperty> list = mmap.get(amAppmanage.getAppmanageIcode());
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Integer index = null;
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getAppmanageId().equals(amAppmanage.getAppmanageId())) continue;
            index = i;
            break;
        }
        if (index != null) {
            list.remove(index);
        }
    }

    private void convert2Property(AmAppmanage app, Map<String, List<AppProperty>> mmap) {
        List list = MapUtil.getList(mmap, (Object)app.getAppmanageIcode());
        Integer index = null;
        for (int i = 0; i < list.size(); ++i) {
            if (!((AppProperty)list.get(i)).getAppmanageAppkey().equals(app.getAppmanageAppkey())) continue;
            index = i;
            break;
        }
        if (index != null) {
            list.set(index, this.makePro(app));
        } else {
            list.add(this.makePro(app));
        }
    }

    private void convertWar2Property(AmAppwar amAppwar, Map<String, List<AppProperty>> mmap) {
        List list = MapUtil.getList(mmap, (Object)amAppwar.getAppwarIcode());
        Integer index = null;
        for (int i = 0; i < list.size(); ++i) {
            if (!((AppProperty)list.get(i)).getAppmanageAppkey().equals(amAppwar.getAppwarAppkey())) continue;
            index = i;
            break;
        }
        if (index != null) {
            list.set(index, this.makeWarPro(amAppwar));
        } else {
            list.add(this.makeWarPro(amAppwar));
        }
    }

    private void makeWarToAppmanage(AmAppmanage amAppmanage, Map<String, AmAppwarJar> jarMap) {
        if (null == amAppmanage || null == jarMap) {
            return;
        }
        AmAppwarJar amAppwarJar = jarMap.get(amAppmanage.getTenantCode() + "-" + amAppmanage.getAppmanageIcode() + "-" + "0");
        if (null == amAppwarJar) {
            this.logger.error("am.ESB.APPMANAGE.AppmanageServiceImpl.makeWarToAppmanage.amAppwarJar", (Object)(amAppmanage.getTenantCode() + "-" + amAppmanage.getAppmanageIcode() + "-" + "0"));
        } else {
            amAppmanage.setAppmanagePicode(amAppwarJar.getAppwarIcode());
        }
        amAppwarJar = jarMap.get(amAppmanage.getTenantCode() + "-" + amAppmanage.getAppmanageIcode() + "-" + "1");
        if (null != amAppwarJar) {
            amAppmanage.setAppmanageRicode(amAppwarJar.getAppwarIcode());
        }
    }

    @Override
    public void updateAppmanageStateCheck(Integer appmanageId, Integer dataState, Integer oldDataState, String memo, String appmanageExtappcode, String uid) throws ApiException {
        this.updateStateMode(appmanageId, dataState, oldDataState, appmanageExtappcode, uid);
        AmAppmanage app = this.getAppmanage(appmanageId);
        app.setMemo(memo);
        this.updateAppmanageMode(app);
        app.setDataState(dataState);
        app.setMemo(memo);
        this.refreshCache(app, false);
    }

    @Override
    public QueryResult<AmAppmanage> queryAppmanageList(Map<String, Object> map) {
        List<AmAppmanage> appManageList = this.query(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countMroleList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(appManageList);
        return queryResult;
    }

    @Override
    public List<AmAppmanage> queryAppmanageListNopage(Map<String, Object> map) {
        List<AmAppmanage> appManageList = this.query(map);
        return appManageList;
    }

    @Override
    public QueryResult<AmAppmanage> queryOfflineAppmanageList(Map<String, Object> map) {
        List<AmAppmanage> appManageList = this.query(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countMroleList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(appManageList);
        return queryResult;
    }

    @Override
    public QueryResult<AmAppmanage> queryOnlineAppmanageList(Map<String, Object> map) {
        List<AmAppmanage> appManageList = this.query(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countMroleList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(appManageList);
        return queryResult;
    }

    private int countMroleList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.amAppmanageMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("am.ESB.APPMANAGE.AppmanageServiceImpl.countMroleList", (Throwable)e);
        }
        return i;
    }

    @Override
    public AmAppmanage getAppmanage(Integer appmanageId) {
        return this.amAppmanageMapper.selectByPrimaryKey(appmanageId);
    }

    @Override
    public AmAppmanage getAppmanageByAppmanageAppkey(String appmanageAppkey) {
        return this.amAppmanageMapper.selectByAppmanageAppkey(appmanageAppkey);
    }

    @Override
    public void deleteAppmanage(Integer appmanageId) throws ApiException {
        AmAppmanage amAppmanage = this.getAppmanage(appmanageId);
        this.amAppmanageMapper.deleteByPrimaryKey(appmanageId);
        this.refreshCache(amAppmanage, true);
    }

    @Override
    public String generateAppKey() {
        HashMap<String, Object> map;
        RandomId r = new RandomId();
        String appKey = "";
        int i = 0;
        do {
            appKey = r.randomId(99999);
            map = new HashMap<String, Object>();
            map.put("appmanageAppkey", appKey);
        } while ((i = this.countMroleList(map)) > 0);
        return appKey;
    }

    @Override
    public void updateAppmanageOnLineByAppkey(String appmanageAppkey) throws ApiException {
        ConcurrentHashMap<String, String> map = new ConcurrentHashMap<String, String>();
        map.put("scheduleTappkey", appmanageAppkey);
        this.internalRouter.inInvoke("am.job.updateScheduleOpenByTappkey", map);
        DisUtil.setMap((String)"EcoreAppmanage-line", (String)appmanageAppkey, (String)appmanageAppkey);
    }

    @Override
    public void updateAppmanageOffLineByAppkey(String appmanageAppkey) throws ApiException {
        DisUtil.setMap((String)"EcoreAppmanage-line", (String)appmanageAppkey, (String)"");
    }

    @Override
    public void updateNewVersion(Map<String, Object> map) throws ApiException {
        this.amAppmanageMapper.updateNewVersion(map);
    }

    @Override
    public AmAppmanage getAppmanageByExtappcode(Map<String, Object> map) throws ApiException {
        return this.amAppmanageMapper.selectByExtappcode(map);
    }
}

