/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.cache;

import com.yqbsoft.laser.service.esb.cache.RedisCache;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.suppercore.point.RegeditUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Client;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisShardInfo;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPool;
import redis.clients.util.Slowlog;

public class ShardedJedisUtil
implements RedisCache {
    public static final String SYS_CODE = "ecache.CACHE.ShardedJedisUtil";
    public static JedisPool jedisPool;
    private static ShardedJedisPool shardedJedisPool;
    protected final SupperLogUtil logger = new SupperLogUtil(this.getClass());
    private Map<String, String> map;
    private static final String LOCK_SUCCESS = "OK";
    private static final String SET_IF_NOT_EXIST = "NX";
    private static final String SET_WITH_EXPIRE_TIME = "PX";

    public ShardedJedisUtil(Map<String, String> map) {
        this.setMap(map);
        this.initialPool();
        this.initialShardedPool();
    }

    public Map<String, String> getMap() {
        return this.map;
    }

    public void setMap(Map<String, String> map) {
        this.map = map;
    }

    private void initialPool() {
        if (null == this.map) {
            this.map = new HashMap<String, String>();
        }
        String ports = this.map.get("port");
        String ip = this.map.get("ip");
        if (StringUtils.isBlank((String)ports)) {
            ports = "6379";
        }
        if (StringUtils.isBlank((String)ip)) {
            ip = "127.0.0.1";
        }
        ip = RegeditUtil.replaceCacheUrl((String)ip);
        JedisPoolConfig config = this.getConfig();
        this.logger.debug("ShardedJedisUtil.initialShardedPool", (Object)(ip + "==" + ports));
        jedisPool = new JedisPool((GenericObjectPoolConfig)config, ip, Integer.valueOf(ports).intValue(), 5000);
    }

    private JedisPoolConfig getConfig() {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxIdle(50);
        config.setMaxTotal(100);
        config.setMaxWaitMillis(10000L);
        config.setTestOnBorrow(true);
        config.setTestOnReturn(true);
        return config;
    }

    private void initialShardedPool() {
        if (null == this.map) {
            this.map = new HashMap<String, String>();
        }
        String portss = this.map.get("port");
        String ips = this.map.get("ip");
        String names = this.map.get("name");
        String psword = this.map.get("psword");
        if (StringUtils.isBlank((String)portss)) {
            portss = "6379";
        }
        if (StringUtils.isBlank((String)ips)) {
            ips = "127.0.0.1";
        }
        if (StringUtils.isBlank((String)names)) {
            names = "master";
        }
        this.logger.debug("ShardedJedisUtil.initialShardedPool", (Object)(ips + "==" + portss + "==" + names));
        JedisPoolConfig config = this.getConfig();
        ArrayList<JedisShardInfo> shards = new ArrayList<JedisShardInfo>();
        String[] ipsstr = ips.split(";");
        String[] portsstr = portss.split(";");
        String[] namesstr = names.split(";");
        for (int i = 0; i < ipsstr.length; ++i) {
            JedisShardInfo jedisShardInfo = new JedisShardInfo(ipsstr[i], Integer.valueOf(portsstr[i]).intValue(), 5000, namesstr[i]);
            if (StringUtils.isNotBlank((String)psword)) {
                jedisShardInfo.setPassword(psword);
            }
            shards.add(jedisShardInfo);
        }
        shardedJedisPool = new ShardedJedisPool((GenericObjectPoolConfig)config, shards);
    }

    private ShardedJedis getJedis() {
        return shardedJedisPool.getResource();
    }

    private void returnRes(ShardedJedis shardedJedis) {
        shardedJedisPool.returnResource(shardedJedis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addVersion(String key) {
        String value = this.get(key);
        if (StringUtils.isBlank((String)value)) {
            value = "0";
        }
        value = String.valueOf(Integer.valueOf(value) + 1);
        ShardedJedis shardedJedis = this.getJedis();
        try {
            shardedJedis.set(key, value);
        }
        catch (Exception e) {
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    @Override
    public boolean checkVersion(String key, String value) {
        String oldValue = this.get(key);
        if (StringUtils.isBlank((String)oldValue)) {
            oldValue = "0";
        }
        if (StringUtils.isBlank((String)value)) {
            value = "0";
        }
        return Integer.valueOf(oldValue) - Integer.valueOf(value) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(String key, String value) {
        this.addVersion(key + "-ver");
        ShardedJedis shardedJedis = shardedJedisPool.getResource();
        try {
            shardedJedis.set(key, value);
        }
        catch (Exception e) {
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(String key, String value) {
        this.addVersion(key + "-ver");
        ShardedJedis shardedJedis = this.getJedis();
        try {
            shardedJedis.append(key, value);
        }
        catch (Exception e) {
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String key) {
        ShardedJedis shardedJedis = shardedJedisPool.getResource();
        try {
            String res;
            String string = res = shardedJedis.get(key);
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void del(String key) {
        this.addVersion(key + "-ver");
        ShardedJedis shardedJedis = this.getJedis();
        try {
            shardedJedis.del(key);
        }
        catch (Exception exception) {
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVer(String key, String value) {
        this.addVersion(key + "-ver");
        ShardedJedis shardedJedis = this.getJedis();
        try {
            shardedJedis.set(key, value);
        }
        catch (Exception e) {
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendVer(String key, String value) {
        this.addVersion(key + "-ver");
        ShardedJedis shardedJedis = this.getJedis();
        try {
            shardedJedis.append(key, value);
        }
        catch (Exception e) {
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delVer(String key) {
        this.addVersion(key + "-ver");
        ShardedJedis shardedJedis = this.getJedis();
        try {
            shardedJedis.del(key);
        }
        catch (Exception exception) {
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setList(String key, String ... strings) {
        this.addVersion(key + "-ver");
        ShardedJedis shardedJedis = this.getJedis();
        try {
            shardedJedis.rpush(key, strings);
        }
        catch (Exception e) {
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getList(String key, long start, long end) {
        ShardedJedis shardedJedis = this.getJedis();
        try {
            List res;
            List list = res = shardedJedis.lrange(key, start, end);
            return list;
        }
        catch (Exception e) {
            List<String> list = null;
            return list;
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String lpop(String key) {
        ShardedJedis shardedJedis = this.getJedis();
        try {
            String res;
            String string = res = shardedJedis.lpop(key);
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String rpop(String key) {
        ShardedJedis shardedJedis = this.getJedis();
        try {
            String res;
            String string = res = shardedJedis.rpop(key);
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> blpop(String key) {
        ShardedJedis shardedJedis = this.getJedis();
        try {
            List res;
            List list = res = shardedJedis.blpop(key);
            return list;
        }
        catch (Exception e) {
            List<String> list = null;
            return list;
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> brpop(String key) {
        ShardedJedis shardedJedis = this.getJedis();
        try {
            List res;
            List list = res = shardedJedis.brpop(key);
            return list;
        }
        catch (Exception e) {
            List<String> list = null;
            return list;
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setListVer(String key, String ... strings) {
        this.addVersion(key + "-ver");
        ShardedJedis shardedJedis = this.getJedis();
        try {
            shardedJedis.rpush(key, strings);
        }
        catch (Exception e) {
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMap(String key, String field, String value) {
        this.addVersion(key + "-ver");
        ShardedJedis shardedJedis = this.getJedis();
        try {
            shardedJedis.hset(key, field, value);
        }
        catch (Exception e) {
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMap(String key, String field) {
        ShardedJedis shardedJedis = this.getJedis();
        try {
            String res;
            String string = res = shardedJedis.hget(key, field);
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getMapAll(String key) {
        ShardedJedis shardedJedis = this.getJedis();
        try {
            Map res;
            Map map = res = shardedJedis.hgetAll(key);
            return map;
        }
        catch (Exception e) {
            Map<String, String> map = null;
            return map;
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getMap(String key, String ... fields) {
        ShardedJedis shardedJedis = this.getJedis();
        try {
            List res;
            List list = res = shardedJedis.hmget(key, fields);
            return list;
        }
        catch (Exception e) {
            List<String> list = null;
            return list;
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delMap(String key, String ... fields) {
        this.addVersion(key + "-ver");
        ShardedJedis shardedJedis = this.getJedis();
        try {
            shardedJedis.hdel(key, fields);
        }
        catch (Exception e) {
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMap(String key, Map<String, String> hash) {
        this.addVersion(key + "-ver");
        ShardedJedis shardedJedis = this.getJedis();
        try {
            shardedJedis.del(key);
            shardedJedis.hmset(key, hash);
        }
        catch (Exception e) {
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMapVer(String key, String field, String value) {
        this.addVersion(key + "-ver");
        ShardedJedis shardedJedis = this.getJedis();
        try {
            shardedJedis.hset(key, field, value);
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delMapVer(String key, String ... fields) {
        this.addVersion(key + "-ver");
        ShardedJedis shardedJedis = this.getJedis();
        try {
            shardedJedis.hdel(key, fields);
        }
        catch (Exception e) {
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMapVer(String key, Map<String, String> hash) {
        this.addVersion(key + "-ver");
        ShardedJedis shardedJedis = this.getJedis();
        try {
            shardedJedis.del(key);
            shardedJedis.hmset(key, hash);
        }
        catch (Exception e) {
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getJedisConfig(String key) {
        Client client = null;
        ShardedJedis shardedJedis = null;
        try {
            shardedJedis = this.getJedis();
            Jedis jedis = (Jedis)shardedJedis.getShard(key);
            client = jedis.getClient();
            if (null == client) {
                String string = null;
                return string;
            }
            client.info();
            String string = client.getBulkReply();
            return string;
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.ShardedJedisUtil.getJedisConfig.ex", (Throwable)e);
        }
        finally {
            if (null != shardedJedis) {
                this.returnRes(shardedJedis);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Slowlog> getShowLog(String key) {
        ShardedJedis shardedJedis = null;
        try {
            shardedJedis = this.getJedis();
            Jedis jedis = (Jedis)shardedJedis.getShard(key);
            List list = jedis.slowlogGet();
            return list;
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.ShardedJedisUtil.getJedisConfig.ex", (Throwable)e);
        }
        finally {
            if (null != shardedJedis) {
                this.returnRes(shardedJedis);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getDbSize(String key) {
        Client client = null;
        ShardedJedis shardedJedis = null;
        try {
            shardedJedis = this.getJedis();
            Jedis jedis = (Jedis)shardedJedis.getShard(key);
            client = jedis.getClient();
            if (null == client) {
                long l = 0L;
                return l;
            }
            client.dbSize();
            long l = client.getIntegerReply();
            return l;
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.ShardedJedisUtil.getJedisConfig.ex", (Throwable)e);
        }
        finally {
            if (null != shardedJedis) {
                this.returnRes(shardedJedis);
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getAllKeys(String key) {
        ShardedJedis shardedJedis = null;
        Set s = null;
        try {
            shardedJedis = this.getJedis();
            shardedJedis.getAllShards();
            Jedis jedis = (Jedis)shardedJedis.getShard(key);
            s = jedis.keys(key);
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.ShardedJedisUtil.getJedisConfig.ex", (Throwable)e);
        }
        finally {
            if (null != shardedJedis) {
                this.returnRes(shardedJedis);
            }
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sadd(String key, String ... values) {
        this.addVersion(key + "-ver");
        ShardedJedis shardedJedis = this.getJedis();
        try {
            shardedJedis.sadd(key, values);
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> smembers(String key) {
        ShardedJedis shardedJedis = this.getJedis();
        try {
            Set set = shardedJedis.smembers(key);
            return set;
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String spop(String key) {
        ShardedJedis shardedJedis = this.getJedis();
        try {
            String string = shardedJedis.spop(key);
            return string;
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(String key, String value, int expires) {
        this.addVersion(key + "-ver");
        ShardedJedis shardedJedis = shardedJedisPool.getResource();
        try {
            shardedJedis.set(key, value);
            shardedJedis.expire(key, expires);
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryGetDistributedLock(String lockKey, String requestId, int expireTime) {
        ShardedJedis shardedJedis = shardedJedisPool.getResource();
        try {
            String result = shardedJedis.set(lockKey, requestId, SET_IF_NOT_EXIST, SET_WITH_EXPIRE_TIME, (long)expireTime);
            if (LOCK_SUCCESS.equals(result)) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.returnRes(shardedJedis);
        }
        return false;
    }
}

