/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.cache.local;

import com.yqbsoft.laser.service.esb.cache.local.CacheUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;

public class LocalCache {
    public static final String SYS_CODE = "ecache.CACHE.local.LocalCache";
    protected final SupperLogUtil logger = new SupperLogUtil(this.getClass());
    public Cache cache;
    private String cacheName;
    private String cacheManagerName;
    private CacheManager cacheManager;

    public LocalCache(String name, String cmName) {
        this.setCacheManager(CacheUtil.cmap.get(cmName));
        if (null == this.getCacheManager()) {
            CacheUtil.create();
            this.setCacheManager(CacheUtil.cmap.get(cmName));
            if (null == this.getCacheManager()) {
                this.logger.error("ecache.CACHE.local.LocalCache.LocalCache", (Object)(cmName + " is null"));
                return;
            }
        }
        this.setCacheName(name);
        this.setCacheManagerName(cmName);
        CacheConfiguration cacheConfiguration = new CacheConfiguration(name, 500).overflowToDisk(true).eternal(true).timeToLiveSeconds(0L).timeToIdleSeconds(0L);
        cacheConfiguration.setDiskSpoolBufferSizeMB(1024);
        cacheConfiguration.setDiskPersistent(true);
        this.setCache(new Cache(cacheConfiguration));
        this.getCacheManager().addCache(this.cache);
    }

    public Cache getCache() {
        return this.cache;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public String getCacheManagerName() {
        return this.cacheManagerName;
    }

    public void setCacheManagerName(String cacheManagerName) {
        this.cacheManagerName = cacheManagerName;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public void put(Object objKey, Object objValue) {
        Element el = this.getCache().get(objKey);
        if (null != el) {
            this.getCache().remove(objKey);
        }
        this.getCache().put(new Element(objKey, objValue));
    }

    public final Object get(Object objKey) {
        Element el = this.getCache().get(objKey);
        if (null == el) {
            return null;
        }
        return el.getObjectValue();
    }

    public void putMap(String objKey, String field, String value) {
        ConcurrentHashMap<String, String> objValue = (ConcurrentHashMap<String, String>)this.get(objKey);
        if (null == objValue) {
            objValue = new ConcurrentHashMap<String, String>();
            this.put(objKey, objValue);
        }
        objValue.put(field, value);
    }

    public void putMapAll(String objKey, Map<String, String> value) {
        this.put(objKey, value);
    }

    public final String getMap(String objKey, String field) {
        Map objValue = (Map)this.get(objKey);
        if (null == objValue) {
            return null;
        }
        return (String)objValue.get(field);
    }

    public final List<String> getMap(String objKey, String ... fields) {
        if (null == fields) {
            return null;
        }
        Map objValue = (Map)this.get(objKey);
        if (null == objValue) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String string : fields) {
            list.add((String)objValue.get(string));
        }
        return list;
    }

    public final Map<String, String> getMapAll(String objKey) {
        return (Map)this.get(objKey);
    }

    public void del(String objKey) {
        try {
            this.getCache().remove((Serializable)((Object)objKey));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void delMap(String objKey, String ... fields) {
        if (null == fields) {
            return;
        }
        Map objValue = (Map)this.get(objKey);
        if (null == objValue) {
            return;
        }
        for (String string : fields) {
            objValue.remove(string);
        }
    }
}

