/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.cache;

import com.fasterxml.jackson.core.type.TypeReference;
import com.yqbsoft.laser.service.esb.cache.RedisUtil;
import com.yqbsoft.laser.service.esb.cache.local.LocalCache;
import com.yqbsoft.laser.service.suppercore.cache.dis.DisCache;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class DisCacheImpl
implements DisCache {
    protected final SupperLogUtil logger = new SupperLogUtil(this.getClass());
    private static final Long SYNC_TIME = 120000L;
    private static final String stringCache = "StringCache";
    private static final String mapCache = "MapCache";
    private static final String OBJECT_CACHE = "ObjectCache";
    private Map<String, String> versionMap = new ConcurrentHashMap<String, String>();
    private Map<String, Long> timeMap = new ConcurrentHashMap<String, Long>();
    private Map<String, Long> timeValueMap = new ConcurrentHashMap<String, Long>();
    private LocalCache stringLocalCache = new LocalCache("StringCache", "defcmname");
    public LocalCache mapLocalCache = new LocalCache("MapCache", "defcmname");
    private LocalCache objectLocalCache = new LocalCache("ObjectCache", "defcmname");

    public Map<String, Long> getTimeValueMap() {
        return this.timeValueMap;
    }

    public void setTimeValueMap(Map<String, Long> timeValueMap) {
        this.timeValueMap = timeValueMap;
    }

    public Map<String, String> getVersionMap() {
        return this.versionMap;
    }

    public void setVersionMap(Map<String, String> versionMap) {
        this.versionMap = versionMap;
    }

    public Map<String, Long> getTimeMap() {
        return this.timeMap;
    }

    public void setTimeMap(Map<String, Long> timeMap) {
        this.timeMap = timeMap;
    }

    private Long getSyncTime(String key) {
        Long syncTime = this.getTimeValueMap().get(key);
        if (null == syncTime) {
            String st = RedisUtil.getRedisUtil().getMap("synctimer", key);
            syncTime = StringUtils.isBlank((String)st) ? SYNC_TIME : Long.valueOf(st);
            this.getTimeValueMap().put(key, syncTime);
        }
        return syncTime;
    }

    private boolean exesync(String key, String field, Long ctime) {
        boolean sync = false;
        if (this.rometflag(key)) {
            return true;
        }
        Long vtime = this.getTimeMap().get(key + "-" + field);
        Long syncTime = this.getSyncTime(key);
        if (null == syncTime) {
            syncTime = SYNC_TIME;
        }
        if ("0".equals(String.valueOf(syncTime))) {
            return false;
        }
        if (vtime == null || ctime - vtime >= syncTime) {
            String ver = RedisUtil.getRedisUtil().get(key + "-ver");
            if (StringUtils.isBlank((String)ver)) {
                ver = "0";
            }
            if (null == this.getVersionMap().get(key) || !this.getVersionMap().get(key).equals(ver)) {
                sync = true;
            } else if (null == this.getVersionMap().get(key + "-" + field) || !this.getVersionMap().get(key + "-" + field).equals(ver)) {
                sync = true;
            }
        }
        return sync;
    }

    private void exesyncUpdate(String key, String field, Long ctime) {
        this.getTimeMap().put(key + "-" + field, ctime);
        String ver = RedisUtil.getRedisUtil().get(key + "-ver");
        if (StringUtils.isBlank((String)ver)) {
            ver = "0";
        }
        this.getVersionMap().put(key + "-" + field, ver);
    }

    private void exesyncUpdate(String key, Long ctime) {
        this.getTimeMap().put(key, ctime);
        String ver = RedisUtil.getRedisUtil().get(key + "-ver");
        if (StringUtils.isBlank((String)ver)) {
            ver = "0";
        }
        this.getVersionMap().put(key, ver);
    }

    private boolean exesync(String key, Long ctime) {
        boolean sync = false;
        if (this.rometflag(key)) {
            return true;
        }
        Long vtime = this.getTimeMap().get(key);
        Long syncTime = this.getSyncTime(key);
        if (null == syncTime) {
            syncTime = SYNC_TIME;
        }
        if ("0".equals(String.valueOf(syncTime))) {
            return false;
        }
        if (vtime == null || ctime - vtime >= syncTime) {
            String ver = RedisUtil.getRedisUtil().get(key + "-ver");
            if (StringUtils.isBlank((String)ver)) {
                ver = "0";
            }
            if (null == this.getVersionMap().get(key) || !this.getVersionMap().get(key).equals(ver)) {
                sync = true;
            }
        }
        return sync;
    }

    private boolean rometflag(String key) {
        Long syncTime = this.getSyncTime(key);
        return "-1".equals(String.valueOf(syncTime));
    }

    public void set(String key, String value) {
        RedisUtil.getRedisUtil().set(key, value);
    }

    public void setJson(String key, Object value) {
        RedisUtil.getRedisUtil().set(key, JsonUtil.buildNormalBinder().toJson(value));
    }

    public void setJsonVer(String key, Object value) {
        RedisUtil.getRedisUtil().addVersion(key + "-ver");
        RedisUtil.getRedisUtil().set(key, JsonUtil.buildNormalBinder().toJson(value));
    }

    public void append(String key, String value) {
        RedisUtil.getRedisUtil().append(key, value);
    }

    public String get(String key) {
        if (this.rometflag(key)) {
            return RedisUtil.getRedisUtil().get(key);
        }
        String obj = (String)this.stringLocalCache.get(key);
        Long ctime = System.currentTimeMillis();
        if (this.exesync(key, ctime)) {
            obj = RedisUtil.getRedisUtil().get(key);
            if (null != obj) {
                this.stringLocalCache.put(key, obj);
                this.exesyncUpdate(key, ctime);
            } else {
                this.stringLocalCache.del(key);
                this.exesyncUpdate(key, ctime);
            }
        }
        return obj;
    }

    public String getRemot(String key) {
        String obj = RedisUtil.getRedisUtil().get(key);
        return obj;
    }

    public <T> T getRemot(String key, Class<T> classz, FormatJson formatJson) {
        T object = null;
        String json = this.getRemot(key);
        if (StringUtils.isBlank((String)json)) {
            return null;
        }
        object = formatJson.format(json, classz);
        return object;
    }

    public <T> T get(String key, Class<T> classz, FormatJson formatJson) {
        Object object = null;
        if (!this.rometflag(key)) {
            Long ctime = System.currentTimeMillis();
            if (this.exesync(key, ctime)) {
                object = this.getRemot(key, classz, formatJson);
                if (null != object) {
                    this.objectLocalCache.put(key, object);
                    this.exesyncUpdate(key, ctime);
                } else {
                    this.objectLocalCache.del(key);
                    this.exesyncUpdate(key, ctime);
                }
            } else {
                object = this.objectLocalCache.get(key);
            }
        } else {
            object = this.getRemot(key, classz, formatJson);
        }
        return (T)object;
    }

    public <T> T getCache(String key, Class<T> classz, FormatJson formatJson) {
        T object = null;
        String json = this.get(key);
        if (StringUtils.isBlank((String)json)) {
            return null;
        }
        object = formatJson.format(json, classz);
        return object;
    }

    public List getListJson(String key, final Class clazz) {
        List object = this.get(key, List.class, new FormatJson(){

            @Override
            <T> T format(String json, Class<T> classz) {
                return (T)JsonUtil.buildNormalBinder().getJsonToList(json, clazz);
            }
        });
        return object;
    }

    public List getListByMapJson(String key, final Class clazz) {
        List object = this.get(key, List.class, new FormatJson(){

            @Override
            <T> T format(String json, Class<T> classz) {
                return (T)JsonUtil.buildNormalBinder().getJsonToListByMap(json, clazz);
            }
        });
        return object;
    }

    public Object getObjectJson(String key, final Class clazz) {
        Object object = this.get(key, Object.class, new FormatJson(){

            @Override
            <T> T format(String json, Class<T> classz) {
                return (T)JsonUtil.buildNormalBinder().getJsonToObject(json, clazz);
            }
        });
        return object;
    }

    public Map getMapJson(String key, final Class keyclazz, final Class valueclazz) {
        Map object = this.get(key, Map.class, new FormatJson(){

            @Override
            <T> T format(String json, Class<T> classz) {
                return (T)JsonUtil.buildNormalBinder().getJsonToMap(json, keyclazz, valueclazz);
            }
        });
        return object;
    }

    public Map getConcMapJson(String key, final Class keyclazz, final Class valueclazz) {
        Map object = this.get(key, Map.class, new FormatJson(){

            @Override
            <T> T format(String json, Class<T> classz) {
                return (T)JsonUtil.buildNormalBinder().getJsonToConcMap(json, keyclazz, valueclazz);
            }
        });
        return object;
    }

    public <T> Object getObject(String key, final TypeReference<T> typeReference) {
        Object object = this.get(key, Object.class, new FormatJson(){

            <K> K format(String json, Class<K> classz) {
                return (K)JsonUtil.buildNormalBinder().getJsonToObject(json, typeReference);
            }
        });
        return object;
    }

    public Map getMapByListJson(String key, final Class keyclazz, final Class valueclazz) {
        Map object = this.get(key, Map.class, new FormatJson(){

            @Override
            <T> T format(String json, Class<T> classz) {
                return (T)JsonUtil.buildNormalBinder().getJsonToMapByList(json, keyclazz, valueclazz);
            }
        });
        return object;
    }

    public Map getRemotMapByListJson(String key, final Class keyclazz, final Class valueclazz) {
        Map object = this.getRemot(key, Map.class, new FormatJson(){

            @Override
            <T> T format(String json, Class<T> classz) {
                return (T)JsonUtil.buildNormalBinder().getJsonToMapByList(json, keyclazz, valueclazz);
            }
        });
        return object;
    }

    public Map getMapByMapJson(String key, final Class keyclazz, final Class valueclazz) {
        Map object = this.get(key, Map.class, new FormatJson(){

            @Override
            <T> T format(String json, Class<T> classz) {
                return (T)JsonUtil.buildNormalBinder().getJsonToMapByMap(json, keyclazz, valueclazz);
            }
        });
        return object;
    }

    public void del(String key) {
        this.delCache(key);
        RedisUtil.getRedisUtil().delVer(key);
    }

    public void delCache(String key) {
        this.stringLocalCache.del(key);
        this.mapLocalCache.del(key);
        this.objectLocalCache.del(key);
    }

    public void setVer(String key, String value) {
        RedisUtil.getRedisUtil().setVer(key, value);
    }

    public void appendVer(String key, String value) {
        RedisUtil.getRedisUtil().appendVer(key, value);
    }

    public void delVer(String key) {
        RedisUtil.getRedisUtil().delVer(key);
        this.delCache(key);
    }

    public void setList(String key, String ... strings) {
        RedisUtil.getRedisUtil().setList(key, strings);
    }

    public void setListVer(String key, String ... strings) {
        RedisUtil.getRedisUtil().setListVer(key, strings);
    }

    public List<String> blpop(String key) {
        return RedisUtil.getRedisUtil().blpop(key);
    }

    public List<String> brpop(String key) {
        return RedisUtil.getRedisUtil().brpop(key);
    }

    public List<String> getList(String key, long start, long end) {
        return RedisUtil.getRedisUtil().getList(key, start, end);
    }

    public String lpop(String key) {
        return RedisUtil.getRedisUtil().lpop(key);
    }

    public String rpop(String key) {
        return RedisUtil.getRedisUtil().rpop(key);
    }

    public void setMap(String key, String field, String value) {
        if (null == field || "".equals(field)) {
            return;
        }
        RedisUtil.getRedisUtil().setMap(key, field, value);
    }

    public String getRemotMap(String key, String field) {
        return RedisUtil.getRedisUtil().getMap(key, field);
    }

    public String getMap(String key, String field) {
        if (this.rometflag(key)) {
            return RedisUtil.getRedisUtil().getMap(key, field);
        }
        Long ctime = System.currentTimeMillis();
        String obj = null;
        if ("UpMenu-menuCode".equals(key)) {
            this.logger.error("======1===" + key + "=" + field);
        }
        if (this.exesync(key, "map-" + field, ctime)) {
            obj = RedisUtil.getRedisUtil().getMap(key, field);
            if (StringUtils.isBlank((String)obj)) {
                this.mapLocalCache.del(key);
                this.exesyncUpdate(key, "map-" + field, ctime);
            } else {
                this.mapLocalCache.putMap(key, field, obj);
                this.exesyncUpdate(key, "map-" + field, ctime);
            }
            if ("UpMenu-menuCode".equals(key)) {
                this.logger.error("======2===" + key + "=" + field + "=" + obj);
            }
        } else {
            obj = this.mapLocalCache.getMap(key, field);
            if ("UpMenu-menuCode".equals(key)) {
                this.logger.error("======3===" + key + "=" + field + "=" + obj);
            }
        }
        return obj;
    }

    public static void main(String[] args) {
        DisCacheImpl a = new DisCacheImpl();
        a.mapLocalCache.putMap("a", "b", "c");
        System.out.println(a.mapLocalCache.getMap("a", "b"));
    }

    public List<?> getMapListJson(String key, String field, Class<?> keyclazz) {
        List obj = null;
        if (!this.rometflag(key)) {
            Long ctime = System.currentTimeMillis();
            if (this.exesync(key, field, ctime)) {
                String json = RedisUtil.getRedisUtil().getMap(key, field);
                if (null != json) {
                    obj = (List)JsonUtil.buildNormalBinder().getJsonToList(json, keyclazz);
                    this.objectLocalCache.put(key + "-" + field, obj);
                    this.exesyncUpdate(key, field, ctime);
                } else {
                    obj = null;
                    this.objectLocalCache.del(key + "-" + field);
                    this.exesyncUpdate(key, field, ctime);
                }
            } else {
                obj = (List)this.objectLocalCache.get(key + "-" + field);
            }
        } else {
            String json = RedisUtil.getRedisUtil().getMap(key, field);
            obj = null != json ? (List)JsonUtil.buildNormalBinder().getJsonToList(json, keyclazz) : null;
        }
        return obj;
    }

    public Map<?, ?> getMapMapJson(String key, String field, Class<?> keyclazz, Class<?> keyclazzy) {
        Map obj = null;
        if (!this.rometflag(key)) {
            Long ctime = System.currentTimeMillis();
            if (this.exesync(key, field, ctime)) {
                String json = RedisUtil.getRedisUtil().getMap(key, field);
                if (null != json) {
                    obj = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, keyclazz, keyclazzy);
                    this.objectLocalCache.put(key + "-" + field, obj);
                    this.exesyncUpdate(key, field, ctime);
                } else {
                    obj = null;
                    this.objectLocalCache.del(key + "-" + field);
                    this.exesyncUpdate(key, field, ctime);
                }
            } else {
                obj = (Map)this.objectLocalCache.get(key + "-" + field);
            }
        } else {
            String json = RedisUtil.getRedisUtil().getMap(key, field);
            obj = null != json ? (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, keyclazz, keyclazzy) : null;
        }
        return obj;
    }

    public <T> Object getMapJson(String key, String field, Class<T> keyclazz) {
        Object obj = null;
        if (!this.rometflag(key)) {
            Long ctime = System.currentTimeMillis();
            if (this.exesync(key, field, ctime)) {
                String json = RedisUtil.getRedisUtil().getMap(key, field);
                if (null != json) {
                    obj = JsonUtil.buildNormalBinder().getJsonToObject(json, keyclazz);
                    this.objectLocalCache.put(key + "-" + field, obj);
                    this.exesyncUpdate(key, field, ctime);
                } else {
                    obj = null;
                    this.objectLocalCache.del(key + "-" + field);
                    this.exesyncUpdate(key, field, ctime);
                }
            } else {
                obj = this.objectLocalCache.get(key + "-" + field);
            }
        } else {
            String json = RedisUtil.getRedisUtil().getMap(key, field);
            obj = null != json ? JsonUtil.buildNormalBinder().getJsonToObject(json, keyclazz) : null;
        }
        return obj;
    }

    public Map<String, String> getRemotMapAll(String key) {
        return RedisUtil.getRedisUtil().getMapAll(key);
    }

    public Map<String, String> getMapAll(String key) {
        if (this.rometflag(key)) {
            return RedisUtil.getRedisUtil().getMapAll(key);
        }
        Map<String, String> obj = this.mapLocalCache.getMapAll(key);
        Long ctime = System.currentTimeMillis();
        if (this.exesync(key, ctime)) {
            obj = RedisUtil.getRedisUtil().getMapAll(key);
            if (null != obj) {
                this.mapLocalCache.putMapAll(key, obj);
                this.exesyncUpdate(key, ctime);
            } else {
                this.mapLocalCache.del(key);
                this.exesyncUpdate(key, ctime);
            }
        }
        return obj;
    }

    public List<String> getMap(String key, String ... fields) {
        return RedisUtil.getRedisUtil().getMap(key, fields);
    }

    public void delMap(String key, String ... fields) {
        RedisUtil.getRedisUtil().delMap(key, fields);
        this.delCache(key);
    }

    public void setMap(String key, Map<String, String> hash) {
        if (null == hash || hash.isEmpty()) {
            return;
        }
        RedisUtil.getRedisUtil().setMap(key, hash);
    }

    public void setMapVer(String key, String field, String value) {
        if (null == field || "".equals(field)) {
            return;
        }
        RedisUtil.getRedisUtil().setMapVer(key, field, value);
    }

    public void delMapVer(String key, String ... fields) {
        RedisUtil.getRedisUtil().delMapVer(key, fields);
        this.delCache(key);
    }

    public void setMapVer(String key, Map<String, String> hash) {
        if (null == hash || hash.isEmpty()) {
            return;
        }
        RedisUtil.getRedisUtil().setMapVer(key, hash);
    }

    public void sadd(String key, String ... values) {
        RedisUtil.getRedisUtil().sadd(key, values);
    }

    public Set<String> smembers(String key) {
        return RedisUtil.getRedisUtil().smembers(key);
    }

    public String spop(String key) {
        return RedisUtil.getRedisUtil().spop(key);
    }

    public void set(String key, String value, int expires) {
        RedisUtil.getRedisUtil().set(key, value, expires);
    }

    public void setJson(String key, Object value, int expires) {
        RedisUtil.getRedisUtil().set(key, JsonUtil.buildNormalBinder().toJson(value), expires);
    }

    abstract class FormatJson {
        FormatJson() {
        }

        abstract <T> T format(String var1, Class<T> var2);
    }
}

