/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.cache;

import com.yqbsoft.laser.service.esb.cache.JedisSentineUtil;
import com.yqbsoft.laser.service.esb.cache.RedisCache;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisCommands;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.util.Slowlog;

public class ClusterJedisUtil
extends JedisSentineUtil
implements RedisCache {
    private JedisCluster jedisCluster;
    private Map<String, String> map;

    @Override
    public void setMap(Map<String, String> map) {
        this.map = map;
    }

    public ClusterJedisUtil(Map<String, String> map) {
        this.logger.info("\u521d\u59cb\u5316ClusterJedisUtil\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
        this.setMap(map);
        this.iniClusterJedisPool();
        this.logger.info("\u521d\u59cb\u5316ClusterJedisUtil \u5b8c\u6210    \u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
    }

    private void iniClusterJedisPool() {
        HashSet<HostAndPort> configSet = new HashSet<HostAndPort>();
        if (null == this.map) {
            this.map = new HashMap<String, String>();
        }
        String portss = this.map.get("port");
        String ips = this.map.get("ip");
        String names = this.map.get("name");
        String psword = this.map.get("psword");
        if (StringUtils.isBlank((String)portss)) {
            portss = "6379";
        }
        if (StringUtils.isBlank((String)ips)) {
            ips = "127.0.0.1";
        }
        if (StringUtils.isBlank((String)names)) {
            names = "master";
        }
        String[] ipsstr = ips.split(";");
        String[] portsstr = portss.split(";");
        for (int i = 0; i < ipsstr.length; ++i) {
            HostAndPort hostAndPort = new HostAndPort(ipsstr[i], Integer.valueOf(portsstr[i]).intValue());
            configSet.add(hostAndPort);
            this.logger.info("ip : >>>>>>>>>>>>>>>>" + ipsstr[i] + "     port>>>>>>>" + portsstr[i]);
        }
        this.jedisCluster = new JedisCluster(configSet, (GenericObjectPoolConfig)this.getConfig());
        if (StringUtils.isNotBlank((String)psword)) {
            this.jedisCluster.auth(psword);
        }
    }

    private JedisPoolConfig getConfig() {
        JedisPoolConfig config = new JedisPoolConfig();
        config.setMaxIdle(50);
        config.setMaxTotal(100);
        config.setMaxWaitMillis(10000L);
        config.setTestOnBorrow(true);
        config.setTestOnReturn(true);
        return config;
    }

    @Override
    protected void returnRes(JedisCommands resource) {
    }

    @Override
    protected JedisCommands getJedis() {
        return this.jedisCluster;
    }

    @Override
    public String getJedisConfig(String key) {
        return "cluster";
    }

    @Override
    public List<Slowlog> getShowLog(String key) {
        return new ArrayList<Slowlog>();
    }

    @Override
    public long getDbSize(String key) {
        return 0L;
    }

    @Override
    public Set<String> getAllKeys(String key) {
        return this.jedisCluster.hkeys(key);
    }
}

