/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.cache;

import com.yqbsoft.laser.service.esb.cache.RedisCache;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.jedis.Client;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCommands;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.util.Slowlog;

public class JedisSentineUtil
implements RedisCache {
    public static final String SYS_CODE = "ecache.CACHE.JedisSentineUtil";
    private static JedisSentinelPool jedisSentinelPool;
    protected SupperLogUtil logger = new SupperLogUtil(JedisSentineUtil.class);
    private Map<String, String> map;
    private static final String LOCK_SUCCESS = "OK";
    private static final String SET_IF_NOT_EXIST = "NX";
    private static final String SET_WITH_EXPIRE_TIME = "PX";
    private static final Long RELEASE_SUCCESS;

    public JedisSentineUtil() {
    }

    public JedisSentineUtil(Map<String, String> map) {
        this.setMap(map);
        this.iniJedisSentinelPool();
    }

    public Map<String, String> getMap() {
        return this.map;
    }

    public void setMap(Map<String, String> map) {
        this.map = map;
    }

    private void iniJedisSentinelPool() {
        if (null == this.map) {
            this.map = new HashMap<String, String>();
        }
        String portss = this.map.get("port");
        String ips = this.map.get("ip");
        String names = this.map.get("name");
        String psword = this.map.get("psword");
        if (StringUtils.isBlank((String)portss)) {
            portss = "26379";
        }
        if (StringUtils.isBlank((String)ips)) {
            ips = "127.0.0.1";
        }
        if (StringUtils.isBlank((String)names)) {
            names = "mymaster";
        }
        HashSet<String> sentinels = new HashSet<String>();
        String[] ipsstr = ips.split(";");
        String[] portsstr = portss.split(";");
        for (int i = 0; i < ipsstr.length; ++i) {
            sentinels.add(ipsstr[i] + ":" + Integer.valueOf(portsstr[i]));
        }
        this.logger.info("RedisUtil.iniJedisSentinelPool", (Object)(names + ":" + ((Object)sentinels).toString()));
        jedisSentinelPool = StringUtils.isNotBlank((String)psword) ? new JedisSentinelPool(names, sentinels, psword) : new JedisSentinelPool(names, sentinels);
    }

    protected JedisCommands getJedis() {
        return jedisSentinelPool.getResource();
    }

    protected void returnRes(JedisCommands resource) {
        jedisSentinelPool.returnResource((Jedis)resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addVersion(String key) {
        String value = this.get(key);
        if (StringUtils.isBlank((String)value)) {
            value = "0";
        }
        value = String.valueOf(Integer.valueOf(value) + 1);
        JedisCommands resource = this.getJedis();
        try {
            resource.set(key, value);
        }
        finally {
            this.returnRes(resource);
        }
    }

    @Override
    public boolean checkVersion(String key, String value) {
        String oldValue = this.get(key);
        if (StringUtils.isBlank((String)oldValue)) {
            oldValue = "0";
        }
        if (StringUtils.isBlank((String)value)) {
            value = "0";
        }
        return Integer.valueOf(oldValue) - Integer.valueOf(value) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(String key, String value) {
        this.addVersion(key + "-ver");
        JedisCommands shardedJedis = this.getJedis();
        try {
            shardedJedis.set(key, value);
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(String key, String value) {
        this.addVersion(key + "-ver");
        JedisCommands shardedJedis = this.getJedis();
        try {
            shardedJedis.append(key, value);
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String key) {
        JedisCommands shardedJedis = this.getJedis();
        try {
            String res;
            String string = res = shardedJedis.get(key);
            return string;
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void del(String key) {
        this.addVersion(key + "-ver");
        JedisCommands shardedJedis = this.getJedis();
        try {
            shardedJedis.del(key);
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVer(String key, String value) {
        this.addVersion(key + "-ver");
        JedisCommands shardedJedis = this.getJedis();
        try {
            shardedJedis.set(key, value);
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendVer(String key, String value) {
        this.addVersion(key + "-ver");
        JedisCommands shardedJedis = this.getJedis();
        try {
            shardedJedis.append(key, value);
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delVer(String key) {
        this.addVersion(key + "-ver");
        JedisCommands shardedJedis = this.getJedis();
        try {
            shardedJedis.del(key);
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setList(String key, String ... strings) {
        this.addVersion(key + "-ver");
        JedisCommands shardedJedis = this.getJedis();
        try {
            shardedJedis.rpush(key, strings);
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getList(String key, long start, long end) {
        JedisCommands shardedJedis = this.getJedis();
        try {
            List res;
            List list = res = shardedJedis.lrange(key, start, end);
            return list;
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String lpop(String key) {
        JedisCommands shardedJedis = this.getJedis();
        try {
            String res;
            String string = res = shardedJedis.lpop(key);
            return string;
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String rpop(String key) {
        JedisCommands shardedJedis = this.getJedis();
        try {
            String res;
            String string = res = shardedJedis.rpop(key);
            return string;
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> blpop(String key) {
        JedisCommands shardedJedis = this.getJedis();
        try {
            List res;
            List list = res = shardedJedis.blpop(key);
            return list;
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> brpop(String key) {
        JedisCommands shardedJedis = this.getJedis();
        try {
            List res;
            List list = res = shardedJedis.brpop(key);
            return list;
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setListVer(String key, String ... strings) {
        this.addVersion(key + "-ver");
        JedisCommands shardedJedis = this.getJedis();
        try {
            shardedJedis.rpush(key, strings);
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMap(String key, String field, String value) {
        this.addVersion(key + "-ver");
        JedisCommands shardedJedis = this.getJedis();
        try {
            shardedJedis.hset(key, field, value);
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMap(String key, String field) {
        JedisCommands shardedJedis = this.getJedis();
        try {
            String res;
            String string = res = shardedJedis.hget(key, field);
            return string;
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getMapAll(String key) {
        JedisCommands shardedJedis = this.getJedis();
        try {
            Map res;
            Map map = res = shardedJedis.hgetAll(key);
            return map;
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getMap(String key, String ... fields) {
        JedisCommands shardedJedis = this.getJedis();
        try {
            List res;
            List list = res = shardedJedis.hmget(key, fields);
            return list;
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delMap(String key, String ... fields) {
        this.addVersion(key + "-ver");
        JedisCommands shardedJedis = this.getJedis();
        try {
            shardedJedis.hdel(key, fields);
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMap(String key, Map<String, String> hash) {
        this.addVersion(key + "-ver");
        JedisCommands shardedJedis = this.getJedis();
        try {
            shardedJedis.del(key);
            shardedJedis.hmset(key, hash);
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMapVer(String key, String field, String value) {
        this.addVersion(key + "-ver");
        JedisCommands shardedJedis = this.getJedis();
        try {
            shardedJedis.hset(key, field, value);
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delMapVer(String key, String ... fields) {
        this.addVersion(key + "-ver");
        JedisCommands shardedJedis = this.getJedis();
        try {
            shardedJedis.hdel(key, fields);
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMapVer(String key, Map<String, String> hash) {
        this.addVersion(key + "-ver");
        JedisCommands shardedJedis = this.getJedis();
        try {
            shardedJedis.del(key);
            shardedJedis.hmset(key, hash);
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getJedisConfig(String key) {
        Client client = null;
        Jedis jedis = (Jedis)this.getJedis();
        try {
            client = jedis.getClient();
            if (null == client) {
                String string = null;
                return string;
            }
            client.info();
            String string = client.getBulkReply();
            return string;
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.getJedisConfig.ex", (Throwable)e);
        }
        finally {
            this.returnRes((JedisCommands)jedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Slowlog> getShowLog(String key) {
        Jedis jedis = (Jedis)this.getJedis();
        try {
            List list = jedis.slowlogGet();
            return list;
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.getJedisConfig.ex", (Throwable)e);
        }
        finally {
            this.returnRes((JedisCommands)jedis);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getDbSize(String key) {
        Client client = null;
        Jedis jedis = (Jedis)this.getJedis();
        try {
            client = jedis.getClient();
            if (null == client) {
                long l = 0L;
                return l;
            }
            client.dbSize();
            long l = client.getIntegerReply();
            return l;
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.getJedisConfig.ex", (Throwable)e);
        }
        finally {
            this.returnRes((JedisCommands)jedis);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getAllKeys(String key) {
        Set s = null;
        Jedis jedis = (Jedis)this.getJedis();
        try {
            s = jedis.keys(key);
        }
        catch (Exception e) {
            this.logger.error("ecache.CACHE.JedisSentineUtil.getJedisConfig.ex", (Throwable)e);
        }
        finally {
            this.returnRes((JedisCommands)jedis);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sadd(String key, String ... values) {
        this.addVersion(key + "-ver");
        JedisCommands shardedJedis = this.getJedis();
        try {
            shardedJedis.sadd(key, values);
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> smembers(String key) {
        JedisCommands shardedJedis = this.getJedis();
        try {
            Set set = shardedJedis.smembers(key);
            return set;
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String spop(String key) {
        JedisCommands shardedJedis = this.getJedis();
        try {
            String string = shardedJedis.spop(key);
            return string;
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(String key, String value, int expires) {
        this.addVersion(key + "-ver");
        JedisCommands shardedJedis = this.getJedis();
        try {
            shardedJedis.set(key, value);
            shardedJedis.expire(key, expires);
        }
        finally {
            this.returnRes(shardedJedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryGetDistributedLock(String lockKey, String requestId, int expireTime) {
        JedisCommands shardedJedis = this.getJedis();
        try {
            String result = shardedJedis.set(lockKey, requestId, SET_IF_NOT_EXIST, SET_WITH_EXPIRE_TIME, (long)expireTime);
            if (LOCK_SUCCESS.equals(result)) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.returnRes(shardedJedis);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean releaseDistributedLock(String lockKey, String requestId) {
        JedisCommands shardedJedis = this.getJedis();
        try {
            String script = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end";
            Object result = ((Jedis)shardedJedis).eval(script, Collections.singletonList(lockKey), Collections.singletonList(requestId));
            if (RELEASE_SUCCESS.equals(result)) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.returnRes(shardedJedis);
        }
        return false;
    }

    static {
        RELEASE_SUCCESS = 1L;
    }
}

