/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.cache;

import com.yqbsoft.laser.service.esb.cache.ClusterJedisUtil;
import com.yqbsoft.laser.service.esb.cache.JedisSentineUtil;
import com.yqbsoft.laser.service.esb.cache.RedisCache;
import com.yqbsoft.laser.service.esb.cache.ShardedJedisUtil;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.suppercore.point.RegeditUtil;
import com.yqbsoft.laser.service.suppercore.point.ServletMain;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import redis.clients.util.Slowlog;

public class RedisUtil {
    public static final String SYS_CODE = "ecache.CACHE.RedisUtil";
    public static final String IP = "ip";
    public static final String PORT = "port";
    public static final String SSL = "ssl";
    public static final String NAME = "name";
    public static final String AUTH = "auth";
    public static final String SCHEME = "scheme";
    public static final String INDEX = "index";
    public static final String PSWORD = "psword";
    private static RedisCache redisCache;
    private static RedisUtil redisUtil;
    private static String index;
    protected final SupperLogUtil logger = new SupperLogUtil(this.getClass());

    public static String getIndex() {
        return index;
    }

    public static void setIndex(String index) {
        RedisUtil.index = index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RedisUtil getRedisUtil() {
        Class<RedisUtil> clazz = RedisUtil.class;
        synchronized (RedisUtil.class) {
            if (null == redisUtil) {
                Map<String, String> map = RedisUtil.getRes();
                String scheme = map.get(SCHEME);
                if (StringUtils.isBlank((String)scheme)) {
                    scheme = "ShardedJedisUtil";
                }
                redisCache = "ClusterJedisUtil".equals(scheme) ? new ClusterJedisUtil(map) : ("ShardedJedisUtil".equals(scheme) ? new ShardedJedisUtil(map) : new JedisSentineUtil(map));
                redisUtil = new RedisUtil();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return redisUtil;
        }
    }

    public static Map<String, String> getRes() {
        String url = "";
        url = null != ServletMain.getRegeditBean() && StringUtils.isNotBlank((String)ServletMain.getRegeditBean().getCacheUrl()) ? ServletMain.getRegeditBean().getCacheUrl() : RegeditUtil.getCacheUrl();
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String[] str = url.split(":");
        if (str.length > 0) {
            map.put(INDEX, str[0]);
            RedisUtil.setIndex(str[0]);
        }
        if (str.length > 1) {
            map.put(SCHEME, str[1]);
        }
        if (str.length > 2) {
            map.put(IP, str[2]);
        }
        if (str.length > 3) {
            map.put(PORT, str[3]);
        }
        if (str.length > 4) {
            map.put(NAME, str[4]);
        }
        if (str.length > 5) {
            map.put(PSWORD, str[5]);
        }
        if (str.length > 6) {
            map.put(SSL, str[6]);
        }
        return map;
    }

    public static void main(String[] args) {
    }

    private String setKeyIndex(String key) {
        if (null != key && key.indexOf(index + "_") != 0) {
            key = index + "_" + key;
        }
        return key;
    }

    public void addVersion(String key) {
        key = this.setKeyIndex(key);
        redisCache.addVersion(key);
    }

    public boolean checkVersion(String key, String value) {
        key = this.setKeyIndex(key);
        return redisCache.checkVersion(key, value);
    }

    public void set(String key, String value) {
        key = this.setKeyIndex(key);
        redisCache.setVer(key, value);
    }

    public void set(String key, String value, int expires) {
        key = this.setKeyIndex(key);
        redisCache.set(key, value, expires);
    }

    public void append(String key, String value) {
        key = this.setKeyIndex(key);
        redisCache.append(key, value);
    }

    public String get(String key) {
        key = this.setKeyIndex(key);
        return redisCache.get(key);
    }

    public void del(String key) {
        key = this.setKeyIndex(key);
        redisCache.delVer(key);
    }

    public void setVer(String key, String value) {
        key = this.setKeyIndex(key);
        redisCache.setVer(key, value);
    }

    public void appendVer(String key, String value) {
        key = this.setKeyIndex(key);
        redisCache.appendVer(key, value);
    }

    public void delVer(String key) {
        key = this.setKeyIndex(key);
        redisCache.delVer(key);
    }

    public void setList(String key, String ... strings) {
        key = this.setKeyIndex(key);
        redisCache.setListVer(key, strings);
    }

    public List<String> getList(String key, long start, long end) {
        key = this.setKeyIndex(key);
        return redisCache.getList(key, start, end);
    }

    public String lpop(String key) {
        key = this.setKeyIndex(key);
        return redisCache.lpop(key);
    }

    public String rpop(String key) {
        key = this.setKeyIndex(key);
        return redisCache.rpop(key);
    }

    public List<String> blpop(String key) {
        key = this.setKeyIndex(key);
        return redisCache.blpop(key);
    }

    public List<String> brpop(String key) {
        key = this.setKeyIndex(key);
        return redisCache.brpop(key);
    }

    public void setListVer(String key, String ... strings) {
        key = this.setKeyIndex(key);
        redisCache.setListVer(key, strings);
    }

    public void setMap(String key, String field, String value) {
        key = this.setKeyIndex(key);
        redisCache.setMapVer(key, field, value);
    }

    public String getMap(String key, String field) {
        key = this.setKeyIndex(key);
        return redisCache.getMap(key, field);
    }

    public Map<String, String> getMapAll(String key) {
        key = this.setKeyIndex(key);
        return redisCache.getMapAll(key);
    }

    public List<String> getMap(String key, String ... fields) {
        key = this.setKeyIndex(key);
        return redisCache.getMap(key, fields);
    }

    public void delMap(String key, String ... fields) {
        key = this.setKeyIndex(key);
        redisCache.delMapVer(key, fields);
    }

    public void setMap(String key, Map<String, String> hash) {
        key = this.setKeyIndex(key);
        redisCache.setMapVer(key, hash);
    }

    public void setMapVer(String key, String field, String value) {
        key = this.setKeyIndex(key);
        redisCache.setMapVer(key, field, value);
    }

    public void delMapVer(String key, String ... fields) {
        key = this.setKeyIndex(key);
        redisCache.delMapVer(key, fields);
    }

    public void setMapVer(String key, Map<String, String> hash) {
        key = this.setKeyIndex(key);
        redisCache.setMapVer(key, hash);
    }

    public String getJedisConfig(String key) {
        return redisCache.getJedisConfig(key);
    }

    public List<Slowlog> getShowLog(String key) {
        return redisCache.getShowLog(key);
    }

    public long getDbSize(String key) {
        return redisCache.getDbSize(key);
    }

    public Set<String> getAllKeys(String key) {
        return redisCache.getAllKeys(key);
    }

    public void sadd(String key, String ... values) {
        key = this.setKeyIndex(key);
        redisCache.sadd(key, values);
    }

    public Set<String> smembers(String key) {
        key = this.setKeyIndex(key);
        return redisCache.smembers(key);
    }

    public String spop(String key) {
        key = this.setKeyIndex(key);
        return redisCache.spop(key);
    }
}

