/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.netty.comm;

import com.yqbsoft.laser.service.esb.core.msgparser.TransMsg;
import com.yqbsoft.laser.service.esb.core.netty.SocketConfig;
import com.yqbsoft.laser.service.esb.netty.comm.SocketConnection;
import com.yqbsoft.laser.service.esb.netty.support.SocketConfigBean;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jboss.netty.util.HashedWheelTimer;

public abstract class AbstractConnection
implements SocketConnection {
    protected int state;
    protected SocketConfig config;
    protected SocketConfigBean configBean;
    protected static HashedWheelTimer timer = new HashedWheelTimer();

    @Override
    public int state() {
        return this.state;
    }

    @Override
    public void init(SocketConfig config) {
        this.config = config;
        this.configBean = new SocketConfigBean(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean start() {
        AbstractConnection abstractConnection = this;
        synchronized (abstractConnection) {
            if (this.state == 3 || this.state == 1) {
                return false;
            }
            this.state = 1;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean close() {
        AbstractConnection abstractConnection = this;
        synchronized (abstractConnection) {
            if (this.state == 2 || this.state == 3) {
                return false;
            }
            this.state = 2;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dispose() {
        AbstractConnection abstractConnection = this;
        synchronized (abstractConnection) {
            if (this.state == 3) {
                return false;
            }
            this.state = 3;
        }
        return true;
    }

    @Override
    public void writeMessage(TransMsg message) {
        throw new RuntimeException("unsupport operation");
    }

    public SocketConfig getConfig() {
        return this.config;
    }

    public void setConfig(SocketConfig config) {
        this.config = config;
    }

    public SocketConfigBean getConfigBean() {
        return this.configBean;
    }

    public void setConfigBean(SocketConfigBean configBean) {
        this.configBean = configBean;
    }

    public String toString() {
        return "connection[" + ToStringBuilder.reflectionToString((Object)this.config, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE) + "]";
    }
}

