/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.netty.comm.semiduplex;

import com.yqbsoft.laser.service.esb.core.msgparser.TransMsg;
import com.yqbsoft.laser.service.esb.core.netty.SocketConfig;
import com.yqbsoft.laser.service.esb.netty.comm.AbstractConnection;
import com.yqbsoft.laser.service.esb.netty.comm.ClientEventHandler;
import com.yqbsoft.laser.service.esb.netty.comm.EventHandler;
import com.yqbsoft.laser.service.esb.netty.comm.semiduplex.IoSession;
import com.yqbsoft.laser.service.esb.netty.comm.semiduplex.SocketAcceptor;
import com.yqbsoft.laser.service.esb.netty.comm.semiduplex.SocketConnector;
import com.yqbsoft.laser.service.esb.netty.comm.semiduplex.impl.CupsClientEventHandler;
import com.yqbsoft.laser.service.esb.netty.comm.semiduplex.impl.CupsServerEventHandler;
import com.yqbsoft.laser.service.esb.netty.comm.semiduplex.impl.IoSessionImpl;
import com.yqbsoft.laser.service.esb.netty.comm.semiduplex.impl.SocketAcceptorImpl;
import com.yqbsoft.laser.service.esb.netty.comm.semiduplex.impl.SocketConnectorImpl;
import com.yqbsoft.laser.service.esb.netty.handler.ChannelHandlerAdapter;
import com.yqbsoft.laser.service.esb.netty.handler.HeartBeatHandler;
import com.yqbsoft.laser.service.esb.netty.handler.IdleHandler;
import com.yqbsoft.laser.service.esb.netty.support.SocketConfigBean;
import com.yqbsoft.laser.service.esb.netty.util.SocketUtil;
import java.util.LinkedList;
import java.util.concurrent.Executor;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.handler.execution.OrderedMemoryAwareThreadPoolExecutor;
import org.jboss.netty.handler.timeout.IdleStateHandler;
import org.jboss.netty.util.Timer;

public class SemiDuplexConnection
extends AbstractConnection {
    private static final Logger logger = Logger.getLogger(SemiDuplexConnection.class);
    private IoSession session;
    private SocketAcceptor socketAcceptor;
    private SocketConnector socketConnector;
    private ExecutionHandler sHandler;
    private ExecutionHandler cHandler;

    @Override
    public void init(SocketConfig cfg) {
        super.init(cfg);
        this.session = new IoSessionImpl();
        this.sHandler = new ExecutionHandler((Executor)new OrderedMemoryAwareThreadPoolExecutor(cfg.getBizPoolSize(), 131072L, 131072L));
        this.cHandler = new ExecutionHandler((Executor)new OrderedMemoryAwareThreadPoolExecutor(cfg.getClientBizPoolSize(), 131072L, 131072L));
        EventHandler seh = SocketUtil.newHandler((String)ObjectUtils.defaultIfNull((Object)cfg.getEvtHandlerClass(), (Object)CupsServerEventHandler.class.getName()), this);
        EventHandler ceh = SocketUtil.newHandler((String)ObjectUtils.defaultIfNull((Object)cfg.getClientEvtHandlerClass(), (Object)CupsClientEventHandler.class.getName()), this);
        if (seh == null || ceh == null) {
            throw new RuntimeException("conn server handlerClass config error!");
        }
        LinkedList<ChannelHandler> sHandlers = new LinkedList<ChannelHandler>();
        sHandlers.add((ChannelHandler)new IdleStateHandler((Timer)timer, cfg.getIdleTime(), 0, 0));
        sHandlers.add((ChannelHandler)new IdleHandler(seh));
        sHandlers.addAll(this.configBean.getEncoders());
        sHandlers.addAll(this.configBean.getDecoders());
        sHandlers.add((ChannelHandler)this.sHandler);
        sHandlers.add((ChannelHandler)new ChannelHandlerAdapter(seh));
        this.socketAcceptor = new SocketAcceptorImpl(cfg, this.session, sHandlers);
        LinkedList<ChannelHandler> cHandlers = new LinkedList<ChannelHandler>();
        cHandlers.add((ChannelHandler)new IdleStateHandler((Timer)timer, 0, cfg.getBeatHeartTime(), 0));
        cHandlers.add((ChannelHandler)new HeartBeatHandler(ceh));
        cHandlers.addAll(this.configBean.getClientEncoders());
        cHandlers.addAll(this.configBean.getClientDecoders());
        cHandlers.add((ChannelHandler)this.cHandler);
        cHandlers.add((ChannelHandler)new ChannelHandlerAdapter(ceh));
        this.socketConnector = new SocketConnectorImpl(cfg, this.session, cHandlers, (ClientEventHandler)ceh);
        this.state = 0;
        logger.info((Object)"[MesiDuplex]connection init!");
    }

    @Override
    public boolean start() {
        if (!super.start()) {
            return false;
        }
        this.socketAcceptor.start();
        if (this.config.isConnectOnStart()) {
            this.socketConnector.connect();
        }
        logger.info((Object)"[MesiDuplex]connection start!");
        return true;
    }

    @Override
    public boolean dispose() {
        if (!super.dispose()) {
            return false;
        }
        this.socketConnector.dispose();
        this.socketAcceptor.dispose();
        if (this.sHandler != null) {
            this.sHandler.releaseExternalResources();
        }
        if (this.cHandler != null) {
            this.cHandler.releaseExternalResources();
        }
        logger.info((Object)"[MesiDuplex]connection dispose!");
        return true;
    }

    @Override
    public boolean close() {
        if (!super.close()) {
            return false;
        }
        this.socketConnector.disconnect(null);
        logger.info((Object)"[MesiDuplex]connection close!");
        return true;
    }

    @Override
    public void writeMessage(TransMsg message) {
        this.socketConnector.writeMessage(message);
    }

    @Override
    public SocketConfig getConfig() {
        return this.config;
    }

    @Override
    public void setConfig(SocketConfig config) {
        this.config = config;
    }

    public IoSession getSession() {
        return this.session;
    }

    public void setSession(IoSession session) {
        this.session = session;
    }

    public SocketAcceptor getSocketAcceptor() {
        return this.socketAcceptor;
    }

    public void setSocketAcceptor(SocketAcceptor socketAcceptor) {
        this.socketAcceptor = socketAcceptor;
    }

    public SocketConnector getSocketConnector() {
        return this.socketConnector;
    }

    public void setSocketConnector(SocketConnector socketConnector) {
        this.socketConnector = socketConnector;
    }

    @Override
    public SocketConfigBean getConfigBean() {
        return this.configBean;
    }

    @Override
    public void setConfigBean(SocketConfigBean configBean) {
        this.configBean = configBean;
    }
}

