/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.netty.comm.semiduplex.impl;

import com.yqbsoft.laser.service.esb.core.msgparser.TransMsg;
import com.yqbsoft.laser.service.esb.netty.comm.ClientEventHandler;
import com.yqbsoft.laser.service.esb.netty.comm.semiduplex.SemiDuplexConnection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.timeout.IdleState;
import org.jboss.netty.handler.timeout.IdleStateEvent;

public class CupsClientEventHandler
implements ClientEventHandler {
    private static final Logger logger = Logger.getLogger(CupsClientEventHandler.class);
    private TransMsg heartBeatMsg;
    private long connectInterval = 5L;
    private SemiDuplexConnection connection;
    private ExecutorService executor = Executors.newFixedThreadPool(2);

    public CupsClientEventHandler(SemiDuplexConnection connection) {
        this.connection = connection;
    }

    @Override
    public void onConnectted(ChannelHandlerContext ctx, ChannelStateEvent e) {
        this.connection.getSession().setClientChan(ctx.getChannel());
    }

    @Override
    public void onDisconnectted(ChannelHandlerContext ctx, ChannelStateEvent e) {
        if (!this.connection.getSession().isCurrentClientChann(ctx.getChannel())) {
            return;
        }
        Channel sch = this.connection.getSession().getServerChan();
        if (sch != null && sch.isConnected()) {
            this.connection.getSession().setAttribute("origServerChannel", sch);
            this.connection.getSocketAcceptor().disconnect(sch);
        }
        this.connection.getSession().reset();
        this.connection.getSocketConnector().reconnect(null);
    }

    @Override
    public void onReceived(ChannelHandlerContext ctx, MessageEvent e) {
    }

    @Override
    public void onWriteComplete(ChannelHandlerContext ctx, MessageEvent e) {
    }

    @Override
    public void onException(ChannelHandlerContext ctx, Throwable ex) {
    }

    @Override
    public void onIdle(ChannelHandlerContext ctx, IdleStateEvent e) {
        if (IdleState.WRITER_IDLE == e.getState()) {
            if (this.heartBeatMsg == null) {
                String dire = this.connection.getConfig().getRouterDire();
                this.heartBeatMsg = this.connection.getConfigBean().getMessageParser().pack(dire, "HBM", null, null);
            }
            this.connection.writeMessage(this.heartBeatMsg);
        }
    }

    @Override
    public void onConnectError(Throwable ex) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    logger.info((Object)"[CupsClient]connect error,start reconnect thread!");
                    Thread.sleep(CupsClientEventHandler.this.connectInterval * 1000L);
                    CupsClientEventHandler.this.connection.getSocketConnector().connect();
                }
                catch (Exception e) {
                    logger.error((Object)("[CupsClient-" + CupsClientEventHandler.this.connection.getConfig().getRouterDire() + "]reconnect thread ex!"), (Throwable)e);
                }
            }
        });
    }

    public SemiDuplexConnection getConnection() {
        return this.connection;
    }

    public void setConnection(SemiDuplexConnection connection) {
        this.connection = connection;
    }

    public TransMsg getHeartBeatMsg() {
        return this.heartBeatMsg;
    }

    public void setHeartBeatMsg(TransMsg heartBeatMsg) {
        this.heartBeatMsg = heartBeatMsg;
    }
}

