/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.netty.comm.semiduplex.impl;

import com.yqbsoft.laser.service.esb.core.msgparser.TransMsg;
import com.yqbsoft.laser.service.esb.netty.comm.ClientEventHandler;
import com.yqbsoft.laser.service.esb.netty.comm.semiduplex.SemiDuplexConnection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.timeout.IdleState;
import org.jboss.netty.handler.timeout.IdleStateEvent;

public class CupsClientMockHandler
implements ClientEventHandler {
    private static final Logger logger = Logger.getLogger(CupsClientMockHandler.class);
    private long connectInterval = 5L;
    private TransMsg heartBeatMsg;
    private SemiDuplexConnection connection;
    private ExecutorService executor = Executors.newFixedThreadPool(2);

    public CupsClientMockHandler(SemiDuplexConnection connection) {
        this.connection = connection;
    }

    @Override
    public void onConnectted(ChannelHandlerContext ctx, ChannelStateEvent e) {
        this.connection.getSession().setClientChan(ctx.getChannel());
    }

    @Override
    public void onDisconnectted(ChannelHandlerContext ctx, ChannelStateEvent e) {
        Object ch = this.connection.getSession().removeAttribute("origClientChannel");
        if (ch != null) {
            logger.info((Object)("[CupsMockClient]in session cch:" + ch));
            if (ch == ctx.getChannel()) {
                logger.info((Object)"[CupsMockClient]server accept new connection cause disconnect.");
                return;
            }
        }
        this.connection.getSocketConnector().disconnect(ctx.getChannel());
        this.connection.getSocketAcceptor().disconnect(null);
    }

    @Override
    public void onReceived(ChannelHandlerContext ctx, MessageEvent e) {
    }

    @Override
    public void onWriteComplete(ChannelHandlerContext ctx, MessageEvent e) {
    }

    @Override
    public void onException(ChannelHandlerContext ctx, Throwable ex) {
    }

    @Override
    public void onIdle(ChannelHandlerContext ctx, IdleStateEvent e) {
        if (this.heartBeatMsg == null) {
            String dire = this.connection.getConfig().getRouterDire();
            this.heartBeatMsg = this.connection.getConfigBean().getMessageParser().pack(dire, "HBM", null, null);
        }
        if (IdleState.WRITER_IDLE == e.getState()) {
            this.connection.writeMessage(this.heartBeatMsg);
        }
    }

    @Override
    public void onConnectError(Throwable ex) {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    logger.info((Object)"[CupsMockClient]connect error,start reconnect thread!");
                    Thread.sleep(CupsClientMockHandler.this.connectInterval * 1000L);
                    CupsClientMockHandler.this.connection.getSocketConnector().connect();
                }
                catch (Exception e) {
                    logger.error((Object)"[CupsMockClient]reconnect thread ex!", (Throwable)e);
                }
            }
        });
    }

    public SemiDuplexConnection getConnection() {
        return this.connection;
    }

    public void setConnection(SemiDuplexConnection connection) {
        this.connection = connection;
    }

    public TransMsg getHeartBeatMsg() {
        return this.heartBeatMsg;
    }

    public void setHeartBeatMsg(TransMsg heartBeatMsg) {
        this.heartBeatMsg = heartBeatMsg;
    }
}

