/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.netty.comm.semiduplex.impl;

import com.yqbsoft.laser.service.esb.core.gateway.RequestReplyExchangeSupport;
import com.yqbsoft.laser.service.esb.core.handler.ProxyContext;
import com.yqbsoft.laser.service.esb.core.msgparser.MessageParseService;
import com.yqbsoft.laser.service.esb.core.msgparser.TransMsg;
import com.yqbsoft.laser.service.esb.core.util.ApiInvokeUtil;
import com.yqbsoft.laser.service.esb.netty.comm.EventHandler;
import com.yqbsoft.laser.service.esb.netty.comm.semiduplex.IoSession;
import com.yqbsoft.laser.service.esb.netty.comm.semiduplex.SemiDuplexConnection;
import com.yqbsoft.laser.service.esb.netty.util.PropUtil;
import com.yqbsoft.laser.service.suppercore.cache.repository.BeanRepository;
import com.yqbsoft.laser.service.suppercore.cache.repository.CacheBean;
import com.yqbsoft.laser.service.suppercore.core.OutMessage;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.timeout.IdleState;
import org.jboss.netty.handler.timeout.IdleStateEvent;

public class CupsServerMockHandler
extends RequestReplyExchangeSupport
implements EventHandler {
    private static final long serialVersionUID = -4588903197600284298L;
    private static final Logger logger = Logger.getLogger(CupsServerMockHandler.class);
    private SemiDuplexConnection connection;
    private static String PARAM_CTX = "ctx";
    private static String PARAM_E = "e";

    public CupsServerMockHandler(SemiDuplexConnection connection) {
        this.connection = connection;
        PropUtil.filling(this);
    }

    @Override
    public void onConnectted(ChannelHandlerContext ctx, ChannelStateEvent e) {
        Channel sch;
        IoSession session = this.connection.getSession();
        Channel cch = session.getClientChan();
        if (cch != null) {
            session.setAttribute("origClientChannel", cch);
        }
        if ((sch = session.getServerChan()) != null) {
            session.setAttribute("origServerChannel", sch);
        }
        this.connection.getSession().setServerChan(ctx.getChannel());
        this.connection.getSocketConnector().reconnect(cch);
    }

    @Override
    public void onDisconnectted(ChannelHandlerContext ctx, ChannelStateEvent e) {
        Channel ch = (Channel)this.connection.getSession().removeAttribute("origServerChannel");
        if (ch != null) {
            logger.info((Object)("[CupsMockServer]in session sch:" + ch));
            if (ch == ctx.getChannel()) {
                logger.info((Object)"[CupsMockServer]server accept new connection cause disconnect.");
                return;
            }
        }
        this.connection.getSocketAcceptor().disconnect(ctx.getChannel());
        this.connection.getSocketConnector().disconnect(null);
    }

    @Override
    public void onReceived(ChannelHandlerContext ctx, MessageEvent e) {
        logger.debug((Object)("[CupsMockServer]recv message:" + e.getMessage()));
        ProxyContext proxyContext = new ProxyContext();
        proxyContext.paramsPut(PARAM_CTX, (Object)ctx);
        proxyContext.paramsPut(PARAM_E, (Object)e);
        this.sendProxyMessage(proxyContext);
    }

    @Override
    public void onWriteComplete(ChannelHandlerContext ctx, MessageEvent e) {
    }

    @Override
    public void onException(ChannelHandlerContext ctx, Throwable ex) {
    }

    @Override
    public void onIdle(ChannelHandlerContext ctx, IdleStateEvent e) {
        if (IdleState.READER_IDLE == e.getState()) {
            this.connection.getSocketAcceptor().disconnect(null);
        }
    }

    public boolean unpackMessage(ProxyContext proxyContext) {
        if (null == proxyContext) {
            return false;
        }
        OutMessage outMessage = proxyContext.getOutMessage();
        if (null == outMessage) {
            outMessage = new OutMessage();
            proxyContext.setOutMessage(outMessage);
        }
        MessageEvent e = (MessageEvent)proxyContext.paramsGet(PARAM_E);
        ChannelHandlerContext ctx = (ChannelHandlerContext)proxyContext.paramsGet(PARAM_CTX);
        if (null == ctx || null == ctx.getChannel()) {
            return false;
        }
        ByteBuffer buff = (ByteBuffer)e.getMessage();
        MessageParseService parser = this.connection.getConfigBean().getMessageParser();
        String dire = this.connection.getConfig().getRouterDire();
        proxyContext.setRouterDire(dire);
        TransMsg msg = parser.unpack(dire, buff);
        if (msg == null) {
            logger.info((Object)"[CupsMockServer]msg unpack return null.");
            return false;
        }
        if ("HBM".equals(msg.getSendType())) {
            logger.debug((Object)"[CupsMockServer]recv hbm.");
            return false;
        }
        proxyContext.setPack((Object)msg);
        return true;
    }

    public void makeProxyMessage(ProxyContext proxyContext) {
        if (null == proxyContext || null == proxyContext.getPack()) {
            return;
        }
        OutMessage outMessage = proxyContext.getOutMessage();
        if (null == outMessage) {
            outMessage = new OutMessage();
            proxyContext.setOutMessage(outMessage);
        }
        TransMsg msg = (TransMsg)proxyContext.getPack();
        MessageParseService parser = this.connection.getConfigBean().getMessageParser();
        proxyContext.setSendFlag(true);
        if ("RES".equals(msg.getSendType())) {
            CacheBean bean = (CacheBean)BeanRepository.newInstance((String)"MOCK").remove(msg.getMsgToken());
            if (bean == null || bean.isExpired()) {
                proxyContext.setSendFlag(false);
                return;
            }
            OutMessage out = new OutMessage();
            out.setReObj((Object)JsonUtil.buildNormalBinder().toJson(msg.getBody()));
            if (msg.getErrCode() != null) {
                out.setErrorCode(msg.getErrCode());
                out.setMsg("msg unpack error");
            }
            bean.getFuture().setDone((Object)out);
            proxyContext.setSendFlag(false);
            return;
        }
        if ("REQ".equals(msg.getSendType())) {
            if (msg.getErrCode() != null) {
                TransMsg tmsg = parser.pack(proxyContext.getRouterDire(), "RES", msg.getBody(), msg.getErrCode());
                proxyContext.setPack((Object)tmsg);
                proxyContext.setSendFlag(false);
                return;
            }
            msg.setFwdApiCode("enetty.mock.cups");
            proxyContext.setProxyMessage(ApiInvokeUtil.invoke((String)msg.getFwdApiCode(), (Object)msg.getBody(), (String)msg.getRouterDire()));
        }
    }

    public boolean writeMessage(ProxyContext proxyContext) {
        ChannelHandlerContext ctx;
        if (null == proxyContext || null == proxyContext.getOutMessage()) {
            return false;
        }
        OutMessage outMessage = proxyContext.getOutMessage();
        if (null == outMessage) {
            outMessage = new OutMessage();
            proxyContext.setOutMessage(outMessage);
        }
        if (null == (ctx = (ChannelHandlerContext)proxyContext.paramsGet(PARAM_CTX)) || null == ctx.getChannel()) {
            return false;
        }
        String dire = this.connection.getConfig().getRouterDire();
        MessageParseService parser = this.connection.getConfigBean().getMessageParser();
        if (null == parser) {
            return false;
        }
        Object obj = outMessage.getReObj();
        Object respMap = null;
        TransMsg msg = null;
        if (outMessage.isOpSuccess()) {
            respMap = null == obj || obj instanceof Map ? (Map)obj : (Map)JsonUtil.buildNormalBinder().getJsonToMap((String)outMessage.getReObj(), String.class, Object.class);
        } else if (null != proxyContext.getPack()) {
            msg = (TransMsg)proxyContext.getPack();
            respMap = msg.getBody();
        }
        boolean flag = this.packErrMsg(parser, dire, respMap, outMessage.getOpErrorCode());
        if (!flag && StringUtils.isBlank((String)outMessage.getOpErrorCode()) && null != proxyContext.getPack()) {
            this.packErrMsg(parser, dire, msg.getBody(), "96");
        }
        return true;
    }

    private boolean packErrMsg(MessageParseService parser, String dire, Object respMap, String respCode) {
        if (respMap == null) {
            return true;
        }
        TransMsg emsg = null;
        try {
            emsg = parser.pack(dire, "RES", respMap, respCode);
        }
        catch (Exception ex1) {
            logger.error((Object)"[ShortDuplex]pack ex msg throw ex1", (Throwable)ex1);
            return false;
        }
        try {
            this.connection.writeMessage(emsg);
        }
        catch (Exception ex1) {
            logger.error((Object)"[ShortDuplex]pack writeMessage msg throw ex1", (Throwable)ex1);
        }
        return true;
    }
}

