/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.netty.comm.semiduplex.impl;

import com.yqbsoft.laser.service.esb.core.netty.SocketConfig;
import com.yqbsoft.laser.service.esb.netty.comm.semiduplex.IoSession;
import com.yqbsoft.laser.service.esb.netty.comm.semiduplex.SocketAcceptor;
import com.yqbsoft.laser.service.esb.netty.util.SocketUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandler;

public class SocketAcceptorImpl
implements SocketAcceptor {
    private static final Logger logger = Logger.getLogger(SocketAcceptorImpl.class);
    private ServerBootstrap server;
    private SocketConfig config;
    private IoSession session;
    private boolean start;
    private List<ChannelHandler> handlers = Collections.emptyList();

    public SocketAcceptorImpl() {
    }

    public SocketAcceptorImpl(SocketConfig config, IoSession session, List<ChannelHandler> handlers) {
        this.config = config;
        this.handlers = handlers;
        this.session = session;
    }

    @Override
    public void init(SocketConfig config, List<ChannelHandler> handlers) {
        this.server = SocketUtil.getServerBootstrap(config, handlers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        SocketAcceptorImpl socketAcceptorImpl = this;
        synchronized (socketAcceptorImpl) {
            if (this.start) {
                return;
            }
            if (this.server == null) {
                this.init(this.config, this.handlers);
            }
        }
        this.server.bind((SocketAddress)new InetSocketAddress(this.config.getPort()));
        logger.info((Object)"Mesi Duplex acceptor start!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        ServerBootstrap strap = null;
        SocketAcceptorImpl socketAcceptorImpl = this;
        synchronized (socketAcceptorImpl) {
            if (this.server == null) {
                return;
            }
            strap = this.server;
            this.server = null;
        }
        this.disconnect(null);
        if (strap != null) {
            strap.releaseExternalResources();
        }
    }

    @Override
    public boolean disconnect(Channel ch) {
        return this.session.closeServerChan(ch);
    }

    public List<ChannelHandler> getHandlers() {
        return this.handlers;
    }

    public void setHandlers(List<ChannelHandler> handlers) {
        this.handlers = handlers;
    }

    public SocketConfig getConfig() {
        return this.config;
    }

    public void setConfig(SocketConfig config) {
        this.config = config;
    }

    public IoSession getSession() {
        return this.session;
    }

    public void setSession(IoSession session) {
        this.session = session;
    }
}

