/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.netty.comm.semiduplex.impl;

import com.yqbsoft.laser.service.esb.core.msgparser.TransMsg;
import com.yqbsoft.laser.service.esb.core.netty.SocketConfig;
import com.yqbsoft.laser.service.esb.netty.comm.ClientEventHandler;
import com.yqbsoft.laser.service.esb.netty.comm.semiduplex.IoSession;
import com.yqbsoft.laser.service.esb.netty.comm.semiduplex.SocketConnector;
import com.yqbsoft.laser.service.esb.netty.support.RecycleLinkedQueue;
import com.yqbsoft.laser.service.esb.netty.util.SocketUtil;
import com.yqbsoft.laser.service.suppercore.cache.repository.CacheBean;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;

public class SocketConnectorImpl
implements SocketConnector {
    private static final Logger logger = Logger.getLogger(SocketConnectorImpl.class);
    public static final int DISCONNECTED = 0;
    public static final int CONNECTING = 1;
    public static final int CONNECTED = 2;
    public static final int SHUTDOWN = 3;
    private volatile int state;
    private IoSession session;
    private SocketConfig config;
    private ClientBootstrap client;
    private ClientEventHandler eventHandler;
    private List<ChannelHandler> handlers = Collections.emptyList();
    private RecycleLinkedQueue<CacheBean> queue = new RecycleLinkedQueue(10000);

    public SocketConnectorImpl() {
    }

    public SocketConnectorImpl(SocketConfig config, IoSession session, List<ChannelHandler> handlers, ClientEventHandler eventHandler) {
        this.config = config;
        this.handlers = handlers;
        this.session = session;
        this.eventHandler = eventHandler;
    }

    @Override
    public void init(SocketConfig config, List<ChannelHandler> handlers) {
        this.client = SocketUtil.getClientBootstrap(config, handlers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() {
        SocketConnectorImpl socketConnectorImpl = this;
        synchronized (socketConnectorImpl) {
            if (this.state != 0) {
                return;
            }
            this.state = 1;
            if (this.client == null) {
                this.init(this.config, this.handlers);
            }
        }
        ChannelFuture future = this.client.connect((SocketAddress)new InetSocketAddress(this.config.getClientIp(), this.config.getClientPort()));
        future.addListener(new ChannelFutureListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void operationComplete(ChannelFuture future) throws Exception {
                block16: {
                    if (!future.isSuccess()) {
                        1 var2_2 = this;
                        synchronized (var2_2) {
                            if (SocketConnectorImpl.this.state != 1) {
                                return;
                            }
                            SocketConnectorImpl.this.state = 0;
                        }
                        SocketConnectorImpl.this.eventHandler.onConnectError(future.getCause());
                        logger.error((Object)"connect error,new reconnect thread!", future.getCause());
                        return;
                    }
                    1 var2_3 = this;
                    synchronized (var2_3) {
                        if (SocketConnectorImpl.this.state != 1) {
                            return;
                        }
                        SocketConnectorImpl.this.state = 2;
                    }
                    Channel ch = future.getChannel();
                    SocketConnectorImpl.this.session.setClientChan(ch);
                    try {
                        while (!SocketConnectorImpl.this.queue.isEmpty()) {
                            CacheBean bean = (CacheBean)SocketConnectorImpl.this.queue.poll();
                            if (bean == null) continue;
                            if (bean.isExpired()) {
                                logger.info((Object)("bean expired obj:" + bean.getValue()));
                                continue;
                            }
                            ch.write(bean.getValue());
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)"write message ex", (Throwable)e);
                        boolean close = SocketConnectorImpl.this.session.closeClientChan(ch);
                        if (!close) break block16;
                        1 var5_9 = this;
                        synchronized (var5_9) {
                            SocketConnectorImpl.this.state = 0;
                        }
                    }
                }
            }
        });
        future.awaitUninterruptibly();
    }

    @Override
    public boolean disconnect(Channel channel) {
        if (this.state != 2) {
            return false;
        }
        boolean close = this.session.closeClientChan(channel);
        if (close && this.state != 3) {
            this.state = 0;
        }
        return close;
    }

    @Override
    public void reconnect(Channel ch) {
        this.disconnect(ch);
        this.connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        ClientBootstrap old = null;
        SocketConnectorImpl socketConnectorImpl = this;
        synchronized (socketConnectorImpl) {
            old = this.client;
            this.client = null;
            this.state = 3;
        }
        this.disconnect(null);
        if (old != null) {
            old.releaseExternalResources();
        }
        this.queue.stop();
    }

    @Override
    public void writeMessage(TransMsg message) {
        if (this.state != 2 && message.getSendType() == "HBM") {
            logger.info((Object)("connector unconnect,discard heart beat msg!state:" + this.state));
            return;
        }
        if (this.state == 3) {
            throw new IllegalStateException("channel is shutdown");
        }
        if (this.state != 2) {
            CacheBean cache = new CacheBean();
            cache.setValue(message.getBody());
            cache.setExpire((long)(this.config.getMsgWaitTime() * 1000));
            this.queue.add(cache);
            return;
        }
        this.session.writeMessage(message.getBody());
    }

    public SocketConfig getConfig() {
        return this.config;
    }

    public void setConfig(SocketConfig config) {
        this.config = config;
    }

    public List<ChannelHandler> getHandlers() {
        return this.handlers;
    }

    public void setHandlers(List<ChannelHandler> handlers) {
        this.handlers = handlers;
    }
}

