/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.netty.comm.shortduplex;

import com.yqbsoft.laser.service.esb.core.netty.SocketConfig;
import com.yqbsoft.laser.service.esb.netty.comm.AbstractConnection;
import com.yqbsoft.laser.service.esb.netty.comm.EventHandler;
import com.yqbsoft.laser.service.esb.netty.comm.Pooled;
import com.yqbsoft.laser.service.esb.netty.comm.shortduplex.ShortDuplexEventHandler;
import com.yqbsoft.laser.service.esb.netty.handler.ChannelHandlerAdapter;
import com.yqbsoft.laser.service.esb.netty.handler.IdleHandler;
import com.yqbsoft.laser.service.esb.netty.util.SocketUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.LinkedList;
import java.util.concurrent.Executor;
import org.apache.commons.lang3.ObjectUtils;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.handler.execution.ExecutionHandler;
import org.jboss.netty.handler.execution.MemoryAwareThreadPoolExecutor;
import org.jboss.netty.handler.timeout.IdleStateHandler;
import org.jboss.netty.util.Timer;

public class ShortDuplexConnection
extends AbstractConnection {
    private ExecutionHandler eHandler;
    private ServerBootstrap serverBootstrap;
    private EventHandler eh;

    @Override
    public void init(SocketConfig config) {
        super.init(config);
        this.eHandler = new ExecutionHandler((Executor)new MemoryAwareThreadPoolExecutor(config.getBizPoolSize(), 262144L, 262144L));
        this.eh = SocketUtil.newHandler((String)ObjectUtils.defaultIfNull((Object)config.getEvtHandlerClass(), (Object)ShortDuplexEventHandler.class.getName()), this);
        ChannelHandlerAdapter handler = new ChannelHandlerAdapter(this.eh);
        LinkedList<ChannelHandler> sHandlers = new LinkedList<ChannelHandler>();
        sHandlers.add((ChannelHandler)new IdleStateHandler((Timer)timer, config.getIdleTime(), config.getIdleTime(), config.getIdleTime()));
        sHandlers.add((ChannelHandler)new IdleHandler(this.eh));
        sHandlers.addAll(this.configBean.getEncoders());
        sHandlers.addAll(this.configBean.getDecoders());
        sHandlers.add((ChannelHandler)this.eHandler);
        sHandlers.add((ChannelHandler)handler);
        this.serverBootstrap = SocketUtil.getServerBootstrap(config, sHandlers);
    }

    @Override
    public boolean start() {
        if (!super.start()) {
            return false;
        }
        this.serverBootstrap.bind((SocketAddress)new InetSocketAddress(this.config.getPort()));
        return true;
    }

    @Override
    public boolean dispose() {
        if (!super.dispose()) {
            return false;
        }
        if (this.serverBootstrap != null) {
            this.serverBootstrap.releaseExternalResources();
        }
        if (this.eHandler != null) {
            this.eHandler.releaseExternalResources();
        }
        if (this.eh != null && this.eh instanceof Pooled) {
            ((Pooled)((Object)this.eh)).close();
        }
        return true;
    }

    public ServerBootstrap getServerBootstrap() {
        return this.serverBootstrap;
    }

    public void setServerBootstrap(ServerBootstrap serverBootstrap) {
        this.serverBootstrap = serverBootstrap;
    }
}

