/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.netty.comm.shortduplex;

import com.yqbsoft.laser.service.esb.core.gateway.RequestReplyExchangeSupport;
import com.yqbsoft.laser.service.esb.core.handler.ProxyContext;
import com.yqbsoft.laser.service.esb.core.log.OpenLogUtil;
import com.yqbsoft.laser.service.esb.core.msgparser.MessageParseService;
import com.yqbsoft.laser.service.esb.core.msgparser.TransMsg;
import com.yqbsoft.laser.service.esb.core.netty.SocketConfig;
import com.yqbsoft.laser.service.esb.core.util.ApiInvokeUtil;
import com.yqbsoft.laser.service.esb.netty.comm.EventHandler;
import com.yqbsoft.laser.service.esb.netty.comm.Pooled;
import com.yqbsoft.laser.service.esb.netty.comm.shortduplex.ShortDuplexConnection;
import com.yqbsoft.laser.service.esb.netty.util.PropUtil;
import com.yqbsoft.laser.service.esb.netty.util.SocketUtil;
import com.yqbsoft.laser.service.suppercore.core.OutMessage;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.timeout.IdleStateEvent;

public class ShortDuplexEventHandler
extends RequestReplyExchangeSupport
implements EventHandler,
Pooled {
    private static final String SYS_CODE = "com.yqbsoft.laser.service.esb.netty.comm.shortduplex.ShortDuplexEventHandler";
    private static final long serialVersionUID = 5481966459187053361L;
    protected final OpenLogUtil logger = new OpenLogUtil(this.getClass());
    private ExecutorService pool;
    public ShortDuplexConnection connection;
    private static String PARAM_CTX = "ctx";
    private static String PARAM_E = "e";

    public ShortDuplexEventHandler(ShortDuplexConnection conn) {
        this.connection = conn;
        this.init(conn.getConfig());
        PropUtil.filling(this);
    }

    @Override
    public void onConnectted(ChannelHandlerContext ctx, ChannelStateEvent e) {
    }

    @Override
    public void onDisconnectted(ChannelHandlerContext ctx, ChannelStateEvent e) {
    }

    @Override
    public void onReceived(ChannelHandlerContext ctx, MessageEvent e) {
        final ChannelHandlerContext syncCtx = ctx;
        final MessageEvent syncE = e;
        final long currentall = System.currentTimeMillis();
        this.pool.execute(new Runnable(){

            @Override
            public void run() {
                long current = System.currentTimeMillis();
                ProxyContext proxyContext = new ProxyContext();
                proxyContext.paramsPut(PARAM_CTX, (Object)syncCtx);
                proxyContext.paramsPut(PARAM_E, (Object)syncE);
                ShortDuplexEventHandler.this.sendProxyMessage(proxyContext);
                ShortDuplexEventHandler.this.logger.info("[ShortDuplex]onreceive spend time:" + (System.currentTimeMillis() - current));
                ShortDuplexEventHandler.this.logger.info("[ShortDuplex-all]onreceive spend time:" + (System.currentTimeMillis() - currentall));
            }
        });
    }

    private boolean packErrMsg(MessageParseService parser, String dire, Map<String, Object> respMap, String respCode, Channel ch) {
        if (respMap == null) {
            SocketUtil.close(ch);
            return true;
        }
        TransMsg emsg = null;
        try {
            emsg = parser.pack(dire, "RES", respMap, respCode);
        }
        catch (Exception ex1) {
            this.logger.error("[ShortDuplex]pack ex msg throw ex1", (Throwable)ex1);
            return false;
        }
        try {
            ch.write(emsg.getBody()).addListener(ChannelFutureListener.CLOSE);
            return true;
        }
        catch (Exception ex1) {
            this.logger.error("[ShortDuplex]pack writeMessage msg throw ex1", (Throwable)ex1);
            return true;
        }
    }

    public boolean unpackMessage(ProxyContext proxyContext) {
        if (null == proxyContext) {
            return false;
        }
        OutMessage outMessage = proxyContext.getOutMessage();
        if (null == outMessage) {
            outMessage = new OutMessage();
            proxyContext.setOutMessage(outMessage);
        }
        MessageEvent e = (MessageEvent)proxyContext.paramsGet(PARAM_E);
        ChannelHandlerContext ctx = (ChannelHandlerContext)proxyContext.paramsGet(PARAM_CTX);
        if (null == this.connection || null == e || null == this.connection.getConfig() || null == ctx || null == ctx.getChannel()) {
            return false;
        }
        MessageParseService parser = this.connection.getConfigBean().getMessageParser();
        if (null == parser) {
            return false;
        }
        String dire = this.connection.getConfig().getRouterDire();
        proxyContext.setRouterDire(dire);
        ByteBuffer bb = (ByteBuffer)e.getMessage();
        TransMsg msg = parser.unpack(dire, bb);
        if (msg == null) {
            this.logger.warn("[ShortDuplex]unpack msg return null,msg:" + msg);
            SocketUtil.close(ctx.getChannel());
            outMessage.setErrorCode("96");
            return false;
        }
        if (msg.getErrCode() != null) {
            this.logger.info("[ShortDuplex]unpack msg unsucess,msg:" + msg);
            outMessage.setErrorCode(msg.getErrCode());
            outMessage.setReObj(msg.getBody());
            return true;
        }
        if (StringUtils.isBlank((String)msg.getFwdApiCode())) {
            this.logger.info("[ShortDuplex]fwdApiCode is null,msg:" + msg);
            outMessage.setErrorCode("96");
            outMessage.setReObj(msg.getBody());
            return true;
        }
        proxyContext.setPack((Object)msg);
        return true;
    }

    public void makeProxyMessage(ProxyContext proxyContext) {
        if (null == proxyContext || null == proxyContext.getPack()) {
            return;
        }
        TransMsg msg = (TransMsg)proxyContext.getPack();
        proxyContext.setProxyMessage(ApiInvokeUtil.invoke((String)msg.getFwdApiCode(), (Object)msg.getBody(), (String)msg.getRouterDire()));
    }

    public boolean writeMessage(ProxyContext proxyContext) {
        if (null == proxyContext || null == proxyContext.getOutMessage()) {
            return false;
        }
        OutMessage outMessage = proxyContext.getOutMessage();
        if (null == outMessage) {
            outMessage = new OutMessage();
            proxyContext.setOutMessage(outMessage);
        }
        ChannelHandlerContext ctx = (ChannelHandlerContext)proxyContext.paramsGet(PARAM_CTX);
        if (null == this.connection || null == this.connection.getConfig() || null == ctx || null == ctx.getChannel()) {
            return false;
        }
        String dire = this.connection.getConfig().getRouterDire();
        MessageParseService parser = this.connection.getConfigBean().getMessageParser();
        if (null == parser) {
            SocketUtil.close(ctx.getChannel());
            return false;
        }
        Object obj = outMessage.getReObj();
        Map respMap = null;
        TransMsg msg = null;
        if (outMessage.isOpSuccess()) {
            respMap = null == obj || obj instanceof Map ? (Map)obj : (Map)JsonUtil.buildNormalBinder().getJsonToMap((String)outMessage.getReObj(), String.class, Object.class);
        } else if (null != proxyContext.getPack()) {
            msg = (TransMsg)proxyContext.getPack();
            respMap = (Map)msg.getBody();
        }
        boolean flag = this.packErrMsg(parser, dire, respMap, outMessage.getOpErrorCode(), ctx.getChannel());
        if (!flag && StringUtils.isBlank((String)outMessage.getOpErrorCode()) && null != proxyContext.getPack()) {
            flag = this.packErrMsg(parser, dire, (Map)((TransMsg)proxyContext.getPack()).getBody(), "96", ctx.getChannel());
        }
        if (!flag) {
            SocketUtil.close(ctx.getChannel());
        }
        return true;
    }

    @Override
    public void onWriteComplete(ChannelHandlerContext ctx, MessageEvent e) {
    }

    @Override
    public void onException(ChannelHandlerContext ctx, Throwable ex) {
        ctx.getChannel().close();
    }

    @Override
    public void onIdle(ChannelHandlerContext ctx, IdleStateEvent e) {
        ctx.getChannel().close();
    }

    @Override
    public void close() {
        if (null != this.pool) {
            try {
                this.pool.shutdownNow();
            }
            catch (Exception e) {
                this.logger.error("com.yqbsoft.laser.service.esb.netty.comm.shortduplex.ShortDuplexEventHandler.close \u7ebf\u7a0b\u6c60\u5173\u95ed\u5f02\u5e38", (Throwable)e);
            }
            this.logger.info("\u7ebf\u7a0b\u6c60\u5173\u95ed\u3002", (Object)this.pool);
        }
    }

    @Override
    public void init(SocketConfig cfg) {
        int core = 70;
        int max = 250;
        int keep = 30;
        if (null != cfg) {
            core = null == cfg.getDefCorePoolSize() || cfg.getDefCorePoolSize() < 0 ? 70 : cfg.getDefCorePoolSize();
            max = null == cfg.getDefMaximumPoolSize() || cfg.getDefMaximumPoolSize() < 0 ? 250 : cfg.getDefMaximumPoolSize();
            int n = keep = null == cfg.getDefKeepaLiveTime() || cfg.getDefKeepaLiveTime() < 0 ? 30 : cfg.getDefKeepaLiveTime();
        }
        if (null != this.pool) {
            this.close();
        }
        this.pool = new ThreadPoolExecutor(core, max, (long)keep, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy());
        this.logger.info("\u7ebf\u7a0b\u6c60\u521b\u5efa\u6210\u529f\uff1a", (Object)this.pool);
    }
}

