/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.netty.decode;

import com.yqbsoft.laser.service.esb.core.msgparser.MessageParseService;
import com.yqbsoft.laser.service.esb.core.netty.SocketConfig;
import com.yqbsoft.laser.service.esb.core.netty.Storable;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import java.nio.ByteBuffer;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.FrameDecoder;

public class MessageDecoder
extends FrameDecoder {
    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buff) throws Exception {
        SocketConfig config = (SocketConfig)((Storable)channel.getPipeline()).getAttr("socketConfig");
        MessageParseService parser = (MessageParseService)SpringApplicationContextUtil.getBean((String)config.getParserSrvId());
        buff.markReaderIndex();
        int length = parser.getPackLength(config.getRouterDire(), buff.toByteBuffer());
        if (length == -1) {
            buff.resetReaderIndex();
            return null;
        }
        if (buff.readableBytes() < length) {
            buff.resetReaderIndex();
            return null;
        }
        byte[] bb = new byte[length];
        buff.readBytes(bb);
        return ByteBuffer.wrap(bb);
    }
}

