/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.netty.handler;

import com.yqbsoft.laser.service.esb.netty.comm.EventHandler;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.channel.WriteCompletionEvent;

@ChannelHandler.Sharable
public class ChannelHandlerAdapter
extends SimpleChannelHandler {
    private static final Logger logger = Logger.getLogger(ChannelHandlerAdapter.class);
    private EventHandler eventHandler;

    public ChannelHandlerAdapter(EventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        super.channelOpen(ctx, e);
        logger.warn((Object)("channelOpen,ch:" + ctx.getChannel() + ",cid:" + ctx.getChannel().getId()));
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        super.channelClosed(ctx, e);
        logger.info((Object)("channelClosed,ch:" + ctx.getChannel() + ",cid:" + ctx.getChannel().getId()));
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        super.messageReceived(ctx, e);
        logger.debug((Object)("messageReceived,ch:" + ctx.getChannel() + ",cid:" + ctx.getChannel().getId()));
        this.eventHandler.onReceived(ctx, e);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        this.eventHandler.onException(ctx, e.getCause());
        logger.error((Object)("exceptionCaught,ch:" + ctx.getChannel() + ",cid:" + ctx.getChannel().getId()), e.getCause());
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        super.channelDisconnected(ctx, e);
        this.eventHandler.onDisconnectted(ctx, e);
        logger.warn((Object)("channelDisconnected,ch:" + ctx.getChannel() + ",cid:" + ctx.getChannel().getId()));
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        super.channelConnected(ctx, e);
        this.eventHandler.onConnectted(ctx, e);
        logger.debug((Object)("channelConnected,ch:" + ctx.getChannel() + ",cid:" + ctx.getChannel().getId()));
    }

    public void writeComplete(ChannelHandlerContext ctx, WriteCompletionEvent e) throws Exception {
        super.writeComplete(ctx, e);
        logger.debug((Object)("writeComplete,ch:" + ctx.getChannel() + ",cid:" + ctx.getChannel().getId()));
    }
}

