/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.netty.handler;

import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.jboss.netty.handler.codec.serialization.ObjectEncoder;
import org.jboss.netty.handler.execution.ExecutionHandler;

public class ServerPipelineFactory
implements ChannelPipelineFactory {
    private SimpleChannelHandler channelHandler = null;
    private ExecutionHandler executionHandler;
    private List<FrameDecoder> decoderList;
    private List<ObjectEncoder> encoderList;

    public ServerPipelineFactory(ExecutionHandler exHandler, SimpleChannelHandler chHandler, List<FrameDecoder> decoderList, List<ObjectEncoder> encoderList) {
        this.executionHandler = exHandler;
        this.channelHandler = chHandler;
        this.encoderList = encoderList;
        this.decoderList = decoderList;
    }

    public ChannelPipeline getPipeline() throws Exception {
        int i;
        ChannelPipeline pipeline = Channels.pipeline();
        if (!CollectionUtils.isEmpty(this.decoderList)) {
            for (i = 0; i < this.decoderList.size(); ++i) {
                pipeline.addLast("decoder-" + i, (ChannelHandler)this.decoderList.get(i));
            }
        }
        if (!CollectionUtils.isEmpty(this.encoderList)) {
            for (i = 0; i < this.encoderList.size(); ++i) {
                pipeline.addLast("encoder-" + i, (ChannelHandler)this.encoderList.get(i));
            }
        }
        pipeline.addLast("handler", (ChannelHandler)this.channelHandler);
        pipeline.addLast("executor", (ChannelHandler)this.executionHandler);
        return pipeline;
    }

    public SimpleChannelHandler getChannelHandler() {
        return this.channelHandler;
    }

    public void setChannelHandler(SimpleChannelHandler channelHandler) {
        this.channelHandler = channelHandler;
    }

    public ExecutionHandler getExecutionHandler() {
        return this.executionHandler;
    }

    public void setExecutionHandler(ExecutionHandler executionHandler) {
        this.executionHandler = executionHandler;
    }

    public List<FrameDecoder> getDecoderList() {
        return this.decoderList;
    }

    public void setDecoderList(List<FrameDecoder> decoderList) {
        this.decoderList = decoderList;
    }

    public List<ObjectEncoder> getEncoderList() {
        return this.encoderList;
    }

    public void setEncoderList(List<ObjectEncoder> encoderList) {
        this.encoderList = encoderList;
    }
}

