/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.netty.server;

import com.yqbsoft.laser.service.esb.core.netty.ConnServerProperty;
import com.yqbsoft.laser.service.esb.core.netty.SocketConfig;
import com.yqbsoft.laser.service.esb.core.netty.SocketService;
import com.yqbsoft.laser.service.esb.core.router.LocalCache;
import com.yqbsoft.laser.service.esb.netty.server.ServerStarter;
import com.yqbsoft.laser.service.suppercore.point.ServletMain;
import com.yqbsoft.laser.service.tool.VfinOpenConstants;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.OpenUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class DefaultServerStarter
implements ServerStarter {
    private static final Logger logger = Logger.getLogger(DefaultServerStarter.class);
    private SocketService socketService;

    @Override
    public void startAll() {
        Map cspMap = LocalCache.getConnServerMap();
        if (MapUtil.isEmpty((Map)cspMap)) {
            return;
        }
        List cspList = (List)cspMap.get(VfinOpenConstants.SERVER_TYPE_SOCKET);
        if (ListUtil.isEmpty((Collection)cspList)) {
            return;
        }
        for (ConnServerProperty prop : cspList) {
            SocketConfig cfg = SocketConfig.parse((ConnServerProperty)prop);
            if (cfg == null) continue;
            if (!ServletMain.getAppName().equals(prop.getAppmanageIcode())) {
                logger.info((Object)("[ServerStarter] ,icode:" + prop.getAppmanageIcode() + ",id:" + prop.getConnServerId()));
                continue;
            }
            if (DefaultServerStarter.filterIp(prop.getAppmanageIp())) {
                logger.info((Object)("[ServerStarter] filter ip:" + prop.getAppmanageIp() + ",id:" + prop.getConnServerId()));
                continue;
            }
            if (!ServletMain.getAppKey().equals(prop.getAppmanageAppkey())) {
                logger.info((Object)("[ServerStarter] filter ,connAppkey:" + prop.getAppmanageAppkey() + ",id:" + prop.getConnServerId()));
                continue;
            }
            this.socketService.start(cfg);
            logger.info((Object)("[ServerStarter]start success prop:" + prop));
        }
        logger.info((Object)"[ServerStarter]server start finish!");
    }

    private static boolean filterIp(String ipstr) {
        String[] ips;
        if (StringUtils.isBlank((CharSequence)ipstr)) {
            return false;
        }
        List localIp = OpenUtils.getAllNetWorkIp();
        for (String ip : ips = StringUtils.split((String)ipstr, (String)",")) {
            if ("127.0.0.1".equals(ip)) {
                return false;
            }
            if (!localIp.contains(ip)) continue;
            return false;
        }
        return true;
    }

    public SocketService getSocketService() {
        return this.socketService;
    }

    public void setSocketService(SocketService socketService) {
        this.socketService = socketService;
    }
}

