/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.netty.service;

import com.yqbsoft.laser.service.esb.core.netty.SocketConfig;
import com.yqbsoft.laser.service.esb.netty.comm.SocketConnection;
import com.yqbsoft.laser.service.esb.netty.service.ConnectionFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.BeanUtils;

public class DefaultConnectionFactory
implements ConnectionFactory {
    private static final Logger logger = Logger.getLogger(DefaultConnectionFactory.class);
    private Map<String, String> connType2Class = new HashMap<String, String>();

    @Override
    public SocketConnection create(SocketConfig config) {
        String clazzName = (String)StringUtils.defaultIfBlank((CharSequence)config.getConnClass(), (CharSequence)this.connType2Class.get(config.getConnType()));
        if (StringUtils.isBlank((CharSequence)clazzName)) {
            throw new RuntimeException("[ConnectionFactory]className not exist!");
        }
        try {
            return (SocketConnection)BeanUtils.instantiate(Class.forName(clazzName));
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)("[ConnectionFactory]ClassNotFound,clazzName:" + clazzName), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Map<String, String> getConnType2Class() {
        return this.connType2Class;
    }

    public void setConnType2Class(Map<String, String> connType2Class) {
        this.connType2Class = connType2Class;
    }
}

