/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.netty.service;

import com.yqbsoft.laser.service.esb.core.msgparser.TransMsg;
import com.yqbsoft.laser.service.esb.core.netty.SocketConfig;
import com.yqbsoft.laser.service.esb.core.netty.SocketService;
import com.yqbsoft.laser.service.esb.netty.comm.SocketConnection;
import com.yqbsoft.laser.service.esb.netty.server.DefaultServerStarter;
import com.yqbsoft.laser.service.esb.netty.service.ConnectionFactory;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;

public class SocketServiceImpl
implements SocketService {
    private static final Logger logger = Logger.getLogger(DefaultServerStarter.class);
    private AtomicInteger incr = new AtomicInteger();
    private ConnectionFactory connectionFactory;
    private Map<String, SocketConfig> key2CfgMap = new ConcurrentHashMap<String, SocketConfig>();
    private ConcurrentHashMap<String, List<String>> dire2KeyMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, SocketConnection> key2ConnMap = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(SocketConfig config) {
        SocketConnection connection = this.key2ConnMap.get(config.getConnkey());
        if (connection != null) {
            if (connection.state() == 1) {
                logger.info((Object)("[SocketService]connection has started!" + connection));
                return;
            }
            connection.dispose();
        }
        if ((connection = this.connectionFactory.create(config)) == null || this.key2ConnMap.putIfAbsent(config.getConnkey(), connection) != null) {
            return;
        }
        this.key2CfgMap.put(config.getConnkey(), config);
        connection.init(config);
        connection.start();
        logger.info((Object)("[SocketService]connection started!" + connection));
        List<String> list = this.dire2KeyMap.get(config.getRouterDire());
        if (list == null) {
            list = new LinkedList<String>();
            if (this.dire2KeyMap.putIfAbsent(config.getRouterDire(), list) != null) {
                list = this.dire2KeyMap.get(config.getRouterDire());
            }
        }
        List<String> list2 = list;
        synchronized (list2) {
            list.add(config.getConnkey());
        }
        logger.info((Object)("[SocketService]connection provide service!" + connection));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(String connKey, boolean keepCfg) {
        SocketConfig config;
        logger.info((Object)"[SocketService]connection shutdown start");
        SocketConfig socketConfig = config = keepCfg ? this.key2CfgMap.get(connKey) : this.key2CfgMap.remove(connKey);
        if (config == null) {
            return;
        }
        List<String> list = this.dire2KeyMap.get(config.getRouterDire());
        if (list == null) {
            return;
        }
        List<String> list2 = list;
        synchronized (list2) {
            list.remove(connKey);
        }
        SocketConnection connection = this.key2ConnMap.get(connKey);
        if (connection != null) {
            connection.dispose();
        }
        logger.info((Object)("[SocketService]connection shutdown finish," + connection));
    }

    public void restart(String connKey) {
        SocketConfig cfg = this.key2CfgMap.get(connKey);
        if (cfg == null) {
            return;
        }
        this.shutdown(connKey, true);
        this.start(cfg);
    }

    public void writeMessage(String routerDire, TransMsg message) {
        List<String> list = this.dire2KeyMap.get(routerDire);
        if (CollectionUtils.isEmpty(list)) {
            throw new RuntimeException("not exist valid connection");
        }
        String connKey = list.get(this.incr.getAndIncrement() % list.size());
        if (message != null) {
            this.key2ConnMap.get(connKey).writeMessage(message);
        }
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }
}

