/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.netty.support;

import com.yqbsoft.laser.service.suppercore.cache.repository.CacheBean;
import java.util.Iterator;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class RecycleLinkedQueue<E extends CacheBean>
extends LinkedBlockingQueue<E> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(RecycleLinkedQueue.class);
    private ScheduledExecutorService service;

    public RecycleLinkedQueue() {
        this(Integer.MAX_VALUE);
    }

    public void stop() {
        this.service.shutdownNow();
    }

    public RecycleLinkedQueue(int size) {
        super(size);
        if (this.service == null || this.service.isShutdown()) {
            this.service = Executors.newScheduledThreadPool(1);
            this.service.scheduleAtFixedRate(new Recycler(), 5L, 5L, TimeUnit.MINUTES);
        }
    }

    class Recycler
    implements Runnable {
        Recycler() {
        }

        @Override
        public void run() {
            Iterator iter = RecycleLinkedQueue.this.iterator();
            while (iter.hasNext()) {
                CacheBean bean = (CacheBean)iter.next();
                if (!bean.isExpired()) continue;
                logger.info((Object)("bean expired,obj:" + bean.getValue()));
                iter.remove();
            }
        }
    }
}

