/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.netty.support;

import com.yqbsoft.laser.service.esb.core.SysException;
import com.yqbsoft.laser.service.esb.core.msgparser.MessageParseService;
import com.yqbsoft.laser.service.esb.core.netty.SocketConfig;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.netty.util.SocketUtil;
import java.util.List;
import org.jboss.netty.channel.ChannelHandler;

public class SocketConfigBean {
    private List<ChannelHandler> encoders;
    private List<ChannelHandler> decoders;
    private MessageParseService messageParser;
    private List<ChannelHandler> clientEncoders;
    private List<ChannelHandler> clientDecoders;

    public SocketConfigBean(SocketConfig cfg) {
        if (cfg.getEncoder() != null) {
            this.encoders = SocketUtil.getHandlers(cfg.getEncoder());
        }
        if (cfg.getDecoder() != null) {
            this.decoders = SocketUtil.getHandlers(cfg.getDecoder());
        }
        if (cfg.getClientEncoder() != null) {
            this.clientEncoders = SocketUtil.getHandlers(cfg.getClientEncoder());
        }
        if (cfg.getClientDecoder() != null) {
            this.clientDecoders = SocketUtil.getHandlers(cfg.getClientDecoder());
        }
        if (cfg.getParserSrvId() != null) {
            this.messageParser = (MessageParseService)SpringApplicationContextUtil.getBean((String)cfg.getParserSrvId());
        }
        if (this.encoders == null || this.decoders == null || this.messageParser == null) {
            throw new SysException("config.ex", "coder config error!");
        }
    }

    public MessageParseService getMessageParser() {
        return this.messageParser;
    }

    public void setMessageParser(MessageParseService messageParser) {
        this.messageParser = messageParser;
    }

    public List<ChannelHandler> getEncoders() {
        return this.encoders;
    }

    public void setEncoders(List<ChannelHandler> encoders) {
        this.encoders = encoders;
    }

    public List<ChannelHandler> getDecoders() {
        return this.decoders;
    }

    public void setDecoders(List<ChannelHandler> decoders) {
        this.decoders = decoders;
    }

    public List<ChannelHandler> getClientEncoders() {
        return this.clientEncoders;
    }

    public void setClientEncoders(List<ChannelHandler> clientEncoders) {
        this.clientEncoders = clientEncoders;
    }

    public List<ChannelHandler> getClientDecoders() {
        return this.clientDecoders;
    }

    public void setClientDecoders(List<ChannelHandler> clientDecoders) {
        this.clientDecoders = clientDecoders;
    }
}

