/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.netty.util;

import com.yqbsoft.laser.service.esb.core.netty.SocketConfig;
import com.yqbsoft.laser.service.esb.core.netty.StorablePipeline;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.netty.comm.EventHandler;
import com.yqbsoft.laser.service.esb.netty.comm.SocketConnection;
import com.yqbsoft.laser.service.esb.netty.comm.semiduplex.SemiDuplexConnection;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.springframework.beans.BeanUtils;

public class SocketUtil {
    private static final Logger logger = Logger.getLogger(SemiDuplexConnection.class);
    public static final String SEP = ",";

    public static ServerBootstrap getServerBootstrap(final SocketConfig config, final List<ChannelHandler> handlerList) {
        ServerBootstrap strap = new ServerBootstrap((ChannelFactory)new NioServerSocketChannelFactory());
        strap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                StorablePipeline pipeline = new StorablePipeline();
                pipeline.setAttr("socketConfig", (Object)config);
                if (!CollectionUtils.isEmpty((Collection)handlerList)) {
                    for (int i = 0; i < handlerList.size(); ++i) {
                        if (FrameDecoder.class.isAssignableFrom(((ChannelHandler)handlerList.get(i)).getClass())) {
                            pipeline.addLast("handler-" + i, (ChannelHandler)((ChannelHandler)handlerList.get(i)).getClass().newInstance());
                            continue;
                        }
                        pipeline.addLast("handler-" + i, (ChannelHandler)handlerList.get(i));
                    }
                }
                return pipeline;
            }
        });
        strap.setOption("child.tcpNoDelay", (Object)true);
        strap.setOption("child.keepAlive", (Object)true);
        strap.setOption("reuseAddress", (Object)true);
        strap.setOption("allIdleTime", (Object)config.getIdleTime());
        return strap;
    }

    public static ClientBootstrap getClientBootstrap(final SocketConfig config, final List<ChannelHandler> handlerList) {
        ClientBootstrap strap = new ClientBootstrap((ChannelFactory)new NioClientSocketChannelFactory());
        strap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                StorablePipeline pipeline = new StorablePipeline();
                pipeline.setAttr("socketConfig", (Object)config);
                if (!CollectionUtils.isEmpty((Collection)handlerList)) {
                    for (int i = 0; i < handlerList.size(); ++i) {
                        pipeline.addLast("handler-" + i, (ChannelHandler)handlerList.get(i));
                    }
                }
                return pipeline;
            }
        });
        strap.setOption("tcpNoDelay", (Object)true);
        strap.setOption("keepAlive", (Object)true);
        strap.setOption("allIdleTime", (Object)config.getIdleTime());
        return strap;
    }

    public static List<ChannelHandler> getHandlers(String value) {
        LinkedList<ChannelHandler> list = new LinkedList<ChannelHandler>();
        if (value != null) {
            String[] arr;
            for (String name : arr = StringUtils.split((String)value, (String)SEP)) {
                ChannelHandler decoder = (ChannelHandler)SpringApplicationContextUtil.getBean((String)name);
                if (decoder == null) continue;
                list.add(decoder);
            }
        }
        return list;
    }

    public static EventHandler newHandler(String className, SocketConnection conn) {
        if (StringUtils.isNotBlank((CharSequence)className)) {
            try {
                Class<?> clazz = Class.forName(className);
                if (!EventHandler.class.isAssignableFrom(clazz)) {
                    return null;
                }
                Constructor<?> cons = clazz.getDeclaredConstructor(conn.getClass());
                return (EventHandler)BeanUtils.instantiateClass(cons, (Object[])new Object[]{conn});
            }
            catch (Exception e) {
                logger.error((Object)("newInstance ex,className:" + className), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public static void close(Channel ch) {
        if (ch == null) {
            return;
        }
        try {
            if (ch.isConnected()) {
                ch.write((Object)ChannelBuffers.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
            } else {
                ch.close();
            }
        }
        catch (Exception e) {
            logger.error((Object)"session write empty buffer error", (Throwable)e);
            ch.close();
        }
    }
}

