/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.rest.dis.controller;

import com.yqbsoft.laser.service.esb.core.netty.ConnServerProperty;
import com.yqbsoft.laser.service.esb.core.router.LocalCache;
import com.yqbsoft.laser.service.esb.rest.controller.HttpUtil;
import com.yqbsoft.laser.service.esb.rest.dis.controller.BaseInterUtil;
import com.yqbsoft.laser.service.esb.rest.dis.controller.HttpDisSupper;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import com.yqbsoft.laser.service.tool.VfinOpenConstants;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/laserDis"})
public class DisHttpController
extends HttpDisSupper {
    private static final SupperLogUtil logger = new SupperLogUtil(DisHttpController.class);
    private static final String ROUTER_ERROR = "8";
    private static final long serialVersionUID = -3303989459344719626L;
    private String tokenApi = "cmc.disOauth.updateTokenFormal";
    private String orderApi = "cmc.disOrder.saveSendOrderStateFormal";
    private String refundApi = "cmc.disRefund.saveSendRefundStateFormal";
    private String delApi = "cmc.disDel.saveSendDelStateFormal";

    @RequestMapping(value={"/http/post/{icode}/{channelCode}/{memberCode}/{tenantCode}"}, method={RequestMethod.POST})
    public void execute(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="icode") String icode, @PathVariable(value="channelCode") String channelCode, @PathVariable(value="memberCode") String memberCode, @PathVariable(value="tenantCode") String tenantCode, @RequestBody(required=false) String resStream) {
        this.execl(request, response, icode, channelCode, memberCode, tenantCode, resStream, this.tokenApi, null);
    }

    @RequestMapping(value={"/http/post/{icode}/{channelCode}/{tenantCode}"}, method={RequestMethod.POST})
    public void execute(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="icode") String icode, @PathVariable(value="channelCode") String channelCode, @PathVariable(value="tenantCode") String tenantCode, @RequestBody(required=false) String resStream) {
        this.execl(request, response, icode, channelCode, "", tenantCode, resStream, this.tokenApi, null);
    }

    private void execl(HttpServletRequest request, HttpServletResponse response, String icode, String channelCode, String memberCode, String tenantCode, String resStream, String apiCode, String methodType) {
        String routerDire = this.injectionRouterDire(icode);
        logger.info("DisHttpController.execl", (Object)("\u6e20\u9053\u56de\u8c03\uff1apostData[" + JsonUtil.buildNormalBinder().toJson((Object)request.getParameterMap()) + "]stream:[" + resStream + "]"));
        if (StringUtils.isNotBlank((String)resStream)) {
            Map map;
            try {
                resStream = resStream.replaceAll("%(?![0-9a-fA-F]{2})", "%25");
                resStream = URLDecoder.decode(resStream, "UTF-8");
                logger.info("DisHttpController.resStream1", (Object)resStream);
            }
            catch (Exception e) {
                logger.error("DisHttpController.resStream", (Object)resStream, (Throwable)e);
            }
            if (StringUtils.isNotBlank((String)resStream) && resStream.trim().indexOf("{") == 0 && MapUtil.isNotEmpty((Map)(map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(resStream, String.class, String.class)))) {
                if (StringUtils.isNotBlank((String)methodType)) {
                    map.put("methodType", methodType);
                }
                request.setAttribute("param", (Object)map);
            }
        }
        request.removeAttribute("app_id");
        request.setAttribute("app_id", (Object)"");
        request.setAttribute("methodType", (Object)methodType);
        request.setAttribute("memberCode", (Object)memberCode);
        request.setAttribute("channelCode", (Object)channelCode);
        request.setAttribute(HttpUtil.BANK_TENANTCODE, (Object)tenantCode);
        request.setAttribute("method", (Object)apiCode);
        request.setAttribute("version", (Object)"1.0");
        logger.info("DisHttpController.invoke", (Object)("=======================" + routerDire + "," + apiCode));
        this.invoke(request, response, routerDire);
    }

    public static void main(String[] args) {
        String resStream = "{\"requestId\":\"200037227619200508\",\"type\":10,\"appId\":64377963,\"message\":\"{\"id\":\"3047275481995800703\",\"orderId\":\"3047275481995800703\",\"address\":\"\u4e1c\u5e73\u56fd\u5bb6\u68ee\u6797\u516c\u56ed-\u89c2\u5149\u679c\u56ed\u4e0a\u6d77\u5e02\u68d5\u6988\u8def\u4e0e\u767d\u7389\u5170\u8def\u4ea4\u53c9\u53e3\u897f\u5357150\u7c7310\u53f7\",\"createdAt\":\"2019-08-04T15:01:53\",\"activeAt\":\"2019-08-04T15:01:53\",\"deliverFee\":0.01,\"merchantDeliverySubsidy\":0.0,\"deliverTime\":null,\"description\":\"\",\"groups\":[{\"name\":\"1\u53f7\u7bee\u5b50\",\"type\":\"normal\",\"items\":[{\"id\":200052556548,\"skuId\":200000447077648892,\"name\":\"\u9999\u5948\u513f\u53ef\u53ef\u5c0f\u59d0\u99a5\u90c1\u9999\u6c34-90ml\",\"categoryId\":1,\"price\":0.01,\"quantity\":1,\"total\":0.01,\"additions\":[],\"newSpecs\":[{\"name\":\"\u89c4\u683c\",\"value\":\"90ml\"}],\"attributes\":[],\"extendCode\":\"5457474\",\"barCode\":\"\",\"weight\":1.0,\"userPrice\":0.0,\"shopPrice\":0.0,\"vfoodId\":1563464484,\"ingredients\":[]}],\"relatedItems\":[]}],\"invoice\":null,\"book\":false,\"onlinePaid\":true,\"railwayAddress\":null,\"phoneList\":[\"13020273448,480\"],\"shopId\":173827150,\"shopName\":\"\u5168\u6e20\u9053\u6d4b\u8bd5\u5e97\u94fa\",\"daySn\":3,\"status\":\"unprocessed\",\"refundStatus\":\"noRefund\",\"userId\":421225970,\"userIdStr\":\"421225970\",\"totalPrice\":0.02,\"originalPrice\":0.02,\"consignee\":\"\u5a1c**\",\"deliveryGeo\":\"121.47698494,31.68298605\",\"deliveryPoiAddress\":\"\u4e1c\u5e73\u56fd\u5bb6\u68ee\u6797\u516c\u56ed-\u89c2\u5149\u679c\u56ed\u4e0a\u6d77\u5e02\u68d5\u6988\u8def\u4e0e\u767d\u7389\u5170\u8def\u4ea4\u53c9\u53e3\u897f\u5357150\u7c7310\u53f7\",\"invoiced\":false,\"income\":0.02,\"serviceRate\":0.08,\"serviceFee\":-0.0,\"hongbao\":0.0,\"packageFee\":0.0,\"activityTotal\":-0.0,\"shopPart\":-0.0,\"elemePart\":-0.0,\"downgraded\":false,\"vipDeliveryFeeDiscount\":0.0,\"openId\":\"\",\"secretPhoneExpireTime\":\"2019-08-04T21:01:47\",\"orderActivities\":[],\"invoiceType\":null,\"taxpayerId\":\"\",\"coldBoxFee\":0.0,\"cancelOrderDescription\":null,\"cancelOrderCreatedAt\":null,\"orderCommissions\":[],\"baiduWaimai\":false,\"userExtraInfo\":{\"giverPhone\":\"\",\"greeting\":\"\"},\"consigneePhones\":[\"152****6832\"],\"superVip\":\"NOT_VIP\",\"confirmCookingTime\":null,\"orderActivityParts\":[{\"partName\":\"\u4f18\u60e0\u603b\u8ba1\",\"partValue\":-0.0,\"weight\":10}],\"orderBusinessType\":0,\"pickUpTime\":\"1970-01-01T08:00:00\",\"pickUpNumber\":0,\"umpOrder\":0,\"tianmaoPart\":-0.0,\"shopBrandId\":0,\"userPart\":0.0,\"specUserPart\":0.0,\"isBusinessOrder\":false,\"pinTuanOrder\":false,\"extraJson\":\"{\\\"originalDeliverFee\\\":\\\"0.01\\\",\\\"deliveryActivityFee\\\":\\\"0.0\\\"}\",\"svcPart\":-0.0,\"orderSourceTag\":\"ELEME\"}\",\"shopId\":173827150,\"timestamp\":1564902113874,\"signature\":\"CC40B6487F28986AF4032E3BF32659D6\",\"userId\":6823695989021101440}";
        Map map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(resStream, String.class, Object.class);
        if (MapUtil.isNotEmpty((Map)map)) {
            for (String key : map.keySet()) {
                System.out.println(key);
                System.out.println(map.get(key));
            }
        }
    }

    @RequestMapping(value={"/http/get/{icode}/{channelCode}/{memberCode}/{tenantCode}"}, method={RequestMethod.GET})
    public void get(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="icode") String icode, @PathVariable(value="channelCode") String channelCode, @PathVariable(value="memberCode") String memberCode, @PathVariable(value="tenantCode") String tenantCode, @RequestBody(required=false) String resStream) {
        this.execl(request, response, icode, channelCode, memberCode, tenantCode, resStream, this.tokenApi, null);
    }

    @RequestMapping(value={"/http/get/{icode}/{channelCode}/{tenantCode}"}, method={RequestMethod.GET})
    public void get(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="icode") String icode, @PathVariable(value="channelCode") String channelCode, @PathVariable(value="tenantCode") String tenantCode, @RequestBody(required=false) String resStream) {
        this.execl(request, response, icode, channelCode, "", tenantCode, resStream, this.tokenApi, null);
    }

    @RequestMapping(value={"/http/postmsg/{icode}/{channelCode}/{tenantCode}"})
    public void executeMsg(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="icode") String icode, @PathVariable(value="channelCode") String channelCode, @PathVariable(value="tenantCode") String tenantCode, @RequestBody(required=false) String resStream) {
        this.execl(request, response, icode, channelCode, "", tenantCode, resStream, this.orderApi, null);
    }

    @RequestMapping(value={"/http/ordermsg/{icode}/{channelCode}/{methodType}/{tenantCode}"})
    public void executeOrderMsg(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="icode") String icode, @PathVariable(value="channelCode") String channelCode, @PathVariable(value="methodType") String methodType, @PathVariable(value="tenantCode") String tenantCode, @RequestBody(required=false) String resStream) {
        this.execl(request, response, icode, channelCode, "", tenantCode, resStream, this.orderApi, methodType);
    }

    @RequestMapping(value={"/http/refundmsg/{icode}/{channelCode}/{methodType}/{tenantCode}"})
    public void executeRefundMsg(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="icode") String icode, @PathVariable(value="channelCode") String channelCode, @PathVariable(value="methodType") String methodType, @PathVariable(value="tenantCode") String tenantCode, @RequestBody(required=false) String resStream) {
        this.execl(request, response, icode, channelCode, "", tenantCode, resStream, this.refundApi, methodType);
    }

    @RequestMapping(value={"/http/delmsg/{icode}/{channelCode}/{methodType}/{tenantCode}"})
    public void executeDelMsg(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="icode") String icode, @PathVariable(value="channelCode") String channelCode, @PathVariable(value="methodType") String methodType, @PathVariable(value="tenantCode") String tenantCode, @RequestBody(required=false) String resStream) {
        this.execl(request, response, icode, channelCode, "", tenantCode, resStream, this.delApi, methodType);
    }

    protected String getDomain(HttpServletRequest request) {
        if (null == request) {
            return null;
        }
        String domain = request.getServerName();
        return domain;
    }

    protected String getContextPath(HttpServletRequest request) {
        if (null == request) {
            return null;
        }
        String contextPath = request.getContextPath();
        return contextPath;
    }

    @RequestMapping(value={"/djsw/{jddjtype}"})
    public void executeMsg(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="jddjtype") String jddjtype, @RequestBody(required=false) String resStream) {
        String domain = this.getDomain(request);
        if (StringUtils.isBlank((String)domain)) {
            logger.error("DisHttpController.domain", (Object)"domain is null");
            return;
        }
        String cacheTenantCode = "";
        String oauthEnvCode = "web";
        String contextPath = this.getContextPath(request);
        String cacheProappTenantCode = BaseInterUtil.getCacheComTenantCode("TmProoapp-domain", domain, contextPath, oauthEnvCode);
        if (StringUtils.isNotBlank((String)cacheProappTenantCode)) {
            cacheTenantCode = cacheProappTenantCode.split(",")[1];
        } else {
            cacheProappTenantCode = BaseInterUtil.getCacheComTenantCode("TmProappEnv-domain-code", domain, contextPath, oauthEnvCode);
            if (StringUtils.isNotBlank((String)cacheProappTenantCode)) {
                cacheTenantCode = cacheProappTenantCode.split(",")[1];
            }
        }
        if (StringUtils.isBlank((String)cacheTenantCode)) {
            logger.error("DisHttpController.cacheTenantCode", (Object)domain);
            return;
        }
        String api = this.orderApi;
        if ("pushDeliveryStatus".equals(jddjtype)) {
            api = this.delApi;
        }
        this.execl(request, response, "dis", "jddj", "", cacheTenantCode, resStream, api, jddjtype);
    }

    private String injectionRouterDire(String icode) {
        if (StringUtils.isBlank((String)icode)) {
            return ROUTER_ERROR;
        }
        Map cspMap = LocalCache.getConnServerMap();
        if (MapUtil.isEmpty((Map)cspMap)) {
            return ROUTER_ERROR;
        }
        List cspList = (List)cspMap.get(VfinOpenConstants.SERVER_TYPE_HTTP);
        if (ListUtil.isEmpty((Collection)cspList)) {
            return ROUTER_ERROR;
        }
        for (ConnServerProperty connServerProperty : cspList) {
            if (!icode.equals(connServerProperty.getConnIcode())) continue;
            Integer routerDire = connServerProperty.getRouterDire();
            if (routerDire == null) {
                return ROUTER_ERROR;
            }
            return routerDire.toString();
        }
        return ROUTER_ERROR;
    }

    @Override
    public Set<String> getIgnoreKey() {
        HashSet<String> keys = new HashSet<String>();
        keys.add("app_id");
        keys.add("version");
        return keys;
    }
}

