/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esb.rest.controller;

import com.yqbsoft.laser.service.esb.core.file.FileBean;
import com.yqbsoft.laser.service.esb.core.handler.ProxyContext;
import com.yqbsoft.laser.service.suppercore.core.OutMessage;
import com.yqbsoft.laser.service.suppercore.core.ProxyMessage;
import com.yqbsoft.laser.service.suppercore.core.SysMessage;
import com.yqbsoft.laser.service.tool.VfinOpenConstants;
import com.yqbsoft.laser.service.tool.util.FileItem;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.OpenUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class HttpUtil {
    public static String PARAM_REQUEST = "request";
    public static String PARAM_RESPONE = "response";
    public static String BANK_CHANNELCODE = "channelClearFchannel";
    public static String BANK_TENANTCODE = "tenantCode";
    public static String IGNORE_KEY = "ignoreKey";

    public static boolean execute(ProxyContext proxyContext) {
        String resStream;
        String version;
        String apiCode;
        String tenantCode;
        if (null == proxyContext) {
            return false;
        }
        HttpServletRequest request = (HttpServletRequest)proxyContext.paramsGet(PARAM_REQUEST);
        if (null == request || null == request.getParameterMap()) {
            return false;
        }
        OutMessage outMessage = proxyContext.getOutMessage();
        if (null == outMessage) {
            outMessage = new OutMessage();
            proxyContext.setOutMessage(outMessage);
        }
        int routerDire = Integer.valueOf(proxyContext.getRouterDire());
        SysMessage sysMessage = new SysMessage();
        sysMessage.setRemoteHostIp(request.getRemoteAddr());
        sysMessage.setProxyType(VfinOpenConstants.SERVER_TYPE_HTTP);
        sysMessage.setEsbHostIp(OpenUtils.getLocalNetWorkIp());
        ProxyMessage inMessage = new ProxyMessage();
        inMessage.setRouterDire(routerDire);
        inMessage.setSysMessage(sysMessage);
        Map ruestmap = request.getParameterMap();
        HashMap<String, String> allParamMap = new HashMap<String, String>();
        HashMap outParamMap = new HashMap();
        String fchannelCode = (String)request.getAttribute(BANK_CHANNELCODE);
        if (StringUtils.isNotBlank((String)fchannelCode)) {
            allParamMap.put(BANK_CHANNELCODE, fchannelCode);
        }
        if (StringUtils.isNotBlank((String)(tenantCode = (String)request.getAttribute(BANK_TENANTCODE)))) {
            allParamMap.put(BANK_TENANTCODE, tenantCode);
        }
        if (StringUtils.isNotBlank((String)(apiCode = (String)request.getAttribute("method")))) {
            if (allParamMap.containsKey("method")) {
                inMessage.getSysParamMap().put("method", allParamMap.get("method"));
            }
            allParamMap.put("method", apiCode);
        }
        if (StringUtils.isNotBlank((String)(version = (String)request.getAttribute("version")))) {
            if (allParamMap.containsKey("version")) {
                inMessage.getSysParamMap().put("version", allParamMap.get("version"));
            }
            allParamMap.put("version", version);
        }
        if (StringUtils.isNotBlank((String)(resStream = (String)request.getAttribute("resStream")))) {
            allParamMap.put("resStream", resStream);
        }
        Set ignoreKey = (Set)request.getAttribute(IGNORE_KEY);
        if (null != ruestmap) {
            for (String key : ruestmap.keySet()) {
                try {
                    if (ignoreKey != null && ignoreKey.contains(key)) {
                        inMessage.getSysParamMap().put(key, ruestmap.get(key) == null ? null : ((String[])ruestmap.get(key))[0]);
                        continue;
                    }
                    allParamMap.put(key, ruestmap.get(key) == null ? null : ((String[])ruestmap.get(key))[0]);
                    if (!VfinOpenConstants.outparamMap.containsKey(key)) continue;
                    outParamMap.put(key, allParamMap.get(key));
                }
                catch (Exception e) {}
            }
        } else {
            return false;
        }
        String requsetName = request.getClass().getSimpleName();
        if (requsetName.equals("DefaultMultipartHttpServletRequest")) {
            MultipartHttpServletRequest fileRequest = (MultipartHttpServletRequest)request;
            try {
                inMessage.setFileParams(HttpUtil.uploadFile(fileRequest.getFileMap(), allParamMap));
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        inMessage.setOpParam(outParamMap);
        inMessage.setAllParamMap(allParamMap);
        proxyContext.setPack((Object)inMessage);
        proxyContext.setProxyMessage(inMessage);
        return true;
    }

    private static Map<String, FileItem> uploadFile(Map<String, MultipartFile> filMap, Map<String, String> allParamMap) throws IOException {
        if (null == filMap || filMap.isEmpty() || null == allParamMap) {
            return null;
        }
        MultipartFile multipartFile = null;
        ArrayList<FileBean> fileBeanList = new ArrayList<FileBean>();
        FileBean fileBean = null;
        for (String key : filMap.keySet()) {
            String[] types;
            multipartFile = filMap.get(key);
            fileBean = new FileBean();
            fileBean.setBytes(multipartFile.getBytes());
            fileBean.setContentType(multipartFile.getContentType());
            if (StringUtils.isNotBlank((String)multipartFile.getOriginalFilename()) && null != (types = multipartFile.getOriginalFilename().split("\\."))) {
                fileBean.setFileType(types[types.length - 1]);
            }
            fileBean.setName(multipartFile.getName());
            fileBean.setOriginalFilename(multipartFile.getOriginalFilename());
            fileBean.setSize(Long.valueOf(multipartFile.getSize()));
            fileBeanList.add(fileBean);
        }
        allParamMap.put("fileBeanList", JsonUtil.buildNormalBinder().toJson(fileBeanList));
        return null;
    }

    public static boolean writeRetrn(ProxyContext proxyContext) {
        if (null == proxyContext) {
            return false;
        }
        OutMessage outMessage = proxyContext.getOutMessage();
        if (null == outMessage) {
            outMessage = new OutMessage();
            proxyContext.setOutMessage(outMessage);
        }
        HttpServletResponse response = (HttpServletResponse)proxyContext.paramsGet(PARAM_RESPONE);
        String returnStr = outMessage.getBody();
        ProxyMessage proxyMessage = proxyContext.getProxyMessage();
        String type = null;
        String charset = null;
        if (null != proxyMessage) {
            type = (String)proxyMessage.getAllParamMap().get("format");
            charset = (String)proxyMessage.getAllParamMap().get("charset");
        }
        if (StringUtils.isEmpty(charset)) {
            charset = "UTF-8";
        }
        if (StringUtils.isEmpty(type)) {
            type = "json";
        }
        response.addHeader("Access-Control-Allow-Origin", "*");
        response.setContentType("text/" + type + "; charset=" + charset);
        if ("Http_ErrorCode".equals(outMessage.getErrorCode())) {
            response.setStatus(500);
        }
        try {
            response.getWriter().print(returnStr);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

