/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.esserver.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esserver.service.EsSeverService;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;

public class EsServerServiceImpl
extends BaseServiceImpl
implements EsSeverService {
    public static final String SYS_CODE = "essever.EsServerServiceImpl";
    private ResourceBundle serverConfig = ResourceBundle.getBundle("esserver");
    private Map<String, Node> startNode = new HashMap<String, Node>();

    @Override
    public void start() throws ApiException {
        this.logger.info("Searchengine start ....");
        HashMap<String, String> settingMap = new HashMap<String, String>();
        settingMap.put("cluster.name", this.serverConfig.getString("cluster.name"));
        settingMap.put("path.data", this.serverConfig.getString("path.data"));
        settingMap.put("path.home", this.serverConfig.getString("path.home"));
        Settings settings = ImmutableSettings.settingsBuilder().put(settingMap).build();
        NodeBuilder nodeBuilder = NodeBuilder.nodeBuilder();
        nodeBuilder.settings(settings);
        Node node = nodeBuilder.node();
        node.start();
        this.startNode.put(this.serverConfig.getString("cluster.name"), node);
        this.logger.info("Searchengine start finsh!!! ");
    }

    @Override
    public void stop() throws ApiException {
        if (this.startNode == null) {
            return;
        }
        for (String key : this.startNode.keySet()) {
            this.startNode.get(key).close();
        }
        this.startNode.clear();
    }
}

