/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.estate.daemon;

import com.yqbsoft.laser.service.esb.core.log.OpenLogUtil;
import com.yqbsoft.laser.service.estate.daemon.LoadDataCollection;
import com.yqbsoft.laser.service.estate.daemon.PageContext;
import com.yqbsoft.laser.service.estate.service.impl.semaphore.service.ExecuteRunnable;
import java.util.List;

public class LoadProcessThread
implements Runnable {
    private OpenLogUtil logger = new OpenLogUtil(LoadProcessThread.class);
    private PageContext pageContext;
    private ExecuteRunnable<?> executeRunnable;
    private LoadDataCollection dataCollection;

    public LoadDataCollection getDataCollection() {
        return this.dataCollection;
    }

    public void setDataCollection(LoadDataCollection dataCollection) {
        this.dataCollection = dataCollection;
    }

    public ExecuteRunnable<?> getExecuteRunnable() {
        return this.executeRunnable;
    }

    public void setExecuteRunnable(ExecuteRunnable<?> executeRunnable) {
        this.executeRunnable = executeRunnable;
    }

    public PageContext getPageContext() {
        return this.pageContext;
    }

    public void setPageContext(PageContext pageContext) {
        this.pageContext = pageContext;
    }

    public LoadProcessThread(ExecuteRunnable<?> executeRunnable, LoadDataCollection dataCollection, PageContext pageContext) {
        this.pageContext = pageContext;
        this.executeRunnable = executeRunnable;
        this.dataCollection = dataCollection;
    }

    @Override
    public void run() {
        this.logger.info("LoadProcessThread.run", (Object)("LoadProcessThread Start thread = " + Thread.currentThread().getId()));
        this.logger.info("LoadProcessThread.run", (Object)("executeRunnable.loadData.start thread = " + Thread.currentThread().getId()));
        List<?> dataList = this.executeRunnable.loadData(this.pageContext);
        this.logger.info("LoadProcessThread.run", (Object)("executeRunnable.loadData.end start=" + this.pageContext.getStart() + ",count=" + dataList.size()));
        this.logger.info("LoadProcessThread.run", (Object)("executeRunnable.process.start process data size = " + dataList.size()));
        this.executeRunnable.process(dataList);
        this.logger.info("LoadProcessThread.run", (Object)"executeRunnable.process.end");
        this.logger.info("LoadProcessThread.run", (Object)"dataCollection.fillData.start");
        this.dataCollection.fillData(dataList);
        this.logger.info("LoadProcessThread.run", (Object)"dataCollection.fillData.end");
        this.logger.info("LoadProcessThread end thread = " + Thread.currentThread().getId());
    }
}

