/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.estate.service.impl;

import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.estate.dao.EstReportMapper;
import com.yqbsoft.laser.service.estate.service.CallbacksAdviseService;
import com.yqbsoft.laser.service.estate.service.EstStatisticsService;
import com.yqbsoft.laser.service.estate.service.impl.CheckPublicPoolCustomerServiceImpl;
import com.yqbsoft.laser.service.estate.service.impl.CustomerRecyclingServiceImpl;
import com.yqbsoft.laser.service.estate.service.impl.semaphore.service.DataService;
import org.springframework.beans.factory.annotation.Autowired;

public class CallbacksAdviseServiceImpl
extends BaseServiceImpl
implements CallbacksAdviseService {
    public static final String SYS_CODE = "estate.CallbacksAdviseServiceImpl";
    @Autowired
    private CustomerRecyclingServiceImpl customerRecyclingService;
    @Autowired
    private CheckPublicPoolCustomerServiceImpl checkPublicPoolCustomerService;
    @Autowired
    private EstStatisticsService estStatisticsService;
    @Autowired
    private EstReportMapper estReportMapper;

    @Override
    public void customerRecycling() {
        this.recyclingCustomerTesting();
    }

    @Override
    public synchronized void statisticsJob() {
        this.estStatisticsService.batchStatisticsJobByCycle();
    }

    @Override
    public synchronized void checkPublicPoolCustomerJob() {
        try {
            int count = this.getCheckRecyclingCustomerCount();
            DataService.getInstance().executeRecovery(count, this.checkPublicPoolCustomerService, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getCheckRecyclingCustomerCount() {
        int i = 0;
        try {
            i = this.estReportMapper.getCheckRecyclingCustomerCount(null);
        }
        catch (Exception e) {
            this.logger.error("estate.CallbacksAdviseServiceImpl.getCountReport", (Throwable)e);
        }
        return i;
    }

    private int recyclingCustomerTestingCount() {
        int i = 0;
        try {
            i = this.estReportMapper.recyclingCustomerTestingCount(null);
        }
        catch (Exception e) {
            this.logger.error("estate.CallbacksAdviseServiceImpl.getCountReport", (Throwable)e);
        }
        return i;
    }

    private void recyclingCustomerTesting() {
        try {
            int count = this.recyclingCustomerTestingCount();
            DataService.getInstance().executeRecovery(count, this.customerRecyclingService, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

